/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationEntry;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation_Exp;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.idempiere.fa.exceptions.AssetException;
import org.idempiere.fa.exceptions.AssetNotActiveException;

public class MDepreciationExp
extends X_A_Depreciation_Exp {
    private static final long serialVersionUID = 6731366890875525147L;
    private static CLogger s_log = CLogger.getCLogger(MDepreciationExp.class);
    private CLogger log = CLogger.getCLogger(this.getClass());

    public MDepreciationExp(Properties ctx, int A_Depreciation_Exp_ID, String trxName) {
        super(ctx, A_Depreciation_Exp_ID, trxName);
    }

    public MDepreciationExp(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MDepreciationExp get(Properties ctx, int A_Depreciation_Exp_ID) {
        if (A_Depreciation_Exp_ID <= 0) {
            return null;
        }
        MDepreciationExp depexp = new MDepreciationExp(ctx, A_Depreciation_Exp_ID, null);
        if (depexp.get_ID() != A_Depreciation_Exp_ID) {
            depexp = null;
        }
        return depexp;
    }

    public static MDepreciationExp createEntry(Properties ctx, String entryType, int A_Asset_ID, int A_Period, Timestamp DateAcct, String postingType, int drAcct, int crAcct, BigDecimal expense, String description, MDepreciationWorkfile assetwk) {
        MDepreciationExp depexp = new MDepreciationExp(ctx, 0, null);
        depexp.setA_Entry_Type(entryType);
        depexp.setA_Asset_ID(A_Asset_ID);
        depexp.setDR_Account_ID(drAcct);
        depexp.setCR_Account_ID(crAcct);
        depexp.setA_Account_Number_Acct(drAcct);
        depexp.setPostingType(postingType);
        depexp.setExpense(expense);
        depexp.setDescription(Msg.parseTranslation(ctx, description));
        depexp.setA_Period(A_Period);
        depexp.setIsDepreciated(true);
        depexp.setDateAcct(DateAcct);
        depexp.updateFrom(assetwk);
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("depexp=" + depexp);
        }
        return depexp;
    }

    public void updateFrom(MDepreciationWorkfile wk) {
        this.setA_Asset_Cost(wk.getA_Asset_Cost());
        this.setA_Accumulated_Depr(wk.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(wk.getA_Accumulated_Depr_F());
        this.setUseLifeMonths(wk.getUseLifeMonths());
        this.setUseLifeMonths_F(wk.getUseLifeMonths_F());
        this.setA_Asset_Remaining(wk.getA_Asset_Remaining());
        this.setA_Asset_Remaining_F(wk.getA_Asset_Remaining_F());
    }

    private MDepreciationWorkfile getA_Depreciation_Workfile() {
        return MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
    }

    public static Collection<MDepreciationExp> createDepreciation(MDepreciationWorkfile assetwk, int PeriodNo, Timestamp dateAcct, BigDecimal amt, BigDecimal amt_F, BigDecimal accumAmt, BigDecimal accumAmt_F, String help, String trxName) {
        ArrayList<MDepreciationExp> list = new ArrayList<MDepreciationExp>();
        Properties ctx = assetwk.getCtx();
        MAssetAcct assetAcct = assetwk.getA_AssetAcct(dateAcct, trxName);
        MDepreciationExp depexp = null;
        depexp = MDepreciationExp.createEntry(ctx, "DEP", assetwk.getA_Asset_ID(), PeriodNo, dateAcct, assetwk.getPostingType(), assetAcct.getA_Depreciation_Acct(), assetAcct.getA_Accumdepreciation_Acct(), amt, "@AssetDepreciationAmt@", assetwk);
        if (depexp != null) {
            depexp.setAD_Org_ID(assetwk.getA_Asset().getAD_Org_ID());
            if (accumAmt != null) {
                depexp.setA_Accumulated_Depr(accumAmt);
            }
            if (accumAmt_F != null) {
                depexp.setA_Accumulated_Depr_F(accumAmt_F);
            }
            if (help != null && help.length() > 0) {
                depexp.setHelp(help);
            }
            depexp.setExpense_F(amt_F);
            depexp.setA_Accumulated_Depr_Delta(amt);
            depexp.setA_Accumulated_Depr_F_Delta(amt_F);
            depexp.saveEx(assetwk.get_TrxName());
            list.add(depexp);
        }
        return list;
    }

    public void process() {
        if (this.isProcessed()) {
            this.log.fine("@AlreadyProcessed@");
            return;
        }
        MDepreciationWorkfile assetwk = this.getA_Depreciation_Workfile();
        if (assetwk == null) {
            throw new AssetException("@NotFound@ @A_Depreciation_Workfile_ID@");
        }
        String entryType = this.getA_Entry_Type();
        if ("DEP".equals(entryType)) {
            MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
            if (!assetwk.getAsset().getA_Asset_Status().equals("AC")) {
                throw new AssetNotActiveException(assetwk.getAsset().get_ID());
            }
            this.setDateAcct(assetwk.getDateAcct());
            assetwk.adjustAccumulatedDepr(this.getExpense(), this.getExpense_F(), false);
        }
        this.setProcessed(true);
        this.updateFrom(assetwk);
        this.saveEx();
        assetwk.setA_Current_Period();
        assetwk.saveEx();
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            MDepreciationWorkfile assetwk = this.getA_Depreciation_Workfile();
            assetwk.adjustAccumulatedDepr(this.getA_Accumulated_Depr().negate(), this.getA_Accumulated_Depr_F().negate(), false);
            assetwk.saveEx();
        }
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLD", this.getAD_Org_ID());
            MDepreciationEntry.deleteFacts(this);
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        if (this.isProcessed()) {
            MDepreciationWorkfile wk = this.getA_Depreciation_Workfile();
            wk.setA_Current_Period();
            wk.saveEx();
        }
        return true;
    }

    protected boolean isPosted() {
        return this.isProcessed() && this.getA_Depreciation_Entry_ID() > 0;
    }

    public static void checkExistsNotProcessedEntries(Properties ctx, int A_Asset_ID, Timestamp dateAcct, String postingType, String trxName) {
        String whereClause = "A_Asset_ID=? AND TRUNC(DateAcct,'MONTH')<? AND PostingType=? AND Processed=?";
        boolean match = new Query(ctx, "A_Depreciation_Exp", "A_Asset_ID=? AND TRUNC(DateAcct,'MONTH')<? AND PostingType=? AND Processed=?", trxName).setParameters(A_Asset_ID, TimeUtil.getMonthFirstDay(dateAcct), postingType, false).match();
        if (match) {
            throw new AssetException("There are unprocessed records to date");
        }
    }

    public static List<MDepreciationExp> getNotProcessedEntries(Properties ctx, int A_Asset_ID, String postingType, String trxName) {
        String whereClause = "A_Asset_ID=? AND PostingType=? AND Processed=?";
        List<MDepreciationExp> list = new Query(ctx, "A_Depreciation_Exp", "A_Asset_ID=? AND PostingType=? AND Processed=?", trxName).setParameters(A_Asset_ID, postingType, false).list();
        return list;
    }

    @Override
    public void setProcessed(boolean Processed) {
        super.setProcessed(Processed);
        if (this.get_ID() > 0) {
            String sql = "UPDATE A_Depreciation_Exp SET Processed=? WHERE A_Depreciation_Exp_ID=?";
            DB.executeUpdateEx("UPDATE A_Depreciation_Exp SET Processed=? WHERE A_Depreciation_Exp_ID=?", new Object[]{Processed, this.get_ID()}, this.get_TrxName());
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.get_ID() + ",A_Asset_ID=" + this.getA_Asset_ID() + ",A_Period=" + this.getA_Period() + ",DateAcct=" + this.getDateAcct() + ",Expense=" + this.getExpense() + ",Entry_ID=" + this.getA_Depreciation_Entry_ID() + "]";
    }
}

