/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation_Entry;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.idempiere.fa.exceptions.AssetArrayException;
import org.idempiere.fa.exceptions.AssetException;

public class MDepreciationEntry
extends X_A_Depreciation_Entry
implements DocAction {
    private static final long serialVersionUID = 6631244784741228058L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MDepreciationEntry(Properties ctx, int A_Depreciation_Entry_ID, String trxName) {
        super(ctx, A_Depreciation_Entry_ID, trxName);
        if (A_Depreciation_Entry_ID == 0) {
            MAcctSchema acctSchema = MClient.get(this.getCtx()).getAcctSchema();
            this.setC_AcctSchema_ID(acctSchema.get_ID());
            this.setC_Currency_ID(acctSchema.getC_Currency_ID());
            this.setA_Entry_Type("DEP");
            this.setPostingType("A");
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
        }
    }

    public MDepreciationEntry(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setC_Period_ID();
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if (!this.isProcessed() && (newRecord || this.is_ValueChanged("DateAcct"))) {
            this.selectLines();
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        this.unselectLines();
        return true;
    }

    public void setC_Period_ID() {
        MPeriod period = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID(), this.get_TrxName());
        if (period == null) {
            throw new AdempiereException("@NotFound@ @C_Period_ID@");
        }
        this.setC_Period_ID(period.get_ID());
    }

    private void unselectLines() {
        String sql = "UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=NULL  WHERE A_Depreciation_Entry_ID=?";
        int id = this.get_ID();
        if (id <= 0) {
            id = this.get_IDOld();
        }
        int no = DB.executeUpdateEx(sql, new Object[]{id}, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated #" + no);
        }
    }

    private void selectLines() {
        this.unselectLines();
        String sql = "UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=? WHERE A_Depreciation_Entry_ID IS NULL AND TRUNC(DateAcct,'MONTH') = ? AND AD_Client_ID=? AND AD_Org_ID=?";
        Timestamp dateAcct = TimeUtil.trunc(this.getDateAcct(), "MM");
        int no = DB.executeUpdateEx("UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=? WHERE A_Depreciation_Entry_ID IS NULL AND TRUNC(DateAcct,'MONTH') = ? AND AD_Client_ID=? AND AD_Org_ID=?", new Object[]{this.get_ID(), dateAcct, this.getAD_Client_ID(), this.getAD_Org_ID()}, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated #" + no);
        }
    }

    public Iterator<MDepreciationExp> getLinesIterator(boolean onlyNotProcessed) {
        String trxName = this.get_TrxName();
        ArrayList<Object> params = new ArrayList<Object>();
        String whereClause = "A_Depreciation_Entry_ID=?";
        params.add(this.get_ID());
        if (onlyNotProcessed) {
            whereClause = String.valueOf(whereClause) + " AND Processed=?";
            params.add(false);
        }
        String orderBy = "A_Asset_ID,PostingType,A_Period,A_Entry_Type";
        Iterator<MDepreciationExp> it = new Query(this.getCtx(), "A_Depreciation_Exp", whereClause, trxName).setOrderBy(orderBy).setParameters(params).iterate();
        return it;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
        this.m_justPrepared = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setDocAction("CO");
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        final MPeriod period = MPeriod.get(this.getCtx(), this.getC_Period_ID());
        ArrayList<Exception> errors = new ArrayList<Exception>();
        final Iterator<MDepreciationExp> it = this.getLinesIterator(true);
        while (it.hasNext()) {
            try {
                Trx.run(this.get_TrxName(), new TrxRunnable(){

                    @Override
                    public void run(String trxName) {
                        MDepreciationExp depexp = (MDepreciationExp)it.next();
                        if (!period.isInPeriod(depexp.getDateAcct())) {
                            throw new AssetException("The date is not within this Period (" + depexp + ", Data=" + depexp.getDateAcct() + ", Period=" + period.getName() + ")");
                        }
                        depexp.process();
                    }
                });
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                errors.add(e);
            }
        }
        if (errors.size() > 0) {
            throw new AssetArrayException(errors);
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public String getSummary() {
        return this.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public static void deleteFacts(MDepreciationExp depexp) {
        String sql = "DELETE FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND Line_ID=?";
        Object[] params = new Object[]{53121, depexp.getA_Depreciation_Entry_ID(), depexp.get_ID()};
        DB.executeUpdateEx("DELETE FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND Line_ID=?", params, depexp.get_TrxName());
    }
}

