/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.X_A_Depreciation_Convention;
import org.compiere.util.CCache;
import org.compiere.util.DB;

public class MDepreciationConvention
extends X_A_Depreciation_Convention {
    private static final long serialVersionUID = 2274629486216430723L;
    private static CCache<Integer, MDepreciationConvention> s_cache = new CCache("A_Depreciation_Convention", 5);

    public MDepreciationConvention(Properties ctx, int A_Depreciation_Convention_ID, String trxName) {
        super(ctx, A_Depreciation_Convention_ID, trxName);
    }

    public MDepreciationConvention(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MDepreciationConvention get(Properties ctx, int A_Depreciation_Convention_ID) {
        Integer key = A_Depreciation_Convention_ID;
        MDepreciationConvention conv = s_cache.get(key);
        if (conv != null) {
            return conv;
        }
        conv = new MDepreciationConvention(ctx, A_Depreciation_Convention_ID, null);
        if (conv.get_ID() > 0) {
            s_cache.put(key, conv);
        } else {
            conv = null;
        }
        return conv;
    }

    public BigDecimal invoke(MDepreciationWorkfile assetwk, MAssetAcct assetAcct, int Flag, int Period) {
        return this.invoke(assetwk.getA_Asset_ID(), assetAcct.getPostingType(), assetAcct.get_ID(), Flag, Period);
    }

    public BigDecimal invoke(int A_Asset_ID, String PostingType, int A_Asset_Acct_ID, int Flag, int Period) {
        BigDecimal retValue;
        block9: {
            String conventionType = this.getConventionType();
            retValue = null;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Entering: ConventionType=" + conventionType + "A_Asset_ID=" + A_Asset_ID + ", PostingType=" + PostingType + ", A_Asset_Acct_ID=" + A_Asset_Acct_ID + ", Flag=" + Flag + ", Period=" + Period);
            }
            if (conventionType.equalsIgnoreCase("FMCON")) {
                return this.apply_FMCON(A_Asset_ID, PostingType, A_Asset_Acct_ID, Flag, Period);
            }
            String sql = "{ ? = call " + conventionType + "(?, ?, ?, ?, ?) }";
            CallableStatement cs = null;
            try {
                try {
                    cs = DB.prepareCall(sql);
                    cs.registerOutParameter(1, 3);
                    cs.setInt(2, A_Asset_ID);
                    cs.setString(3, PostingType);
                    cs.setInt(4, A_Asset_Acct_ID);
                    cs.setInt(5, Flag);
                    cs.setInt(6, Period);
                    cs.execute();
                    retValue = cs.getBigDecimal(1);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(cs);
                    cs = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(cs);
                cs = null;
                throw throwable;
            }
            DB.close(cs);
            cs = null;
        }
        if (retValue == null) {
            retValue = BigDecimal.ZERO;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: retValue=" + retValue);
        }
        return retValue;
    }

    public BigDecimal apply_FMCON(int A_Asset_ID, String PostingType, int A_Asset_Acct_ID, int Flag, int Period) {
        return BigDecimal.ONE;
    }
}

