/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MLanguage;
import org.compiere.model.MRegion;
import org.compiere.model.Query;
import org.compiere.model.X_C_Country;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class MCountry
extends X_C_Country
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = -4966707939803861163L;
    private static String s_AD_Language = null;
    private static CCache<Integer, MCountry> s_countries = null;
    private static CCache<Integer, MCountry> s_default = new CCache("C_Country", 3);
    private static CLogger s_log = CLogger.getCLogger(MCountry.class);
    private static String DISPLAYSEQUENCE = "@C@, @P@";

    public static MCountry get(Properties ctx, int C_Country_ID) {
        MCountry.loadAllCountriesIfNeeded(ctx);
        MCountry c = s_countries.get(C_Country_ID);
        if (c != null) {
            return c;
        }
        c = new MCountry(ctx, C_Country_ID, null);
        if (c.getC_Country_ID() == C_Country_ID) {
            s_countries.put(C_Country_ID, c);
            return c;
        }
        return null;
    }

    public static MCountry getDefault(Properties ctx) {
        int clientID = Env.getAD_Client_ID(ctx);
        MCountry c = s_default.get(clientID);
        if (c != null) {
            return c;
        }
        MCountry.loadDefaultCountry(ctx);
        c = s_default.get(clientID);
        return c;
    }

    public static MCountry[] getCountries(Properties ctx) {
        MCountry.loadAllCountriesIfNeeded(ctx);
        MCountry[] retValue = new MCountry[s_countries.size()];
        s_countries.values().toArray(retValue);
        Arrays.sort(retValue, new MCountry(ctx, 0, null));
        return retValue;
    }

    private static synchronized void loadAllCountriesIfNeeded(Properties ctx) {
        if (s_countries == null || s_countries.isEmpty()) {
            MCountry.loadAllCountries(ctx);
        }
    }

    private static void loadAllCountries(Properties ctx) {
        MClient client = MClient.get(ctx);
        MLanguage lang = MLanguage.get(ctx, client.getAD_Language());
        s_countries = new CCache("C_Country", 250);
        List countries = new Query(ctx, "C_Country", "", null).setOnlyActiveRecords(true).list();
        for (MCountry c : countries) {
            s_countries.put(c.getC_Country_ID(), c);
            if (lang == null || !lang.getCountryCode().equals(c.getCountryCode())) continue;
            s_default.put(client.getAD_Client_ID(), c);
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("#" + s_countries.size() + " - Default=" + s_default);
        }
    }

    private static void loadDefaultCountry(Properties ctx) {
        MCountry.loadAllCountriesIfNeeded(ctx);
        MClient client = MClient.get(ctx);
        MCountry found = s_default.get(client.getAD_Client_ID());
        if (found != null) {
            return;
        }
        MLanguage lang = MLanguage.get(ctx, client.getAD_Language());
        MCountry usa = null;
        for (Map.Entry<Integer, MCountry> cachedEntry : s_countries.entrySet()) {
            MCountry c = cachedEntry.getValue();
            if (lang != null && lang.getCountryCode().equals(c.getCountryCode())) {
                found = c;
                break;
            }
            if (c.getC_Country_ID() != 100) continue;
            usa = c;
        }
        if (found != null) {
            s_default.put(client.getAD_Client_ID(), found);
        } else {
            s_default.put(client.getAD_Client_ID(), usa);
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("#" + s_countries.size() + " - Default=" + s_default);
        }
    }

    public static void setDisplayLanguage(String AD_Language) {
        s_AD_Language = AD_Language;
        if (Language.isBaseLanguage(AD_Language)) {
            s_AD_Language = null;
        }
    }

    public MCountry(Properties ctx, int C_Country_ID, String trxName) {
        super(ctx, C_Country_ID, trxName);
        if (C_Country_ID == 0) {
            this.setDisplaySequence(DISPLAYSEQUENCE);
            this.setHasRegion(false);
            this.setHasPostal_Add(false);
            this.setIsAddressLinesLocalReverse(false);
            this.setIsAddressLinesReverse(false);
        }
    }

    public MCountry(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        return this.getTrlName();
    }

    public String getTrlName() {
        return this.getTrlName(Env.getAD_Language(Env.getCtx()));
    }

    public String getTrlName(String language) {
        return this.get_Translation("Name", language);
    }

    @Override
    public String getDisplaySequence() {
        String ds = super.getDisplaySequence();
        if (ds == null || ds.length() == 0) {
            ds = DISPLAYSEQUENCE;
        }
        return ds;
    }

    @Override
    public String getDisplaySequenceLocal() {
        String ds = super.getDisplaySequenceLocal();
        if (ds == null || ds.length() == 0) {
            ds = this.getDisplaySequence();
        }
        return ds;
    }

    @Override
    public int compare(Object o1, Object o2) {
        String s2;
        String s1 = o1.toString();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = o2.toString()) == null) {
            s2 = "";
        }
        Collator collator = Collator.getInstance();
        return collator.compare(s1, s2);
    }

    public boolean isValidRegion(int C_Region_ID) {
        if (C_Region_ID == 0 || this.getC_Country_ID() == 0 || !this.isHasRegion()) {
            return false;
        }
        MRegion[] regions = MRegion.getRegions(this.getCtx(), this.getC_Country_ID());
        int i2 = 0;
        while (i2 < regions.length) {
            if (C_Region_ID == regions[i2].getC_Region_ID()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

