/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.DatabaseKey;
import org.compiere.model.I_AD_Table;
import org.compiere.model.MRefTable;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Column;
import org.compiere.model.X_AD_Reference;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MColumn
extends X_AD_Column {
    private static final long serialVersionUID = 7215660422231054443L;
    private static CCache<Integer, MColumn> s_cache = new CCache("AD_Column", 20);
    private static CLogger s_log = CLogger.getCLogger(MColumn.class);

    public static MColumn get(Properties ctx, int AD_Column_ID) {
        return MColumn.get(ctx, AD_Column_ID, null);
    }

    public static MColumn get(Properties ctx, int AD_Column_ID, String trxName) {
        Integer key = AD_Column_ID;
        MColumn retValue = s_cache.get(key);
        if (retValue != null) {
            retValue.set_TrxName(trxName);
            return retValue;
        }
        retValue = new MColumn(ctx, AD_Column_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MColumn get(Properties ctx, String tableName, String columnName) {
        MTable table2 = MTable.get(ctx, tableName);
        return table2.getColumn(columnName);
    }

    public static String getColumnName(Properties ctx, int AD_Column_ID) {
        return MColumn.getColumnName(ctx, AD_Column_ID, null);
    }

    public static String getColumnName(Properties ctx, int AD_Column_ID, String trxName) {
        MColumn col = MColumn.get(ctx, AD_Column_ID, trxName);
        if (col.get_ID() == 0) {
            return null;
        }
        return col.getColumnName();
    }

    public MColumn(Properties ctx, int AD_Column_ID, String trxName) {
        super(ctx, AD_Column_ID, trxName);
        if (AD_Column_ID == 0) {
            this.setIsAlwaysUpdateable(false);
            this.setIsEncrypted(false);
            this.setIsIdentifier(false);
            this.setIsKey(false);
            this.setIsMandatory(false);
            this.setIsParent(false);
            this.setIsSelectionColumn(false);
            this.setIsTranslated(false);
            this.setIsUpdateable(true);
            this.setVersion(Env.ZERO);
        }
    }

    public MColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
    }

    public boolean isStandardColumn() {
        String columnName = this.getColumnName();
        return columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("IsActive") || columnName.equals("Processing") || columnName.equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy");
    }

    public boolean isUUIDColumn() {
        return this.getColumnName().equals(PO.getUUIDColumnName(this.getAD_Table().getTableName()));
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isVirtualDBColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0 && !s.startsWith("@SQL=");
    }

    public boolean isVirtualUIColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0 && s.startsWith("@SQL=");
    }

    public boolean isEncrypted() {
        String s = this.getIsEncrypted();
        return "Y".equals(s);
    }

    public void setIsEncrypted(boolean IsEncrypted) {
        this.setIsEncrypted(IsEncrypted ? "Y" : "N");
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String pattern;
        int cnt;
        int displayType = this.getAD_Reference_ID();
        if (DisplayType.isLOB(displayType)) {
            if (this.getFieldLength() != 0) {
                this.setFieldLength(0);
            }
        } else if (this.getFieldLength() == 0) {
            if (DisplayType.isID(displayType)) {
                this.setFieldLength(10);
            } else if (DisplayType.isNumeric(displayType)) {
                this.setFieldLength(14);
            } else if (DisplayType.isDate(displayType)) {
                this.setFieldLength(7);
            } else {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "FieldLength"));
                return false;
            }
        }
        if (displayType != 28 && !"N".equals(this.getIsToolbarButton())) {
            this.setIsToolbarButton("N");
        }
        if (!this.isVirtualColumn() && this.getValueMax() != null && this.getValueMin() != null) {
            try {
                BigDecimal valueMax = new BigDecimal(this.getValueMax());
                BigDecimal valueMin = new BigDecimal(this.getValueMin());
                if (valueMax.compareTo(valueMin) < 0) {
                    this.log.saveError("MaxLessThanMin", Msg.getElement(this.getCtx(), "ValueMax"));
                    return false;
                }
            }
            catch (Exception valueMax) {
                // empty catch block
            }
        }
        if (this.isIdentifier() && (cnt = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Column WHERE AD_Table_ID=? AND AD_Column_ID!=? AND IsIdentifier='Y' AND SeqNo=?", this.getAD_Table_ID(), this.getAD_Column_ID(), this.getSeqNo())) > 0) {
            this.log.saveError("SaveErrorNotUnique", Msg.getElement(this.getCtx(), "SeqNo"));
            return false;
        }
        if (this.isVirtualColumn()) {
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
            if (this.isUpdateable()) {
                this.setIsUpdateable(false);
            }
            if (this.isVirtualUIColumn() && this.isIdentifier()) {
                this.setIsIdentifier(false);
            }
        }
        if (this.isParent() || this.isKey()) {
            this.setIsUpdateable(false);
        }
        if (this.isAlwaysUpdateable() && !this.isUpdateable()) {
            this.setIsAlwaysUpdateable(false);
        }
        String colname = this.getColumnName();
        if (this.isEncrypted()) {
            int dt = this.getAD_Reference_ID();
            if (this.isKey() || this.isParent() || this.isStandardColumn() || this.isVirtualColumn() || this.isIdentifier() || this.isTranslated() || this.isUUIDColumn() || DisplayType.isLookup(dt) || DisplayType.isLOB(dt) || "DocumentNo".equalsIgnoreCase(colname) || "Value".equalsIgnoreCase(colname) || "Name".equalsIgnoreCase(colname)) {
                this.log.warning("Encryption not sensible - " + colname);
                this.setIsEncrypted(false);
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            this.setColumnName(element.getColumnName());
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        if (this.isAllowCopy() && (this.isKey() || this.isVirtualColumn() || this.isUUIDColumn() || this.isStandardColumn())) {
            this.setIsAllowCopy(false);
        }
        if (!Util.isEmpty(pattern = this.getFormatPattern(), true)) {
            if (DisplayType.isNumeric(this.getAD_Reference_ID())) {
                DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
                try {
                    format.applyPattern(pattern);
                }
                catch (IllegalArgumentException e) {
                    this.log.saveError("SaveError", "Invalid number format: " + pattern);
                    return false;
                }
            } else if (DisplayType.isDate(this.getAD_Reference_ID())) {
                SimpleDateFormat format = (SimpleDateFormat)DateFormat.getInstance();
                try {
                    format.applyPattern(pattern);
                }
                catch (IllegalArgumentException e) {
                    this.log.saveError("SaveError", "Invalid date pattern: " + pattern);
                    return false;
                }
            } else {
                this.setFormatPattern(null);
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return success;
    }

    public String getSQLAdd(MTable table2) {
        StringBuilder sql = new StringBuilder("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(this.getSQLDDL());
        String constraint = this.getConstraint(table2.getTableName());
        if (constraint != null && constraint.length() > 0) {
            sql.append("; ").append("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(constraint);
        }
        return sql.toString();
    }

    public String getSQLDDL() {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuilder sql = new StringBuilder().append(this.getColumnName()).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sql.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!this.isMandatory()) {
                sql.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        if (this.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(this.getColumnName()).append(" IN ('Y','N'))");
        }
        if (this.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    public String getSQLModify(MTable table2, boolean setNullOption) {
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlBase = new StringBuilder("ALTER TABLE ").append(table2.getTableName()).append(" MODIFY ").append(this.getColumnName());
        StringBuilder sqlDefault = new StringBuilder(sqlBase).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sqlDefault.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!this.isMandatory()) {
                sqlDefault.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        sql.append((CharSequence)sqlDefault);
        if (this.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            StringBuilder sqlSet = new StringBuilder("UPDATE ").append(table2.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
            sql.append("; ").append((CharSequence)sqlSet);
        }
        if (setNullOption) {
            StringBuilder sqlNull = new StringBuilder(sqlBase);
            if (this.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append((CharSequence)sqlNull);
        }
        return sql.toString();
    }

    public String getSQLDataType() {
        String columnName = this.getColumnName();
        int dt = this.getAD_Reference_ID();
        return DisplayType.getSQLDataType(dt, columnName, this.getFieldLength());
    }

    public String getConstraint(String tableName) {
        if (this.isKey()) {
            StringBuilder constraintName = tableName.length() > 26 ? new StringBuilder(tableName.substring(0, 26)).append("_Key") : new StringBuilder(tableName).append("_Key");
            StringBuilder msgreturn = new StringBuilder("CONSTRAINT ").append((CharSequence)constraintName).append(" PRIMARY KEY (").append(this.getColumnName()).append(")");
            return msgreturn.toString();
        }
        if (this.getColumnName().equals(PO.getUUIDColumnName(tableName))) {
            StringBuilder indexName = new StringBuilder().append(this.getColumnName()).append("_idx");
            if (indexName.length() > 30) {
                indexName = new StringBuilder().append(this.getColumnName().substring(0, 25));
                indexName.append("uuidx");
            }
            StringBuilder msgreturn = new StringBuilder("CONSTRAINT ").append((CharSequence)indexName).append(" UNIQUE (").append(this.getColumnName()).append(")");
            return msgreturn.toString();
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MColumn[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }

    public static int getColumn_ID(String TableName, String columnName) {
        int retValue;
        block7: {
            int m_table_id = MTable.getTable_ID(TableName);
            if (m_table_id == 0) {
                return 0;
            }
            retValue = 0;
            String SQL = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ?  AND columnname = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setInt(1, m_table_id);
                    pstmt.setString(2, columnName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static int getTable_ID(Properties ctx, int AD_Column_ID, String trxName) {
        String sqlStmt = "SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?";
        return DB.getSQLValue(trxName, sqlStmt, AD_Column_ID);
    }

    public static boolean isSuggestSelectionColumn(String columnName, boolean caseSensitive) {
        if (Util.isEmpty(columnName, true)) {
            return false;
        }
        if (columnName.equals("Value") || !caseSensitive && columnName.equalsIgnoreCase("Value")) {
            return true;
        }
        if (columnName.equals("Name") || !caseSensitive && columnName.equalsIgnoreCase("Name")) {
            return true;
        }
        if (columnName.equals("DocumentNo") || !caseSensitive && columnName.equalsIgnoreCase("DocumentNo")) {
            return true;
        }
        if (columnName.equals("Description") || !caseSensitive && columnName.equalsIgnoreCase("Description")) {
            return true;
        }
        return columnName.indexOf("Name") != -1 || !caseSensitive && columnName.toUpperCase().indexOf("Name".toUpperCase()) != -1;
    }

    public String getReferenceTableName() {
        String foreignTable = null;
        int refid = this.getAD_Reference_ID();
        if (19 == refid || 30 == refid && this.getAD_Reference_Value_ID() == 0) {
            foreignTable = this.getColumnName().substring(0, this.getColumnName().length() - 3);
        } else if (18 == refid || 30 == refid) {
            MRefTable rt;
            int cnt;
            X_AD_Reference ref = new X_AD_Reference(this.getCtx(), this.getAD_Reference_Value_ID(), this.get_TrxName());
            if ("T".equals(ref.getValidationType()) && (cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Ref_Table WHERE AD_Reference_ID=?", this.getAD_Reference_Value_ID())) == 1 && (rt = new MRefTable(this.getCtx(), this.getAD_Reference_Value_ID(), this.get_TrxName())) != null) {
                foreignTable = rt.getAD_Table().getTableName();
            }
        } else if (17 == refid || 200012 == refid) {
            foreignTable = "AD_Ref_List";
        } else if (21 == refid) {
            foreignTable = "C_Location";
        } else if (25 == refid) {
            foreignTable = "C_ValidCombination";
        } else if (31 == refid) {
            foreignTable = "M_Locator";
        } else if (35 == refid) {
            foreignTable = "M_AttributeSetInstance";
        } else if (33 == refid) {
            foreignTable = "S_ResourceAssignment";
        } else if (32 == refid && !"BinaryData".equals(this.getColumnName())) {
            foreignTable = "AD_Image";
        } else if (53370 == refid) {
            foreignTable = "AD_Chart";
        }
        return foreignTable;
    }

    public void setSmartDefaults() {
        if (MColumn.isSuggestSelectionColumn(this.getColumnName(), true)) {
            this.setIsSelectionColumn(true);
        }
        if (PO.getUUIDColumnName(this.getAD_Table().getTableName()).equals(this.getColumnName())) {
            this.setAD_Reference_ID(10);
            this.setAD_Val_Rule_ID(0);
            this.setAD_Reference_Value_ID(0);
            this.setFieldLength(36);
            this.setDefaultValue(null);
            this.setMandatoryLogic(null);
            this.setReadOnlyLogic(null);
            this.setIsIdentifier(false);
            this.setIsUpdateable(false);
            this.setIsAlwaysUpdateable(false);
            this.setIsKey(false);
        } else if (this.getAD_Table().getTableName().concat("_ID").equals(this.getColumnName())) {
            this.setAD_Reference_ID(13);
            this.setAD_Val_Rule_ID(0);
            this.setAD_Reference_Value_ID(0);
            this.setFieldLength(22);
            this.setDefaultValue(null);
            this.setMandatoryLogic(null);
            this.setReadOnlyLogic(null);
            this.setIsIdentifier(false);
            this.setIsUpdateable(false);
            this.setIsAlwaysUpdateable(false);
            this.setIsKey(true);
        } else {
            String sql = "SELECT AD_Reference_ID,        AD_Val_Rule_ID,        AD_Reference_Value_ID,        FieldLength,        DefaultValue,        MandatoryLogic,        ReadOnlyLogic,        IsIdentifier,        IsUpdateable,        IsAlwaysUpdateable,        FKConstraintType,       COUNT(*) FROM   AD_Column WHERE  ColumnName = ? GROUP  BY AD_Reference_ID,           AD_Val_Rule_ID,           AD_Reference_Value_ID,           FieldLength,           DefaultValue,           MandatoryLogic,           ReadOnlyLogic,           IsIdentifier,           IsUpdateable,           IsAlwaysUpdateable,           FKConstraintType ORDER  BY COUNT(*) DESC ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setString(1, this.getColumnName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        int ad_reference_id = rs.getInt(1);
                        if (ad_reference_id == 13) {
                            ad_reference_id = 19;
                        }
                        this.setAD_Reference_ID(ad_reference_id);
                        this.setAD_Val_Rule_ID(rs.getInt(2));
                        this.setAD_Reference_Value_ID(rs.getInt(3));
                        this.setFieldLength(rs.getInt(4));
                        this.setDefaultValue(rs.getString(5));
                        this.setMandatoryLogic(rs.getString(6));
                        this.setReadOnlyLogic(rs.getString(7));
                        this.setIsIdentifier("Y".equals(rs.getString(8)));
                        this.setIsUpdateable("Y".equals(rs.getString(9)));
                        this.setIsAlwaysUpdateable("Y".equals(rs.getString(10)));
                        this.setFKConstraintType(rs.getString(11));
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            Object var2_2 = null;
        }
    }

    @Override
    public I_AD_Table getAD_Table() throws RuntimeException {
        MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID(), this.get_TrxName());
        return table2;
    }

    public static String getForeignKeyConstraintSql(DatabaseMetaData md, String catalog, String schema, String tableName, MTable table2, MColumn column, boolean isNoTable) throws Exception {
        String referenceTableName;
        int refid;
        StringBuilder fkConstraintSql = new StringBuilder();
        if (!(column.isKey() || column.getColumnName().equals(PO.getUUIDColumnName(table2.getTableName())) || column.isVirtualColumn() || (refid = column.getAD_Reference_ID()) == 17 || refid == 200012 || (referenceTableName = column.getReferenceTableName()) == null)) {
            String fkConstraint;
            Hashtable<String, DatabaseKey> htForeignKeys = new Hashtable<String, DatabaseKey>();
            if (md.storesUpperCaseIdentifiers()) {
                referenceTableName = referenceTableName.toUpperCase();
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                referenceTableName = referenceTableName.toLowerCase();
                tableName = tableName.toLowerCase();
            }
            if (!isNoTable) {
                ResultSet rs = null;
                try {
                    rs = md.getCrossReference(catalog, schema, referenceTableName, catalog, schema, tableName);
                    while (rs.next()) {
                        String dbFKName = rs.getString("FK_NAME");
                        if (dbFKName == null) continue;
                        String dbFKTable = rs.getString("FKTABLE_NAME");
                        short deleteRule = rs.getShort("DELETE_RULE");
                        String key = dbFKName.toLowerCase();
                        DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                        if (dbForeignKey == null) {
                            dbForeignKey = new DatabaseKey(dbFKName, dbFKTable, new String[30], deleteRule);
                        }
                        String columnName = rs.getString("FKCOLUMN_NAME");
                        short pos = rs.getShort("KEY_SEQ");
                        if (pos > 0) {
                            dbForeignKey.getKeyColumns()[pos - 1] = columnName;
                        }
                        htForeignKeys.put(key, dbForeignKey);
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs);
                    rs = null;
                    throw throwable;
                }
                DB.close(rs);
                rs = null;
            }
            Enumeration en = htForeignKeys.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                if (dbForeignKey.getKeyColumns()[1] == null) continue;
                htForeignKeys.remove(key);
            }
            boolean modified = false;
            en = htForeignKeys.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                if (!dbForeignKey.getKeyColumns()[0].equalsIgnoreCase(column.getColumnName())) continue;
                DatabaseKey primaryKey = MColumn.getPrimaryKey(md, referenceTableName);
                if (primaryKey != null) {
                    fkConstraintSql.append("; ");
                    fkConstraintSql.append("ALTER TABLE ").append(table2.getTableName());
                    fkConstraintSql.append(" DROP CONSTRAINT ").append(dbForeignKey.getKeyName());
                    String dbDeleteRule = null;
                    if (dbForeignKey.getDeleteRule() == 0) {
                        dbDeleteRule = "C";
                    } else if (dbForeignKey.getDeleteRule() == 2) {
                        dbDeleteRule = "S";
                    } else if (dbForeignKey.getDeleteRule() == 3 || dbForeignKey.getDeleteRule() == 1) {
                        dbDeleteRule = "N";
                    }
                    String fkConstraintType = column.getFKConstraintType();
                    if (fkConstraintType == null && (fkConstraintType = dbDeleteRule) == null) {
                        fkConstraintType = "AD_Client_ID".equals(column.getColumnName()) || "AD_Org_ID".equals(column.getColumnName()) || "CreatedBy".equals(column.getColumnName()) || "UpdatedBy".equals(column.getColumnName()) ? "D" : "N";
                    }
                    if (!fkConstraintType.equals("D")) {
                        String fkConstraintName = column.getFKConstraintName();
                        if (fkConstraintName == null || fkConstraintName.trim().length() == 0) {
                            fkConstraintName = dbForeignKey.getKeyName();
                        }
                        StringBuilder fkConstraint2 = new StringBuilder();
                        fkConstraint2.append("CONSTRAINT ").append(fkConstraintName);
                        fkConstraint2.append(" FOREIGN KEY (").append(column.getColumnName()).append(") REFERENCES ");
                        fkConstraint2.append(primaryKey.getKeyTable()).append("(").append(primaryKey.getKeyColumns()[0]);
                        int i2 = 1;
                        while (i2 < primaryKey.getKeyColumns().length) {
                            if (primaryKey.getKeyColumns()[i2] == null) break;
                            fkConstraint2.append(", ").append(primaryKey.getKeyColumns()[i2]);
                            ++i2;
                        }
                        fkConstraint2.append(")");
                        if (!fkConstraintType.equals("N")) {
                            if (fkConstraintType.equals("C")) {
                                fkConstraint2.append(" ON DELETE CASCADE");
                            } else if (fkConstraintType.equals("S")) {
                                fkConstraint2.append(" ON DELETE SET NULL");
                            }
                        }
                        fkConstraint2.append(" DEFERRABLE INITIALLY DEFERRED");
                        fkConstraintSql.append("; ");
                        fkConstraintSql.append("ALTER TABLE ").append(table2.getTableName());
                        fkConstraintSql.append(" ADD ");
                        fkConstraintSql.append((CharSequence)fkConstraint2);
                        column.setFKConstraintName(fkConstraintName);
                        column.setFKConstraintType(fkConstraintType);
                        column.saveEx();
                        if (dbForeignKey.getKeyName().equalsIgnoreCase(column.getFKConstraintName()) && (dbForeignKey.getDeleteRule() == 0 && "C".equals(column.getFKConstraintType()) || dbForeignKey.getDeleteRule() == 2 && "S".equals(column.getFKConstraintType()) || dbForeignKey.getDeleteRule() == 3 && "N".equals(column.getFKConstraintType()) || dbForeignKey.getDeleteRule() == 1 && "N".equals(column.getFKConstraintType()))) {
                            return "";
                        }
                    }
                }
                modified = true;
                break;
            }
            if (!modified && (fkConstraint = MColumn.getForeignKeyConstraint(md, table2, column)) != null && fkConstraint.length() > 0) {
                fkConstraintSql.append("; ");
                fkConstraintSql.append("ALTER TABLE ").append(table2.getTableName());
                fkConstraintSql.append(" ADD ");
                fkConstraintSql.append(fkConstraint);
            }
        }
        return fkConstraintSql.toString();
    }

    public static DatabaseKey getPrimaryKey(DatabaseMetaData md, String primaryTableName) throws Exception {
        DatabaseKey primaryKey = null;
        String catalog = DB.getDatabase().getCatalog();
        String schema = DB.getDatabase().getSchema();
        String tableName = primaryTableName;
        if (md.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (md.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        ResultSet rs = null;
        try {
            rs = md.getPrimaryKeys(catalog, schema, tableName);
            while (rs.next()) {
                String primaryKeyName = rs.getString("PK_NAME");
                if (primaryKeyName == null) continue;
                String primaryKeyTableName = rs.getString("TABLE_NAME");
                short deleteRule = -1;
                if (primaryKey == null) {
                    primaryKey = new DatabaseKey(primaryKeyName, primaryKeyTableName, new String[30], deleteRule);
                }
                String primaryKeyColumn = rs.getString("COLUMN_NAME");
                short pos = rs.getShort("KEY_SEQ");
                if (pos <= 0) continue;
                primaryKey.getKeyColumns()[pos - 1] = primaryKeyColumn;
            }
        }
        catch (Exception e) {
            DB.close(rs);
            rs = null;
        }
        return primaryKey;
    }

    public static String getForeignKeyConstraint(DatabaseMetaData md, MTable table2, MColumn column) throws Exception {
        if (!column.isKey() && !column.getColumnName().equals(PO.getUUIDColumnName(table2.getTableName()))) {
            DatabaseKey primaryKey;
            String referenceTableName;
            String fkConstraintType = column.getFKConstraintType();
            if (fkConstraintType == null) {
                fkConstraintType = "N";
            }
            if (fkConstraintType.equals("D")) {
                return "";
            }
            int refid = column.getAD_Reference_ID();
            if (refid != 17 && refid != 200012 && (referenceTableName = column.getReferenceTableName()) != null && (primaryKey = MColumn.getPrimaryKey(md, referenceTableName)) != null) {
                String fkConstraintName = column.getFKConstraintName();
                if (fkConstraintName == null || fkConstraintName.trim().length() == 0) {
                    String columnName = column.getColumnName();
                    if (columnName.toUpperCase().endsWith("_ID")) {
                        columnName = columnName.substring(0, columnName.length() - 3);
                    }
                    StringBuilder constraintName = new StringBuilder();
                    constraintName.append(columnName.replace("_", ""));
                    constraintName.append("_");
                    constraintName.append(table2.getTableName().replace("_", ""));
                    if (constraintName.length() > 30) {
                        constraintName = new StringBuilder(constraintName.substring(0, 30));
                    }
                    fkConstraintName = constraintName.toString();
                }
                StringBuilder fkConstraint = new StringBuilder();
                fkConstraint.append("CONSTRAINT ").append(fkConstraintName);
                fkConstraint.append(" FOREIGN KEY (").append(column.getColumnName()).append(") REFERENCES ");
                fkConstraint.append(primaryKey.getKeyTable()).append("(").append(primaryKey.getKeyColumns()[0]);
                int i2 = 1;
                while (i2 < primaryKey.getKeyColumns().length) {
                    if (primaryKey.getKeyColumns()[i2] == null) break;
                    fkConstraint.append(", ").append(primaryKey.getKeyColumns()[i2]);
                    ++i2;
                }
                fkConstraint.append(")");
                if (!fkConstraintType.equals("N")) {
                    if (fkConstraintType.equals("C")) {
                        fkConstraint.append(" ON DELETE CASCADE");
                    } else if (fkConstraintType.equals("S")) {
                        fkConstraint.append(" ON DELETE SET NULL");
                    }
                }
                fkConstraint.append(" DEFERRABLE INITIALLY DEFERRED");
                column.setFKConstraintName(fkConstraintName);
                column.setFKConstraintType(fkConstraintType);
                column.saveEx();
                return fkConstraint.toString();
            }
        }
        return "";
    }

    public boolean isAdvanced() {
        String sql = "SELECT COUNT(*) FROM   AD_Tab t        JOIN AD_Field f ON ( f.AD_Tab_ID = t.AD_Tab_ID ) WHERE  f.AD_Column_ID = ?        AND ( t.IsAdvancedTab = 'Y' OR f.IsAdvancedField = 'Y' )";
        int cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM   AD_Tab t        JOIN AD_Field f ON ( f.AD_Tab_ID = t.AD_Tab_ID ) WHERE  f.AD_Column_ID = ?        AND ( t.IsAdvancedTab = 'Y' OR f.IsAdvancedField = 'Y' )", this.getAD_Column_ID());
        return cnt > 0;
    }

    public String getColumnSQL(boolean nullForUI) {
        String query = this.getColumnSQL();
        if (query != null && query.length() > 0 && query.startsWith("@SQL=") && nullForUI) {
            query = "NULL";
        }
        return query;
    }
}

