/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.X_PA_ColorSchema;
import org.compiere.print.MPrintColor;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MColorSchema
extends X_PA_ColorSchema {
    private static final long serialVersionUID = 4645092884363283719L;
    private static CCache<Integer, MColorSchema> s_cache = new CCache("PA_ColorSchema", 20);

    public static Color getColor(Properties ctx, int PA_ColorSchema_ID, BigDecimal target, BigDecimal actual) {
        int percent = 0;
        if (actual != null && actual.signum() != 0 && target != null && target.signum() != 0) {
            BigDecimal pp = actual.multiply(Env.ONEHUNDRED).divide(target, 0, RoundingMode.HALF_UP);
            percent = pp.intValue();
        }
        return MColorSchema.getColor(ctx, PA_ColorSchema_ID, percent);
    }

    public static Color getColor(Properties ctx, int PA_ColorSchema_ID, int percent) {
        MColorSchema cs = MColorSchema.get(ctx, PA_ColorSchema_ID);
        return cs.getColor(percent);
    }

    public static MColorSchema get(Properties ctx, int PA_ColorSchema_ID) {
        if (PA_ColorSchema_ID == 0) {
            MColorSchema retValue = new MColorSchema(ctx, 0, null);
            retValue.setDefault();
            return retValue;
        }
        Integer key = PA_ColorSchema_ID;
        MColorSchema retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MColorSchema(ctx, PA_ColorSchema_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MColorSchema(Properties ctx, int PA_ColorSchema_ID, String trxName) {
        super(ctx, PA_ColorSchema_ID, trxName);
    }

    public MColorSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setDefault() {
        this.setName("Default");
        this.setMark1Percent(50);
        this.setAD_PrintColor1_ID(102);
        this.setMark2Percent(100);
        this.setAD_PrintColor2_ID(113);
        this.setMark3Percent(9999);
        this.setAD_PrintColor3_ID(103);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getMark1Percent() > this.getMark2Percent()) {
            this.setMark1Percent(this.getMark2Percent());
        }
        if (this.getMark2Percent() > this.getMark3Percent() && this.getMark3Percent() != 0) {
            this.setMark2Percent(this.getMark3Percent());
        }
        if (this.getMark3Percent() > this.getMark4Percent() && this.getMark4Percent() != 0) {
            this.setMark4Percent(this.getMark4Percent());
        }
        return true;
    }

    public Color getColor(int percent) {
        int AD_PrintColor_ID = 0;
        AD_PrintColor_ID = percent <= this.getMark1Percent() || this.getMark2Percent() == 0 ? this.getAD_PrintColor1_ID() : (percent <= this.getMark2Percent() || this.getMark3Percent() == 0 ? this.getAD_PrintColor2_ID() : (percent <= this.getMark3Percent() || this.getMark4Percent() == 0 ? this.getAD_PrintColor3_ID() : this.getAD_PrintColor4_ID()));
        if (AD_PrintColor_ID == 0) {
            if (this.getAD_PrintColor3_ID() != 0) {
                AD_PrintColor_ID = this.getAD_PrintColor3_ID();
            } else if (this.getAD_PrintColor2_ID() != 0) {
                AD_PrintColor_ID = this.getAD_PrintColor2_ID();
            } else if (this.getAD_PrintColor1_ID() != 0) {
                AD_PrintColor_ID = this.getAD_PrintColor1_ID();
            }
        }
        if (AD_PrintColor_ID == 0) {
            return Color.black;
        }
        MPrintColor pc = MPrintColor.get(this.getCtx(), AD_PrintColor_ID);
        if (pc != null) {
            return pc.getColor();
        }
        return Color.black;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MColorSchema[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

