/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MChart;
import org.compiere.model.MQuery;
import org.compiere.model.X_AD_ChartDatasource;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MChartDatasource
extends X_AD_ChartDatasource {
    private static final long serialVersionUID = 5108909995064477463L;

    public MChartDatasource(Properties ctx, int AD_ChartDatasource_ID, String trxName) {
        super(ctx, AD_ChartDatasource_ID, trxName);
    }

    public MChartDatasource(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private String convertToQuarter(String month) {
        if (month.length() != 7) {
            return month;
        }
        String mm = month.substring(5, 7);
        int mon = Integer.parseInt(mm);
        return String.valueOf(month.substring(0, 5)) + "Q" + (mon / 3 + 1);
    }

    public MQuery getZoomQuery(MChart parent, String value, String category2) {
        String category;
        MQuery query = new MQuery(this.getAD_Table_ID());
        if (!parent.isTimeSeries()) {
            category = this.getCategoryColumn();
        } else {
            String unit = "D";
            if (parent.getTimeUnit().equals("W")) {
                unit = "W";
            } else if (parent.getTimeUnit().equals("M")) {
                unit = "MM";
            } else if (parent.getTimeUnit().equals("Q")) {
                unit = "Q";
            } else if (parent.getTimeUnit().equals("Y")) {
                unit = "Y";
            }
            category = " TRUNC(" + this.getDateColumn() + ", '" + unit + "') ";
        }
        String where = this.getWhereClause();
        if (!Util.isEmpty(where)) {
            where = Env.parseContext(Env.getCtx(), parent.getWindowNo(), where, true);
        }
        String series = DB.TO_STRING(this.getName());
        if (this.getSeriesColumn() != null) {
            series = this.getSeriesColumn();
        }
        String sql = "SELECT " + this.getKeyColumn() + "," + category + "," + series + " FROM " + this.getFromClause();
        if (!Util.isEmpty(where)) {
            sql = String.valueOf(sql) + " WHERE " + where;
        }
        sql = String.valueOf(sql) + " GROUP BY " + series + ", " + category + "," + this.getKeyColumn() + " ORDER BY " + series + ", " + category + "," + this.getKeyColumn();
        StringBuffer includedIds = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String key = rs.getString(2);
                    if (parent.isTimeSeries()) {
                        Date date = rs.getDate(2);
                        String unit = "yyyy-MM-dd";
                        if (parent.getTimeUnit().equals("W")) {
                            unit = "yyyy-w";
                        } else if (parent.getTimeUnit().equals("M")) {
                            unit = "yyyy-MMM";
                        } else if (parent.getTimeUnit().equals("Q")) {
                            unit = "yyyy-MM";
                        } else if (parent.getTimeUnit().equals("Y")) {
                            unit = "yyyy";
                        }
                        SimpleDateFormat format = new SimpleDateFormat(unit);
                        key = format.format(date);
                        if (parent.getTimeUnit().equals("Q")) {
                            key = this.convertToQuarter(format.format(date));
                        }
                    }
                    if (!value.equals(key)) continue;
                    if (includedIds.length() > 0) {
                        includedIds.append(",");
                    }
                    includedIds.append(id);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (includedIds.length() == 0) {
            return MQuery.getNoRecordQuery(query.getTableName(), false);
        }
        return query;
    }
}

