/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.model.MRole;
import org.compiere.model.X_C_BankStatementMatcher;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MBankStatementMatcher
extends X_C_BankStatementMatcher {
    private static final long serialVersionUID = -3756318777177414260L;
    private static CLogger s_log = CLogger.getCLogger(MBankStatementMatcher.class);
    private BankStatementMatcherInterface m_matcher = null;
    private Boolean m_matcherValid = null;

    public static MBankStatementMatcher[] getMatchers(Properties ctx, String trxName) {
        ArrayList<MBankStatementMatcher> list;
        block6: {
            list = new ArrayList<MBankStatementMatcher>();
            String sql = MRole.getDefault(ctx, false).addAccessSQL("SELECT * FROM C_BankStatementMatcher ORDER BY SeqNo", "C_BankStatementMatcher", false, false);
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MBankStatementMatcher(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MBankStatementMatcher[] retValue = new MBankStatementMatcher[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBankStatementMatcher(Properties ctx, int C_BankStatementMatcher_ID, String trxName) {
        super(ctx, C_BankStatementMatcher_ID, trxName);
    }

    public MBankStatementMatcher(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isMatcherValid() {
        if (this.m_matcherValid == null) {
            this.getMatcher();
        }
        return this.m_matcherValid;
    }

    public BankStatementMatcherInterface getMatcher() {
        if (this.m_matcher != null || this.m_matcherValid != null && this.m_matcherValid.booleanValue()) {
            return this.m_matcher;
        }
        String className = this.getClassname();
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("MBankStatementMatch Class Name=" + className);
            }
            this.m_matcher = Core.getBankStatementMatcher(className);
            if (this.m_matcher == null) {
                Class<?> bsrClass = Class.forName(className);
                this.m_matcher = (BankStatementMatcherInterface)bsrClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.m_matcherValid = Boolean.TRUE;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, className, e);
            this.m_matcher = null;
            this.m_matcherValid = Boolean.FALSE;
        }
        return this.m_matcher;
    }
}

