/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.Query;
import org.compiere.model.X_C_BankAccount_Processor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MBankAccountProcessor
extends X_C_BankAccount_Processor {
    private static final long serialVersionUID = -9082774421123292838L;
    private static CLogger s_log = CLogger.getCLogger(MBankAccountProcessor.class);

    public static MBankAccountProcessor[] find(Properties ctx, String tender, String CCType, int AD_Client_ID, int AD_Org_ID, int C_Currency_ID, BigDecimal Amt, String trxName) {
        return MBankAccountProcessor.find(ctx, tender, CCType, AD_Client_ID, C_Currency_ID, Amt, trxName);
    }

    public static MBankAccountProcessor[] find(Properties ctx, String tender, String CCType, int AD_Client_ID, int C_Currency_ID, BigDecimal Amt, String trxName) {
        ArrayList<MBankAccountProcessor> list = new ArrayList<MBankAccountProcessor>();
        StringBuffer sql = new StringBuffer("SELECT bap.* FROM C_BankAccount_Processor bap, C_PaymentProcessor pp, C_BankAccount ba WHERE pp.C_PaymentProcessor_ID = bap.C_PaymentProcessor_ID AND ba.C_BankAccount_ID = bap.C_BankAccount_ID AND ba.AD_Client_ID=? AND pp.IsActive='Y' AND ba.IsActive='Y' AND bap.IsActive='Y'  AND (bap.C_Currency_ID IS NULL OR bap.C_Currency_ID=?) AND (bap.MinimumAmt IS NULL OR bap.MinimumAmt = 0 OR bap.MinimumAmt <= ?)");
        if ("A".equals(tender)) {
            sql.append(" AND bap.AcceptDirectDeposit='Y' AND pp.AcceptDirectDeposit='Y' ");
        } else if ("D".equals(tender)) {
            sql.append(" AND bap.AcceptDirectDebit='Y' AND pp.AcceptDirectDebit='Y' ");
        } else if ("K".equals(tender)) {
            sql.append(" AND bap.AcceptCheck='Y' AND pp.AcceptCheck='Y' ");
        } else if ("C".equals(CCType)) {
            sql.append(" AND bap.AcceptATM='Y' AND pp.AcceptATM='Y' ");
        } else if ("A".equals(CCType)) {
            sql.append(" AND bap.AcceptAMEX='Y' AND pp.AcceptAMEX='Y' ");
        } else if ("V".equals(CCType)) {
            sql.append(" AND bap.AcceptVISA='Y' AND pp.AcceptVISA='Y' ");
        } else if ("M".equals(CCType)) {
            sql.append(" AND bap.AcceptMC='Y' AND pp.AcceptMC='Y' ");
        } else if ("D".equals(CCType)) {
            sql.append(" AND bap.AcceptDiners='Y' AND pp.AcceptDiners='Y' ");
        } else if ("N".equals(CCType)) {
            sql.append(" AND bap.AcceptDiscover='Y' AND pp.AcceptDiscover='Y' ");
        } else if ("P".equals(CCType)) {
            sql.append(" AND bap.AcceptCORPORATE='Y' AND pp.AcceptCORPORATE='Y' ");
        }
        sql.append(" ORDER BY ba.IsDefault DESC ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                pstmt.setInt(1, AD_Client_ID);
                pstmt.setInt(2, C_Currency_ID);
                pstmt.setBigDecimal(3, Amt);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MBankAccountProcessor(ctx, rs, trxName));
                }
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, "find - " + sql, e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (list.size() == 0) {
            s_log.warning("find - not found - AD_Client_ID=" + AD_Client_ID + ", C_Currency_ID=" + C_Currency_ID + ", Amt=" + Amt);
        } else if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("find - #" + list.size() + " - AD_Client_ID=" + AD_Client_ID + ", C_Currency_ID=" + C_Currency_ID + ", Amt=" + Amt);
        }
        MBankAccountProcessor[] retValue = new MBankAccountProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MBankAccountProcessor get(Properties ctx, int C_BankAccount_ID, int C_PaymentProcessor_ID, String trxName) {
        String whereClause = "C_BankAccount_ID=? AND C_PaymentProcessor_ID=?";
        MBankAccountProcessor retValue = (MBankAccountProcessor)new Query(ctx, "C_BankAccount_Processor", "C_BankAccount_ID=? AND C_PaymentProcessor_ID=?", trxName).setParameters(C_BankAccount_ID, C_PaymentProcessor_ID).first();
        return retValue;
    }

    public MBankAccountProcessor(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MBankAccountProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankAccountProcessor(Properties ctx, int C_BankAccount_ID, int C_PaymentProcessor_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setC_BankAccount_ID(C_BankAccount_ID);
        this.setC_PaymentProcessor_ID(C_PaymentProcessor_ID);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MPaymentProcessor pp;
        if (this.getC_PaymentProcessor_ID() > 0 && this.isActive() && !(pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName())).isActive()) {
            throw new AdempiereException(String.valueOf(Msg.translate(this.getCtx(), "InactivePaymentProcessor")) + ". " + pp.toString());
        }
        return true;
    }

    public boolean accepts(String TenderType, String CreditCardType) {
        if (this.getC_PaymentProcessor_ID() > 0) {
            MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
            return "A".equals(TenderType) && this.isAcceptDirectDeposit() && pp.isAcceptDirectDeposit() || "D".equals(TenderType) && this.isAcceptDirectDebit() && pp.isAcceptDirectDebit() || "K".equals(TenderType) && this.isAcceptCheck() && pp.isAcceptCheck() || "C".equals(CreditCardType) && this.isAcceptATM() && pp.isAcceptATM() || "A".equals(CreditCardType) && this.isAcceptAMEX() && pp.isAcceptAMEX() || "P".equals(CreditCardType) && this.isAcceptCorporate() && pp.isAcceptCorporate() || "D".equals(CreditCardType) && this.isAcceptDiners() && pp.isAcceptDiners() || "N".equals(CreditCardType) && this.isAcceptDiscover() && pp.isAcceptDiscover() || "M".equals(CreditCardType) && this.isAcceptMC() && pp.isAcceptMC() || "V".equals(CreditCardType) && this.isAcceptVisa() && pp.isAcceptVisa();
        }
        return "A".equals(TenderType) && this.isAcceptDirectDeposit() || "D".equals(TenderType) && this.isAcceptDirectDebit() || "K".equals(TenderType) && this.isAcceptCheck() || "C".equals(CreditCardType) && this.isAcceptATM() || "A".equals(CreditCardType) && this.isAcceptAMEX() || "P".equals(CreditCardType) && this.isAcceptCorporate() || "D".equals(CreditCardType) && this.isAcceptDiners() || "N".equals(CreditCardType) && this.isAcceptDiscover() || "M".equals(CreditCardType) && this.isAcceptMC() || "V".equals(CreditCardType) && this.isAcceptVisa();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBankAccountProcessor[").append("C_BankAccount_ID=").append(this.getC_BankAccount_ID()).append(",C_PaymentProcessor_ID=").append(this.getC_PaymentProcessor_ID()).append("]");
        return sb.toString();
    }

    public String getHostAddress() {
        MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
        return pp.getHostAddress();
    }

    public int getHostPort() {
        MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
        return pp.getHostPort();
    }

    public String getProxyAddress() {
        MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
        return pp.getProxyAddress();
    }

    public int getProxyPort() {
        MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
        return pp.getProxyPort();
    }

    public String getProxyLogon() {
        MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
        return pp.getProxyLogon();
    }

    public String getProxyPassword() {
        MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
        return pp.getProxyPassword();
    }
}

