/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MBank;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_C_BankAccount;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.IBAN;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MBankAccount
extends X_C_BankAccount {
    private static final long serialVersionUID = -110709935374907275L;
    private static CCache<Integer, MBankAccount> s_cache = new CCache("C_BankAccount", 5);

    public static MBankAccount get(Properties ctx, int C_BankAccount_ID) {
        Integer key = C_BankAccount_ID;
        MBankAccount retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBankAccount(ctx, C_BankAccount_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MBankAccount(Properties ctx, int C_BankAccount_ID, String trxName) {
        super(ctx, C_BankAccount_ID, trxName);
        if (C_BankAccount_ID == 0) {
            this.setIsDefault(false);
            this.setBankAccountType("C");
            this.setCurrentBalance(Env.ZERO);
            this.setCreditLimit(Env.ZERO);
        }
    }

    public MBankAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBankAccount[").append(this.get_ID()).append("-").append(this.getAccountNo()).append("]");
        return sb.toString();
    }

    public MBank getBank() {
        return MBank.get(this.getCtx(), this.getC_Bank_ID());
    }

    @Override
    public String getName() {
        StringBuilder msgreturn = new StringBuilder().append(this.getBank().getName()).append(" ").append(this.getAccountNo());
        return msgreturn.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (MSysConfig.getBooleanValue("IBAN_VALIDATION", true, Env.getAD_Client_ID(Env.getCtx())) && !Util.isEmpty(this.getIBAN())) {
            this.setIBAN(IBAN.normalizeIBAN(this.getIBAN()));
            if (!IBAN.isValid(this.getIBAN())) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "InvalidIBAN"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            return this.insert_Accounting("C_BankAccount_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }
}

