/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_BP_Group;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MBPGroup
extends X_C_BP_Group {
    private static final long serialVersionUID = 8897399796117872715L;
    private static CCache<Integer, MBPGroup> s_cache = new CCache("C_BP_Group", 10);
    private static CCache<Integer, MBPGroup> s_cacheDefault = new CCache("C_BP_Group", String.valueOf(MBPGroup.class.getName()) + ".Default", 5);
    private static CLogger s_log = CLogger.getCLogger(MBPGroup.class);

    public static MBPGroup get(Properties ctx, int C_BP_Group_ID) {
        Integer key = C_BP_Group_ID;
        MBPGroup retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBPGroup(ctx, C_BP_Group_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MBPGroup get(Properties ctx, int C_BP_Group_ID, String trxName) {
        if (Util.isEmpty(trxName, true)) {
            return MBPGroup.get(ctx, C_BP_Group_ID);
        }
        return new MBPGroup(ctx, C_BP_Group_ID, trxName);
    }

    public static MBPGroup getDefault(Properties ctx) {
        MBPGroup retValue;
        int AD_Client_ID;
        block8: {
            AD_Client_ID = Env.getAD_Client_ID(ctx);
            Integer key = AD_Client_ID;
            retValue = s_cacheDefault.get(key);
            if (retValue != null) {
                return retValue;
            }
            String sql = "SELECT * FROM C_BP_Group g WHERE IsDefault='Y' AND AD_Client_ID=? ORDER BY IsActive DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next() && (retValue = new MBPGroup(ctx, rs, null)).get_ID() != 0) {
                        s_cacheDefault.put(key, retValue);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            s_log.warning("No Default BP Group for AD_Client_ID=" + AD_Client_ID);
        }
        return retValue;
    }

    public static MBPGroup getOfBPartner(Properties ctx, int C_BPartner_ID) {
        MBPGroup retValue;
        block7: {
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM C_BP_Group g WHERE EXISTS (SELECT * FROM C_BPartner p WHERE p.C_BPartner_ID=? AND p.C_BP_Group_ID=g.C_BP_Group_ID)";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MBPGroup(ctx, rs, null);
                        Integer key = retValue.getC_BP_Group_ID();
                        if (retValue.get_ID() != 0) {
                            s_cache.put(key, retValue);
                        }
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public MBPGroup(Properties ctx, int C_BP_Group_ID, String trxName) {
        super(ctx, C_BP_Group_ID, trxName);
        if (C_BP_Group_ID == 0) {
            this.setIsConfidentialInfo(false);
            this.setIsDefault(false);
            this.setPriorityBase("S");
        }
    }

    public MBPGroup(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public BigDecimal getCreditWatchPercent() {
        BigDecimal bd = super.getCreditWatchPercent();
        if (bd != null) {
            return bd;
        }
        return new BigDecimal(90);
    }

    public BigDecimal getCreditWatchRatio() {
        BigDecimal bd = super.getCreditWatchPercent();
        if (bd.compareTo(Env.ZERO) != 0) {
            return bd.divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
        }
        return BigDecimal.valueOf(0.9);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            return this.insert_Accounting("C_BP_Group_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }
}

