/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.compiere.model.MAttribute;
import org.compiere.model.X_M_AttributeInstance;

public class MAttributeInstance
extends X_M_AttributeInstance {
    private static final long serialVersionUID = 6154044437449512042L;

    public MAttributeInstance(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MAttributeInstance(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, String Value, String trxName) {
        super(ctx, 0, trxName);
        this.setM_Attribute_ID(M_Attribute_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setValue(Value);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, BigDecimal BDValue, String trxName) {
        super(ctx, 0, trxName);
        this.setM_Attribute_ID(M_Attribute_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setValueNumber(BDValue);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, int M_AttributeValue_ID, String Value, String trxName) {
        super(ctx, 0, trxName);
        this.setM_Attribute_ID(M_Attribute_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_AttributeValue_ID(M_AttributeValue_ID);
        this.setValue(Value);
    }

    public MAttributeInstance(Properties ctx, int m_Attribute_ID, int m_AttributeSetInstance_ID, Timestamp value, String trxName) {
        super(ctx, 0, trxName);
        this.setM_Attribute_ID(m_Attribute_ID);
        this.setM_AttributeSetInstance_ID(m_AttributeSetInstance_ID);
        this.setValueDate(value);
    }

    @Override
    public void setValueNumber(BigDecimal ValueNumber) {
        super.setValueNumber(ValueNumber);
        if (ValueNumber == null) {
            this.setValue(null);
            return;
        }
        if (ValueNumber.signum() == 0) {
            this.setValue("0");
            return;
        }
        char[] chars = ValueNumber.toString().toCharArray();
        StringBuilder display = new StringBuilder();
        boolean add = false;
        int i2 = chars.length - 1;
        while (i2 >= 0) {
            char c = chars[i2];
            if (add) {
                display.insert(0, c);
            } else if (c != '0') {
                if (c == '.') {
                    add = true;
                } else {
                    display.insert(0, c);
                    add = true;
                }
            }
            --i2;
        }
        this.setValue(display.toString());
    }

    @Override
    public void setValueDate(Timestamp valueDate) {
        super.setValueDate(valueDate);
        if (valueDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(new MAttribute(this.getCtx(), this.getM_Attribute_ID(), this.get_TrxName()).getDateFormat());
            this.setValue(sdf.format(valueDate));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String toString() {
        return this.getValue();
    }
}

