/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetGroup;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Type;
import org.compiere.util.ArhRuntimeException;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MAssetType
extends X_A_Asset_Type {
    private static final long serialVersionUID = -1371478760221357780L;
    private static final String A_ASSET_TYPE_MFX = "MFX";
    private static final String A_ASSET_TYPE_INV = "INV";
    private static CCache<Integer, MAssetType> s_cache = new CCache("A_Asset_Type", 10, 0);

    public static MAssetType get(Properties ctx, int A_Asset_Type_ID) {
        if (A_Asset_Type_ID <= 0) {
            return null;
        }
        MAssetType o = s_cache.get(A_Asset_Type_ID);
        if (o != null) {
            return o;
        }
        o = new MAssetType(ctx, A_Asset_Type_ID, null);
        if (o.get_ID() > 0) {
            s_cache.put(A_Asset_Type_ID, o);
            return o;
        }
        return null;
    }

    public static MAssetType get(Properties ctx, Object id) {
        if (id == null) {
            return null;
        }
        return MAssetType.get(ctx, ((Number)id).intValue());
    }

    public MAssetType(Properties ctx, int A_Asset_Type_ID, String trxName) {
        super(ctx, A_Asset_Type_ID, trxName);
    }

    public MAssetType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isFixedAsset() {
        return A_ASSET_TYPE_MFX.equals(this.getValue());
    }

    public static boolean isFixedAsset(int A_Asset_ID) {
        MAsset asset = MAsset.get(Env.getCtx(), A_Asset_ID, null);
        return MAssetType.isFixedAsset(asset);
    }

    public static boolean isFixedAsset(MAsset asset) {
        return asset != null && A_ASSET_TYPE_MFX.equals(asset.getA_Asset_Type().getValue());
    }

    public static boolean isFixedAssetGroup(Properties ctx, int A_Asset_Group_ID) {
        if (A_Asset_Group_ID <= 0) {
            return false;
        }
        MAssetGroup assetGroup = MAssetGroup.get(ctx, A_Asset_Group_ID);
        int assetType_ID = assetGroup.getA_Asset_Type_ID();
        if (assetType_ID <= 0) {
            return false;
        }
        MAssetType assetType = MAssetType.get(ctx, assetType_ID);
        return assetType.isFixedAsset();
    }

    public boolean isInventoryObject() {
        return A_ASSET_TYPE_INV.equals(this.getValue());
    }

    protected static Boolean getBoolean(String value, boolean useDefaults) {
        if (value == null || value.length() == 0) {
            return null;
        }
        String f = value.substring(0, 1);
        if ("N".equals(f)) {
            return Boolean.FALSE;
        }
        if ("Y".equals(f)) {
            return Boolean.TRUE;
        }
        if ("X".equals(f) && useDefaults) {
            return MAssetType.getBoolean(value.substring(1), false);
        }
        return null;
    }

    public static void validate(Model m) {
        MAssetType assetType = MAssetType.get(m.getCtx(), m.getA_Asset_Type_ID());
        if (assetType == null) {
            throw new ArhRuntimeException(m.getCtx(), "@NotFound@ @A_Asset_Type_ID@").addInfo("@A_Asset_Type_ID", m.getA_Asset_Type_ID());
        }
        ArhRuntimeException err = new ArhRuntimeException(m.getCtx(), "");
        Boolean f = MAssetType.getBoolean(assetType.getIsOwned(), false);
        if (f != null && f.booleanValue() != m.isOwned()) {
            err.addInfo("@IsOwned@ <> @" + f + "@");
        }
        if ((f = MAssetType.getBoolean(assetType.getIsInPosession(), false)) != null && f.booleanValue() != m.isInPosession()) {
            err.addInfo("@IsInPosession@ <> @" + f + "@");
        }
        if ((f = MAssetType.getBoolean(assetType.getIsDepreciable(), false)) != null && f.booleanValue() != m.isDepreciated()) {
            err.addInfo("@IsDepreciated@ <> @" + f + "@");
        }
        if (err.hasInfo()) {
            throw err;
        }
    }

    public boolean update(SetGetModel model, boolean useDefaults) {
        Boolean f = MAssetType.getBoolean(this.getIsOwned(), useDefaults);
        if (f != null) {
            model.set_AttrValue("IsOwned", f);
        }
        if ((f = MAssetType.getBoolean(this.getIsInPosession(), useDefaults)) != null) {
            model.set_AttrValue("IsInPosession", f);
        }
        if ((f = MAssetType.getBoolean(this.getIsDepreciable(), useDefaults)) != null) {
            model.set_AttrValue("IsDepreciated", f);
        }
        if (!this.isFixedAsset()) {
            model.set_AttrValue("A_Asset_Class_ID", null);
        }
        model.set_AttrValue("A_Asset_Type", this.getValue());
        return true;
    }

    public static class Callout
    extends CalloutEngine {
        public String assetType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
            if (this.isCalloutActive()) {
                return "";
            }
            int A_Asset_Type_ID = 0;
            if (value == null || !(value instanceof Number)) {
                return "";
            }
            A_Asset_Type_ID = ((Number)value).intValue();
            MAssetType assetType = MAssetType.get(ctx, A_Asset_Type_ID);
            if (assetType != null) {
                assetType.update(SetGetUtil.wrap(mTab), true);
            }
            return "";
        }
    }

    public static interface Model {
        public Properties getCtx();

        public int getA_Asset_Type_ID();

        public boolean isInPosession();

        public boolean isOwned();

        public boolean isDepreciated();
    }
}

