/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset_Change;
import org.compiere.util.CLogger;

public class MAssetChange
extends X_A_Asset_Change {
    private static final long serialVersionUID = 4083373951793617528L;
    private static CLogger s_log = CLogger.getCLogger(MAssetChange.class);

    public MAssetChange(Properties ctx, int A_Asset_Change_ID, String trxName) {
        super(ctx, A_Asset_Change_ID, trxName);
    }

    public MAssetChange(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String textDetails = this.getTextDetails();
        if (textDetails == null || textDetails.length() == 0) {
            this.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", this.getChangeType()));
        }
        return true;
    }

    public static MAssetChange createAddition(MAssetAddition assetAdd, MDepreciationWorkfile assetwk) {
        MAssetChange change = new MAssetChange(assetAdd.getCtx(), 0, assetAdd.get_TrxName());
        change.setAD_Org_ID(assetAdd.getAD_Org_ID());
        change.setA_Asset_ID(assetAdd.getA_Asset_ID());
        change.setA_QTY_Current(assetAdd.getA_QTY_Current());
        change.setChangeType("ADD");
        change.setTextDetails(MRefList.getListDescription(assetAdd.getCtx(), "A_Update_Type", "ADD"));
        change.setPostingType(assetwk.getPostingType());
        change.setAssetValueAmt(assetAdd.getAssetValueAmt());
        change.setA_QTY_Current(assetAdd.getA_QTY_Current());
        change.saveEx();
        return change;
    }

    public static MAssetChange create(Properties ctx, String changeType, PO[] pos, String trxName) {
        return MAssetChange.create(ctx, changeType, pos, false, trxName);
    }

    public static MAssetChange createAndSave(Properties ctx, String changeType, PO[] pos, String trxName) {
        return null;
    }

    public static MAssetChange create(Properties ctx, String changeType, PO[] pos, boolean save, String trxName) {
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Entering: changeType=" + changeType);
        }
        if (pos == null || pos.length == 0) {
            s_log.fine("Entering/Leaving: POs is empty");
            return null;
        }
        MAssetChange change = new MAssetChange(ctx, 0, trxName);
        change.setChangeType(changeType);
        PO[] pOArray = pos;
        int n = pos.length;
        int n2 = 0;
        while (n2 < n) {
            PO po = pOArray[n2];
            change.addChanges(po);
            ++n2;
        }
        if (save) {
            change.saveEx();
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Leaving: change=" + change);
        }
        return change;
    }

    public void addChanges(PO po) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: po=" + po);
        }
        if (po == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: po=" + po);
        }
    }
}

