/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAssetProduct;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MConversionType;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MFactAcct;
import org.compiere.model.MIFixedAsset;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Addition;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProjectClose;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.idempiere.fa.exceptions.AssetAlreadyDepreciatedException;
import org.idempiere.fa.exceptions.AssetException;
import org.idempiere.fa.exceptions.AssetNotImplementedException;
import org.idempiere.fa.exceptions.AssetNotSupportedException;
import org.idempiere.fa.feature.UseLifeImpl;
import org.idempiere.fa.util.POCacheLocal;

public class MAssetAddition
extends X_A_Asset_Addition
implements DocAction {
    private static final long serialVersionUID = 5977180589101094202L;
    private static CLogger s_log = CLogger.getCLogger(MAssetAddition.class);
    private final POCacheLocal<MProject> m_cacheCProject = POCacheLocal.newInstance(this, MProject.class);
    private final POCacheLocal<MMatchInv> m_cacheMatchInv = POCacheLocal.newInstance(this, MMatchInv.class);
    private final POCacheLocal<MIFixedAsset> m_cacheIFixedAsset = POCacheLocal.newInstance(this, MIFixedAsset.class);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private final POCacheLocal<MAsset> m_cacheAsset = POCacheLocal.newInstance(this, MAsset.class);

    public MAssetAddition(Properties ctx, int A_Asset_Addition_ID, String trxName) {
        super(ctx, A_Asset_Addition_ID, trxName);
        if (A_Asset_Addition_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetAddition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setA_CreateAsset();
        if (this.isA_CreateAsset() && this.getA_QTY_Current().signum() == 0) {
            this.setA_QTY_Current(Env.ONE);
        }
        if (this.getC_Currency_ID() <= 0) {
            this.setC_Currency_ID(MClient.get(this.getCtx()).getAcctSchema().getC_Currency_ID());
        }
        if (this.getC_ConversionType_ID() <= 0) {
            this.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
        }
        this.getDateAcct();
        this.setAssetValueAmt();
        if (this.isA_CreateAsset()) {
            this.setA_CapvsExp("Cap");
        }
        this.setIsApproved();
        return true;
    }

    public static MAssetAddition createAsset(MMatchInv match) {
        MAssetAddition assetAdd = new MAssetAddition(match);
        assetAdd.dump();
        if ("Cap".equals(assetAdd.getA_CapvsExp()) && match.getC_InvoiceLine().getA_Asset_ID() == 0 && assetAdd.isA_CreateAsset()) {
            MAsset asset = assetAdd.createAsset();
            asset.dump();
            MAssetGroupAcct assetgrpacct = MAssetGroupAcct.forA_Asset_Group_ID(asset.getCtx(), asset.getA_Asset_Group_ID(), assetAdd.getPostingType());
            assetAdd.setDeltaUseLifeYears(assetgrpacct.getUseLifeYears());
            assetAdd.setDeltaUseLifeYears_F(assetgrpacct.getUseLifeYears_F());
        } else {
            assetAdd.setA_Asset_ID(match.getC_InvoiceLine().getA_Asset_ID());
            assetAdd.setA_CreateAsset(false);
        }
        assetAdd.saveEx();
        return assetAdd;
    }

    public static MAssetAddition createAsset(MIFixedAsset ifa) {
        MAssetAddition assetAdd = new MAssetAddition(ifa);
        assetAdd.dump();
        if ("Cap".equals(assetAdd.getA_CapvsExp()) && ifa.getA_Asset_ID() == 0) {
            MAsset asset = assetAdd.createAsset();
            asset.dump();
        }
        assetAdd.saveEx();
        return assetAdd;
    }

    public static MAssetAddition createAsset(MProject project, MProduct product) {
        MAssetAddition assetAdd = new MAssetAddition(project);
        assetAdd.dump();
        MAsset asset = assetAdd.createAsset();
        if (product != null) {
            asset.setM_Product_ID(product.getM_Product_ID());
            asset.setA_Asset_Group_ID(product.getA_Asset_Group_ID());
            MAttributeSetInstance asi = MAttributeSetInstance.create(Env.getCtx(), product, null);
            asset.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
            asset.setName(product.getName().concat(project.getName()));
            asset.setValue(product.getName().concat(project.getName()));
        }
        asset.saveEx();
        asset.dump();
        MAssetGroupAcct assetgrpacct = MAssetGroupAcct.forA_Asset_Group_ID(asset.getCtx(), asset.getA_Asset_Group_ID(), assetAdd.getPostingType());
        assetAdd.setDeltaUseLifeYears(assetgrpacct.getUseLifeYears());
        assetAdd.setDeltaUseLifeYears_F(assetgrpacct.getUseLifeYears_F());
        assetAdd.setA_Asset(asset);
        assetAdd.saveEx();
        return assetAdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MAsset createAsset() {
        MAsset asset = null;
        if (this.getA_Asset_ID() > 0) return this.getA_Asset(false);
        String sourceType = this.getA_SourceType();
        if ("INV".equals(sourceType)) {
            asset = new MAsset(this.getMatchInv(false));
            asset.saveEx();
            this.setA_Asset(asset);
            return asset;
        } else if ("IMP".equals(sourceType)) {
            asset = new MAsset(this.getI_FixedAsset(false));
            asset.saveEx();
            this.setA_Asset(asset);
            return asset;
        } else {
            if (!"PRJ".equals(sourceType)) throw new AssetNotSupportedException("A_SourceType", sourceType);
            return new MAsset(this.getC_Project(false));
        }
    }

    private MAssetAddition(MMatchInv match) {
        this(match.getCtx(), 0, match.get_TrxName());
        this.setM_MatchInv(match);
        this.setC_DocType_ID();
    }

    private MAssetAddition(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: Project=" + project);
        }
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("PRJ");
        this.setC_Currency_ID(project.getC_Currency_ID());
        if (project.get_ValueAsInt("C_ConversionType_ID") > 0) {
            this.setC_ConversionType_ID(project.get_ValueAsInt("C_ConversionType_ID"));
        }
        this.setSourceAmt(project.getProjectBalanceAmt());
        this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        this.setA_CreateAsset(true);
        this.setDeltaUseLifeYears(I_ZERO);
        this.setDeltaUseLifeYears_F(I_ZERO);
        this.setC_DocType_ID();
        Timestamp dateAcct = new Timestamp(System.currentTimeMillis());
        if (dateAcct != null) {
            dateAcct = UseLifeImpl.getDateAcct(dateAcct, 1);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DateAcct=" + dateAcct);
            }
            this.setDateAcct(dateAcct);
        }
        this.setC_Project(project);
    }

    public MProject getC_Project(boolean requery) {
        return this.m_cacheCProject.get(requery);
    }

    private void setC_Project(MProject project) {
        this.set_Value("C_Project_ID", (Object)project.get_ID());
        this.m_cacheCProject.set(project);
    }

    private MAssetAddition(MIFixedAsset ifa) {
        this(ifa.getCtx(), 0, ifa.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: ifa=" + ifa);
        }
        this.setAD_Org_ID(ifa.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("IMP");
        this.setM_Product_ID(ifa.getM_Product_ID());
        this.setSourceAmt(ifa.getA_Asset_Cost());
        this.setDateDoc(ifa.getAssetServiceDate());
        this.setM_Locator_ID(ifa.getM_Locator_ID());
        boolean isAccmDeprAdjust = ifa.getA_Accumulated_Depr().compareTo(Env.ZERO) > 0;
        this.setA_Accumulated_Depr_Adjust(isAccmDeprAdjust);
        this.setA_Period_Start(ifa.getA_Current_Period());
        this.setA_Accumulated_Depr(ifa.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(ifa.getA_Accumulated_Depr_F());
        this.setDeltaUseLifeYears(ifa.getUseLifeMonths() / 12);
        this.setDeltaUseLifeYears_F(ifa.getUseLifeMonths_F() / 12);
        this.setA_CapvsExp("Cap");
        this.setA_CreateAsset(true);
        this.setA_Salvage_Value(ifa.getA_Salvage_Value());
        this.setC_DocType_ID();
        Timestamp dateAcct = ifa.getDateAcct();
        if (dateAcct != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DateAcct=" + dateAcct);
            }
            this.setDateAcct(dateAcct);
        }
        this.setI_FixedAsset(ifa);
    }

    private MMatchInv getMatchInv(boolean requery) {
        return this.m_cacheMatchInv.get(requery);
    }

    private void setM_MatchInv(MMatchInv mi) {
        mi.load(this.get_TrxName());
        this.setAD_Org_ID(mi.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("INV");
        this.setM_MatchInv_ID(mi.get_ID());
        if ("Cap".equals(mi.getC_InvoiceLine().getA_CapvsExp()) && mi.getC_InvoiceLine().getA_Asset_ID() == 0) {
            this.setA_CreateAsset(true);
        }
        this.setC_Invoice_ID(mi.getC_InvoiceLine().getC_Invoice_ID());
        this.setC_InvoiceLine_ID(mi.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(mi.getM_InOutLine_ID());
        this.setM_Product_ID(mi.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(mi.getM_AttributeSetInstance_ID());
        this.setA_QTY_Current(mi.getQty());
        this.setLine(mi.getC_InvoiceLine().getLine());
        this.setM_Locator_ID(mi.getM_InOutLine().getM_Locator_ID());
        this.setA_CapvsExp(mi.getC_InvoiceLine().getA_CapvsExp());
        this.setAssetAmtEntered(mi.getC_InvoiceLine().getLineNetAmt());
        this.setAssetSourceAmt(mi.getC_InvoiceLine().getLineNetAmt());
        this.setC_Currency_ID(mi.getC_InvoiceLine().getC_Invoice().getC_Currency_ID());
        this.setC_ConversionType_ID(mi.getC_InvoiceLine().getC_Invoice().getC_ConversionType_ID());
        this.setDateDoc(mi.getM_InOutLine().getM_InOut().getMovementDate());
        this.setDateAcct(mi.getM_InOutLine().getM_InOut().getMovementDate());
        this.m_cacheMatchInv.set(mi);
    }

    public static boolean setM_MatchInv(SetGetModel model, int M_MatchInv_ID) {
        boolean newRecord = false;
        String trxName = null;
        if (model instanceof PO) {
            PO po = (PO)((Object)model);
            newRecord = po.is_new();
            trxName = po.get_TrxName();
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Entering: model=" + model + ", M_MatchInv_ID=" + M_MatchInv_ID + ", newRecord=" + newRecord + ", trxName=" + trxName);
        }
        String qMatchInv_select = "SELECT  C_Invoice_ID, C_InvoiceLine_ID, M_InOutLine_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty AS A_QTY_Current, InvoiceLine AS Line, M_Locator_ID, A_CapVsExp, MatchNetAmt AS AssetAmtEntered, MatchNetAmt AS AssetSourceAmt, C_Currency_ID, C_ConversionType_ID, MovementDate AS DateDoc";
        String qMatchInv_from = " FROM mb_matchinv WHERE M_MatchInv_ID=";
        String query = "SELECT  C_Invoice_ID, C_InvoiceLine_ID, M_InOutLine_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty AS A_QTY_Current, InvoiceLine AS Line, M_Locator_ID, A_CapVsExp, MatchNetAmt AS AssetAmtEntered, MatchNetAmt AS AssetSourceAmt, C_Currency_ID, C_ConversionType_ID, MovementDate AS DateDoc";
        if (newRecord) {
            query = String.valueOf(query) + ", A_Asset_ID, A_CreateAsset";
        }
        query = String.valueOf(query) + " FROM mb_matchinv WHERE M_MatchInv_ID=" + M_MatchInv_ID;
        SetGetUtil.updateColumns(model, null, query, trxName);
        s_log.fine("Leaving: RETURN TRUE");
        return true;
    }

    public MIFixedAsset getI_FixedAsset(boolean requery) {
        return this.m_cacheIFixedAsset.get(requery);
    }

    private void setI_FixedAsset(MIFixedAsset ifa) {
        this.setI_FixedAsset_ID(ifa.get_ID());
        this.m_cacheIFixedAsset.set(ifa);
    }

    private void setAssetValueAmt() {
        this.getDateAcct();
        MConversionRateUtil.convertBase(SetGetUtil.wrap(this), "DateAcct", "AssetSourceAmt", "AssetValueAmt", null);
    }

    public void setSourceAmt(BigDecimal amt) {
        this.setAssetAmtEntered(amt);
        this.setAssetSourceAmt(amt);
    }

    public void setIsApproved() {
        if (!this.isProcessed()) {
            String str = Env.getContext(this.getCtx(), "#IsCanApproveOwnDoc");
            boolean isApproved = "Y".equals(str);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#IsCanApproveOwnDoc=" + str + "=" + isApproved);
            }
            this.setIsApproved(isApproved);
        }
    }

    @Override
    public Timestamp getDateAcct() {
        Timestamp dateAcct = super.getDateAcct();
        if (dateAcct == null) {
            dateAcct = this.getDateDoc();
            this.setDateAcct(dateAcct);
        }
        return dateAcct;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return false;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLJ", this.getAD_Org_ID());
        if (this.getAssetValueAmt().signum() == 0) {
            this.m_processMsg = "@Invalid@ @AssetValueAmt@=0";
            return "IN";
        }
        MAsset asset = this.getA_Asset(true);
        if (this.isA_CreateAsset() && this.hasZeroValues()) {
            throw new AssetException("New document has nulls");
        }
        if (this.isA_CreateAsset() && !"NW".equals(asset.getA_Asset_Status())) {
            throw new AssetException("Only new assets can be activated");
        }
        if ("PRJ".equals(this.getA_SourceType())) {
            if (this.getC_Project_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"C_Project_ID"});
            }
            String whereClause = "C_Project_ID=? AND DocStatus IN ('IP','CO','CL') AND A_Asset_Addition_ID<>?";
            List list = new Query(this.getCtx(), "A_Asset_Addition", "C_Project_ID=? AND DocStatus IN ('IP','CO','CL') AND A_Asset_Addition_ID<>?", this.get_TrxName()).setParameters(this.getC_Project_ID(), this.get_ID()).list();
            if (list.size() > 0) {
                StringBuilder sb = new StringBuilder("You can not create project for this asset, Project already has assets. View: ");
                for (MAssetAddition aa : list) {
                    sb.append(aa.getDocumentInfo()).append("; ");
                }
                throw new AssetException(sb.toString());
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        MDepreciationWorkfile assetwk;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.checkCreateASI();
        MAsset asset = this.getA_Asset(!this.m_justPrepared);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("asset=" + asset);
        }
        if ((assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName())) == null) {
            assetwk = new MDepreciationWorkfile(asset, this.getPostingType(), null);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("workfile: " + assetwk);
        }
        if (this.getA_CapvsExp().equals("Cap")) {
            MDepreciationExp.checkExistsNotProcessedEntries(assetwk.getCtx(), assetwk.getA_Asset_ID(), this.getDateAcct(), assetwk.getPostingType(), assetwk.get_TrxName());
            if (this.getA_Salvage_Value().signum() > 0) {
                assetwk.setA_Salvage_Value(this.getA_Salvage_Value());
            }
            assetwk.adjustCost(this.getAssetValueAmt(), this.getA_QTY_Current(), this.isA_CreateAsset());
            assetwk.adjustUseLife(this.getDeltaUseLifeYears(), this.getDeltaUseLifeYears_F(), this.isA_CreateAsset());
            assetwk.setDateAcct(this.getDateAcct());
            assetwk.setProcessed(true);
            assetwk.saveEx();
        }
        MAssetChange.createAddition(this, assetwk);
        if (this.isA_CreateAsset() && this.getM_Locator_ID() > 0) {
            asset.setM_Locator_ID(this.getM_Locator_ID());
        }
        this.updateA_Asset_Product(false);
        if (this.isA_CreateAsset()) {
            asset.setAssetServiceDate(this.getDateDoc());
        }
        asset.changeStatus("AC", this.getDateAcct());
        asset.saveEx();
        if (this.isA_CreateAsset() && !this.isA_Accumulated_Depr_Adjust()) {
            assetwk.setA_Current_Period(1);
            assetwk.saveEx();
        }
        if (this.isA_Accumulated_Depr_Adjust() && this.isA_CreateAsset() && this.isA_Accumulated_Depr_Adjust()) {
            assetwk.setA_Current_Period(this.getA_Period_Start());
            assetwk.setA_Accumulated_Depr(this.getA_Accumulated_Depr());
            assetwk.setA_Accumulated_Depr_F(this.getA_Accumulated_Depr_F());
            assetwk.saveEx();
        }
        assetwk.buildDepreciation();
        this.updateSourceDocument(false);
        this.setProcessed(true);
        this.setDocAction("CL");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.reverseIt(false);
        String errmsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (errmsg != null) {
            this.m_processMsg = errmsg;
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private void reverseIt(boolean isReActivate) {
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.setDocAction("--");
            throw new AssetException("Document Closed: " + this.getDocStatus());
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk == null) {
            throw new AssetException("@NotFound@ @A_DepreciationWorkfile_ID");
        }
        if (assetwk.isFullyDepreciated()) {
            throw new AssetNotImplementedException("Unable to verify if it is fully depreciated");
        }
        if (!this.isA_CreateAsset() && assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        assetwk.adjustCost(this.getAssetValueAmt().negate(), this.getA_QTY_Current().negate(), false);
        assetwk.adjustUseLife(0 - this.getDeltaUseLifeYears(), 0 - this.getDeltaUseLifeYears_F(), false);
        assetwk.saveEx();
        String whereClause = "A_Asset_Addition_ID=? AND PostingType=?";
        List list = new Query(this.getCtx(), "A_Depreciation_Exp", "A_Asset_Addition_ID=? AND PostingType=?", this.get_TrxName()).setParameters(this.get_ID(), assetwk.getPostingType()).setOrderBy("DateAcct DESC, A_Depreciation_Exp_ID DESC").list();
        for (MDepreciationExp depexp : list) {
            depexp.deleteEx(true);
        }
        if (this.isA_CreateAsset()) {
            assetwk.deleteEx(true);
        } else {
            assetwk.setA_Current_Period();
            assetwk.saveEx();
            assetwk.buildDepreciation();
        }
        this.updateA_Asset_Product(true);
        if (this.isA_CreateAsset()) {
            MAsset asset = this.getA_Asset(true);
            asset.changeStatus("NW", this.getDateAcct());
            asset.saveEx();
            if (!isReActivate) {
                this.setA_CreateAsset(false);
            }
        }
        MFactAcct.deleteEx(this.get_Table_ID(), this.get_ID(), this.get_TrxName());
        this.updateSourceDocument(true);
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("reverseCorrectIt");
    }

    @Override
    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("reverseAccrualIt");
    }

    @Override
    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.reverseIt(true);
        String errmsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (errmsg != null) {
            this.m_processMsg = errmsg;
            return false;
        }
        this.setProcessed(false);
        this.setDocAction("CO");
        return true;
    }

    @Override
    public String getSummary() {
        MAsset asset = this.getA_Asset(false);
        StringBuilder sb = new StringBuilder();
        sb.append("@DocumentNo@ #").append(this.getDocumentNo()).append(": @A_CreateAsset@=@").append(this.isA_CreateAsset() ? "Y" : "N").append("@");
        if (asset != null) {
            sb.append(", @A_Asset_ID@=").append(asset.getName());
        }
        return Msg.parseTranslation(this.getCtx(), sb.toString());
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getAssetValueAmt();
    }

    public MAsset getA_Asset(boolean requery) {
        return this.m_cacheAsset.get(requery);
    }

    private void setA_Asset(MAsset asset) {
        this.setA_Asset_ID(asset.getA_Asset_ID());
        this.m_cacheAsset.set(asset);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        this.updateSourceDocument(false);
        return true;
    }

    private void updateSourceDocument(boolean isReversalParam) {
        String sourceType;
        boolean isReversal = isReversalParam;
        String docStatus = this.getDocStatus();
        if (!isReversal && ("RE".equals(docStatus) || "VO".equals(docStatus))) {
            isReversal = true;
        }
        if ("INV".equals(sourceType = this.getA_SourceType()) && this.isProcessed()) {
            int C_InvoiceLine_ID = this.getC_InvoiceLine_ID();
            MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.get_TrxName());
            invoiceLine.setA_Processed(!isReversal);
            invoiceLine.setA_Asset_ID(isReversal ? 0 : this.getA_Asset_ID());
            invoiceLine.saveEx();
        } else if ("PRJ".equals(sourceType) && this.isProcessed()) {
            if (!isReversal) {
                int project_id = this.getC_Project_ID();
                ProcessInfo pi = new ProcessInfo("", 0, 203, project_id);
                pi.setAD_Client_ID(this.getAD_Client_ID());
                pi.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
                ProjectClose proc = new ProjectClose();
                proc.startProcess(this.getCtx(), pi, Trx.get(this.get_TrxName(), false));
                if (pi.isError()) {
                    throw new AssetException(pi.getSummary());
                }
            }
        } else if ("IMP".equals(sourceType) && !this.isProcessed()) {
            MIFixedAsset ifa;
            if (this.is_new() && this.getI_FixedAsset_ID() > 0 && (ifa = this.getI_FixedAsset(false)) != null) {
                ifa.setI_IsImported(true);
                ifa.setA_Asset_ID(this.getA_Asset_ID());
                ifa.saveEx(this.get_TrxName());
            }
        } else if ("MAN".equals(sourceType) && this.isProcessed()) {
            this.log.fine("Nothing to do");
        }
    }

    private void checkCreateASI() {
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MAttributeSetInstance asi = null;
        if (product != null && this.getM_AttributeSetInstance_ID() == 0) {
            asi = new MAttributeSetInstance(this.getCtx(), 0, this.get_TrxName());
            asi.setAD_Org_ID(0);
            asi.setM_AttributeSet_ID(product.getM_AttributeSet_ID());
            asi.saveEx();
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
    }

    private void updateA_Asset_Product(boolean isReversal) {
        if (this.getM_Product_ID() <= 0) {
            return;
        }
        MAssetProduct assetProduct = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        if (assetProduct.get_ID() <= 0 && isReversal) {
            this.log.warning("No Product found " + this + " [IGNORE]");
            return;
        }
        BigDecimal adjQty = this.getA_QTY_Current();
        if (isReversal) {
            adjQty = adjQty.negate();
        }
        assetProduct.addA_Qty_Current(this.getA_QTY_Current());
        assetProduct.setAD_Org_ID(this.getA_Asset().getAD_Org_ID());
        assetProduct.saveEx();
        if (this.isA_CreateAsset()) {
            MAsset asset = this.getA_Asset(false);
            assetProduct.updateAsset(asset);
            asset.saveEx();
        }
    }

    public boolean hasZeroValues() {
        return this.getDeltaUseLifeYears() <= 0 || this.getDeltaUseLifeYears_F() <= 0 || this.getDeltaUseLifeYears() != this.getDeltaUseLifeYears_F() || this.getAssetValueAmt().signum() <= 0;
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(this.getDocumentNo()) + " / " + this.getDateDoc();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("@DocumentNo@: " + this.getDocumentNo());
        MAsset asset = this.getA_Asset(false);
        if (asset != null && asset.get_ID() > 0) {
            sb.append(", @A_Asset_ID@: ").append(asset.getName());
        }
        return sb.toString();
    }

    private void setA_CreateAsset() {
        if ("VO".equals(this.getDocStatus())) {
            this.setA_CreateAsset(false);
        } else {
            String sql = "SELECT COUNT(*) FROM A_Asset_Addition WHERE A_Asset_ID=? AND A_CreateAsset='Y' AND DocStatus<>'VO' AND IsActive='Y' AND A_Asset_Addition_ID<>?";
            int cnt = DB.getSQLValueEx(null, "SELECT COUNT(*) FROM A_Asset_Addition WHERE A_Asset_ID=? AND A_CreateAsset='Y' AND DocStatus<>'VO' AND IsActive='Y' AND A_Asset_Addition_ID<>?", this.getA_Asset_ID(), this.getA_Asset_Addition_ID());
            if (this.isA_CreateAsset()) {
                if (cnt >= 1) {
                    this.setA_CreateAsset(false);
                }
            } else if (cnt == 0) {
                this.setA_CreateAsset(true);
            }
        }
    }

    private void setC_DocType_ID() {
        StringBuilder sql = new StringBuilder("SELECT C_DocType_ID FROM C_DocType ").append("WHERE AD_Client_ID=? AND AD_Org_ID IN (0,").append(this.getAD_Org_ID()).append(") AND DocBaseType='FAA' ").append("ORDER BY AD_Org_ID DESC, IsDefault DESC");
        int C_DocType_ID = DB.getSQLValue(null, sql.toString(), this.getAD_Client_ID());
        if (C_DocType_ID <= 0) {
            this.log.severe("No FAA found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(PO) - " + C_DocType_ID);
            }
            this.setC_DocType_ID(C_DocType_ID);
        }
    }
}

