/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.IArchiveStore;
import org.compiere.model.MClientInfo;
import org.compiere.model.MStorageProvider;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_AD_Archive;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MArchive
extends X_AD_Archive {
    private static final long serialVersionUID = 3217541537768473865L;
    private static CLogger s_log = CLogger.getCLogger(MArchive.class);
    public MStorageProvider provider;

    public static MArchive[] get(Properties ctx, String whereClause) {
        StringBuilder sql;
        ArrayList<MArchive> list;
        block10: {
            list = new ArrayList<MArchive>();
            sql = new StringBuilder("SELECT * FROM AD_Archive WHERE AD_Client_ID=?");
            if (whereClause != null && whereClause.length() > 0) {
                sql.append(whereClause);
            }
            sql.append(" ORDER BY Created");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, Env.getAD_Client_ID(ctx));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MArchive(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            s_log.fine(sql.toString());
        } else if (s_log.isLoggable(Level.FINER)) {
            s_log.finer(sql.toString());
        }
        MArchive[] retValue = new MArchive[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MArchive(Properties ctx, int AD_Archive_ID, String trxName) {
        super(ctx, AD_Archive_ID, trxName);
        this.initArchiveStoreDetails(ctx, trxName);
    }

    public MArchive(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.initArchiveStoreDetails(ctx, trxName);
    }

    public MArchive(Properties ctx, PrintInfo info, String trxName) {
        this(ctx, 0, trxName);
        this.setName(info.getName());
        this.setIsReport(info.isReport());
        this.setAD_Process_ID(info.getAD_Process_ID());
        this.setAD_Table_ID(info.getAD_Table_ID());
        this.setRecord_ID(info.getRecord_ID());
        this.setC_BPartner_ID(info.getC_BPartner_ID());
    }

    private void initArchiveStoreDetails(Properties ctx, String trxName) {
        MClientInfo clientInfo = MClientInfo.get(ctx);
        this.provider = new MStorageProvider(ctx, clientInfo.getStorageArchive_ID(), trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MArchive[");
        sb.append(this.get_ID()).append(",Name=").append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public byte[] getBinaryData() {
        IArchiveStore prov = this.provider.getArchiveStore();
        if (prov != null) {
            return prov.loadLOBData(this, this.provider);
        }
        return null;
    }

    public InputStream getInputStream() {
        byte[] inflatedData = this.getBinaryData();
        if (inflatedData == null) {
            return null;
        }
        return new ByteArrayInputStream(inflatedData);
    }

    @Override
    public void setBinaryData(byte[] inflatedData) {
        IArchiveStore prov = this.provider.getArchiveStore();
        if (prov != null) {
            prov.save(this, this.provider, inflatedData);
        }
    }

    public String getCreatedByName() {
        String name;
        block6: {
            name = "?";
            String sql = "SELECT Name FROM AD_User WHERE AD_User_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getCreatedBy());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        name = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return name;
    }

    public String getArchivePathSnippet() {
        StringBuilder path = new StringBuilder().append(this.getAD_Client_ID()).append(File.separator).append(this.getAD_Org_ID()).append(File.separator);
        if (this.getAD_Process_ID() > 0) {
            path.append(this.getAD_Process_ID()).append(File.separator);
        }
        if (this.getAD_Table_ID() > 0) {
            path.append(this.getAD_Table_ID()).append(File.separator);
        }
        if (this.getRecord_ID() > 0) {
            path.append(this.getRecord_ID()).append(File.separator);
        }
        return path.toString();
    }

    public byte[] getByteData() {
        return super.getBinaryData();
    }

    public void setByteData(byte[] BinaryData) {
        super.setBinaryData(BinaryData);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        byte[] data = super.getBinaryData();
        if (data == null || data.length == 0) {
            return false;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        IArchiveStore prov = this.provider.getArchiveStore();
        if (prov != null) {
            return prov.deleteArchive(this, this.provider);
        }
        return true;
    }
}

