/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.model.IAddressValidation;
import org.compiere.model.MAddressValidation;
import org.compiere.model.MOnlineTrxHistory;
import org.compiere.model.X_C_AddressTransaction;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MAddressTransaction
extends X_C_AddressTransaction {
    private static final long serialVersionUID = 8572809249265680649L;
    private String m_errorMessage = null;

    public MAddressTransaction(Properties ctx, int C_AddressTransaction_ID, String trxName) {
        super(ctx, C_AddressTransaction_ID, trxName);
    }

    public MAddressTransaction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public MAddressValidation getMAddressValidation() {
        return new MAddressValidation(this.getCtx(), this.getC_AddressValidation_ID(), this.get_TrxName());
    }

    public boolean processOnline() {
        this.setErrorMessage(null);
        boolean processed = false;
        try {
            IAddressValidation validation = Core.getAddressValidation(this.getMAddressValidation());
            if (validation == null) {
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "AddressNoValidation"));
            } else {
                processed = validation.onlineValidate(this.getCtx(), this, this.get_TrxName());
                if (!processed || !this.isValid()) {
                    this.setErrorMessage("From " + this.getMAddressValidation().getName() + ": " + this.getResult());
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processOnline", e);
            this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "AddressNotProcessed")) + ":\n" + e.getMessage());
        }
        MOnlineTrxHistory history = new MOnlineTrxHistory(this.getCtx(), 0, this.get_TrxName());
        history.setAD_Table_ID(200102);
        history.setRecord_ID(this.getC_AddressTransaction_ID());
        history.setIsError(!processed || !this.isValid());
        history.setProcessed(processed);
        StringBuilder msg = new StringBuilder();
        if (processed) {
            msg.append(this.getResult());
        } else {
            msg.append("ERROR: " + this.getErrorMessage());
        }
        history.setTextMsg(msg.toString());
        history.saveEx();
        this.setProcessed(processed);
        return processed;
    }
}

