/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MColumn;
import org.compiere.model.Query;
import org.compiere.model.X_C_AcctSchema_Element;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class MAcctSchemaElement
extends X_C_AcctSchema_Element {
    private static final long serialVersionUID = 4215184252533527719L;
    private static CLogger s_log = CLogger.getCLogger(MAcctSchemaElement.class);
    private static CCache<Integer, MAcctSchemaElement[]> s_cache = new CCache("C_AcctSchema_Element", 10);
    private String m_ColumnName = null;

    public static MAcctSchemaElement[] getAcctSchemaElements(MAcctSchema as) {
        Integer key = as.getC_AcctSchema_ID();
        MAcctSchemaElement[] retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("C_AcctSchema_ID=" + as.getC_AcctSchema_ID());
        }
        ArrayList<MAcctSchemaElement> list = new ArrayList<MAcctSchemaElement>();
        String whereClause = "C_AcctSchema_ID=? AND IsActive=?";
        List elements = new Query(as.getCtx(), "C_AcctSchema_Element", "C_AcctSchema_ID=? AND IsActive=?", as.get_TrxName()).setParameters(as.getC_AcctSchema_ID(), "Y").setOrderBy("SeqNo").list();
        for (MAcctSchemaElement ase : elements) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine(" - " + ase);
            }
            if (ase.isMandatory() && ase.getDefaultValue() == 0) {
                s_log.log(Level.SEVERE, "No default value for " + ase.getName());
            }
            list.add(ase);
        }
        retValue = new MAcctSchemaElement[list.size()];
        list.toArray(retValue);
        s_cache.put(key, retValue);
        return retValue;
    }

    public static String getColumnName(String elementType) {
        if (elementType.equals("OO")) {
            return "AD_Org_ID";
        }
        if (elementType.equals("AC")) {
            return "Account_ID";
        }
        if (elementType.equals("BP")) {
            return "C_BPartner_ID";
        }
        if (elementType.equals("PR")) {
            return "M_Product_ID";
        }
        if (elementType.equals("AY")) {
            return "C_Activity_ID";
        }
        if (elementType.equals("LF")) {
            return "C_LocFrom_ID";
        }
        if (elementType.equals("LT")) {
            return "C_LocTo_ID";
        }
        if (elementType.equals("MC")) {
            return "C_Campaign_ID";
        }
        if (elementType.equals("OT")) {
            return "AD_OrgTrx_ID";
        }
        if (elementType.equals("PJ")) {
            return "C_Project_ID";
        }
        if (elementType.equals("SR")) {
            return "C_SalesRegion_ID";
        }
        if (elementType.equals("U1")) {
            return "User1_ID";
        }
        if (elementType.equals("U2")) {
            return "User2_ID";
        }
        if (elementType.equals("X1")) {
            return "UserElement1_ID";
        }
        if (elementType.equals("X2")) {
            return "UserElement2_ID";
        }
        return "";
    }

    public static String getValueQuery(String elementType) {
        boolean translated;
        String baseLanguage = Language.getBaseAD_Language();
        String language = Language.getLoginLanguage().getAD_Language();
        boolean bl = translated = Env.isMultiLingualDocument(Env.getCtx()) && !language.equalsIgnoreCase(baseLanguage);
        if (elementType.equals("OO")) {
            return "SELECT Value,Name FROM AD_Org WHERE AD_Org_ID=";
        }
        if (elementType.equals("AC") || elementType.equals("U1") || elementType.equals("U2")) {
            if (translated) {
                return "SELECT o.Value,t.Name FROM C_ElementValue o JOIN C_ElementValue_Trl t ON (o.C_ElementValue_ID=t.C_ElementValue_ID AND t.AD_Language=" + DB.TO_STRING(language) + ") WHERE o.C_ElementValue_ID=";
            }
            return "SELECT Value,Name FROM C_ElementValue WHERE C_ElementValue_ID=";
        }
        if (elementType.equals("SA")) {
            return "SELECT Value,Name FROM C_SubAccount WHERE C_SubAccount_ID=";
        }
        if (elementType.equals("BP")) {
            return "SELECT Value,Name FROM C_BPartner WHERE C_BPartner_ID=";
        }
        if (elementType.equals("PR")) {
            if (translated) {
                return "SELECT o.Value,t.Name FROM M_Product o JOIN M_Product_Trl t ON (o.M_Product_ID=t.M_Product_ID AND t.AD_Language=" + DB.TO_STRING(language) + ") WHERE o.M_Product_ID=";
            }
            return "SELECT Value,Name FROM M_Product WHERE M_Product_ID=";
        }
        if (elementType.equals("AY")) {
            if (translated) {
                return "SELECT Value,Name FROM C_Activity o JOIN C_Activity_Trl t ON (o.C_Activity_ID=t.C_Activity_ID AND t.AD_Language=" + DB.TO_STRING(language) + ") WHERE o.C_Activity_ID=";
            }
            return "SELECT Value,Name FROM C_Activity WHERE C_Activity_ID=";
        }
        if (elementType.equals("LF") || elementType.equals("LT")) {
            return "SELECT City,Address1 FROM C_Location WHERE C_Location_ID=";
        }
        if (elementType.equals("MC")) {
            if (translated) {
                return "SELECT Value,Name FROM C_Campaign o JOIN C_Campaign_Trl t ON (o.C_Campaign_ID=t.C_Campaign_ID AND t.AD_Language=" + DB.TO_STRING(language) + ") WHERE o.C_Campaign_ID=";
            }
            return "SELECT Value,Name FROM C_Campaign WHERE C_Campaign_ID=";
        }
        if (elementType.equals("OT")) {
            return "SELECT Value,Name FROM AD_Org WHERE AD_Org_ID=";
        }
        if (elementType.equals("PJ")) {
            return "SELECT Value,Name FROM C_Project WHERE C_Project_ID=";
        }
        if (elementType.equals("SR")) {
            if (translated) {
                return "SELECT Value,Name FROM C_SalesRegion o JOIN C_SalesRegion_Trl t ON (o.C_SalesRegion_ID=t.C_SalesRegion_ID AND t.AD_Language=" + DB.TO_STRING(language) + ") WHERE o.C_SalesRegion_ID=";
            }
            return "SELECT Value,Name FROM C_SalesRegion WHERE C_SalesRegion_ID=";
        }
        if (elementType.equals("X1") || elementType.equals("X2")) {
            return null;
        }
        return "";
    }

    public MAcctSchemaElement(Properties ctx, int C_AcctSchema_Element_ID, String trxName) {
        super(ctx, C_AcctSchema_Element_ID, trxName);
        if (C_AcctSchema_Element_ID == 0) {
            this.setIsBalanced(false);
            this.setIsMandatory(false);
        }
    }

    public MAcctSchemaElement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAcctSchemaElement(MAcctSchema as) {
        this(as.getCtx(), 0, as.get_TrxName());
        this.setClientOrg(as);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
    }

    public void setTypeOrg(int SeqNo, String Name2, int Org_ID) {
        this.setElementType("OO");
        this.setSeqNo(SeqNo);
        this.setName(Name2);
        this.setOrg_ID(Org_ID);
    }

    public void setTypeAccount(int SeqNo, String Name2, int C_Element_ID, int C_ElementValue_ID) {
        this.setElementType("AC");
        this.setSeqNo(SeqNo);
        this.setName(Name2);
        this.setC_Element_ID(C_Element_ID);
        this.setC_ElementValue_ID(C_ElementValue_ID);
    }

    public void setTypeBPartner(int SeqNo, String Name2, int C_BPartner_ID) {
        this.setElementType("BP");
        this.setSeqNo(SeqNo);
        this.setName(Name2);
        this.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setTypeProduct(int SeqNo, String Name2, int M_Product_ID) {
        this.setElementType("PR");
        this.setSeqNo(SeqNo);
        this.setName(Name2);
        this.setM_Product_ID(M_Product_ID);
    }

    public void setTypeProject(int SeqNo, String Name2, int C_Project_ID) {
        this.setElementType("PJ");
        this.setSeqNo(SeqNo);
        this.setName(Name2);
        this.setC_Project_ID(C_Project_ID);
    }

    public boolean isElementType(String elementType) {
        if (elementType == null) {
            return false;
        }
        return elementType.equals(this.getElementType());
    }

    public int getDefaultValue() {
        String elementType = this.getElementType();
        int defaultValue = 0;
        if (elementType.equals("OO")) {
            defaultValue = this.getOrg_ID();
        } else if (elementType.equals("AC")) {
            defaultValue = this.getC_ElementValue_ID();
        } else if (elementType.equals("BP")) {
            defaultValue = this.getC_BPartner_ID();
        } else if (elementType.equals("PR")) {
            defaultValue = this.getM_Product_ID();
        } else if (elementType.equals("AY")) {
            defaultValue = this.getC_Activity_ID();
        } else if (elementType.equals("LF")) {
            defaultValue = this.getC_Location_ID();
        } else if (elementType.equals("LT")) {
            defaultValue = this.getC_Location_ID();
        } else if (elementType.equals("MC")) {
            defaultValue = this.getC_Campaign_ID();
        } else if (elementType.equals("OT")) {
            defaultValue = this.getOrg_ID();
        } else if (elementType.equals("PJ")) {
            defaultValue = this.getC_Project_ID();
        } else if (elementType.equals("SR")) {
            defaultValue = this.getC_SalesRegion_ID();
        } else if (elementType.equals("U1")) {
            defaultValue = this.getC_ElementValue_ID();
        } else if (elementType.equals("U2")) {
            defaultValue = this.getC_ElementValue_ID();
        } else if (elementType.equals("X1")) {
            defaultValue = 0;
        } else if (elementType.equals("X2")) {
            defaultValue = 0;
        }
        return defaultValue;
    }

    public String getColumnName() {
        String et = this.getElementType();
        return MAcctSchemaElement.getColumnName(et);
    }

    public String getDisplayColumnName() {
        String et = this.getElementType();
        if ("X1".equals(et) || "X2".equals(et)) {
            if (this.m_ColumnName == null) {
                this.m_ColumnName = MColumn.getColumnName(this.getCtx(), this.getAD_Column_ID());
            }
            return this.m_ColumnName;
        }
        return MAcctSchemaElement.getColumnName(et);
    }

    @Override
    public String toString() {
        StringBuilder msgreturn = new StringBuilder("AcctSchemaElement[").append(this.get_ID()).append("-").append(this.getName()).append("(").append(this.getElementType()).append(")=").append(this.getDefaultValue()).append(",Pos=").append(this.getSeqNo()).append("]");
        return msgreturn.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        String et = this.getElementType();
        if (this.isMandatory() && ("U1".equals(et) || "U2".equals(et) || "X1".equals(et) || "X2".equals(et))) {
            this.setIsMandatory(false);
        }
        if ("AC".equals(et) || "OO".equals(et)) {
            if (!this.isMandatory()) {
                this.setIsMandatory(true);
            }
            if (!this.isActive()) {
                this.setIsActive(true);
            }
        } else if (this.isMandatory()) {
            String errorField = null;
            if ("AC".equals(et) && this.getC_ElementValue_ID() == 0) {
                errorField = "C_ElementValue_ID";
            } else if ("AY".equals(et) && this.getC_Activity_ID() == 0) {
                errorField = "C_Activity_ID";
            } else if ("BP".equals(et) && this.getC_BPartner_ID() == 0) {
                errorField = "C_BPartner_ID";
            } else if ("MC".equals(et) && this.getC_Campaign_ID() == 0) {
                errorField = "C_Campaign_ID";
            } else if ("LF".equals(et) && this.getC_Location_ID() == 0) {
                errorField = "C_Location_ID";
            } else if ("LT".equals(et) && this.getC_Location_ID() == 0) {
                errorField = "C_Location_ID";
            } else if ("OO".equals(et) && this.getOrg_ID() == 0) {
                errorField = "Org_ID";
            } else if ("OT".equals(et) && this.getOrg_ID() == 0) {
                errorField = "Org_ID";
            } else if ("PR".equals(et) && this.getM_Product_ID() == 0) {
                errorField = "M_Product_ID";
            } else if ("PJ".equals(et) && this.getC_Project_ID() == 0) {
                errorField = "C_Project_ID";
            } else if ("SR".equals(et) && this.getC_SalesRegion_ID() == 0) {
                errorField = "C_SalesRegion_ID";
            }
            if (errorField != null) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@IsMandatory@: @" + errorField + "@"));
                return false;
            }
        }
        if (this.getAD_Column_ID() == 0 && ("X1".equals(et) || "X2".equals(et))) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@IsMandatory@: @AD_Column_ID@"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (this.isMandatory() && this.is_ValueChanged("IsMandatory")) {
            if ("AY".equals(this.getElementType())) {
                this.updateData("C_Activity_ID", this.getC_Activity_ID());
            } else if ("BP".equals(this.getElementType())) {
                this.updateData("C_BPartner_ID", this.getC_BPartner_ID());
            } else if ("PR".equals(this.getElementType())) {
                this.updateData("M_Product_ID", this.getM_Product_ID());
            } else if ("PJ".equals(this.getElementType())) {
                this.updateData("C_Project_ID", this.getC_Project_ID());
            }
        }
        s_cache.clear();
        if (newRecord || this.is_ValueChanged("SeqNo")) {
            StringBuilder msguvd = new StringBuilder("AD_Client_ID=").append(this.getAD_Client_ID());
            MAccount.updateValueDescription(this.getCtx(), msguvd.toString(), this.get_TrxName());
        }
        return success;
    }

    private void updateData(String element, int id) {
        StringBuilder msguvd = new StringBuilder(element).append("=").append(id);
        MAccount.updateValueDescription(this.getCtx(), msguvd.toString(), this.get_TrxName());
        StringBuilder sql = new StringBuilder("UPDATE C_ValidCombination SET ").append(element).append("=").append(id).append(" WHERE ").append(element).append(" IS NULL AND AD_Client_ID=").append(this.getAD_Client_ID());
        int noC = DB.executeUpdate(sql.toString(), this.get_TrxName());
        sql = new StringBuilder("UPDATE Fact_Acct SET ").append(element).append("=").append(id).append(" WHERE ").append(element).append(" IS NULL AND C_AcctSchema_ID=").append(this.getC_AcctSchema_ID());
        int noF = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("ValidCombination=" + noC + ", Fact=" + noF);
        }
    }

    @Override
    protected boolean beforeDelete() {
        String et = this.getElementType();
        if ("AC".equals(et) || "OO".equals(et)) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@DeleteError@ @IsMandatory@"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        StringBuilder msguvd = new StringBuilder("AD_Client_ID=").append(this.getAD_Client_ID());
        MAccount.updateValueDescription(this.getCtx(), msguvd.toString(), this.get_TrxName());
        s_cache.clear();
        return success;
    }
}

