/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MAcctProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MSchedule;
import org.compiere.model.Query;
import org.compiere.model.X_C_AcctProcessor;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MAcctProcessor
extends X_C_AcctProcessor
implements AdempiereProcessor,
AdempiereProcessor2 {
    private static final long serialVersionUID = -4760475718973777369L;

    public static MAcctProcessor[] getActive(Properties ctx) {
        List<MAcctProcessor> list = new Query(ctx, "C_AcctProcessor", null, null).setOnlyActiveRecords(true).list();
        return list.toArray(new MAcctProcessor[list.size()]);
    }

    public MAcctProcessor(Properties ctx, int C_AcctProcessor_ID, String trxName) {
        super(ctx, C_AcctProcessor_ID, trxName);
        if (C_AcctProcessor_ID == 0) {
            this.setKeepLogDays(7);
        }
    }

    public MAcctProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAcctProcessor(MClient client, int Supervisor_ID) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        StringBuilder msgset = new StringBuilder().append(client.getName()).append(" - ").append(Msg.translate(this.getCtx(), "C_AcctProcessor_ID"));
        this.setName(msgset.toString());
        this.setSupervisor_ID(Supervisor_ID);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        long nextWork;
        if ((newRecord || this.is_ValueChanged("AD_Schedule_ID")) && (nextWork = MSchedule.getNextRunMS(System.currentTimeMillis(), this.getScheduleType(), this.getFrequencyType(), this.getFrequency(), this.getCronPattern())) > 0L) {
            this.setDateNextRun(new Timestamp(nextWork));
        }
        return true;
    }

    @Override
    public String getServerID() {
        StringBuilder msgreturn = new StringBuilder("AcctProcessor").append(this.get_ID());
        return msgreturn.toString();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        String whereClause = "C_AcctProcessor_ID=? ";
        List<MAcctProcessorLog> list = new Query(this.getCtx(), "C_AcctProcessorLog", whereClause, this.get_TrxName()).setParameters(this.getC_AcctProcessor_ID()).setOrderBy("Created DESC").list();
        return list.toArray(new MAcctProcessorLog[list.size()]);
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        StringBuilder sql = new StringBuilder("DELETE C_AcctProcessorLog ").append("WHERE C_AcctProcessor_ID=").append(this.getC_AcctProcessor_ID()).append(" AND (Created+").append(this.getKeepLogDays()).append(") < SysDate");
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        return no;
    }

    @Override
    public String getFrequencyType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequencyType();
    }

    @Override
    public int getFrequency() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequency();
    }

    @Override
    public boolean isIgnoreProcessingTime() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).isIgnoreProcessingTime();
    }

    @Override
    public String getScheduleType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getScheduleType();
    }

    @Override
    public String getCronPattern() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getCronPattern();
    }
}

