/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.PO_LOB;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.MSort;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class GridTable
extends AbstractTableModel
implements Serializable {
    private static final long serialVersionUID = -2741647620577906242L;
    public static final String DATA_REFRESH_MESSAGE = "Refreshed";
    public static final String DATA_UPDATE_COPIED_MESSAGE = "UpdateCopied";
    public static final String DATA_INSERTED_MESSAGE = "Inserted";
    public static final String DATA_IGNORED_MESSAGE = "Ignored";
    private static CLogger log = CLogger.getCLogger(GridTable.class);
    private Properties m_ctx;
    private int m_AD_Table_ID;
    private String m_tableName = "";
    private int m_WindowNo;
    private int m_TabNo;
    private boolean m_withAccessControl;
    private boolean m_readOnly = true;
    private boolean m_deleteable = true;
    private boolean m_virtual;
    public static final String CTX_KeyColumnName = "KeyColumnName";
    private int m_rowCount = 0;
    private boolean m_changed = false;
    private int m_rowChanged = -1;
    private boolean m_inserting = false;
    private int m_newRow = -1;
    private boolean m_open = false;
    private boolean m_compareDB = true;
    private volatile ArrayList<Object[]> m_buffer = new ArrayList(100);
    private volatile ArrayList<MSort> m_sort = new ArrayList(100);
    private volatile Map<Integer, Object[]> m_virtualBuffer = new HashMap<Integer, Object[]>(100);
    private Object[] m_rowData = null;
    private Object[] m_oldValue = null;
    private Loader m_loader = null;
    private ArrayList<GridField> m_fields = new ArrayList(30);
    private ArrayList<Object> m_parameterSELECT = new ArrayList(5);
    private ArrayList<Object> m_parameterWHERE = new ArrayList(5);
    private String m_SQL;
    private String m_SQL_Count;
    private String m_SQL_Select;
    private String m_whereClause = "2=3";
    private boolean m_onlyCurrentRows = false;
    private int m_onlyCurrentDays = 1;
    private String m_orderClause = "";
    private int m_maxRows = 0;
    private int m_indexKeyColumn = -1;
    private int m_indexUUIDColumn = -1;
    private int m_indexColorColumn = -1;
    private int m_indexProcessedColumn = -1;
    private int m_indexActiveColumn = -1;
    private int m_indexClientColumn = -1;
    private int m_indexOrgColumn = -1;
    private VetoableChangeSupport m_vetoableChangeSupport = new VetoableChangeSupport(this);
    private Future<?> m_loaderFuture;
    public static final String PROPERTY = "MTable-RowSave";
    private static final Integer NEW_ROW_ID = -1;
    private static final int DEFAULT_FETCH_SIZE = 200;
    private int m_lastSortColumnIndex = -1;
    private boolean m_lastSortedAscending = true;
    public static final char SAVE_OK = 'O';
    public static final char SAVE_ERROR = 'E';
    public static final char SAVE_ACCESS = 'A';
    public static final char SAVE_MANDATORY = 'M';
    public static final char SAVE_ABORT = 'U';
    private ArrayList<String> m_createSqlColumn = new ArrayList();
    private ArrayList<String> m_createSqlValue = new ArrayList();
    private ArrayList<PO_LOB> m_lobInfo = null;
    private boolean m_importing = false;
    private String m_trxName = null;

    public GridTable(Properties ctx, int AD_Table_ID, String TableName, int WindowNo, int TabNo, boolean withAccessControl) {
        this(ctx, AD_Table_ID, TableName, WindowNo, TabNo, withAccessControl, false);
    }

    public GridTable(Properties ctx, int AD_Table_ID, String TableName, int WindowNo, int TabNo, boolean withAccessControl, boolean virtual) {
        log.info(TableName);
        this.m_ctx = ctx;
        this.m_AD_Table_ID = AD_Table_ID;
        this.setTableName(TableName);
        this.m_WindowNo = WindowNo;
        this.m_TabNo = TabNo;
        this.m_withAccessControl = withAccessControl;
        this.m_virtual = virtual;
    }

    public void setTableName(String newTableName) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return;
        }
        if (newTableName == null || newTableName.length() == 0) {
            return;
        }
        this.m_tableName = newTableName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public boolean setSelectWhereClause(String newWhereClause, boolean onlyCurrentRows, int onlyCurrentDays) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return false;
        }
        this.m_whereClause = newWhereClause;
        this.m_onlyCurrentRows = onlyCurrentRows;
        this.m_onlyCurrentDays = onlyCurrentDays;
        if (this.m_whereClause == null) {
            this.m_whereClause = "";
        }
        return true;
    }

    public String getSelectWhereClause() {
        return this.m_whereClause;
    }

    public boolean isOnlyCurrentRowsDisplayed() {
        return !this.m_onlyCurrentRows;
    }

    public void setOrderClause(String newOrderClause) {
        this.m_orderClause = newOrderClause;
        if (this.m_orderClause == null) {
            this.m_orderClause = "";
        }
    }

    public String getOrderClause() {
        return this.m_orderClause;
    }

    private String createSelectSql() {
        if (this.m_fields.size() == 0 || this.m_tableName == null || this.m_tableName.equals("")) {
            return "";
        }
        StringBuilder select = new StringBuilder("SELECT ");
        int i2 = 0;
        while (i2 < this.m_fields.size()) {
            if (i2 > 0) {
                select.append(",");
            }
            GridField field = this.m_fields.get(i2);
            select.append(field.getColumnSQL(true));
            ++i2;
        }
        select.append(" FROM ").append(this.m_tableName);
        this.m_SQL_Select = select.toString();
        this.m_SQL_Count = "SELECT COUNT(*) FROM " + this.m_tableName;
        int parentTabNo = this.getParentTabNo();
        String parentKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentTabNo, "_TabInfo_KeyColumnName", true);
        String valueKey = null;
        String currKey = null;
        if (parentKey != null && parentKey.length() > 0) {
            valueKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentTabNo, parentKey, true);
            currKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentKey);
            if (currKey == null) {
                currKey = new String("");
            }
            if (valueKey != null && valueKey.length() > 0 && parentKey != null && parentKey.length() > 0 && !currKey.equals(valueKey)) {
                Env.setContext(this.m_ctx, this.m_WindowNo, parentKey, valueKey);
            }
        }
        StringBuilder where = new StringBuilder("");
        if (this.m_whereClause.length() > 0) {
            where.append(" WHERE (");
            if (this.m_whereClause.indexOf(64) == -1) {
                where.append(this.m_whereClause);
            } else {
                String context = Env.parseContext(this.m_ctx, this.m_WindowNo, this.m_whereClause, false);
                if (context != null && context.trim().length() > 0) {
                    where.append(context);
                } else {
                    log.log(Level.WARNING, "Failed to parse where clause. whereClause=" + this.m_whereClause);
                    where.append(" 1 = 2 ");
                }
            }
            where.append(")");
        }
        if (this.m_onlyCurrentRows && this.m_TabNo == 0) {
            if (where.toString().indexOf(" WHERE ") == -1) {
                where.append(" WHERE ");
            } else {
                where.append(" AND ");
            }
            where.append("(Processed='N' OR Updated>");
            where.append("SysDate-1");
            where.append(")");
        }
        this.m_SQL = String.valueOf(this.m_SQL_Select) + where.toString();
        this.m_SQL_Count = String.valueOf(this.m_SQL_Count) + where.toString();
        if (this.m_withAccessControl) {
            this.m_SQL = MRole.getDefault(this.m_ctx, false).addAccessSQL(this.m_SQL, this.m_tableName, true, false);
            this.m_SQL_Count = MRole.getDefault(this.m_ctx, false).addAccessSQL(this.m_SQL_Count, this.m_tableName, true, false);
        }
        if (!this.m_orderClause.equals("")) {
            this.m_SQL = String.valueOf(this.m_SQL) + " ORDER BY " + this.m_orderClause;
        }
        log.fine(this.m_SQL_Count);
        Env.setContext(this.m_ctx, this.m_WindowNo, this.m_TabNo, "_TabInfo_SQL", this.m_SQL);
        return this.m_SQL;
    }

    public void addField(GridField field) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("(" + this.m_tableName + ") - " + field.getColumnName());
        }
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored: " + field.getColumnName());
            return;
        }
        if (!MRole.getDefault(this.m_ctx, false).isColumnAccess(this.m_AD_Table_ID, field.getAD_Column_ID(), true)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No Column Access " + field.getColumnName());
            }
            return;
        }
        if (field.isKey()) {
            this.m_indexKeyColumn = this.m_fields.size();
        } else if (field.isUUID()) {
            this.m_indexUUIDColumn = this.m_fields.size();
        }
        if (field.getColumnName().equals("IsActive")) {
            this.m_indexActiveColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("Processed")) {
            this.m_indexProcessedColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Client_ID")) {
            this.m_indexClientColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Org_ID")) {
            this.m_indexOrgColumn = this.m_fields.size();
        }
        this.m_fields.add(field);
    }

    @Override
    public String getColumnName(int index) {
        if (index < 0 || index > this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return "";
        }
        GridField field = this.m_fields.get(index);
        return field.getColumnName();
    }

    @Override
    public int findColumn(String columnName) {
        int i2 = 0;
        while (i2 < this.m_fields.size()) {
            GridField field = this.m_fields.get(i2);
            if (columnName.equals(field.getColumnName())) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return null;
        }
        GridField field = this.m_fields.get(index);
        return DisplayType.getClass(field.getDisplayType(), false);
    }

    public void setParameterSELECT(int index, Object parameter) {
        if (index >= this.m_parameterSELECT.size()) {
            this.m_parameterSELECT.add(parameter);
        } else {
            this.m_parameterSELECT.set(index, parameter);
        }
    }

    public void setParameterWHERE(int index, Object parameter) {
        if (index >= this.m_parameterWHERE.size()) {
            this.m_parameterWHERE.add(parameter);
        } else {
            this.m_parameterWHERE.set(index, parameter);
        }
    }

    public GridField getField(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            return null;
        }
        return this.m_fields.get(index);
    }

    protected GridField getField(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        int cols = this.m_fields.size();
        int i2 = 0;
        while (i2 < cols) {
            GridField field = this.m_fields.get(i2);
            if (identifier.equalsIgnoreCase(field.getColumnName())) {
                return field;
            }
            ++i2;
        }
        return null;
    }

    public GridField[] getFields() {
        GridField[] retValue = new GridField[this.m_fields.size()];
        this.m_fields.toArray(retValue);
        return retValue;
    }

    public boolean open(int maxRows) {
        if (log.isLoggable(Level.INFO)) {
            log.info("MaxRows=" + maxRows);
        }
        this.m_maxRows = maxRows;
        if (this.m_open) {
            log.fine("already open");
            this.dataRefreshAll();
            return true;
        }
        if (this.m_virtual) {
            this.verifyVirtual();
        }
        this.createSelectSql();
        if (this.m_SQL == null || this.m_SQL.equals("")) {
            log.log(Level.SEVERE, "No SQL");
            return false;
        }
        if (!this.m_open) {
            this.m_open = true;
        }
        this.m_loader = new Loader();
        this.m_loaderFuture = null;
        this.m_rowCount = this.m_loader.open(maxRows);
        if (this.m_virtual) {
            this.m_buffer = null;
            this.m_virtualBuffer = new HashMap<Integer, Object[]>(210);
        } else {
            this.m_buffer = new ArrayList(this.m_rowCount + 10);
        }
        this.m_sort = new ArrayList(this.m_rowCount + 10);
        if (this.m_rowCount > 0) {
            this.m_loader.setContext(ServerContext.getCurrentInstance());
            this.m_loaderFuture = Adempiere.getThreadPoolExecutor().submit(this.m_loader);
        } else {
            this.m_loader.close();
        }
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        return true;
    }

    private void verifyVirtual() {
        if (this.m_indexKeyColumn == -1) {
            this.m_virtual = false;
            return;
        }
        GridField[] fields = this.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            if (fields[i2].isKey() && i2 != this.m_indexKeyColumn) {
                this.m_virtual = false;
                return;
            }
            ++i2;
        }
    }

    public void loadComplete() {
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            try {
                this.m_loaderFuture.get();
            }
            catch (Exception ie) {
                log.log(Level.SEVERE, "Interrupted", ie);
            }
        }
        int i2 = 0;
        while (i2 < this.m_fields.size()) {
            GridField field = this.m_fields.get(i2);
            field.lookupLoadComplete();
            ++i2;
        }
    }

    public boolean isLoading() {
        return this.m_loaderFuture != null && !this.m_loaderFuture.isDone();
    }

    public void waitLoading(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            if (timeout > 0L) {
                this.m_loaderFuture.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                this.m_loaderFuture.get();
            }
        }
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void close(boolean finalCall) {
        if (!this.m_open) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("final=" + finalCall);
        }
        if (finalCall) {
            DataStatusListener[] evl = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
            int i2 = 0;
            while (i2 < evl.length) {
                this.listenerList.remove(DataStatusListener.class, evl[i2]);
                ++i2;
            }
            TableModelListener[] ev2 = (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
            int i3 = 0;
            while (i3 < ev2.length) {
                this.listenerList.remove(TableModelListener.class, ev2[i3]);
                ++i3;
            }
            VetoableChangeListener[] vcl = this.m_vetoableChangeSupport.getVetoableChangeListeners();
            int i4 = 0;
            while (i4 < vcl.length) {
                this.m_vetoableChangeSupport.removeVetoableChangeListener(vcl[i4]);
                ++i4;
            }
        }
        while (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            log.fine("Interrupting Loader ...");
            this.m_loaderFuture.cancel(true);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_loaderFuture = null;
        }
        if (!this.m_inserting) {
            this.dataSave(false);
        }
        if (this.m_buffer != null) {
            this.m_buffer.clear();
            this.m_buffer = null;
        }
        if (this.m_sort != null) {
            this.m_sort.clear();
            this.m_sort = null;
        }
        if (this.m_virtualBuffer != null) {
            this.m_virtualBuffer.clear();
            this.m_virtualBuffer = null;
        }
        if (finalCall) {
            this.dispose();
        }
        log.fine("");
        this.m_open = false;
    }

    private void dispose() {
        int i2 = 0;
        while (i2 < this.m_fields.size()) {
            this.m_fields.get(i2).dispose();
            ++i2;
        }
        this.m_fields.clear();
        this.m_fields = null;
        this.m_vetoableChangeSupport = null;
        this.m_parameterSELECT.clear();
        this.m_parameterSELECT = null;
        this.m_parameterWHERE.clear();
        this.m_parameterWHERE = null;
        this.m_buffer = null;
        this.m_virtualBuffer = null;
        this.m_sort = null;
        this.m_rowData = null;
        this.m_oldValue = null;
        this.m_loader = null;
        this.m_loaderFuture = null;
    }

    @Override
    public int getColumnCount() {
        return this.m_fields.size();
    }

    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    public void setColorColumn(String columnName) {
        this.m_indexColorColumn = this.findColumn(columnName);
    }

    public int getColorCode(int row) {
        if (this.m_indexColorColumn == -1) {
            return 0;
        }
        Object data = this.getValueAt(row, this.m_indexColorColumn);
        if (data == null || !(data instanceof BigDecimal)) {
            return 0;
        }
        BigDecimal bd = (BigDecimal)data;
        return bd.signum();
    }

    public void sort(int col, boolean ascending) {
        boolean isSameSortEntries;
        if (log.isLoggable(Level.INFO)) {
            log.info("#" + col + " " + ascending);
        }
        if (col < 0) {
            return;
        }
        if (this.getRowCount() == 0) {
            return;
        }
        boolean bl = isSameSortEntries = col == this.m_lastSortColumnIndex && ascending == this.m_lastSortedAscending;
        if (!isSameSortEntries) {
            this.m_lastSortColumnIndex = col;
            this.m_lastSortedAscending = ascending;
        }
        Object[] changedRow = this.m_rowChanged >= 0 ? this.getDataAtRow(this.m_rowChanged) : null;
        GridField field = this.getField(col);
        if (field.getDisplayType() == 26) {
            return;
        }
        boolean isLookup = DisplayType.isLookup(field.getDisplayType());
        boolean isASI = 35 == field.getDisplayType();
        int i2 = 0;
        while (i2 < this.m_sort.size()) {
            MSort sort = this.m_sort.get(i2);
            Object[] rowData = this.getDataAtRow(i2);
            sort.data = rowData[col] == null ? null : (isLookup || isASI ? field.getLookup().getDisplay(rowData[col]) : rowData[col]);
            ++i2;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(field.toString()) + " #" + this.m_sort.size());
        }
        MSort sort = new MSort(0, null);
        sort.setSortAsc(ascending);
        Collections.sort(this.m_sort, sort);
        if (this.m_virtual) {
            Object[] newRow = this.m_virtualBuffer.get(NEW_ROW_ID);
            this.m_virtualBuffer.clear();
            if (newRow != null && newRow.length > 0) {
                this.m_virtualBuffer.put(NEW_ROW_ID, newRow);
            }
            if (changedRow != null && changedRow.length > 0 && changedRow[this.m_indexKeyColumn] != null && (Integer)changedRow[this.m_indexKeyColumn] > 0) {
                this.m_virtualBuffer.put((Integer)changedRow[this.m_indexKeyColumn], changedRow);
                int i3 = 0;
                while (i3 < this.m_sort.size()) {
                    if (this.m_sort.get((int)i3).index == (Integer)changedRow[this.m_indexKeyColumn]) {
                        this.m_rowChanged = i3;
                        break;
                    }
                    ++i3;
                }
            }
            int i4 = 0;
            while (i4 < this.m_sort.size()) {
                this.m_sort.get((int)i4).data = null;
                ++i4;
            }
        }
        if (!isSameSortEntries) {
            this.fireTableDataChanged();
            this.fireDataStatusIEvent("Sorted", "#" + this.m_sort.size());
        }
    }

    public int getKeyID(int row) {
        if (this.m_indexKeyColumn != -1) {
            Integer ii;
            block4: {
                try {
                    ii = (Integer)this.getValueAt(row, this.m_indexKeyColumn);
                    if (ii != null) break block4;
                    return -1;
                }
                catch (Exception e) {
                    return -1;
                }
            }
            return ii;
        }
        return -1;
    }

    public UUID getUUID(int row) {
        if (this.m_indexUUIDColumn != -1) {
            String ii;
            block4: {
                try {
                    ii = (String)this.getValueAt(row, this.m_indexUUIDColumn);
                    if (ii != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return UUID.fromString(ii);
        }
        return null;
    }

    public String getKeyColumnName() {
        if (this.m_indexKeyColumn != -1) {
            return this.getColumnName(this.m_indexKeyColumn);
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.m_open || row < 0 || col < 0 || row >= this.m_rowCount) {
            return null;
        }
        this.waitLoadingForRow(row);
        if (row >= this.m_sort.size()) {
            return null;
        }
        Object[] rowData = this.getDataAtRow(row);
        if (rowData == null || col > rowData.length) {
            return null;
        }
        return rowData[col];
    }

    public void waitLoadingForRow(int row) {
        Exception savedEx;
        int loops = 0;
        int timeout = MSysConfig.getIntValue("GRIDTABLE_LOAD_TIMEOUT_IN_SECONDS", 30, Env.getAD_Client_ID(Env.getCtx()));
        while (row >= this.m_sort.size() && this.m_loaderFuture != null && !this.m_loaderFuture.isDone() && loops < timeout) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Waiting for loader row=" + row + ", size=" + this.m_sort.size());
            }
            try {
                this.m_loaderFuture.get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++loops;
        }
        if (this.m_sort.size() == 0 && (savedEx = CLogger.retrieveException()) != null) {
            throw new IllegalStateException(savedEx);
        }
        if (row >= this.m_sort.size()) {
            log.warning("Reached " + timeout + " seconds timeout loading row " + (row + 1) + " for SQL=" + this.m_SQL);
            throw new IllegalStateException("Timeout loading row " + (row + 1));
        }
    }

    private Object[] getDataAtRow(int row) {
        return this.getDataAtRow(row, true);
    }

    private Object[] getDataAtRow(int row, boolean fetchIfNotFound) {
        this.waitLoadingForRow(row);
        MSort sort = this.m_sort.get(row);
        Object[] rowData = null;
        if (this.m_virtual) {
            if (sort.index != NEW_ROW_ID && !this.m_virtualBuffer.containsKey(sort.index) && fetchIfNotFound) {
                this.fillBuffer(row, 200);
            }
            rowData = this.m_virtualBuffer.get(sort.index);
        } else {
            rowData = this.m_buffer.get(sort.index);
        }
        return rowData;
    }

    private void setDataAtRow(int row, Object[] rowData) {
        MSort sort = this.m_sort.get(row);
        if (this.m_virtual) {
            if (sort.index != NEW_ROW_ID && !this.m_virtualBuffer.containsKey(sort.index)) {
                this.fillBuffer(row, 200);
            }
            this.m_virtualBuffer.put(sort.index, rowData);
        } else {
            this.m_buffer.set(sort.index, rowData);
        }
    }

    private void fillBuffer(int start, int fetchSize) {
        block14: {
            if (start > 0 && start + fetchSize >= this.m_sort.size() && (start -= fetchSize - (this.m_sort.size() - start)) < 0) {
                start = 0;
            }
            StringBuilder sql = new StringBuilder();
            sql.append(this.m_SQL_Select).append(" WHERE ").append(this.getKeyColumnName()).append(" IN (");
            LinkedHashMap<Integer, Integer> rowmap = new LinkedHashMap<Integer, Integer>(200);
            int i2 = start;
            while (i2 < start + fetchSize && i2 < this.m_sort.size()) {
                if (i2 > start) {
                    sql.append(",");
                }
                sql.append(this.m_sort.get((int)i2).index);
                rowmap.put(this.m_sort.get((int)i2).index, i2);
                ++i2;
            }
            sql.append(")");
            Object[] newRow = this.m_virtualBuffer.get(NEW_ROW_ID);
            Object[] changedRow = this.m_rowChanged >= 0 ? this.getDataAtRow(this.m_rowChanged, false) : null;
            this.m_virtualBuffer = new HashMap<Integer, Object[]>(210);
            if (newRow != null && newRow.length > 0) {
                this.m_virtualBuffer.put(NEW_ROW_ID, newRow);
            }
            if (changedRow != null && changedRow.length > 0 && changedRow[this.m_indexKeyColumn] != null && (Integer)changedRow[this.m_indexKeyColumn] > 0) {
                this.m_virtualBuffer.put((Integer)changedRow[this.m_indexKeyColumn], changedRow);
            }
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.prepareStatement(sql.toString(), null);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        Object[] data = this.readData(rs);
                        rowmap.remove(data[this.m_indexKeyColumn]);
                        this.m_virtualBuffer.put((Integer)data[this.m_indexKeyColumn], data);
                    }
                    if (!rowmap.isEmpty()) {
                        ArrayList<Integer> toremove = new ArrayList<Integer>();
                        for (Map.Entry entry : rowmap.entrySet()) {
                            toremove.add((Integer)entry.getValue());
                        }
                        Collections.reverse(toremove);
                        for (Integer row : toremove) {
                            this.m_sort.remove(row);
                        }
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    DB.close(rs, stmt);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                throw throwable;
            }
            DB.close(rs, stmt);
        }
    }

    public void setChanged(boolean changed) {
        if (!this.m_open || this.m_readOnly) {
            return;
        }
        this.m_changed = changed;
        if (!changed) {
            this.m_rowChanged = -1;
        }
    }

    @Override
    public final void setValueAt(Object value, int row, int col) {
        this.setValueAt(value, row, col, false, false);
    }

    public final void setValueAt(Object value, int row, int col, boolean force) {
        this.setValueAt(value, row, col, force, false);
    }

    public final void setValueAt(Object value, int row, int col, boolean force, boolean isInitEdit) {
        if (!this.m_open || this.m_readOnly || row < 0 || col < 0 || this.m_rowCount == 0 || row >= this.m_rowCount) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("r=" + row + " c=" + col + " - R/O=" + this.m_readOnly + ", Rows=" + this.m_rowCount + " - Ignored");
            }
            return;
        }
        this.dataSave(row, false);
        Object oldValue = this.getValueAt(row, col);
        if (!(force || isInitEdit || this.isValueChanged(oldValue, value))) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("r=" + row + " c=" + col + " - New=" + value + "==Old=" + oldValue + " - Ignored");
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("r=" + row + " c=" + col + " = " + value + " (" + oldValue + ")");
        }
        this.m_oldValue = new Object[3];
        this.m_oldValue[0] = row;
        this.m_oldValue[1] = col;
        this.m_oldValue[2] = oldValue;
        Object[] rowData = this.getDataAtRow(row);
        this.m_rowChanged = row;
        if (this.m_rowData == null) {
            int size = this.m_fields.size();
            this.m_rowData = new Object[size];
            int i2 = 0;
            while (i2 < size) {
                this.m_rowData[i2] = rowData[i2];
                ++i2;
            }
        }
        rowData[col] = value;
        this.setDataAtRow(row, rowData);
        this.fireTableCellUpdated(row, col);
        GridField field = this.getField(col);
        field.setValue(value, this.m_inserting);
        DataStatusEvent evt = this.createDSE();
        evt.setIsInitEdit(isInitEdit);
        evt.setChangedColumn(col, field.getColumnName());
        this.fireDataStatusChanged(evt);
    }

    public Object getOldValue(int row, int col) {
        if (this.m_oldValue == null) {
            return null;
        }
        if ((Integer)this.m_oldValue[0] == row && (Integer)this.m_oldValue[1] == col) {
            return this.m_oldValue[2];
        }
        return null;
    }

    public boolean needSave(boolean onlyRealChange) {
        return this.needSave(this.m_rowChanged, onlyRealChange);
    }

    public boolean needSave() {
        return this.needSave(this.m_rowChanged, false);
    }

    public boolean needSave(int newRow) {
        return this.needSave(newRow, false);
    }

    public boolean needSave(int newRow, boolean onlyRealChange) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        }
        if (!this.m_changed && this.m_rowChanged == -1) {
            return false;
        }
        if (this.m_changed && this.m_rowChanged == -1 && onlyRealChange) {
            return false;
        }
        return newRow != this.m_rowChanged;
    }

    public boolean dataSave(int newRow, boolean manualCmd) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        }
        if (!this.m_changed && this.m_rowChanged == -1) {
            return true;
        }
        if (newRow == this.m_rowChanged) {
            return true;
        }
        return this.dataSave(manualCmd) == 'O';
    }

    public char dataSave(boolean manualCmd) {
        boolean manualUpdate;
        Object[] rowDataDB;
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuilder multiRowWHERE;
        StringBuilder singleRowWHERE;
        StringBuilder select;
        block161: {
            String is;
            boolean error;
            Object[] rowData;
            block160: {
                String missingColumns;
                String tablename;
                if (!this.m_open) {
                    log.warning("Error - Open=" + this.m_open);
                    return 'E';
                }
                if (this.m_rowChanged == -1) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("NoNeed - Changed=" + this.m_changed + ", Row=" + this.m_rowChanged);
                    }
                    if (!manualCmd) {
                        return 'O';
                    }
                }
                if (this.m_rowData == null) {
                    this.m_rowChanged = -1;
                    log.fine("No Changes");
                    return 'E';
                }
                if (this.m_readOnly) {
                    log.warning("IsReadOnly - ignored");
                    this.dataIgnore();
                    return 'A';
                }
                if (this.m_rowChanged == -1) {
                    if (this.m_newRow != -1) {
                        this.m_rowChanged = this.m_newRow;
                    } else {
                        this.fireDataStatusEEvent("SaveErrorNoChange", "", true);
                        return 'E';
                    }
                }
                int[] co = this.getClientOrg(this.m_rowChanged);
                int AD_Client_ID = co[0];
                int AD_Org_ID = co[1];
                if (!MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, 0, true)) {
                    this.fireDataStatusEEvent(CLogger.retrieveError());
                    this.dataIgnore();
                    return 'A';
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("Row=" + this.m_rowChanged);
                }
                try {
                    if (!manualCmd) {
                        this.m_vetoableChangeSupport.fireVetoableChange(PROPERTY, -1, this.m_rowChanged);
                    }
                }
                catch (PropertyVetoException pve) {
                    log.warning(pve.getMessage());
                    return 'U';
                }
                rowData = this.getDataAtRow(this.m_rowChanged);
                boolean specialZeroUpdate = false;
                if (!this.m_inserting && manualCmd && (Env.getAD_User_ID(this.m_ctx) == 0 || Env.getAD_User_ID(this.m_ctx) == 100) && this.getKeyID(this.m_rowChanged) == 0 && MTable.isZeroIDTable(tablename = this.getTableName())) {
                    specialZeroUpdate = true;
                }
                if ((missingColumns = this.getMandatory(rowData)).length() != 0) {
                    this.fireDataStatusEEvent("FillMandatory", String.valueOf(missingColumns) + "\n", true);
                    return 'M';
                }
                int Record_ID = 0;
                if (!this.m_inserting) {
                    Record_ID = this.getKeyID(this.m_rowChanged);
                }
                try {
                    if (!this.m_tableName.endsWith("_Trl") && !specialZeroUpdate) {
                        return this.dataSavePO(Record_ID);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof ClassNotFoundException) {
                        log.warning(String.valueOf(this.m_tableName) + " - " + e.getLocalizedMessage());
                    }
                    log.log(Level.SEVERE, "Persistency Issue - " + this.m_tableName + ": " + e.getLocalizedMessage(), e);
                    log.saveError("Error", e.getLocalizedMessage());
                    return 'E';
                }
                log.info("NonPO");
                error = false;
                this.lobReset();
                is = null;
                String ERROR = "ERROR: ";
                String INFO = "Info: ";
                select = new StringBuilder("SELECT ");
                int i2 = 0;
                int addedColumns = 0;
                while (i2 < this.m_fields.size()) {
                    GridField field = this.m_fields.get(i2);
                    if (!this.m_inserting || !field.isVirtualColumn()) {
                        if (addedColumns++ > 0) {
                            select.append(",");
                        }
                        select.append(field.getColumnSQL(true));
                    }
                    ++i2;
                }
                select.append(" FROM ").append(this.m_tableName);
                singleRowWHERE = new StringBuilder();
                multiRowWHERE = new StringBuilder();
                if (this.m_inserting) {
                    select.append(" WHERE 1=2");
                } else {
                    select.append(" WHERE ").append(this.getWhereClause(rowData));
                }
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement(select.toString(), 1005, 1008, null);
                rs = pstmt.executeQuery();
                if (this.m_inserting || rs.next()) break block160;
                this.fireDataStatusEEvent("SaveErrorRowNotFound", "", true);
                this.dataRefresh(this.m_rowChanged);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return 'E';
            }
            rowDataDB = null;
            boolean bl = manualUpdate = 1007 == rs.getConcurrency();
            if (!manualUpdate && Ini.isPropertyBool("LogMigrationScript")) {
                manualUpdate = true;
            }
            if (manualUpdate) {
                this.createUpdateSqlReset();
            }
            if (this.m_inserting) {
                if (manualUpdate) {
                    log.fine("Prepare inserting ... manual");
                } else {
                    log.fine("Prepare inserting ... RowSet");
                    rs.moveToInsertRow();
                }
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Prepare updating ... manual=" + manualUpdate);
                }
                rowDataDB = this.readData(rs);
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            int user = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
            int size = this.m_fields.size();
            int colRs = 1;
            int col = 0;
            while (col < size) {
                GridField field = this.m_fields.get(col);
                if (field.isVirtualColumn()) {
                    if (!this.m_inserting) {
                        ++colRs;
                    }
                } else {
                    String columnName = field.getColumnName();
                    if (field.getDisplayType() != 26 && !field.isVirtualColumn()) {
                        if (field.isKey() && this.m_inserting) {
                            if (columnName.endsWith("_ID") || columnName.toUpperCase().endsWith("_ID")) {
                                int insertID = DB.getNextID(this.m_ctx, this.m_tableName, null);
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, String.valueOf(insertID));
                                } else {
                                    rs.updateInt(colRs, insertID);
                                }
                                singleRowWHERE.append(columnName).append("=").append(insertID);
                                is = "Info: " + columnName + " -> " + insertID + " (Key)";
                            } else {
                                String str = rowData[col].toString();
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, DB.TO_STRING(str));
                                } else {
                                    rs.updateString(colRs, str);
                                }
                                singleRowWHERE = new StringBuilder();
                                singleRowWHERE.append(columnName).append("=").append(DB.TO_STRING(str));
                                is = "Info: " + columnName + " -> " + str + " (StringKey)";
                            }
                            log.fine(is);
                        } else if (columnName.equals("DocumentNo")) {
                            boolean newDocNo = false;
                            String docNo = (String)rowData[col];
                            if (docNo == null || docNo.length() == 0) {
                                newDocNo = true;
                            } else if (docNo.startsWith("<") && docNo.endsWith(">")) {
                                newDocNo = true;
                            }
                            if (newDocNo || this.m_inserting) {
                                String insertDoc = null;
                                if (this.m_inserting) {
                                    insertDoc = DB.getDocumentNo(this.m_ctx, this.m_WindowNo, this.m_tableName, true, null);
                                }
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("DocumentNo entered=" + docNo + ", DocTypeInsert=" + insertDoc + ", newDocNo=" + newDocNo);
                                }
                                if (insertDoc == null || insertDoc.length() == 0) {
                                    insertDoc = !newDocNo && docNo != null && docNo.length() > 0 ? docNo : DB.getDocumentNo(this.m_ctx, this.m_WindowNo, this.m_tableName, false, null);
                                }
                                if (insertDoc == null || insertDoc.length() == 0) {
                                    if (docNo != null && docNo.length() != 0) {
                                        insertDoc = (String)rowData[col];
                                    } else {
                                        error = true;
                                        is = "ERROR: " + field.getColumnName() + "= " + rowData[col] + " NO DocumentNo";
                                        log.fine(is);
                                        break;
                                    }
                                }
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, DB.TO_STRING(insertDoc));
                                } else {
                                    rs.updateString(colRs, insertDoc);
                                }
                                is = "Info: " + columnName + " -> " + insertDoc + " (DocNo)";
                                log.fine(is);
                            }
                        } else if (columnName.equals("Value") && this.m_inserting) {
                            String value = (String)rowData[col];
                            if (!(value != null && value.length() != 0 || (value = DB.getDocumentNo(this.m_ctx, this.m_WindowNo, this.m_tableName, false, null)) != null && value.length() != 0)) {
                                error = true;
                                is = "ERROR: " + field.getColumnName() + "= " + rowData[col] + " No Value";
                                log.fine(is);
                                break;
                            }
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_STRING(value));
                            } else {
                                rs.updateString(colRs, value);
                            }
                            is = "Info: " + columnName + " -> " + value + " (Value)";
                            log.fine(is);
                        } else if (columnName.equals("Updated")) {
                            if (this.m_compareDB && !this.m_inserting && !this.m_rowData[col].equals(rowDataDB[col])) {
                                error = true;
                                is = "ERROR: " + field.getColumnName() + "= " + this.m_rowData[col] + " != DB: " + rowDataDB[col];
                                log.fine(is);
                                break;
                            }
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_DATE(now, false));
                            } else {
                                rs.updateTimestamp(colRs, now);
                            }
                            is = "Info: Updated/By -> " + now + " - " + user;
                            log.fine(is);
                        } else if (columnName.equals("UpdatedBy")) {
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, String.valueOf(user));
                            } else {
                                rs.updateInt(colRs, user);
                            }
                        } else if (this.m_inserting && columnName.equals("Created")) {
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_DATE(now, false));
                            } else {
                                rs.updateTimestamp(colRs, now);
                            }
                        } else if (this.m_inserting && columnName.equals("CreatedBy")) {
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, String.valueOf(user));
                            } else {
                                rs.updateInt(colRs, user);
                            }
                        } else if (this.m_rowData[col] == null && rowData[col] == null) {
                            if (this.m_inserting) {
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, "NULL");
                                } else {
                                    rs.updateNull(colRs);
                                }
                                is = "Info: " + columnName + "= NULL";
                                log.fine(is);
                            }
                        } else if (this.m_inserting || this.m_rowData[col] == null && rowData[col] != null || this.m_rowData[col] != null && rowData[col] == null || !this.m_rowData[col].equals(rowData[col])) {
                            if (this.m_inserting || !this.m_compareDB || this.m_rowData[col] == null && rowDataDB[col] == null || this.m_rowData[col] != null && this.m_rowData[col].equals(rowDataDB[col])) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(String.valueOf(columnName) + "=" + rowData[col] + " " + (rowData[col] == null ? "" : rowData[col].getClass().getName()));
                                }
                                boolean encrypted = field.isEncryptedColumn();
                                String type = "String";
                                if (rowData[col] == null) {
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, "NULL");
                                    } else {
                                        rs.updateNull(colRs);
                                    }
                                } else if (DisplayType.isID(field.getDisplayType()) || field.getDisplayType() == 11) {
                                    try {
                                        Object dd = rowData[col];
                                        Integer iii = null;
                                        iii = dd instanceof Integer ? (Integer)dd : Integer.valueOf(dd.toString());
                                        if (encrypted) {
                                            iii = (Integer)this.encrypt(iii, this.getAD_Client_ID());
                                        }
                                        if (manualUpdate) {
                                            this.createUpdateSql(columnName, String.valueOf(iii));
                                        } else {
                                            rs.updateInt(colRs, (int)iii);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (manualUpdate) {
                                            this.createUpdateSql(columnName, DB.TO_STRING(rowData[col].toString()));
                                        }
                                        rs.updateString(colRs, rowData[col].toString());
                                    }
                                    type = "Int";
                                } else if (DisplayType.isNumeric(field.getDisplayType())) {
                                    BigDecimal bd = (BigDecimal)rowData[col];
                                    if (encrypted) {
                                        bd = (BigDecimal)this.encrypt(bd, this.getAD_Client_ID());
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, bd.toString());
                                    } else {
                                        rs.updateBigDecimal(colRs, bd);
                                    }
                                    type = "Number";
                                } else if (DisplayType.isDate(field.getDisplayType())) {
                                    Timestamp ts = (Timestamp)rowData[col];
                                    if (encrypted) {
                                        ts = (Timestamp)this.encrypt(ts, this.getAD_Client_ID());
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, DB.TO_DATE(ts, false));
                                    } else {
                                        rs.updateTimestamp(colRs, ts);
                                    }
                                    type = "Date";
                                } else if (field.getDisplayType() == 36) {
                                    PO_LOB lob = new PO_LOB(this.getTableName(), columnName, null, field.getDisplayType(), rowData[col]);
                                    this.lobAdd(lob);
                                    type = "CLOB";
                                } else if (field.getDisplayType() == 20) {
                                    String yn = null;
                                    if (rowData[col] instanceof Boolean) {
                                        Boolean bb = (Boolean)rowData[col];
                                        yn = bb != false ? "Y" : "N";
                                    } else {
                                        String string = yn = "Y".equals(rowData[col]) ? "Y" : "N";
                                    }
                                    if (encrypted) {
                                        // empty if block
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, DB.TO_STRING(yn));
                                    } else {
                                        rs.updateString(colRs, yn);
                                    }
                                } else {
                                    String str = rowData[col].toString();
                                    if (encrypted) {
                                        str = (String)this.encrypt(str, this.getAD_Client_ID());
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, DB.TO_STRING(str));
                                    } else {
                                        rs.updateString(colRs, str);
                                    }
                                }
                                is = "Info: " + columnName + "= " + this.m_rowData[col] + " -> " + rowData[col] + " (" + type + ")";
                                if (encrypted) {
                                    is = String.valueOf(is) + " encrypted";
                                }
                                log.fine(is);
                            } else {
                                error = true;
                                is = "ERROR: " + field.getColumnName() + "= " + this.m_rowData[col] + " != DB: " + rowDataDB[col] + " -> " + rowData[col];
                                log.fine(is);
                            }
                        }
                    }
                    if (field.isKey() && !this.m_inserting) {
                        if (rowData[col] == null) {
                            throw new RuntimeException("Key is NULL - " + columnName);
                        }
                        if (columnName.endsWith("_ID")) {
                            singleRowWHERE.append(columnName).append("=").append(rowData[col]);
                        } else {
                            singleRowWHERE = new StringBuilder();
                            singleRowWHERE.append(columnName).append("=").append(DB.TO_STRING(rowData[col].toString()));
                        }
                    }
                    if (field.isParentColumn()) {
                        if (rowData[col] == null) {
                            throw new RuntimeException("MultiKey Parent is NULL - " + columnName);
                        }
                        if (multiRowWHERE.length() != 0) {
                            multiRowWHERE.append(" AND ");
                        }
                        if (columnName.endsWith("_ID")) {
                            multiRowWHERE.append(columnName).append("=").append(rowData[col]);
                        } else {
                            multiRowWHERE.append(columnName).append("=").append(DB.TO_STRING(rowData[col].toString()));
                        }
                    }
                    ++colRs;
                }
                ++col;
            }
            if (!error) break block161;
            if (manualUpdate) {
                this.createUpdateSqlReset();
            } else {
                rs.cancelRowUpdates();
            }
            this.fireDataStatusEEvent("SaveErrorDataChanged", "", true);
            this.dataRefresh(this.m_rowChanged);
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return 'E';
        }
        try {
            try {
                StringBuffer refreshSQL;
                String sql;
                String whereClause = singleRowWHERE.toString();
                if (whereClause.length() == 0) {
                    whereClause = multiRowWHERE.toString();
                }
                if (this.m_inserting) {
                    log.fine("Inserting ...");
                    if (manualUpdate) {
                        sql = this.createUpdateSql(true, null);
                        int no = DB.executeUpdateEx(sql, null);
                        if (no != 1) {
                            log.log(Level.SEVERE, "Insert #=" + no + " - " + sql);
                        }
                    } else {
                        rs.insertRow();
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Updating ... " + whereClause);
                    }
                    if (manualUpdate) {
                        sql = this.createUpdateSql(false, whereClause);
                        int no = DB.executeUpdateEx(sql, null);
                        if (no != 1) {
                            log.log(Level.SEVERE, "Update #=" + no + " - " + sql);
                        }
                    } else {
                        rs.updateRow();
                    }
                }
                log.fine("Committing ...");
                DB.commit(true, null);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                this.lobSave(whereClause);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reading ... " + whereClause);
                }
                if ((rs = (pstmt = DB.prepareStatement((refreshSQL = new StringBuffer(this.m_SQL_Select).append(" WHERE ").append(whereClause)).toString(), null)).executeQuery()).next()) {
                    rowDataDB = this.readData(rs);
                    this.setDataAtRow(this.m_rowChanged, rowDataDB);
                    if (this.m_virtual) {
                        MSort sort = this.m_sort.get(this.m_rowChanged);
                        int oldId = sort.index;
                        int newId = this.getKeyID(this.m_rowChanged);
                        if (newId != oldId) {
                            sort.index = newId;
                            Object[] data = this.m_virtualBuffer.remove(oldId);
                            this.m_virtualBuffer.put(newId, data);
                        }
                    }
                    this.fireTableRowsUpdated(this.m_rowChanged, this.m_rowChanged);
                } else {
                    log.log(Level.SEVERE, "Inserted row not found");
                }
            }
            catch (Exception e) {
                String msg = "SaveError";
                String dbException = DBException.getDefaultDBExceptionMessage(e);
                if (!Util.isEmpty(dbException)) {
                    log.log(Level.SEVERE, dbException, e);
                    msg = dbException;
                } else {
                    log.log(Level.SEVERE, select.toString(), e);
                }
                this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return 'E';
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        CacheMgt.get().reset(this.m_tableName);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = -1;
        this.m_inserting = false;
        this.fireDataStatusIEvent("Saved", "");
        log.info("fini");
        return 'O';
    }

    private char dataSavePO(int Record_ID) throws Exception {
        String info;
        if (log.isLoggable(Level.FINE)) {
            log.fine("ID=" + Record_ID);
        }
        Object[] rowData = this.getDataAtRow(this.m_rowChanged);
        MTable table2 = MTable.get(this.m_ctx, this.m_AD_Table_ID);
        PO po = null;
        if (!this.m_importing) {
            this.m_trxName = null;
        }
        if ((po = Record_ID != -1 ? table2.getPO(Record_ID, this.m_trxName) : table2.getPO(this.getWhereClause(rowData), this.m_trxName)) == null) {
            throw new ClassNotFoundException("No Persistent Object");
        }
        int size = this.m_fields.size();
        int col = 0;
        while (col < size) {
            GridField field = this.m_fields.get(col);
            if (!field.isVirtualColumn()) {
                String columnName = field.getColumnName();
                Object value = rowData[col];
                Object oldValue = this.m_rowData[col];
                if (field.getDisplayType() != 26 && (oldValue != null || value != null) && (this.m_inserting || this.isValueChanged(oldValue, value))) {
                    int poIndex = po.get_ColumnIndex(columnName);
                    if (poIndex < 0) {
                        po.set_CustomColumn(columnName, value);
                    } else {
                        Object dbValue = po.get_Value(poIndex);
                        if (this.m_inserting || !this.m_compareDB || oldValue == null && dbValue == null || oldValue != null && oldValue.equals(dbValue) || value == null && dbValue == null || value != null && value.equals(dbValue) || oldValue != null && dbValue != null && oldValue.getClass().equals(byte[].class) && dbValue.getClass().equals(byte[].class) && Arrays.equals((byte[])oldValue, (byte[])dbValue) || value != null && dbValue != null && value.getClass().equals(byte[].class) && dbValue.getClass().equals(byte[].class) && Arrays.equals((byte[])oldValue, (byte[])dbValue)) {
                            if (!po.set_ValueNoCheck(columnName, value)) {
                                ValueNamePair lastError = CLogger.retrieveError();
                                if (lastError != null) {
                                    String adMessage = lastError.getValue();
                                    String adMessageArgument = lastError.getName().trim();
                                    StringBuilder info2 = new StringBuilder(adMessageArgument);
                                    if (!adMessageArgument.endsWith(";")) {
                                        info2.append(";");
                                    }
                                    info2.append(field.getHeader());
                                    this.fireDataStatusEEvent(adMessage, info2.toString(), true);
                                } else {
                                    this.fireDataStatusEEvent("Set value failed", field.getHeader(), true);
                                }
                                return 'E';
                            }
                        } else {
                            String msg = String.valueOf(columnName) + "= " + oldValue + (oldValue == null ? "" : "(" + oldValue.getClass().getName() + ")") + " != DB: " + dbValue + (dbValue == null ? "" : "(" + dbValue.getClass().getName() + ")") + " -> New: " + value + (value == null ? "" : "(" + value.getClass().getName() + ")");
                            this.dataRefresh(this.m_rowChanged);
                            this.fireDataStatusEEvent("SaveErrorDataChanged", msg, true);
                            return 'E';
                        }
                    }
                }
            }
            ++col;
        }
        if (!po.save()) {
            String msg = "SaveError";
            String info3 = "";
            ValueNamePair ppE = CLogger.retrieveError();
            if (ppE != null) {
                msg = ppE.getValue();
                info3 = ppE.getName();
                if ("DBExecuteError".equals(msg)) {
                    info3 = "DBExecuteError:" + info3;
                }
            }
            this.fireDataStatusEEvent(msg, info3, true);
            return 'E';
        }
        if (this.m_virtual && po.get_ID() > 0) {
            MSort sort = this.m_sort.get(this.m_rowChanged);
            int oldid = sort.index;
            if (oldid != po.get_ID()) {
                sort.index = po.get_ID();
                Object[] data = this.m_virtualBuffer.remove(oldid);
                data[this.m_indexKeyColumn] = sort.index;
                this.m_virtualBuffer.put(sort.index, data);
            }
        }
        String whereClause = po.get_WhereClause(true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Reading ... " + whereClause);
        }
        StringBuffer refreshSQL = new StringBuffer(this.m_SQL_Select).append(" WHERE ").append(whereClause);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(refreshSQL.toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Object[] rowDataDB = this.readData(rs);
                    this.setDataAtRow(this.m_rowChanged, rowDataDB);
                    this.fireTableRowsUpdated(this.m_rowChanged, this.m_rowChanged);
                }
            }
            catch (SQLException e) {
                String msg = "SaveError";
                log.log(Level.SEVERE, refreshSQL.toString(), e);
                this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return 'E';
            }
        }
        catch (Throwable dbValue) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw dbValue;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.m_rowData = null;
        this.m_changed = false;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = -1;
        this.m_inserting = false;
        ValueNamePair pp = CLogger.retrieveWarning();
        if (pp != null) {
            String msg = pp.getValue();
            info = pp.getName();
            this.fireDataStatusEEvent(msg, info, false);
        } else {
            pp = CLogger.retrieveInfo();
            String msg = "Saved";
            info = "";
            if (pp != null) {
                msg = pp.getValue();
                info = pp.getName();
            }
            this.fireDataStatusIEvent(msg, info);
        }
        log.config("fini");
        return 'O';
    }

    private String getWhereClause(Object[] rowData) {
        int size = this.m_fields.size();
        StringBuffer singleRowWHERE = null;
        StringBuffer multiRowWHERE = null;
        String tableName = this.getTableName();
        int col = 0;
        while (col < size) {
            Object value;
            String columnName;
            GridField field = this.m_fields.get(col);
            if (field.isKey()) {
                columnName = field.getColumnName();
                value = rowData[col];
                if (value == null) {
                    log.log(Level.WARNING, "PK data is null - " + columnName);
                    return null;
                }
                singleRowWHERE = columnName.endsWith("_ID") ? new StringBuffer(tableName).append(".").append(columnName).append("=").append(value) : new StringBuffer(tableName).append(".").append(columnName).append("=").append(DB.TO_STRING(value.toString()));
            } else if (field.isParentColumn()) {
                columnName = field.getColumnName();
                value = rowData[col];
                if (value == null) {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "FK data is null - " + columnName);
                    }
                } else {
                    if (multiRowWHERE == null) {
                        multiRowWHERE = new StringBuffer();
                    } else {
                        multiRowWHERE.append(" AND ");
                    }
                    if (columnName.endsWith("_ID")) {
                        multiRowWHERE.append(tableName).append(".").append(columnName).append("=").append(value);
                    } else {
                        multiRowWHERE.append(tableName).append(".").append(columnName).append("=").append(DB.TO_STRING(value.toString()));
                    }
                }
            }
            ++col;
        }
        if (singleRowWHERE != null) {
            return singleRowWHERE.toString();
        }
        if (multiRowWHERE != null) {
            return multiRowWHERE.toString();
        }
        log.log(Level.WARNING, "No key Found");
        return null;
    }

    private void createUpdateSql(String columnName, String value) {
        this.m_createSqlColumn.add(columnName);
        this.m_createSqlValue.add(value);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("#" + this.m_createSqlColumn.size() + " - " + columnName + "=" + value);
        }
    }

    private String createUpdateSql(boolean insert, String whereClause) {
        StringBuilder sb = new StringBuilder();
        if (insert) {
            sb.append("INSERT INTO ").append(this.m_tableName).append(" (");
            int i2 = 0;
            while (i2 < this.m_createSqlColumn.size()) {
                if (i2 != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlColumn.get(i2));
                ++i2;
            }
            sb.append(") VALUES ( ");
            i2 = 0;
            while (i2 < this.m_createSqlValue.size()) {
                if (i2 != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlValue.get(i2));
                ++i2;
            }
            sb.append(")");
        } else {
            sb.append("UPDATE ").append(this.m_tableName).append(" SET ");
            int i3 = 0;
            while (i3 < this.m_createSqlColumn.size()) {
                if (i3 != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlColumn.get(i3)).append("=").append(this.m_createSqlValue.get(i3));
                ++i3;
            }
            sb.append(" WHERE ").append(whereClause);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(sb.toString());
        }
        this.createUpdateSqlReset();
        return sb.toString();
    }

    private void createUpdateSqlReset() {
        this.m_createSqlColumn = new ArrayList();
        this.m_createSqlValue = new ArrayList();
    }

    private String getMandatory(Object[] rowData) {
        StringBuilder sb = new StringBuilder();
        int size = this.m_fields.size();
        int i2 = 0;
        while (i2 < size) {
            GridField field = this.m_fields.get(i2);
            if (field.isMandatory(true)) {
                if (rowData[i2] == null || rowData[i2].toString().length() == 0) {
                    field.setInserting(true);
                    field.setError(true);
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(field.getHeader());
                } else {
                    field.setError(false);
                }
            }
            ++i2;
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString();
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(PO_LOB lob) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("LOB=" + lob);
        }
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private void lobSave(String whereClause) {
        if (this.m_lobInfo == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m_lobInfo.size()) {
            PO_LOB lob = this.m_lobInfo.get(i2);
            lob.save(whereClause, null);
            ++i2;
        }
        this.lobReset();
    }

    public boolean dataNew(int currentRow, boolean copyCurrent) {
        MSort newSort;
        if (log.isLoggable(Level.INFO)) {
            log.info("Current=" + currentRow + ", Copy=" + copyCurrent);
        }
        if (this.m_readOnly) {
            this.fireDataStatusEEvent("AccessCannotInsert", "", true);
            return false;
        }
        this.dataSave(-2, false);
        this.m_inserting = true;
        int size = this.m_fields.size();
        this.m_rowData = new Object[size];
        Object[] rowData = new Object[size];
        this.m_changed = true;
        this.m_compareDB = true;
        this.m_newRow = currentRow + 1;
        if (this.m_sort.size() < this.m_newRow) {
            this.m_newRow = this.m_sort.size();
        }
        MSort mSort = newSort = this.m_virtual ? new MSort(NEW_ROW_ID, null) : new MSort(this.m_sort.size(), null);
        if (this.m_virtual) {
            this.m_virtualBuffer.put(NEW_ROW_ID, rowData);
        } else {
            this.m_buffer.add(rowData);
        }
        this.m_sort.add(this.m_newRow, newSort);
        ++this.m_rowCount;
        if (copyCurrent) {
            boolean hasDocTypeTargetField = this.getField("C_DocTypeTarget_ID") != null;
            Object[] origData = this.getDataAtRow(currentRow);
            int i2 = 0;
            while (i2 < size) {
                GridField field = this.m_fields.get(i2);
                MColumn column = null;
                if (field.getAD_Column_ID() > 0) {
                    column = MColumn.get(this.m_ctx, field.getAD_Column_ID());
                }
                if (!field.isVirtualColumn()) {
                    Object value;
                    if (field.isKey() || column != null && column.isUUIDColumn() || column != null && column.isStandardColumn() && !column.getColumnName().equals("AD_Org_ID") || hasDocTypeTargetField && field.getColumnName().equals("C_DocType_ID") || !field.isAllowCopy()) {
                        value = field.getDefault();
                        field.setValue(value, this.m_inserting);
                        field.validateValueNoDirect();
                        rowData[i2] = field.getValue();
                    } else {
                        value = origData[i2];
                        field.setValue(value, this.m_inserting);
                        field.validateValueNoDirect();
                        rowData[i2] = field.getValue();
                    }
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < size) {
                GridField field = this.m_fields.get(i3);
                Object value = field.getDefault();
                field.setValue(value, this.m_inserting);
                field.validateValueNoDirect();
                rowData[i3] = field.getValue();
                ++i3;
            }
        }
        this.m_rowChanged = -1;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Current=" + currentRow + ", New=" + this.m_newRow);
        }
        this.fireTableRowsInserted(this.m_newRow, this.m_newRow);
        this.fireDataStatusIEvent(copyCurrent ? DATA_UPDATE_COPIED_MESSAGE : DATA_INSERTED_MESSAGE, "");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Current=" + currentRow + ", New=" + this.m_newRow + " - complete");
        }
        return true;
    }

    public boolean dataDelete(int row) {
        Boolean processed;
        if (log.isLoggable(Level.INFO)) {
            log.info("Row=" + row);
        }
        if (row < 0) {
            return false;
        }
        if (this.m_readOnly) {
            this.fireDataStatusEEvent("AccessCannotDelete", "", true);
            return false;
        }
        if (!this.m_deleteable) {
            this.fireDataStatusEEvent("AccessNotDeleteable", "", true);
            return false;
        }
        if (this.m_indexProcessedColumn > 0 && !this.m_tableName.startsWith("I_") && (processed = (Boolean)this.getValueAt(row, this.m_indexProcessedColumn)) != null && processed.booleanValue()) {
            this.fireDataStatusEEvent("CannotDeleteTrx", "", true);
            return false;
        }
        int[] co = this.getClientOrg(row);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        if (!MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, 0, true)) {
            this.fireDataStatusEEvent("AccessCannotDelete", "", true);
            return false;
        }
        MSort sort = this.m_sort.get(row);
        Object[] rowData = this.getDataAtRow(row);
        PO po = this.getPO(row);
        if (po != null) {
            boolean ok = false;
            try {
                ok = po.delete(false);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Delete", t);
            }
            if (!ok) {
                ValueNamePair vp = CLogger.retrieveError();
                if (vp != null) {
                    this.fireDataStatusEEvent(vp);
                } else {
                    this.fireDataStatusEEvent("DeleteError", "", true);
                }
                return false;
            }
        } else {
            StringBuilder sql = new StringBuilder("DELETE ");
            sql.append(this.m_tableName).append(" WHERE ").append(this.getWhereClause(rowData));
            int no = 0;
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), 1005, 1008, null);
                    no = pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                    String msg = "DeleteError";
                    String dbMsg = DBException.getDefaultDBExceptionMessage(e);
                    if (!Util.isEmpty(dbMsg)) {
                        msg = dbMsg;
                    }
                    this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                    DB.close(pstmt);
                    pstmt = null;
                    return false;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                pstmt = null;
                throw throwable;
            }
            DB.close(pstmt);
            pstmt = null;
            if (no != 1) {
                log.log(Level.SEVERE, "Number of deleted rows = " + no);
                return false;
            }
        }
        if (this.m_virtual) {
            this.m_virtualBuffer.remove(sort.index);
        } else {
            this.m_buffer.remove(sort.index);
        }
        --this.m_rowCount;
        this.m_sort.remove(row);
        if (!this.m_virtual) {
            int i2 = 0;
            while (i2 < this.m_sort.size()) {
                MSort ptr = this.m_sort.get(i2);
                if (ptr.index > sort.index) {
                    --ptr.index;
                }
                ++i2;
            }
        }
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.fireTableRowsDeleted(row, row);
        this.fireDataStatusIEvent("Deleted", "");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Row=" + row + " complete");
        }
        return true;
    }

    public void dataIgnore() {
        if (!this.m_inserting && !this.m_changed && this.m_rowChanged < 0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Nothing to ignore");
            }
            this.m_newRow = -1;
            return;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Inserting=" + this.m_inserting);
        }
        if (this.m_inserting) {
            MSort sort = this.m_sort.get(this.m_newRow);
            if (this.m_virtual) {
                this.m_virtualBuffer.remove(NEW_ROW_ID);
            } else {
                this.m_buffer.remove(sort.index);
            }
            --this.m_rowCount;
            this.m_sort.remove(this.m_newRow);
            this.m_changed = false;
            this.m_rowData = null;
            this.m_rowChanged = -1;
            this.m_inserting = false;
            this.fireTableRowsDeleted(this.m_newRow, this.m_newRow);
        } else {
            if (this.m_rowData != null) {
                this.setDataAtRow(this.m_rowChanged, this.m_rowData);
            }
            this.m_changed = false;
            this.m_rowData = null;
            this.m_rowChanged = -1;
            this.m_inserting = false;
        }
        this.m_newRow = -1;
        this.fireDataStatusIEvent(DATA_IGNORED_MESSAGE, "");
    }

    public void dataRefresh(int row) {
        this.dataRefresh(row, true);
    }

    public String getWhereClause(int row) {
        if (row < 0 || this.m_sort.size() == 0 || this.m_inserting) {
            return null;
        }
        Object[] rowData = this.getDataAtRow(row);
        if (rowData == null) {
            return null;
        }
        String where = this.getWhereClause(rowData);
        return where;
    }

    public void dataRefresh(int row, boolean fireStatusEvent) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Row=" + row);
        }
        if (row < 0 || this.m_sort.size() == 0 || this.m_inserting) {
            return;
        }
        Object[] rowData = this.getDataAtRow(row);
        this.dataIgnore();
        String where = this.getWhereClause(rowData);
        if (where == null || where.length() == 0) {
            where = "1=2";
        }
        String sql = String.valueOf(this.m_SQL_Select) + " WHERE " + where;
        Object[] rowDataDB = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rowDataDB = this.readData(rs);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
                this.fireTableRowsUpdated(row, row);
                this.fireDataStatusEEvent("RefreshError", sql, true);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (rowDataDB != null) {
            this.setDataAtRow(row, rowDataDB);
        }
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableRowsUpdated(row, row);
        if (fireStatusEvent) {
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
    }

    public void dataRefreshAll() {
        this.dataRefreshAll(true);
    }

    public void dataRefreshAll(boolean fireStatusEvent) {
        this.dataRefreshAll(fireStatusEvent, -1);
    }

    public void dataRefreshAll(boolean fireStatusEvent, int rowToRetained) {
        log.info("");
        this.m_inserting = false;
        this.dataIgnore();
        String retainedWhere = null;
        if (rowToRetained >= 0) {
            retainedWhere = this.getWhereClause(rowToRetained);
        }
        this.close(false);
        if (retainedWhere != null) {
            if (this.m_whereClause != null && this.m_whereClause.trim().length() > 0) {
                this.m_whereClause = "((" + this.m_whereClause + ") OR (" + retainedWhere + ")) ";
            }
            this.open(this.m_maxRows);
        } else {
            this.open(this.m_maxRows);
        }
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        if (this.m_lastSortColumnIndex >= 0) {
            this.loadComplete();
            this.sort(this.m_lastSortColumnIndex, this.m_lastSortedAscending);
        }
        this.fireTableDataChanged();
        if (fireStatusEvent) {
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
    }

    public boolean dataRequery(String whereClause, boolean onlyCurrentRows, int onlyCurrentDays, boolean fireEvents) {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(whereClause) + "; OnlyCurrent=" + onlyCurrentRows);
        }
        this.close(false);
        this.m_onlyCurrentDays = onlyCurrentDays;
        this.setSelectWhereClause(whereClause, onlyCurrentRows, this.m_onlyCurrentDays);
        this.open(this.m_maxRows);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        if (this.m_lastSortColumnIndex >= 0) {
            this.loadComplete();
            this.sort(this.m_lastSortColumnIndex, this.m_lastSortedAscending);
        }
        if (fireEvents) {
            this.fireTableDataChanged();
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
        return true;
    }

    public boolean dataRequery(String whereClause, boolean onlyCurrentRows, int onlyCurrentDays) {
        return this.dataRequery(whereClause, onlyCurrentRows, onlyCurrentDays, true);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_readOnly) {
            return false;
        }
        if (col == this.m_indexKeyColumn) {
            return false;
        }
        if (col < 0 && col >= this.m_fields.size()) {
            return false;
        }
        if (col == this.m_indexActiveColumn && this.m_indexProcessedColumn == -1) {
            return true;
        }
        if (!this.isRowEditable(row)) {
            return false;
        }
        return this.m_fields.get(col).isEditable(false);
    }

    public boolean isRowEditable(int row) {
        Object processed;
        Object value;
        if (this.m_readOnly || row < 0) {
            return false;
        }
        if (this.m_indexActiveColumn > 0 && ((value = this.getValueAt(row, this.m_indexActiveColumn)) instanceof Boolean ? (Boolean)value == false : "N".equals(value))) {
            return false;
        }
        if (this.m_indexProcessedColumn > 0 && ((processed = this.getValueAt(row, this.m_indexProcessedColumn)) instanceof Boolean ? (Boolean)processed != false : "Y".equals(processed))) {
            return false;
        }
        int[] co = this.getClientOrg(row);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        int Record_ID = this.getKeyID(row);
        return MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, Record_ID, false);
    }

    private int[] getClientOrg(int row) {
        Integer ii;
        Integer ii2;
        int AD_Client_ID = -1;
        if (this.m_indexClientColumn != -1 && (ii2 = (Integer)this.getValueAt(row, this.m_indexClientColumn)) != null) {
            AD_Client_ID = ii2;
        }
        int AD_Org_ID = 0;
        if (this.m_indexOrgColumn != -1 && (ii = (Integer)this.getValueAt(row, this.m_indexOrgColumn)) != null) {
            AD_Org_ID = ii;
        }
        return new int[]{AD_Client_ID, AD_Org_ID};
    }

    public void setReadOnly(boolean value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("ReadOnly=" + value);
        }
        this.m_readOnly = value;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public boolean isInserting() {
        return this.m_inserting;
    }

    public void setCompareDB(boolean compareDB) {
        this.m_compareDB = compareDB;
    }

    public boolean getCompareDB() {
        return this.m_compareDB;
    }

    public void setDeleteable(boolean value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleteable=" + value);
        }
        this.m_deleteable = value;
    }

    private Object[] readData(ResultSet rs) {
        int size = this.m_fields.size();
        Object[] rowData = new Object[size];
        String columnName = null;
        int displayType = 0;
        try {
            int j = 0;
            while (j < size) {
                GridField field = this.m_fields.get(j);
                columnName = field.getColumnName();
                displayType = field.getDisplayType();
                if (displayType == 11 || DisplayType.isID(displayType) && !columnName.equals("EntityType") && !columnName.equals("AD_Language")) {
                    rowData[j] = rs.getInt(j + 1);
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    }
                } else if (DisplayType.isNumeric(displayType)) {
                    rowData[j] = rs.getBigDecimal(j + 1);
                } else if (DisplayType.isDate(displayType)) {
                    rowData[j] = rs.getTimestamp(j + 1);
                } else if (displayType == 26) {
                    rowData[j] = null;
                } else if (displayType == 20) {
                    String str = rs.getString(j + 1);
                    if (field.isEncryptedColumn()) {
                        str = (String)this.decrypt(str, this.getAD_Client_ID(rs));
                    }
                    rowData[j] = "Y".equals(str);
                } else if (DisplayType.isLOB(displayType)) {
                    long length;
                    Object lob;
                    Object value = rs.getObject(j + 1);
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    } else if (value instanceof Clob) {
                        lob = (Clob)value;
                        length = lob.length();
                        rowData[j] = lob.getSubString(1L, (int)length);
                    } else if (value instanceof Blob) {
                        lob = (Blob)value;
                        length = lob.length();
                        rowData[j] = lob.getBytes(1L, (int)length);
                    } else if (value instanceof String) {
                        rowData[j] = value;
                    } else if (value instanceof byte[]) {
                        rowData[j] = value;
                    }
                } else {
                    rowData[j] = rs.getString(j + 1);
                }
                if (field.isEncryptedColumn() && displayType != 20) {
                    rowData[j] = this.decrypt(rowData[j], this.getAD_Client_ID(rs));
                }
                ++j;
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, String.valueOf(columnName) + ", DT=" + displayType, e);
        }
        return rowData;
    }

    private Object encrypt(Object xx, int AD_Client_ID) {
        if (xx == null) {
            return null;
        }
        return SecureEngine.encrypt(xx, AD_Client_ID);
    }

    private Object decrypt(Object yy, int AD_Client_ID) {
        if (yy == null) {
            return null;
        }
        return SecureEngine.decrypt(yy, AD_Client_ID);
    }

    private int getAD_Client_ID(ResultSet rs) {
        int AD_Client_ID = -1;
        try {
            AD_Client_ID = rs.getInt("AD_Client_ID");
            if (rs.wasNull()) {
                AD_Client_ID = -1;
            }
        }
        catch (SQLException e) {
            AD_Client_ID = -1;
        }
        if (AD_Client_ID == -1) {
            AD_Client_ID = this.getAD_Client_ID();
        }
        return AD_Client_ID;
    }

    private int getAD_Client_ID() {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        GridField field = this.getField("AD_Client_ID");
        if (field != null && field.getValue() != null) {
            AD_Client_ID = ((Number)field.getValue()).intValue();
        }
        return AD_Client_ID;
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.listenerList.remove(DataStatusListener.class, l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.listenerList.add(DataStatusListener.class, l);
    }

    private void fireDataStatusChanged(DataStatusEvent e) {
        DataStatusListener[] listeners = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
        int i2 = 0;
        while (i2 < listeners.length) {
            listeners[i2].dataStatusChanged(e);
            ++i2;
        }
    }

    private DataStatusEvent createDSE() {
        boolean changed = this.m_changed;
        if (this.m_rowChanged != -1) {
            changed = true;
        }
        DataStatusEvent dse = new DataStatusEvent(this, this.m_rowCount, changed, Env.isAutoCommit(this.m_ctx, this.m_WindowNo), this.m_inserting);
        dse.AD_Table_ID = this.m_AD_Table_ID;
        dse.Record_ID = null;
        return dse;
    }

    protected void fireDataStatusIEvent(String AD_Message, String info) {
        DataStatusEvent e = this.createDSE();
        e.setInfo(AD_Message, info, false, false);
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(String AD_Message, String info, boolean isError) {
        DataStatusEvent e = this.createDSE();
        if (info != null && info.startsWith("DBExecuteError:")) {
            String newinfo;
            int nl = info.indexOf("\n");
            String firstline = nl > 0 ? info.substring(0, nl) : info;
            if (firstline.equals(newinfo = Msg.getMsg(this.m_ctx, firstline))) {
                newinfo = info.substring(15);
            }
            e.setInfo(AD_Message, newinfo, isError, !isError);
        } else {
            e.setInfo(AD_Message, info, isError, !isError);
        }
        if (isError) {
            log.saveWarning(AD_Message, info);
        }
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(ValueNamePair errorLog) {
        if (errorLog != null) {
            this.fireDataStatusEEvent(errorLog.getValue(), errorLog.getName(), true);
        }
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.addVetoableChangeListener(l);
    }

    protected void fireVetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        this.m_vetoableChangeSupport.fireVetoableChange(e);
    }

    public String toString() {
        return new StringBuffer("MTable[").append(this.m_tableName).append(",WindowNo=").append(this.m_WindowNo).append(",Tab=").append(this.m_TabNo).append("]").toString();
    }

    public int getNewRow() {
        return this.m_newRow;
    }

    protected void setFieldVFormat(String identifier, String strNewFormat) {
        int cols = this.m_fields.size();
        int i2 = 0;
        while (i2 < cols) {
            GridField field = this.m_fields.get(i2);
            if (identifier.equalsIgnoreCase(field.getColumnName())) {
                field.setVFormat(strNewFormat);
                this.m_fields.set(i2, field);
                break;
            }
            ++i2;
        }
    }

    public boolean hasChanged(int row) {
        if (this.getKeyID(row) > 0) {
            int colUpdated = this.findColumn("Updated");
            int colProcessed = this.findColumn("Processed");
            boolean hasUpdated = colUpdated > 0;
            boolean hasProcessed = colProcessed > 0;
            String columns = null;
            if (hasUpdated && hasProcessed) {
                columns = new String("Updated, Processed");
            } else if (hasUpdated) {
                columns = new String("Updated");
            } else if (hasProcessed) {
                columns = new String("Processed");
            } else {
                return false;
            }
            if (this.findColumn(String.valueOf(this.m_tableName) + "_ID") == -1) {
                return false;
            }
            Timestamp dbUpdated = null;
            String dbProcessedS = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT " + columns + " FROM " + this.m_tableName + " WHERE " + this.m_tableName + "_ID=?";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getKeyID(row));
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        int idx = 1;
                        if (hasUpdated) {
                            dbUpdated = rs.getTimestamp(idx++);
                        }
                        if (hasProcessed) {
                            dbProcessedS = rs.getString(idx++);
                        }
                    } else if (log.isLoggable(Level.INFO)) {
                        log.info("No Value " + sql);
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sql);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (hasUpdated) {
                Timestamp memUpdated = null;
                memUpdated = (Timestamp)this.getOldValue(row, colUpdated);
                if (memUpdated == null) {
                    memUpdated = (Timestamp)this.getValueAt(row, colUpdated);
                }
                if (memUpdated != null && !memUpdated.equals(dbUpdated)) {
                    return true;
                }
            }
            if (hasProcessed) {
                Boolean memProcessed = null;
                memProcessed = (Boolean)this.getOldValue(row, colProcessed);
                if (memProcessed == null) {
                    if (this.getValueAt(row, colProcessed) instanceof Boolean) {
                        memProcessed = (Boolean)this.getValueAt(row, colProcessed);
                    } else if (this.getValueAt(row, colProcessed) instanceof String) {
                        memProcessed = Boolean.valueOf((String)this.getValueAt(row, colProcessed));
                    }
                }
                Boolean dbProcessed = Boolean.TRUE;
                if (!dbProcessedS.equals("Y")) {
                    dbProcessed = Boolean.FALSE;
                }
                if (memProcessed != null && !memProcessed.equals(dbProcessed)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int getParentTabNo() {
        tabNo = this.m_TabNo;
        currentLevel = Env.getContextAsInt(this.m_ctx, this.m_WindowNo, tabNo, "_TabInfo_TabLevel");
        parentLevel = currentLevel - 1;
        if (parentLevel >= 0) ** GOTO lbl8
        return tabNo;
lbl-1000:
        // 1 sources

        {
            currentLevel = Env.getContextAsInt(this.m_ctx, this.m_WindowNo, --tabNo, "_TabInfo_TabLevel");
            if (tabNo == 0) break;
lbl8:
            // 2 sources

            ** while (parentLevel != currentLevel)
        }
lbl9:
        // 2 sources

        return tabNo;
    }

    public int getTabNo() {
        return this.m_TabNo;
    }

    private boolean isNotNullAndIsEmpty(Object value) {
        return value != null && value instanceof String && value.toString().equals("");
    }

    private boolean isValueChanged(Object oldValue, Object value) {
        boolean bChanged;
        if (this.isNotNullAndIsEmpty(oldValue)) {
            oldValue = null;
        }
        if (this.isNotNullAndIsEmpty(value)) {
            value = null;
        }
        boolean bl = bChanged = oldValue == null && value != null || oldValue != null && value == null;
        if (!bChanged && oldValue != null) {
            if (oldValue.getClass().equals(value.getClass())) {
                bChanged = oldValue instanceof Comparable ? ((Comparable)oldValue).compareTo(value) != 0 : !oldValue.equals(value);
            } else if (value != null) {
                bChanged = !oldValue.toString().equals(value.toString());
            }
        }
        return bChanged;
    }

    public PO getPO(int row) {
        MTable table2 = MTable.get(this.m_ctx, this.m_AD_Table_ID);
        PO po = null;
        int Record_ID = this.getKeyID(row);
        po = Record_ID != -1 ? table2.getPO(Record_ID, this.m_trxName) : table2.getPO(this.getWhereClause(this.getDataAtRow(row)), this.m_trxName);
        return po;
    }

    public void setImportingMode(boolean importing, String trxName) {
        this.m_importing = importing;
        this.m_trxName = trxName;
    }

    public boolean isImporting() {
        return this.m_importing;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    public void resetCacheSortState() {
        this.m_lastSortColumnIndex = -1;
        this.m_lastSortedAscending = true;
    }

    public int getKeyColumnIndex() {
        return this.m_indexKeyColumn;
    }

    class Loader
    implements Serializable,
    Runnable {
        private static final long serialVersionUID = -8735217685095696892L;
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;
        private Trx trx = null;
        private Properties m_context = null;
        private int maxRows;
        private int rows;

        public void setContext(Properties context) {
            this.m_context = context;
        }

        protected int open(int maxRows) {
            this.maxRows = maxRows;
            this.rows = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(GridTable.this.m_SQL_Count, null);
                    this.setParameter(pstmt, true);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.rows = rs.getInt(1);
                    }
                }
                catch (SQLException e0) {
                    if (!DBException.isInvalidIdentifierError(e0)) {
                        throw new AdempiereException(e0);
                    }
                    log.warning("Count - " + e0.getLocalizedMessage() + "\nSQL=" + GridTable.this.m_SQL_Count);
                    DB.close(rs, pstmt);
                    return 0;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
            StringBuilder info = new StringBuilder("Rows=");
            info.append(this.rows);
            if (this.rows == 0) {
                info.append(" - ").append(GridTable.this.m_SQL_Count);
            }
            if (maxRows > 0 && this.rows > maxRows) {
                info.append(" - MaxRows=").append(maxRows);
                this.rows = maxRows;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(info.toString());
            }
            return this.rows;
        }

        private void openResultSet() {
            String trxName = GridTable.this.m_virtual ? Trx.createTrxName("Loader") : null;
            Trx trx = this.trx = trxName != null ? Trx.get(trxName, true) : null;
            if (this.trx != null) {
                this.trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_openResultSet");
            }
            try {
                this.m_pstmt = DB.prepareStatement(GridTable.this.m_SQL, trxName);
                if (this.maxRows > 0 && this.rows == this.maxRows) {
                    this.m_pstmt.setMaxRows(this.maxRows);
                }
                if (GridTable.this.m_virtual) {
                    this.m_pstmt.setFetchSize(100);
                }
                this.setParameter(this.m_pstmt, false);
                this.m_rs = this.m_pstmt.executeQuery();
            }
            catch (SQLException e) {
                log.saveError(e.getLocalizedMessage(), e);
                throw new DBException(e);
            }
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
            if (this.trx != null) {
                this.trx.close();
            }
        }

        @Override
        public void run() {
            try {
                if (this.m_context != null) {
                    ServerContext.setCurrentInstance(this.m_context);
                }
                this.doRun();
            }
            finally {
                if (this.m_context != null) {
                    ServerContext.dispose();
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void doRun() {
            block15: {
                this.openResultSet();
                if (this.m_rs != null) ** GOTO lbl45
                return;
                {
                    try {
                        if (Thread.interrupted()) {
                            if (GridTable.log.isLoggable(Level.FINE)) {
                                GridTable.log.fine("Interrupted");
                            }
                            this.close();
                            this.close();
                            return;
                        }
                    }
                    catch (SQLException e) {
                        GridTable.log.log(Level.SEVERE, "run", e);
                        this.close();
                        break block15;
                    }
                    catch (Throwable var5_7) {
                        this.close();
                        throw var5_7;
                    }
                    {
                        recordId = 0;
                        rowData = null;
                        if (GridTable.this.m_virtual) {
                            recordId = this.m_rs.getInt(GridTable.this.getKeyColumnName());
                        } else {
                            rowData = GridTable.this.readData(this.m_rs);
                        }
                        v0 = sort = GridTable.this.m_virtual != false ? new MSort(recordId, null) : new MSort(GridTable.this.m_buffer.size(), null);
                        if (!GridTable.this.m_virtual) {
                            GridTable.this.m_buffer.add(rowData);
                        }
                        GridTable.this.m_sort.add(sort);
                        if (GridTable.this.m_sort.size() % 1000 != 0) continue;
                        try {
                            Thread.yield();
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            if (GridTable.log.isLoggable(Level.FINE)) {
                                GridTable.log.fine("Interrupted while sleeping");
                            }
                            this.close();
                            this.close();
                            return;
                        }
                    }
                    {
                        evt = GridTable.this.createDSE();
                        evt.setLoading(GridTable.this.m_sort.size());
                        GridTable.this.fireDataStatusChanged(evt);
lbl45:
                        // 3 sources

                        if (this.m_rs.next()) continue;
                    }
                }
                this.close();
            }
            GridTable.this.fireDataStatusIEvent("", "");
        }

        private void setParameter(PreparedStatement pstmt, boolean countSQL) {
            if (GridTable.this.m_parameterSELECT.size() == 0 && GridTable.this.m_parameterWHERE.size() == 0) {
                return;
            }
            try {
                Integer ii;
                Object para;
                int pos = 1;
                int i2 = 0;
                while (!countSQL && i2 < GridTable.this.m_parameterSELECT.size()) {
                    para = GridTable.this.m_parameterSELECT.get(i2);
                    if (para != null && log.isLoggable(Level.FINE)) {
                        log.fine("Select " + i2 + "=" + para);
                    }
                    if (para != null) {
                        if (para instanceof Integer) {
                            ii = (Integer)para;
                            pstmt.setInt(pos++, ii);
                        } else if (para instanceof BigDecimal) {
                            pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        } else {
                            pstmt.setString(pos++, para.toString());
                        }
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < GridTable.this.m_parameterWHERE.size()) {
                    para = GridTable.this.m_parameterWHERE.get(i2);
                    if (para != null && log.isLoggable(Level.FINE)) {
                        log.fine("Where " + i2 + "=" + para);
                    }
                    if (para != null) {
                        if (para instanceof Integer) {
                            ii = (Integer)para;
                            pstmt.setInt(pos++, ii);
                        } else if (para instanceof BigDecimal) {
                            pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        } else {
                            pstmt.setString(pos++, para.toString());
                        }
                    }
                    ++i2;
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "parameter", e);
            }
        }
    }
}

