/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MRole;
import org.compiere.model.MUserDefField;
import org.compiere.model.MValRule;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class GridFieldVO
implements Serializable {
    private static final long serialVersionUID = -1752172363171842152L;
    public Properties ctx = null;
    public int WindowNo;
    public int TabNo;
    public int AD_Window_ID;
    public int AD_Process_ID_Of_Panel;
    public int AD_Window_ID_Of_Panel;
    public int AD_Infowindow_ID;
    public int AD_Tab_ID;
    public boolean tabReadOnly = false;
    public boolean isProcess = false;
    public String ColumnName = "";
    public String ColumnSQL;
    public String Header = "";
    public int displayType = 0;
    public int AD_Table_ID = 0;
    public int AD_Column_ID = 0;
    public int DisplayLength = 0;
    public boolean IsSameLine = false;
    public boolean IsDisplayed = false;
    public boolean IsDisplayedGrid = false;
    public int SeqNo = 0;
    public int SeqNoGrid = 0;
    public String DisplayLogic = "";
    public String DefaultValue = "";
    public boolean IsMandatory = false;
    public boolean IsReadOnly = false;
    public boolean IsUpdateable = false;
    public boolean IsAlwaysUpdateable = false;
    public boolean IsHeading = false;
    public boolean IsFieldOnly = false;
    public boolean IsEncryptedField = false;
    public boolean IsEncryptedColumn = false;
    public boolean IsSelectionColumn = false;
    public int SeqNoSelection = 0;
    public int SortNo = 0;
    public int FieldLength = 0;
    public String VFormat = "";
    public String FormatPattern;
    public String ValueMin = "";
    public String ValueMax = "";
    public String FieldGroup = "";
    public String FieldGroupType = "";
    public boolean IsKey = false;
    public boolean IsParent = false;
    public String Callout = "";
    public int AD_Process_ID = 0;
    public String Description = "";
    public String Help = "";
    public String MandatoryLogic = "";
    public String ReadOnlyLogic = "";
    public String ObscureType = null;
    public boolean IsDefaultFocus = false;
    public String ValidationCode = "";
    public int AD_Reference_Value_ID = 0;
    public boolean isRange = false;
    public String DefaultValue2 = "";
    public MLookupInfo lookupInfo = null;
    public int AD_Field_ID = 0;
    public int XPosition = 0;
    public int ColumnSpan = 0;
    public int NumLines = 0;
    public int Included_Tab_ID = 0;
    public boolean IsCollapsedByDefault = false;
    public boolean IsAutocomplete = false;
    public boolean IsAllowCopy = false;
    public String IsToolbarButton = "N";
    public int AD_Chart_ID = 0;
    public int AD_LabelStyle_ID = 0;
    public int AD_FieldStyle_ID = 0;
    public int PA_DashboardContent_ID = 0;
    public String Placeholder = "";
    public String Placeholder2 = "";
    public boolean IsHtml = false;

    public static String getSQL(Properties ctx) {
        StringBuilder sql;
        MRole role = MRole.getDefault(ctx, false);
        String advancedFilter = " AND IsAdvancedField='N' ";
        if (!Env.isBaseLanguage(ctx, "AD_Tab")) {
            sql = new StringBuilder("SELECT * FROM AD_Field_vt WHERE AD_Tab_ID=?").append(" AND AD_Language='" + Env.getAD_Language(ctx) + "'");
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY IsDisplayed DESC, SeqNo");
        } else {
            sql = new StringBuilder("SELECT * FROM AD_Field_v WHERE AD_Tab_ID=?");
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY IsDisplayed DESC, SeqNo");
        }
        return sql.toString();
    }

    public static GridFieldVO create(Properties ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean readOnly, ResultSet rs) {
        MClient client;
        int AD_Field_ID;
        String columnName;
        GridFieldVO vo;
        block152: {
            vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, readOnly);
            columnName = "ColumnName";
            AD_Field_ID = 0;
            vo.ColumnName = rs.getString("ColumnName");
            if (vo.ColumnName != null) break block152;
            return null;
        }
        try {
            CLogger.get().fine(vo.ColumnName);
            ResultSetMetaData rsmd = rs.getMetaData();
            int i2 = 1;
            while (i2 <= rsmd.getColumnCount()) {
                String s;
                columnName = rsmd.getColumnName(i2);
                if (columnName.equalsIgnoreCase("Name")) {
                    vo.Header = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("AD_Reference_ID")) {
                    vo.displayType = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("AD_Column_ID")) {
                    vo.AD_Column_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("AD_Table_ID")) {
                    vo.AD_Table_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("DisplayLength")) {
                    vo.DisplayLength = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("IsSameLine")) {
                    vo.IsSameLine = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsDisplayed")) {
                    vo.IsDisplayed = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsDisplayedGrid")) {
                    vo.IsDisplayedGrid = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("SeqNo")) {
                    vo.SeqNo = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("SeqNoGrid")) {
                    vo.SeqNoGrid = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("DisplayLogic")) {
                    vo.DisplayLogic = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("DefaultValue")) {
                    vo.DefaultValue = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("IsMandatory")) {
                    vo.IsMandatory = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsReadOnly")) {
                    vo.IsReadOnly = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsUpdateable")) {
                    vo.IsUpdateable = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsAlwaysUpdateable")) {
                    vo.IsAlwaysUpdateable = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsHeading")) {
                    vo.IsHeading = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsFieldOnly")) {
                    vo.IsFieldOnly = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsEncryptedField")) {
                    vo.IsEncryptedField = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsEncryptedColumn")) {
                    vo.IsEncryptedColumn = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsSelectionColumn")) {
                    vo.IsSelectionColumn = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("SeqNoSelection")) {
                    vo.SeqNoSelection = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("SortNo")) {
                    vo.SortNo = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("FieldLength")) {
                    vo.FieldLength = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("VFormat")) {
                    vo.VFormat = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("FormatPattern")) {
                    vo.FormatPattern = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("ValueMin")) {
                    vo.ValueMin = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("ValueMax")) {
                    vo.ValueMax = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("FieldGroup")) {
                    vo.FieldGroup = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("FieldGroupType")) {
                    vo.FieldGroupType = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("IsKey")) {
                    vo.IsKey = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsParent")) {
                    vo.IsParent = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("Description")) {
                    s = rs.getString(i2);
                    vo.Description = s != null ? s.intern() : s;
                } else if (columnName.equalsIgnoreCase("Help")) {
                    s = rs.getString(i2);
                    vo.Help = s != null ? s.intern() : s;
                } else if (columnName.equalsIgnoreCase("Callout")) {
                    vo.Callout = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("AD_Process_ID")) {
                    vo.AD_Process_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("ReadOnlyLogic")) {
                    vo.ReadOnlyLogic = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("MandatoryLogic")) {
                    vo.MandatoryLogic = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("ObscureType")) {
                    vo.ObscureType = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("IsDefaultFocus")) {
                    vo.IsDefaultFocus = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("AD_Reference_Value_ID")) {
                    vo.AD_Reference_Value_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("ValidationCode")) {
                    vo.ValidationCode = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("ColumnSQL")) {
                    vo.ColumnSQL = rs.getString(i2);
                    if (vo.ColumnSQL != null && !vo.ColumnSQL.startsWith("@SQL=") && vo.ColumnSQL.contains("@")) {
                        vo.ColumnSQL = Env.parseContext(ctx, -1, vo.ColumnSQL, false, true);
                    }
                } else if (columnName.equalsIgnoreCase("Included_Tab_ID")) {
                    vo.Included_Tab_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("IsCollapsedByDefault")) {
                    vo.IsCollapsedByDefault = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsAutocomplete")) {
                    vo.IsAutocomplete = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("IsAllowCopy")) {
                    vo.IsAllowCopy = "Y".equals(rs.getString(i2));
                } else if (columnName.equalsIgnoreCase("AD_Field_ID")) {
                    vo.AD_Field_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("XPosition")) {
                    vo.XPosition = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("ColumnSpan")) {
                    vo.ColumnSpan = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("NumLines")) {
                    vo.NumLines = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("IsToolbarButton")) {
                    vo.IsToolbarButton = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("AD_Chart_ID")) {
                    vo.AD_Chart_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("AD_LabelStyle_ID")) {
                    vo.AD_LabelStyle_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("AD_FieldStyle_ID")) {
                    vo.AD_FieldStyle_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("PA_DashboardContent_ID")) {
                    vo.PA_DashboardContent_ID = rs.getInt(i2);
                } else if (columnName.equalsIgnoreCase("placeholder")) {
                    vo.Placeholder = rs.getString(i2);
                } else if (columnName.equalsIgnoreCase("IsHtml")) {
                    vo.IsHtml = "Y".equals(rs.getString(i2));
                }
                ++i2;
            }
            if (vo.Header == null) {
                vo.Header = vo.ColumnName;
            }
            AD_Field_ID = rs.getInt("AD_Field_ID");
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "ColumnName=" + columnName, e);
            return null;
        }
        if (vo.IsDisplayed && !(client = MClient.get(ctx)).isDisplayField(AD_Field_ID)) {
            vo.IsDisplayed = false;
        }
        if (vo.IsDisplayed) {
            MUserDefField userDef = null;
            userDef = MUserDefField.get(vo.ctx, AD_Field_ID, AD_Tab_ID, AD_Window_ID);
            if (userDef != null) {
                if (userDef.getName() != null) {
                    vo.Header = userDef.getName();
                }
                if (userDef.getDescription() != null) {
                    vo.Description = userDef.getDescription();
                }
                if (userDef.getHelp() != null) {
                    vo.Help = userDef.getHelp();
                }
                if (userDef.getDisplayLength() > 0) {
                    vo.DisplayLength = userDef.getDisplayLength();
                }
                if (userDef.getDisplayLogic() != null) {
                    vo.DisplayLogic = userDef.getDisplayLogic();
                }
                if (userDef.getDefaultValue() != null) {
                    vo.DefaultValue = userDef.getDefaultValue();
                }
                if (userDef.getSortNo() > 0) {
                    vo.SortNo = userDef.getSortNo();
                }
                if (userDef.getIsDisplayed() != null) {
                    vo.IsDisplayed = "Y".equals(userDef.getIsDisplayed());
                }
                if (userDef.getIsReadOnly() != null) {
                    vo.IsReadOnly = "Y".equals(userDef.getIsReadOnly());
                }
                if (userDef.getIsSameLine() != null) {
                    vo.IsSameLine = "Y".equals(userDef.getIsSameLine());
                }
                if (userDef.getIsUpdateable() != null) {
                    vo.IsUpdateable = "Y".equals(userDef.getIsUpdateable());
                }
                if (userDef.getIsAlwaysUpdateable() != null) {
                    vo.IsAlwaysUpdateable = "Y".equals(userDef.getIsAlwaysUpdateable());
                }
                if (userDef.getReadOnlyLogic() != null) {
                    vo.ReadOnlyLogic = userDef.getReadOnlyLogic();
                }
                if (userDef.getMandatoryLogic() != null) {
                    vo.MandatoryLogic = userDef.getMandatoryLogic();
                }
                if (userDef.getAD_Reference_ID() > 0) {
                    vo.displayType = userDef.getAD_Reference_ID();
                }
                if (userDef.getAD_Reference_Value_ID() > 0) {
                    vo.AD_Reference_Value_ID = userDef.getAD_Reference_Value_ID();
                }
                if (userDef.getIsMandatory() != null) {
                    vo.IsMandatory = "Y".equals(userDef.getIsMandatory());
                }
                if (userDef.getXPosition() > 0) {
                    vo.XPosition = userDef.getXPosition();
                }
                if (userDef.getColumnSpan() > 0) {
                    vo.ColumnSpan = userDef.getColumnSpan();
                }
                if (userDef.getNumLines() > 0) {
                    vo.NumLines = userDef.getNumLines();
                }
                if (userDef.getIsToolbarButton() != null) {
                    vo.IsToolbarButton = userDef.getIsToolbarButton();
                }
                if (userDef.getVFormat() != null) {
                    vo.VFormat = userDef.getVFormat();
                }
                if (userDef.getSeqNo() > 0) {
                    vo.SeqNo = userDef.getSeqNo();
                }
                if (userDef.getAD_Val_Rule_ID() > 0) {
                    vo.ValidationCode = MValRule.get(ctx, userDef.getAD_Val_Rule_ID()).getCode();
                }
                if (userDef.getAD_LabelStyle_ID() > 0) {
                    vo.AD_LabelStyle_ID = userDef.getAD_LabelStyle_ID();
                }
                if (userDef.getAD_FieldStyle_ID() > 0) {
                    vo.AD_FieldStyle_ID = userDef.getAD_FieldStyle_ID();
                }
                if (userDef.getPA_DashboardContent_ID() > 0) {
                    vo.PA_DashboardContent_ID = userDef.getPA_DashboardContent_ID();
                }
                if (userDef.getPlaceholder() != null) {
                    vo.Placeholder = userDef.getPlaceholder();
                }
            }
        }
        vo.initFinish();
        return vo;
    }

    public static GridFieldVO createParameter(Properties ctx, int WindowNo, int ProcessIDOfPanel, int WindowIDOfPanel, int adInfoPaneId, ResultSet rs) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, 0, 0, 0, false);
        vo.isProcess = true;
        vo.IsDisplayed = true;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.AD_Process_ID_Of_Panel = ProcessIDOfPanel;
        vo.AD_Window_ID_Of_Panel = WindowIDOfPanel;
        vo.AD_Infowindow_ID = adInfoPaneId;
        try {
            vo.AD_Table_ID = 0;
            vo.AD_Column_ID = rs.getInt("AD_Process_Para_ID");
            vo.ColumnName = rs.getString("ColumnName");
            vo.Header = rs.getString("Name");
            vo.Description = rs.getString("Description");
            vo.Help = rs.getString("Help");
            vo.displayType = rs.getInt("AD_Reference_ID");
            vo.IsMandatory = rs.getString("IsMandatory").equals("Y");
            vo.DisplayLength = vo.FieldLength = rs.getInt("FieldLength");
            vo.DefaultValue = rs.getString("DefaultValue");
            vo.DefaultValue2 = rs.getString("DefaultValue2");
            vo.VFormat = rs.getString("VFormat");
            vo.FormatPattern = rs.getString("FormatPattern");
            vo.ValueMin = rs.getString("ValueMin");
            vo.ValueMax = rs.getString("ValueMax");
            vo.isRange = rs.getString("IsRange").equals("Y");
            vo.AD_Reference_Value_ID = rs.getInt("AD_Reference_Value_ID");
            vo.ValidationCode = rs.getString("ValidationCode");
            vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
            vo.DisplayLogic = rs.getString("DisplayLogic");
            vo.IsEncryptedField = rs.getString("IsEncrypted").equals("Y");
            vo.MandatoryLogic = rs.getString("MandatoryLogic");
            vo.Placeholder = rs.getString("Placeholder");
            vo.Placeholder2 = rs.getString("Placeholder2");
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "createParameter", e);
        }
        vo.initFinish();
        if (vo.DefaultValue2 == null) {
            vo.DefaultValue2 = "";
        }
        if (vo.Placeholder2 == null) {
            vo.Placeholder2 = "";
        }
        return vo;
    }

    public static GridFieldVO createParameter(GridFieldVO voF) {
        GridFieldVO voT = new GridFieldVO(voF.ctx, voF.WindowNo, voF.TabNo, voF.AD_Window_ID, voF.AD_Tab_ID, voF.tabReadOnly);
        voT.isProcess = true;
        voT.IsDisplayed = true;
        voT.IsReadOnly = false;
        voT.IsUpdateable = true;
        voT.AD_Table_ID = voF.AD_Table_ID;
        voT.AD_Column_ID = voF.AD_Column_ID;
        voT.ColumnName = voF.ColumnName;
        voT.Header = voF.Header;
        voT.Description = voF.Description;
        voT.Help = voF.Help;
        voT.displayType = voF.displayType;
        voT.IsMandatory = voF.IsMandatory;
        voT.FieldLength = voF.FieldLength;
        voT.DisplayLength = voF.FieldLength;
        voT.DefaultValue = voF.DefaultValue2;
        voT.Placeholder2 = voF.Placeholder2;
        voT.VFormat = voF.VFormat;
        voT.FormatPattern = voF.FormatPattern;
        voT.ValueMin = voF.ValueMin;
        voT.ValueMax = voF.ValueMax;
        voT.isRange = voF.isRange;
        voT.AD_Reference_Value_ID = voF.AD_Reference_Value_ID;
        voT.ValidationCode = voF.ValidationCode;
        voT.IsEncryptedField = voF.IsEncryptedField;
        voT.ReadOnlyLogic = voF.ReadOnlyLogic;
        voT.DisplayLogic = voF.DisplayLogic;
        voT.AD_Process_ID_Of_Panel = voF.AD_Process_ID_Of_Panel;
        voT.initFinish();
        return voT;
    }

    public static GridFieldVO createParameter(Properties ctx, int WindowNo, int WindowIDOfPanel, int infoWindowID, int AD_Column_ID, String ColumnName, String Name2, int AD_Reference_ID, int AD_Reference_Value_ID, boolean IsMandatory, boolean IsEncrypted, String Placeholder) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, 0, 0, 0, false);
        vo.isProcess = true;
        vo.IsDisplayed = true;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.AD_Table_ID = 0;
        vo.AD_Column_ID = AD_Column_ID;
        vo.ColumnName = ColumnName;
        vo.Header = Name2;
        vo.displayType = AD_Reference_ID;
        vo.AD_Reference_Value_ID = AD_Reference_Value_ID;
        vo.IsMandatory = IsMandatory;
        vo.IsEncryptedField = IsEncrypted;
        vo.AD_Infowindow_ID = infoWindowID;
        vo.AD_Window_ID_Of_Panel = WindowIDOfPanel;
        vo.Placeholder = Placeholder;
        vo.initFinish();
        return vo;
    }

    public static GridFieldVO createStdField(Properties ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean tabReadOnly, boolean isCreated, boolean isTimestamp) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, tabReadOnly);
        String string = vo.ColumnName = isCreated ? "Created" : "Updated";
        if (!isTimestamp) {
            vo.ColumnName = String.valueOf(vo.ColumnName) + "By";
        }
        int n = vo.displayType = isTimestamp ? 16 : 18;
        if (!isTimestamp) {
            vo.AD_Reference_Value_ID = 110;
        }
        vo.IsDisplayed = false;
        vo.IsMandatory = false;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.initFinish();
        return vo;
    }

    private GridFieldVO(Properties Ctx, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
        this.TabNo = tabNo;
        this.AD_Window_ID = ad_Window_ID;
        this.AD_Tab_ID = ad_Tab_ID;
        this.tabReadOnly = TabReadOnly;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        if (this.lookupInfo != null) {
            this.lookupInfo.ctx = newCtx;
        }
    }

    protected void initFinish() {
        if (this.DisplayLogic == null) {
            this.DisplayLogic = "";
        }
        if (this.DefaultValue == null) {
            this.DefaultValue = "";
        }
        if (this.FieldGroup == null) {
            this.FieldGroup = "";
        }
        if (this.FieldGroupType == null) {
            this.FieldGroupType = "";
        }
        if (this.Description == null) {
            this.Description = "";
        }
        if (this.Help == null) {
            this.Help = "";
        }
        if (this.Callout == null) {
            this.Callout = "";
        }
        if (this.ReadOnlyLogic == null) {
            this.ReadOnlyLogic = "";
        }
        if (this.MandatoryLogic == null) {
            this.MandatoryLogic = "";
        }
        if (this.Placeholder == null) {
            this.Placeholder = "";
        }
        if (DisplayType.isLookup(this.displayType) && this.IsDisplayed) {
            this.loadLookupInfo();
        }
    }

    public void loadLookupInfo() {
        try {
            this.lookupInfo = MLookupFactory.getLookupInfo(this.ctx, this.WindowNo, this.TabNo, this.AD_Column_ID, this.displayType, Env.getLanguage(this.ctx), this.ColumnName, this.AD_Reference_Value_ID, this.IsParent, this.ValidationCode);
            if (this.lookupInfo == null) {
                this.displayType = 13;
            }
        }
        catch (Exception e) {
            CLogger.get().log(Level.SEVERE, "No LookupInfo for " + this.ColumnName, e);
            this.displayType = 13;
        }
    }

    public GridFieldVO clone(Properties Ctx, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        GridFieldVO clone = new GridFieldVO(Ctx, windowNo, tabNo, ad_Window_ID, ad_Tab_ID, TabReadOnly);
        clone.isProcess = false;
        clone.ColumnName = this.ColumnName;
        clone.ColumnSQL = this.ColumnSQL;
        clone.Header = this.Header;
        clone.displayType = this.displayType;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.DisplayLength = this.DisplayLength;
        clone.IsSameLine = this.IsSameLine;
        clone.IsDisplayed = this.IsDisplayed;
        clone.IsDisplayedGrid = this.IsDisplayedGrid;
        clone.AD_Field_ID = this.AD_Field_ID;
        clone.SeqNo = this.SeqNo;
        clone.SeqNoGrid = this.SeqNoGrid;
        clone.DisplayLogic = this.DisplayLogic;
        clone.DefaultValue = this.DefaultValue;
        clone.IsMandatory = this.IsMandatory;
        clone.IsReadOnly = this.IsReadOnly;
        clone.AD_Chart_ID = this.AD_Chart_ID;
        clone.IsUpdateable = this.IsUpdateable;
        clone.IsAlwaysUpdateable = this.IsAlwaysUpdateable;
        clone.IsHeading = this.IsHeading;
        clone.IsFieldOnly = this.IsFieldOnly;
        clone.IsEncryptedField = this.IsEncryptedField;
        clone.IsEncryptedColumn = this.IsEncryptedColumn;
        clone.IsSelectionColumn = this.IsSelectionColumn;
        clone.SeqNoSelection = this.SeqNoSelection;
        clone.IsAutocomplete = this.IsAutocomplete;
        clone.IsAllowCopy = this.IsAllowCopy;
        clone.SortNo = this.SortNo;
        clone.FieldLength = this.FieldLength;
        clone.VFormat = this.VFormat;
        clone.FormatPattern = this.FormatPattern;
        clone.ValueMin = this.ValueMin;
        clone.ValueMax = this.ValueMax;
        clone.FieldGroup = this.FieldGroup;
        clone.FieldGroupType = this.FieldGroupType;
        clone.IsKey = this.IsKey;
        clone.IsParent = this.IsParent;
        clone.Callout = this.Callout;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.MandatoryLogic = this.MandatoryLogic;
        clone.ObscureType = this.ObscureType;
        clone.IsDefaultFocus = this.IsDefaultFocus;
        clone.AD_FieldStyle_ID = this.AD_FieldStyle_ID;
        clone.AD_LabelStyle_ID = this.AD_LabelStyle_ID;
        clone.PA_DashboardContent_ID = this.PA_DashboardContent_ID;
        clone.Placeholder = this.Placeholder;
        clone.IsHtml = this.IsHtml;
        clone.ValidationCode = this.ValidationCode;
        clone.AD_Reference_Value_ID = this.AD_Reference_Value_ID;
        clone.lookupInfo = this.lookupInfo;
        clone.isRange = this.isRange;
        clone.DefaultValue2 = this.DefaultValue2;
        clone.Placeholder2 = this.Placeholder2;
        clone.AD_Process_ID_Of_Panel = this.AD_Process_ID_Of_Panel;
        clone.AD_Window_ID_Of_Panel = this.AD_Window_ID_Of_Panel;
        clone.AD_Infowindow_ID = this.AD_Infowindow_ID;
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MFieldVO[");
        sb.append(this.AD_Column_ID).append("-").append(this.ColumnName).append("]");
        return sb.toString();
    }

    public static class SeqNoComparator
    implements Comparator<GridFieldVO> {
        @Override
        public int compare(GridFieldVO gf1, GridFieldVO gf2) {
            return Integer.valueOf(gf1.SeqNo).compareTo(gf2.SeqNo);
        }
    }
}

