/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.EventObject;
import org.idempiere.fa.util.Util;

public final class DataStatusEvent
extends EventObject
implements Serializable {
    private static final long serialVersionUID = -1988674163839245029L;
    private int m_totalRows;
    private boolean m_changed;
    private boolean m_autoSave;
    private boolean m_inserting;
    private String m_AD_Message = null;
    private String m_info = null;
    private boolean m_isError = false;
    private boolean m_isWarning = false;
    private boolean m_confirmed = false;
    private boolean m_allLoaded = true;
    private int m_loadedRows = -1;
    private int m_currentRow = -1;
    private int m_changedColumn = -1;
    private String m_columnName = null;
    private boolean isInitEdit = false;
    public Timestamp Created = null;
    public Integer CreatedBy = null;
    public Timestamp Updated = null;
    public Integer UpdatedBy = null;
    public String Info = null;
    public int AD_Table_ID = 0;
    public Object Record_ID = null;

    public DataStatusEvent(Object source1, int totalRows, boolean changed, boolean autoSave, boolean inserting) {
        super(source1);
        this.m_totalRows = totalRows;
        this.m_changed = changed;
        this.m_autoSave = autoSave;
        this.m_inserting = inserting;
    }

    public void setLoading(int loadedRows) {
        this.m_allLoaded = false;
        this.m_loadedRows = loadedRows;
    }

    public boolean isLoading() {
        return !this.m_allLoaded;
    }

    public int getLoadedRows() {
        return this.m_loadedRows;
    }

    public void setCurrentRow(int currentRow) {
        this.m_currentRow = currentRow;
    }

    public int getCurrentRow() {
        return this.m_currentRow;
    }

    public int getTotalRows() {
        return this.m_totalRows;
    }

    public void setInfo(String AD_Message, String info, boolean isError, boolean isWarning) {
        this.m_AD_Message = AD_Message;
        this.m_info = info;
        this.m_isError = isError;
        this.m_isWarning = isWarning;
    }

    public void setInserting(boolean inserting) {
        this.m_inserting = inserting;
    }

    public boolean isInserting() {
        return this.m_inserting;
    }

    public String getAD_Message() {
        return this.m_AD_Message;
    }

    public String getInfo() {
        return this.m_info;
    }

    public boolean isError() {
        return this.m_isError;
    }

    public boolean isWarning() {
        return this.m_isWarning;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DataStatusEvent - ");
        if (this.m_AD_Message != null) {
            sb.append(this.m_AD_Message);
        }
        if (this.m_info != null) {
            sb.append(" ").append(this.m_info);
        }
        sb.append(" : ").append(this.getMessage());
        return sb.toString();
    }

    public String getMessage() {
        StringBuilder retValue = new StringBuilder();
        if (this.m_inserting) {
            retValue.append("+");
        }
        retValue.append(this.m_changed ? (this.m_autoSave ? "*" : "?") : " ");
        if (this.m_totalRows == 0) {
            retValue.append(this.m_currentRow);
        } else {
            retValue.append(this.m_currentRow + 1);
        }
        retValue.append("/");
        if (this.m_allLoaded) {
            retValue.append(this.m_totalRows);
        } else {
            retValue.append(this.m_loadedRows).append("->").append(this.m_totalRows);
        }
        return retValue.toString();
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public boolean isFirstRow() {
        if (this.m_totalRows == 0) {
            return true;
        }
        return this.m_currentRow == 0;
    }

    public boolean isLastRow() {
        if (this.m_totalRows == 0) {
            return true;
        }
        return this.m_currentRow == this.m_totalRows - 1;
    }

    public void setChangedColumn(int col, String columnName) {
        this.m_changedColumn = col;
        this.m_columnName = columnName;
    }

    public int getChangedColumn() {
        return this.m_changedColumn;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setConfirmed(boolean confirmed) {
        this.m_confirmed = confirmed;
    }

    public boolean isConfirmed() {
        return this.m_confirmed;
    }

    public boolean isEqual(DataStatusEvent e) {
        if (e == null) {
            return false;
        }
        return e.m_changed == this.m_changed && e.m_inserting == this.m_inserting && e.m_isError == this.m_isError && e.m_isWarning == this.m_isWarning && Util.equals(e.m_AD_Message, this.m_AD_Message) && e.m_changedColumn == this.m_changedColumn && Util.equals(e.m_columnName, this.m_columnName) && e.m_currentRow == this.m_currentRow;
    }

    public boolean isInitEdit() {
        return this.isInitEdit;
    }

    public void setIsInitEdit(boolean isInitEdit) {
        this.isInitEdit = isInitEdit;
    }
}

