/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.IArchiveStore;
import org.compiere.model.MArchive;
import org.compiere.model.MStorageProvider;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ArchiveFileSystem
implements IArchiveStore {
    private String ARCHIVE_FOLDER_PLACEHOLDER = "%ARCHIVE_FOLDER%";
    private final CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    public byte[] loadLOBData(MArchive archive, MStorageProvider prov) {
        Node fileNode;
        String archivePathRoot;
        block17: {
            Node entryNode;
            NamedNodeMap attributes;
            archivePathRoot = this.getArchivePathRoot(prov);
            if ("".equals(archivePathRoot)) {
                throw new IllegalArgumentException("no attachmentPath defined");
            }
            byte[] data = archive.getByteData();
            if (data == null) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data));
            NodeList entries = document.getElementsByTagName("entry");
            if (entries.getLength() != 1) {
                this.log.severe("no archive entry found");
            }
            if ((fileNode = (attributes = (entryNode = entries.item(0)).getAttributes()).getNamedItem("file")) != null) break block17;
            this.log.severe("no filename for entry");
            return null;
        }
        try {
            File file;
            String filePath = fileNode.getNodeValue();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("filePath: " + filePath);
            }
            if (filePath != null) {
                filePath = filePath.replaceFirst(this.ARCHIVE_FOLDER_PLACEHOLDER, archivePathRoot.replaceAll("\\\\", "\\\\\\\\"));
                String replaceSeparator = File.separator;
                if (!replaceSeparator.equals("/")) {
                    replaceSeparator = "\\\\";
                }
                filePath = filePath.replaceAll("/", replaceSeparator);
                filePath = filePath.replaceAll("\\\\", replaceSeparator);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("filePath: " + filePath);
            }
            if ((file = new File(filePath)).exists()) {
                byte[] dataEntry = new byte[(int)file.length()];
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    fileInputStream.read(dataEntry);
                    fileInputStream.close();
                }
                catch (FileNotFoundException e) {
                    this.log.severe("File Not Found.");
                    e.printStackTrace();
                }
                catch (IOException e1) {
                    this.log.severe("Error Reading The File.");
                    e1.printStackTrace();
                }
                return dataEntry;
            }
            this.log.severe("file not found: " + file.getAbsolutePath());
            return null;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            this.log.severe(x.getMessage());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            this.log.severe(pce.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.log.severe(ioe.getMessage());
        }
        return null;
    }

    @Override
    public void save(MArchive archive, MStorageProvider prov, byte[] inflatedData) {
        block18: {
            String archivePathRoot = this.getArchivePathRoot(prov);
            if ("".equals(archivePathRoot)) {
                throw new IllegalArgumentException("no attachmentPath defined");
            }
            if (inflatedData == null || inflatedData.length == 0) {
                throw new IllegalArgumentException("InflatedData is NULL");
            }
            if (archive.get_ID() == 0) {
                archive.setByteData(new byte[]{48});
                if (!archive.save()) {
                    throw new IllegalArgumentException("unable to save MArchive");
                }
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            FilterOutputStream out = null;
            try {
                try {
                    StringBuilder msgfile = new StringBuilder().append(archivePathRoot).append(archive.getArchivePathSnippet());
                    File destFolder = new File(msgfile.toString());
                    if (!destFolder.exists() && !destFolder.mkdirs()) {
                        this.log.warning("unable to create folder: " + destFolder.getPath());
                    }
                    msgfile = new StringBuilder().append(archivePathRoot).append(File.separator).append(archive.getArchivePathSnippet()).append(archive.get_ID()).append(".pdf");
                    File destFile = new File(msgfile.toString());
                    out = new BufferedOutputStream(new FileOutputStream(destFile));
                    out.write(inflatedData);
                    ((BufferedOutputStream)out).flush();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.newDocument();
                    Element root = document.createElement("archive");
                    document.appendChild(root);
                    document.setXmlStandalone(true);
                    Element entry = document.createElement("entry");
                    StringBuilder msgsat = new StringBuilder(this.ARCHIVE_FOLDER_PLACEHOLDER).append(archive.getArchivePathSnippet()).append(archive.get_ID()).append(".pdf");
                    entry.setAttribute("file", msgsat.toString());
                    root.appendChild(entry);
                    DOMSource source = new DOMSource(document);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    StreamResult result = new StreamResult(bos);
                    Transformer xformer = TransformerFactory.newInstance().newTransformer();
                    xformer.transform(source, result);
                    byte[] xmlData = bos.toByteArray();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(bos.toString());
                    }
                    archive.setByteData(xmlData);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "saveLOBData", e);
                    archive.setByteData(null);
                    if (out == null) break block18;
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private String getArchivePathRoot(MStorageProvider prov) {
        String archivePathRoot = prov.getFolder();
        if (archivePathRoot == null) {
            archivePathRoot = "";
        }
        if (Util.isEmpty(archivePathRoot)) {
            this.log.severe("no archivePath defined");
        } else if (!archivePathRoot.endsWith(File.separator)) {
            archivePathRoot = String.valueOf(archivePathRoot) + File.separator;
            this.log.fine(archivePathRoot);
        }
        return archivePathRoot;
    }

    @Override
    public boolean deleteArchive(MArchive archive, MStorageProvider prov) {
        String archivePathRoot = this.getArchivePathRoot(prov);
        if ("".equals(archivePathRoot)) {
            throw new IllegalArgumentException("no attachmentPath defined");
        }
        StringBuilder msgfile = new StringBuilder().append(archivePathRoot).append(archive.getArchivePathSnippet()).append(archive.get_ID()).append(".pdf");
        File file = new File(msgfile.toString());
        if (file != null && file.exists() && !file.delete()) {
            this.log.warning("unable to delete " + file.getAbsolutePath());
            return false;
        }
        return true;
    }
}

