/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.compiere.model.IArchiveStore;
import org.compiere.model.MArchive;
import org.compiere.model.MStorageProvider;
import org.compiere.util.CLogger;

public class ArchiveDB
implements IArchiveStore {
    private final CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    public byte[] loadLOBData(MArchive archive, MStorageProvider prov) {
        byte[] deflatedData = archive.getByteData();
        if (deflatedData == null) {
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("ZipSize=" + deflatedData.length);
        }
        if (deflatedData.length == 0) {
            return null;
        }
        byte[] inflatedData = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(deflatedData);
            ZipInputStream zip = new ZipInputStream(in);
            ZipEntry entry = zip.getNextEntry();
            if (entry != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = zip.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = zip.read(buffer);
                }
                inflatedData = out.toByteArray();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Size=" + inflatedData.length + " - zip=" + entry.getCompressedSize() + "(" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            inflatedData = null;
        }
        return inflatedData;
    }

    @Override
    public void save(MArchive archive, MStorageProvider prov, byte[] inflatedData) {
        if (inflatedData == null || inflatedData.length == 0) {
            throw new IllegalArgumentException("InflatedData is NULL");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        zip.setComment("idempiere");
        byte[] deflatedData = null;
        try {
            ZipEntry entry = new ZipEntry("IdempiereArchive");
            entry.setTime(System.currentTimeMillis());
            entry.setMethod(8);
            zip.putNextEntry(entry);
            zip.write(inflatedData, 0, inflatedData.length);
            zip.closeEntry();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(entry.getCompressedSize()) + " (" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
            }
            zip.close();
            deflatedData = out.toByteArray();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Length=" + inflatedData.length);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            deflatedData = null;
        }
        archive.setByteData(deflatedData);
    }

    @Override
    public boolean deleteArchive(MArchive archive, MStorageProvider prov) {
        return true;
    }
}

