/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.interfaces.impl;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.ProcessUtil;
import org.compiere.acct.Doc;
import org.compiere.interfaces.Server;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MTask;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.EMail;
import org.compiere.util.Env;

public class ServerBean
implements Server {
    private static CLogger log = CLogger.getCLogger(ServerBean.class);

    @Override
    public String postImmediate(Properties ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Table=" + AD_Table_ID + ", Record=" + Record_ID);
        }
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID);
        return Doc.postImmediate(ass, AD_Table_ID, Record_ID, force, null);
    }

    @Override
    public ProcessInfo process(Properties ctx, ProcessInfo pi) {
        ProcessUtil.startJavaProcess(ctx, pi, null);
        return pi;
    }

    @Override
    public ProcessInfo workflow(Properties ctx, ProcessInfo pi, int AD_Workflow_ID) {
        if (log.isLoggable(Level.INFO)) {
            log.info("AD_Workflow_ID=" + AD_Workflow_ID);
        }
        ProcessUtil.startWorkFlow(ctx, pi, AD_Workflow_ID);
        return pi;
    }

    @Override
    public String executeTask(Properties ctx, int AD_Task_ID) {
        MTask task = new MTask(Env.getCtx(), AD_Task_ID, null);
        return task.execute();
    }

    @Override
    public int cacheReset(Properties ctx, String tableName, int Record_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(tableName) + " - " + Record_ID);
        }
        return CacheMgt.get().reset(tableName, Record_ID);
    }

    @Override
    public ProcessInfo dbProcess(Properties ctx, ProcessInfo processInfo, String procedureName) {
        ProcessUtil.startDatabaseProcedure(processInfo, procedureName, null);
        return processInfo;
    }

    @Override
    public String sendEMail(Properties ctx, EMail email) {
        return email.send();
    }
}

