/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.compiere.impexp.OFX1ToXML;
import org.compiere.model.MBankStatementLoader;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class OFXBankStatementHandler
extends DefaultHandler {
    protected MBankStatementLoader m_controller;
    protected StringBuffer m_errorMessage;
    protected StringBuffer m_errorDescription;
    protected BufferedReader m_reader = null;
    protected SAXParser m_parser;
    protected boolean m_success = false;
    protected StatementLine m_line;
    protected String m_routingNo = "0";
    protected String m_bankAccountNo = null;
    protected String m_currency = null;
    protected int HEADER_SIZE = 20;
    protected boolean m_test = false;
    protected Timestamp m_dateLastRun = null;
    protected Timestamp m_statementDate = null;
    StringBuffer m_valueBuffer = new StringBuffer();
    public static final String XML_OFX_TAG = "OFX";
    public static final String XML_SIGNONMSGSRSV2_TAG = "SIGNONMSGSRSV2";
    public static final String XML_SIGNONMSGSRSV1_TAG = "SIGNONMSGSRSV1";
    public static final String XML_SONRS_TAG = "SONRS";
    public static final String XML_DTSERVER_TAG = "DTSERVER";
    public static final String XML_USERKEY_TAG = "USERKEY";
    public static final String XML_TSKEYEXPIRE_TAG = "TSKEYEXPIRE";
    public static final String XML_LANGUAGE_TAG = "LANGUAGE";
    public static final String XML_DTPROFUP_TAG = "DTPROFUP";
    public static final String XML_STATUS_TAG = "STATUS";
    public static final String XML_STMTRS_TAG = "STMTRS";
    public static final String XML_CURDEF_TAG = "CURDEF";
    public static final String XML_BANKACCTFROM_TAG = "BANKACCTFROM";
    public static final String XML_BANKID_TAG = "BANKID";
    public static final String XML_BRANCHID_TAG = "BRANCHID";
    public static final String XML_ACCTID_TAG = "ACCTID";
    public static final String XML_ACCTTYPE_TAG = "ACCTTYPE";
    public static final String XML_ACCTTYPE2_TAG = "ACCTTYPE2";
    public static final String XML_ACCTKEY_TAG = "ACCTKEY";
    public static final String XML_BANKTRANLIST_TAG = "BANKTRANLIST";
    public static final String XML_DTSTART_TAG = "DTSTART";
    public static final String XML_DTEND_TAG = "DTEND";
    public static final String XML_STMTTRN_TAG = "STMTTRN";
    public static final String XML_TRNTYPE_TAG = "TRNTYPE";
    public static final String XML_TRNAMT_TAG = "TRNAMT";
    public static final String XML_DTPOSTED_TAG = "DTPOSTED";
    public static final String XML_DTAVAIL_TAG = "DTAVAIL";
    public static final String XML_FITID_TAG = "FITID";
    public static final String XML_CHECKNUM_TAG = "CHECKNUM";
    public static final String XML_CHKNUM_TAG = "CHKNUM";
    public static final String XML_REFNUM_TAG = "REFNUM";
    public static final String XML_MEMO_TAG = "MEMO";
    public static final String XML_NAME_TAG = "NAME";
    public static final String XML_PAYEEID_TAG = "PAYEEID";
    public static final String XML_PAYEE_TAG = "PAYEE";
    public static final String XML_LEDGERBAL_TAG = "LEDGERBAL";
    public static final String XML_BALAMT_TAG = "BALAMT";
    public static final String XML_DTASOF_TAG = "DTASOF";
    public static final String XML_AVAILBAL_TAG = "AVAILBAL";
    public static final String XML_MKTGINFO_TAG = "MKTGINFO";
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final int DATE_FORMAT_LENGTH = "yyyyMMddHHmmss.SSS".length();
    public static final int TIME_FORMAT_LENGTH = "HHmmss.SSS".length();

    protected boolean init(MBankStatementLoader controller) {
        boolean result = false;
        if (controller == null) {
            this.m_errorMessage = new StringBuffer("ErrorInitializingParser");
            this.m_errorDescription = new StringBuffer("ImportController is a null reference");
            return result;
        }
        this.m_controller = controller;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.m_parser = factory.newSAXParser();
            result = true;
        }
        catch (ParserConfigurationException e) {
            this.m_errorMessage = new StringBuffer("ErrorInitializingParser");
            this.m_errorDescription = new StringBuffer("Unable to configure SAX parser: ").append(e.getMessage());
        }
        catch (SAXException e) {
            this.m_errorMessage = new StringBuffer("ErrorInitializingParser");
            this.m_errorDescription = new StringBuffer("Unable to initialize SAX parser: ").append(e.getMessage());
        }
        if (!result) {
            this.closeBufferedReader();
        }
        return result;
    }

    protected boolean attachInput(InputStream is) {
        boolean isOfx1 = true;
        boolean result = false;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            reader.mark(this.HEADER_SIZE + 20000);
            StringBuilder header = new StringBuilder();
            int i = 0;
            while (i < this.HEADER_SIZE) {
                header.append(reader.readLine());
                ++i;
            }
            isOfx1 = header.indexOf("<?OFX") != -1 || header.indexOf("<?ofx") != -1 ? false : header.indexOf("<?XML") == -1 && header.indexOf("<?xml") == -1;
            reader.reset();
            this.m_reader = isOfx1 ? new BufferedReader(new InputStreamReader(new OFX1ToXML(reader))) : reader;
            result = true;
        }
        catch (IOException e) {
            this.m_errorMessage = new StringBuffer("ErrorReadingData");
            this.m_errorDescription = new StringBuffer(e.getMessage());
            this.closeBufferedReader();
            return result;
        }
        return result;
    }

    public boolean isValid() {
        boolean result = true;
        return result;
    }

    public boolean importSuccessfull() {
        return this.m_success;
    }

    public boolean loadLines() {
        boolean result = false;
        try {
            try {
                this.m_parser.parse(new InputSource(this.m_reader), (DefaultHandler)this);
                result = true;
                this.m_success = true;
            }
            catch (SAXException e) {
                this.m_errorMessage = new StringBuffer("ErrorParsingData");
                this.m_errorDescription = new StringBuffer(e.getMessage());
                this.closeBufferedReader();
            }
            catch (IOException e) {
                this.m_errorMessage = new StringBuffer("ErrorReadingData");
                this.m_errorDescription = new StringBuffer(e.getMessage());
                this.closeBufferedReader();
            }
        }
        finally {
            this.closeBufferedReader();
        }
        return result;
    }

    private void closeBufferedReader() {
        if (this.m_reader != null) {
            try {
                this.m_reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Timestamp getDateLastRun() {
        return this.m_dateLastRun;
    }

    public String getRoutingNo() {
        return this.m_line.routingNo;
    }

    public String getBankAccountNo() {
        return this.m_line.bankAccountNo;
    }

    public String getIBAN() {
        return null;
    }

    public String getStatementReference() {
        return this.m_line.statementReference;
    }

    public Timestamp getStatementDate() {
        return this.m_statementDate;
    }

    public String getReference() {
        return this.m_line.reference;
    }

    public Timestamp getStatementLineDate() {
        return this.m_line.statementLineDate;
    }

    public Timestamp getValutaDate() {
        return this.m_line.valutaDate;
    }

    public String getTrxType() {
        return this.m_line.trxType;
    }

    public boolean getIsReversal() {
        return this.m_line.isReversal;
    }

    public String getCurrency() {
        return this.m_line.currency;
    }

    public BigDecimal getStmtAmt() {
        return this.m_line.stmtAmt;
    }

    public BigDecimal getTrxAmt() {
        return this.m_line.stmtAmt;
    }

    public BigDecimal getInterestAmt() {
        return Env.ZERO;
    }

    public String getMemo() {
        return this.m_line.memo;
    }

    public String getChargeName() {
        return this.m_line.chargeName;
    }

    public BigDecimal getChargeAmt() {
        return this.m_line.chargeAmt;
    }

    public String getTrxID() {
        return this.m_line.trxID;
    }

    public String getPayeeAccountNo() {
        return this.m_line.payeeAccountNo;
    }

    public String getPayeeName() {
        return this.m_line.payeeName;
    }

    public String getCheckNo() {
        return this.m_line.checkNo;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean validOFX = true;
        if (!validOFX) {
            this.m_errorDescription = new StringBuffer("Invalid OFX syntax: ").append(qName);
            throw new SAXException("Invalid OFX syntax: " + qName);
        }
        if (qName.equals(XML_STMTTRN_TAG)) {
            this.m_line = new StatementLine(this.m_routingNo, this.m_bankAccountNo, this.m_currency);
        }
        this.m_valueBuffer = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_valueBuffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String XML_TAG = qName;
        String value = this.m_valueBuffer.toString();
        try {
            if (XML_TAG.equals(XML_CURDEF_TAG)) {
                this.m_currency = value;
            } else if (XML_TAG.equals(XML_BANKID_TAG)) {
                this.m_routingNo = value;
            } else if (XML_TAG.equals(XML_ACCTID_TAG)) {
                this.m_bankAccountNo = value;
            } else if (XML_TAG.equals(XML_DTEND_TAG)) {
                this.m_dateLastRun = this.parseOfxDate(value);
            } else if (XML_TAG.equals(XML_DTASOF_TAG)) {
                this.m_statementDate = this.parseOfxDate(value);
            } else if (XML_TAG.equals(XML_TRNTYPE_TAG)) {
                this.m_line.trxType = value;
            } else if (XML_TAG.equals(XML_DTPOSTED_TAG)) {
                this.m_line.statementLineDate = this.parseOfxDate(value);
            } else if (XML_TAG.equals(XML_DTAVAIL_TAG)) {
                this.m_line.valutaDate = this.parseOfxDate(value);
            } else if (XML_TAG.equals(XML_TRNAMT_TAG)) {
                this.m_line.stmtAmt = new BigDecimal(value);
            } else if (XML_TAG.equals(XML_FITID_TAG)) {
                this.m_line.trxID = value;
            } else if (XML_TAG.equals(XML_CHECKNUM_TAG) || XML_TAG.equals(XML_CHKNUM_TAG)) {
                this.m_line.checkNo = value;
            } else if (XML_TAG.equals(XML_REFNUM_TAG)) {
                this.m_line.reference = value;
            } else if (XML_TAG.equals(XML_MEMO_TAG)) {
                this.m_line.memo = value;
            } else if (XML_TAG.equals(XML_NAME_TAG)) {
                this.m_line.payeeName = value;
            }
        }
        catch (Exception e) {
            this.m_errorDescription = new StringBuffer("Invalid data: ").append(value).append(" <-> ").append(e.getMessage());
            throw new SAXException("Invalid data: " + value);
        }
        if (qName.equals(XML_STMTTRN_TAG) && !this.m_test && !this.m_controller.saveLine()) {
            this.m_errorMessage = new StringBuffer().append(this.m_controller.getErrorMessage());
            this.m_errorDescription = new StringBuffer(this.m_controller.getErrorDescription());
            throw new SAXException(this.m_errorMessage.toString());
        }
    }

    protected TimeZone parseTimeZone(String tzoffset) {
        StringTokenizer tokenizer = new StringTokenizer(tzoffset, "[]:");
        TimeZone tz = GMT_TIME_ZONE;
        if (tokenizer.hasMoreTokens()) {
            String hoursOff = tokenizer.nextToken();
            tz = TimeZone.getTimeZone("GMT" + hoursOff);
        }
        return tz;
    }

    protected Date parseDate(String value) {
        char[] parseableDate = new char[DATE_FORMAT_LENGTH];
        Arrays.fill(parseableDate, '0');
        parseableDate[parseableDate.length - 4] = 46;
        char[] valueChars = value.toCharArray();
        int index = 0;
        while (index < valueChars.length && valueChars[index] != '[') {
            if (index < DATE_FORMAT_LENGTH) {
                parseableDate[index] = valueChars[index];
            }
            ++index;
        }
        int year = Integer.parseInt(new String(parseableDate, 0, 4));
        int month = Integer.parseInt(new String(parseableDate, 4, 2)) - 1;
        int day = Integer.parseInt(new String(parseableDate, 6, 2));
        int hour = Integer.parseInt(new String(parseableDate, 8, 2));
        int minute = Integer.parseInt(new String(parseableDate, 10, 2));
        int second = Integer.parseInt(new String(parseableDate, 12, 2));
        int milli = Integer.parseInt(new String(parseableDate, 15, 3));
        GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute, second);
        if (index < valueChars.length && valueChars[index] == '[') {
            String tzoffset = value.substring(index);
            calendar.setTimeZone(this.parseTimeZone(tzoffset));
        } else {
            calendar.setTimeZone(GMT_TIME_ZONE);
        }
        calendar.add(14, milli);
        return calendar.getTime();
    }

    private Timestamp parseOfxDate(String value) throws ParseException {
        try {
            return new Timestamp(this.parseDate(value).getTime());
        }
        catch (Exception e) {
            throw new ParseException("Error parsing date: " + value, 0);
        }
    }

    public String getLastErrorMessage() {
        return this.m_errorMessage.toString();
    }

    public String getLastErrorDescription() {
        return this.m_errorDescription.toString();
    }

    static class StatementLine {
        protected String routingNo = null;
        protected String bankAccountNo = null;
        protected String statementReference = null;
        protected Timestamp statementLineDate = null;
        protected String reference = null;
        protected Timestamp valutaDate;
        protected String trxType = null;
        protected boolean isReversal = false;
        protected String currency = null;
        protected BigDecimal stmtAmt = null;
        protected String memo = null;
        protected String chargeName = null;
        protected BigDecimal chargeAmt = null;
        protected String payeeAccountNo = null;
        protected String payeeName = null;
        protected String trxID = null;
        protected String checkNo = null;

        public StatementLine(String RoutingNo, String BankAccountNo, String Currency2) {
            this.bankAccountNo = BankAccountNo;
            this.routingNo = RoutingNo;
            this.currency = Currency2;
        }
    }
}

