/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Callout;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public final class ImpFormatRow {
    private int m_seqNo;
    private String m_columnName;
    private String m_name;
    private int m_startNo = 0;
    private int m_endNo = 0;
    private String m_dataType;
    private String m_dataFormat = "";
    private String m_decimalPoint = ".";
    private boolean m_divideBy100 = false;
    private String m_constantValue = "";
    private boolean m_constantIsString = true;
    private Callout m_callout = null;
    private String m_method = null;
    private SimpleDateFormat m_dformat = null;
    private int m_maxLength = 0;
    private CLogger log = CLogger.getCLogger(this.getClass());

    public ImpFormatRow(int seqNo, String columnName, int startNo, int endNo, String dataType, int maxLength, String name) {
        this.m_seqNo = seqNo;
        this.setColumnName(columnName);
        this.setName(name);
        this.m_startNo = startNo;
        this.m_endNo = endNo;
        this.setDataType(dataType);
        this.setMaxLength(maxLength);
    }

    public ImpFormatRow(int seqNo, String columnName, String dataType, int maxLength) {
        this.m_seqNo = seqNo;
        this.setColumnName(columnName);
        this.setDataType(dataType);
        this.setMaxLength(maxLength);
    }

    public int getSeqNo() {
        return this.m_seqNo;
    }

    public void setSeqNo(int newSeqNo) {
        this.m_seqNo = newSeqNo;
    }

    public void setStartNo(int newStartNo) {
        this.m_startNo = newStartNo;
    }

    public int getStartNo() {
        return this.m_startNo;
    }

    public void setEndNo(int newEndNo) {
        this.m_endNo = newEndNo;
    }

    public int getEndNo() {
        return this.m_endNo;
    }

    public void setColumnName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            throw new IllegalArgumentException("ColumnName must be at least 1 char");
        }
        this.m_columnName = columnName;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be at least 1 char");
        }
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setDataType(String dataType) {
        if (!(dataType.equals("S") || dataType.equals("D") || dataType.equals("N") || dataType.equals("C"))) {
            throw new IllegalArgumentException("DataType must be S/D/N/C");
        }
        this.m_dataType = dataType;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public boolean isString() {
        if (this.m_dataType.equals("C")) {
            return this.m_constantIsString;
        }
        return this.m_dataType.equals("S");
    }

    public boolean isNumber() {
        return this.m_dataType.equals("N");
    }

    public boolean isDate() {
        return this.m_dataType.equals("D");
    }

    public boolean isConstant() {
        return this.m_dataType.equals("C");
    }

    public void setFormatInfo(String dataFormat, String decimalPoint, boolean divideBy100, String constantValue, String callout) {
        this.m_dataFormat = dataFormat == null ? "" : dataFormat;
        this.m_dformat = null;
        this.m_decimalPoint = decimalPoint == null || !decimalPoint.equals(",") ? "." : ",";
        this.m_divideBy100 = divideBy100;
        if (constantValue == null || constantValue.length() == 0 || !this.m_dataType.equals("C")) {
            this.m_constantValue = "";
            this.m_constantIsString = true;
        } else {
            this.m_constantValue = constantValue;
            this.m_constantIsString = false;
            int i = 0;
            while (i < this.m_constantValue.length()) {
                char c = this.m_constantValue.charAt(i);
                if (!Character.isDigit(c) && c != '.') {
                    this.m_constantIsString = true;
                    break;
                }
                ++i;
            }
        }
        if (callout != null) {
            int methodStart = callout.lastIndexOf(46);
            try {
                if (methodStart != -1) {
                    Class<?> cClass = Class.forName(callout.substring(0, methodStart));
                    this.m_callout = (Callout)cClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.m_method = callout.substring(methodStart + 1);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "MTab.setFormatInfo - " + e.toString());
            }
            if (this.m_callout == null || this.m_method == null || this.m_method.length() == 0) {
                this.log.log(Level.SEVERE, "MTab.setFormatInfo - Invalid Callout " + callout);
                this.m_callout = null;
            }
        }
    }

    public String getDataFormat() {
        return this.m_dataFormat;
    }

    public String getDecimalPoint() {
        return this.m_decimalPoint;
    }

    public boolean isDivideBy100() {
        return this.m_divideBy100;
    }

    public String getConstantValue() {
        return this.m_constantValue;
    }

    public void setMaxLength(int maxLength) {
        this.m_maxLength = maxLength;
    }

    public String parse(String info) {
        if (info == null || info.length() == 0) {
            return "";
        }
        if (info.startsWith("[") && info.endsWith("]")) {
            return "";
        }
        String retValue = null;
        retValue = this.isNumber() ? this.parseNumber(info) : (this.isDate() ? this.parseDate(info) : (this.isConstant() ? (this.m_constantIsString ? this.parseString(this.m_constantValue) : this.m_constantValue) : this.parseString(info)));
        if (this.m_callout != null) {
            try {
                retValue = this.m_callout.convert(this.m_method, retValue);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ImpFormatRow.parse - " + info + " (" + retValue + ")", e);
            }
        }
        if (retValue == null) {
            retValue = "";
        }
        return retValue.trim();
    }

    private String parseDate(String info) {
        if (this.m_dformat == null) {
            try {
                if (!Util.isEmpty(this.m_dataFormat)) {
                    this.m_dformat = new SimpleDateFormat(this.m_dataFormat);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ImpFormatRow.parseDate Format=" + this.m_dataFormat, e);
            }
            if (this.m_dformat == null) {
                this.m_dformat = (SimpleDateFormat)DateFormat.getDateInstance();
            }
            this.m_dformat.setLenient(true);
        }
        Timestamp ts = null;
        try {
            ts = new Timestamp(this.m_dformat.parse(info).getTime());
        }
        catch (ParseException pe) {
            String msg = String.valueOf(pe.getLocalizedMessage()) + ": Pattern[" + this.m_dformat.toPattern() + "]  Data[" + info + "]";
            throw new AdempiereException(msg);
        }
        String dateString = ts.toString();
        return dateString.substring(0, dateString.indexOf(46));
    }

    private String parseString(String info) {
        String retValue = info;
        if (this.m_maxLength > 0 && retValue.length() > this.m_maxLength) {
            retValue = retValue.substring(0, this.m_maxLength);
        }
        StringBuilder out = new StringBuilder(retValue.length());
        int i = 0;
        while (i < retValue.length()) {
            char c = retValue.charAt(i);
            if (c == '\'') {
                out.append("''");
            } else if (c == '\\') {
                out.append("\\\\");
            } else {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    private String parseNumber(String info) {
        boolean hasComma;
        boolean hasPoint = info.indexOf(46) != -1;
        boolean bl = hasComma = info.indexOf(44) != -1;
        if (hasComma && this.m_decimalPoint.equals(".")) {
            info = info.replace(',', ' ');
        }
        if (hasPoint && this.m_decimalPoint.equals(",")) {
            info = info.replace('.', ' ');
        }
        boolean bl2 = hasComma = info.indexOf(44) != -1;
        if (hasComma && this.m_decimalPoint.equals(",")) {
            info = info.replace(',', '.');
        }
        char[] charArray = info.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < charArray.length) {
            if (Character.isDigit(charArray[i]) || charArray[i] == '.' || charArray[i] == '-') {
                sb.append(charArray[i]);
            }
            ++i;
        }
        if (sb.length() == 0) {
            return "0";
        }
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(sb.toString());
        }
        catch (NumberFormatException pe) {
            this.log.log(Level.SEVERE, "ImpFormatRow.parseNumber - " + info, pe);
        }
        if (bd == null) {
            bd = BigDecimal.ZERO;
        }
        if (this.m_divideBy100) {
            bd = bd.divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
        }
        return bd.toString();
    }
}

