/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.db.Database;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public abstract class Convert {
    public static final int REGEX_FLAGS = 34;
    protected Statement m_stmt = null;
    protected String m_conversionError = null;
    protected Exception m_exception = null;
    protected boolean m_verbose = true;
    private static CLogger log = CLogger.getCLogger(Convert.class);
    private static FileOutputStream tempFileOr = null;
    private static Writer writerOr;
    private static FileOutputStream tempFilePg;
    private static Writer writerPg;
    private static String[] dontLogTables;
    private static String m_oldprm_COMMENT;

    static {
        tempFilePg = null;
        dontLogTables = new String[]{"AD_ACCESSLOG", "AD_ALERTPROCESSORLOG", "AD_CHANGELOG", "AD_DOCUMENT_ACTION_ACCESS", "AD_FORM_ACCESS", "AD_INFOWINDOW_ACCESS", "AD_ISSUE", "AD_LDAPPROCESSORLOG", "AD_PACKAGE_IMP", "AD_PACKAGE_IMP_BACKUP", "AD_PACKAGE_IMP_DETAIL", "AD_PACKAGE_IMP_INST", "AD_PACKAGE_IMP_PROC", "AD_PINSTANCE", "AD_PINSTANCE_LOG", "AD_PINSTANCE_PARA", "AD_PREFERENCE", "AD_PROCESS_ACCESS", "AD_RECENTITEM", "AD_REPLICATION_LOG", "AD_SCHEDULERLOG", "AD_SESSION", "AD_WINDOW_ACCESS", "AD_WORKFLOW_ACCESS", "AD_WORKFLOWPROCESSORLOG", "CM_WEBACCESSLOG", "C_ACCTPROCESSORLOG", "K_INDEXLOG", "R_REQUESTPROCESSORLOG", "T_AGING", "T_ALTER_COLUMN", "T_DISTRIBUTIONRUNDETAIL", "T_INVENTORYVALUE", "T_INVOICEGL", "T_REPLENISH", "T_REPORT", "T_REPORTSTATEMENT", "T_SELECTION", "T_SELECTION2", "T_SPOOL", "T_TRANSACTION", "T_TRIALBALANCE"};
        m_oldprm_COMMENT = "";
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean execute(String sqlStatements, Connection conn) {
        if (conn == null) {
            throw new IllegalStateException("Require connection");
        }
        String[] sql = this.convert(sqlStatements);
        this.m_exception = null;
        if (this.m_conversionError != null || sql == null) {
            return false;
        }
        boolean ok = true;
        int i2 = 0;
        String statement = null;
        try {
            if (this.m_stmt == null) {
                this.m_stmt = conn.createStatement();
            }
            i2 = 0;
            while (ok && i2 < sql.length) {
                block25: {
                    statement = sql[i2];
                    if (statement.length() == 0) {
                        if (this.m_verbose && log.isLoggable(Level.FINER)) {
                            log.finer("Skipping empty (" + i2 + ")");
                        }
                    } else {
                        if (this.m_verbose) {
                            if (log.isLoggable(Level.INFO)) {
                                log.info("Executing (" + i2 + ") <<" + statement + ">>");
                            }
                        } else if (log.isLoggable(Level.INFO)) {
                            log.info("Executing " + i2);
                        }
                        try {
                            this.m_stmt.clearWarnings();
                            int no = this.m_stmt.executeUpdate(statement);
                            SQLWarning warn = this.m_stmt.getWarnings();
                            if (warn != null) {
                                if (this.m_verbose) {
                                    if (log.isLoggable(Level.INFO)) {
                                        log.info("- " + warn);
                                    }
                                } else if (log.isLoggable(Level.INFO)) {
                                    log.info("Executing (" + i2 + ") <<" + statement + ">>");
                                    log.info("- " + warn);
                                }
                            }
                            if (this.m_verbose && log.isLoggable(Level.FINE)) {
                                log.fine("- ok " + no);
                            }
                        }
                        catch (SQLException ex) {
                            if (!statement.startsWith("DROP ")) {
                                ok = false;
                                this.m_exception = ex;
                            }
                            if (!this.m_verbose && log.isLoggable(Level.INFO)) {
                                log.info("Executing (" + i2 + ") <<" + statement + ">>");
                            }
                            if (!log.isLoggable(Level.INFO)) break block25;
                            log.info("Error executing " + i2 + "/" + sql.length + " = " + ex);
                        }
                    }
                }
                ++i2;
            }
        }
        catch (SQLException e) {
            this.m_exception = e;
            if (!this.m_verbose && log.isLoggable(Level.INFO)) {
                log.info("Executing (" + i2 + ") <<" + statement + ">>");
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Error executing " + i2 + "/" + sql.length + " = " + e);
            }
            return false;
        }
        return ok;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public boolean hasError() {
        return this.m_exception != null | this.m_conversionError != null;
    }

    public String convertAll(String sqlStatements) {
        String[] sql = this.convert(sqlStatements);
        StringBuilder sb = new StringBuilder(sqlStatements.length() + 10);
        int i2 = 0;
        while (i2 < sql.length) {
            sb.append(sql[i2]).append("\n/\n");
            if (this.m_verbose && log.isLoggable(Level.INFO)) {
                log.info("Statement " + i2 + ": " + sql[i2]);
            }
            ++i2;
        }
        return sb.toString();
    }

    public String[] convert(String sqlStatements) {
        this.m_conversionError = null;
        if (sqlStatements == null || sqlStatements.length() == 0) {
            this.m_conversionError = "SQL_Statement is null or has zero length";
            log.info(this.m_conversionError);
            return null;
        }
        return this.convertIt(sqlStatements);
    }

    public String getConversionError() {
        return this.m_conversionError;
    }

    protected String[] convertIt(String sqlStatements) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.convertStatement(sqlStatements));
        String[] sql = new String[result.size()];
        result.toArray(sql);
        return sql;
    }

    protected String cleanUpStatement(String statement) {
        String clean = statement.trim();
        Matcher m = Pattern.compile("\\s+").matcher(clean);
        clean = m.replaceAll(" ");
        clean = clean.trim();
        return clean;
    }

    protected String replaceQuotedStrings(String inputValue, Vector<String> retVars) {
        retVars.clear();
        String quoteMarker = "<--QUOTE" + System.currentTimeMillis() + "-->";
        inputValue = inputValue.replace("''", quoteMarker);
        Pattern p2 = Pattern.compile("'[[^']*]*'");
        Matcher m = p2.matcher(inputValue);
        int i2 = 0;
        StringBuffer retValue = new StringBuffer(inputValue.length());
        while (m.find()) {
            String var = inputValue.substring(m.start(), m.end()).replace(quoteMarker, "''");
            retVars.addElement(var);
            m.appendReplacement(retValue, "<--" + i2 + "-->");
            ++i2;
        }
        m.appendTail(retValue);
        return retValue.toString().replace(quoteMarker, "''");
    }

    protected String recoverQuotedStrings(String retValue, Vector<String> retVars) {
        int i2 = 0;
        while (i2 < retVars.size()) {
            String replacement = retVars.get(i2);
            replacement = this.escapeQuotedString(replacement);
            retValue = retValue.replace("<--" + i2 + "-->", replacement);
            ++i2;
        }
        return retValue;
    }

    protected String escapeQuotedString(String in) {
        return in;
    }

    private String applyConvertMap(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("EXCEPTION WHEN") != -1) {
            String error = "Exception clause needs to be converted: " + sqlStatement;
            log.info(error);
            this.m_conversionError = error;
            return sqlStatement;
        }
        String retValue = sqlStatement;
        Map<String, String> convertMap = this.getConvertMap();
        if (convertMap != null) {
            for (String regex : convertMap.keySet()) {
                String replacement = convertMap.get(regex);
                try {
                    Pattern p2 = Pattern.compile(regex, 34);
                    Matcher m = p2.matcher(retValue);
                    retValue = m.replaceAll(replacement);
                }
                catch (Exception e) {
                    String error = "Error expression: " + regex + " - " + e;
                    log.info(error);
                    this.m_conversionError = error;
                }
            }
        }
        return retValue;
    }

    protected String convertWithConvertMap(String sqlStatement) {
        try {
            sqlStatement = this.applyConvertMap(this.cleanUpStatement(sqlStatement));
        }
        catch (RuntimeException e) {
            log.warning(e.getLocalizedMessage());
            this.m_exception = e;
        }
        return sqlStatement;
    }

    protected Map<String, String> getConvertMap() {
        return null;
    }

    protected abstract ArrayList<String> convertStatement(String var1);

    public abstract boolean isOracle();

    public static synchronized void logMigrationScript(String oraStatement, String pgStatement) {
        boolean logMigrationScript = false;
        if (Ini.isClient()) {
            logMigrationScript = Ini.isPropertyBool("LogMigrationScript");
        } else {
            String sysProperty = Env.getCtx().getProperty("LogMigrationScript", "N");
            boolean bl = logMigrationScript = "y".equalsIgnoreCase(sysProperty) || "true".equalsIgnoreCase(sysProperty);
        }
        if (logMigrationScript) {
            if (Convert.dontLog(oraStatement)) {
                return;
            }
            try {
                if (tempFileOr == null) {
                    File fileNameOr = File.createTempFile("migration_script_", "_oracle.sql");
                    tempFileOr = new FileOutputStream(fileNameOr, true);
                    writerOr = new BufferedWriter(new OutputStreamWriter((OutputStream)tempFileOr, "UTF8"));
                    writerOr.append("SET SQLBLANKLINES ON\nSET DEFINE OFF\n\n");
                }
                Convert.writeLogMigrationScript(writerOr, oraStatement);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (pgStatement == null) {
                    Convert convert = Database.getDatabase(Database.DB_POSTGRESQL).getConvert();
                    String[] r = convert.convert(oraStatement);
                    pgStatement = r[0];
                }
                if (tempFilePg == null) {
                    File fileNamePg = File.createTempFile("migration_script_", "_postgresql.sql");
                    tempFilePg = new FileOutputStream(fileNamePg, true);
                    writerPg = new BufferedWriter(new OutputStreamWriter((OutputStream)tempFilePg, "UTF8"));
                }
                Convert.writeLogMigrationScript(writerPg, pgStatement);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean dontLog(String statement) {
        String uppStmt = statement.toUpperCase().trim();
        if (uppStmt.startsWith("SELECT ")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE AD_PROCESS SET STATISTIC_")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE C_ACCTPROCESSOR SET DATENEXTRUN")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE R_REQUESTPROCESSOR SET DATELASTRUN")) {
            return true;
        }
        if (uppStmt.startsWith("DELETE FROM ") && uppStmt.endsWith(" WHERE AD_TABLE_ID=? AND RECORD_ID=?")) {
            return true;
        }
        if (uppStmt.matches("UPDATE .*_TRL SET .*")) {
            return true;
        }
        if (uppStmt.matches("INSERT INTO .*_TRL .*")) {
            return true;
        }
        if (uppStmt.startsWith("INSERT INTO AD_TREENODE ") && uppStmt.contains(" AND T.TREETYPE='TL' AND T.AD_TABLE_ID=")) {
            return true;
        }
        int i2 = 0;
        while (i2 < dontLogTables.length) {
            if (uppStmt.startsWith("INSERT INTO " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("DELETE FROM " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("DELETE " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("UPDATE " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("INSERT INTO " + dontLogTables[i2] + "(")) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static void writeLogMigrationScript(Writer w, String statement) throws IOException {
        boolean isUseCentralizedID = "Y".equals(MSysConfig.getValue("DICTIONARY_ID_USE_CENTRALIZED_ID", "Y"));
        boolean isUseProjectCentralizedID = "Y".equals(MSysConfig.getValue("PROJECT_ID_USE_CENTRALIZED_ID", "N"));
        String prm_COMMENT = !isUseCentralizedID && isUseProjectCentralizedID ? MSysConfig.getValue("PROJECT_ID_COMMENTS") : MSysConfig.getValue("DICTIONARY_ID_COMMENTS");
        if (prm_COMMENT != null && !m_oldprm_COMMENT.equals(prm_COMMENT)) {
            w.append("-- ");
            w.append(prm_COMMENT);
            w.append("\n");
            if (w == writerPg) {
                m_oldprm_COMMENT = prm_COMMENT;
            }
        }
        SimpleDateFormat format = DisplayType.getDateFormat(16);
        String dateTimeText = format.format(new Timestamp(System.currentTimeMillis()));
        w.append("-- ");
        w.append(dateTimeText);
        w.append("\n");
        w.append(statement);
        w.append("\n;\n\n");
        w.flush();
    }
}

