/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class JDBCInfo {
    private DatabaseMetaData m_md = null;
    private static CLogger log = CLogger.getCLogger(JDBCInfo.class);

    public JDBCInfo(Connection conn) throws SQLException {
        this.m_md = conn.getMetaData();
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_md.getDatabaseProductName());
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.m_md.getDatabaseProductVersion());
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_md.getDriverName());
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.m_md.getDriverVersion());
            log.config(String.valueOf(this.m_md.getDriverMajorVersion()) + "/" + this.m_md.getDriverMinorVersion());
        }
    }

    public void listAll() {
        try {
            this.listSchemas();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        try {
            this.listCatalogs();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        try {
            this.listTypes();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    public void listCatalogs() throws SQLException {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(this.m_md.getCatalogTerm()) + " -> " + this.m_md.getCatalogSeparator());
        }
        ResultSet rs = this.m_md.getCatalogs();
        while (rs.next()) {
            JDBCInfo.dump(rs);
        }
    }

    public void listSchemas() throws SQLException {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_md.getSchemaTerm());
        }
        ResultSet rs = this.m_md.getSchemas();
        while (rs.next()) {
            JDBCInfo.dump(rs);
        }
    }

    public void listTypes() throws SQLException {
        ResultSet rs = this.m_md.getTypeInfo();
        while (rs.next()) {
            log.info("");
            JDBCInfo.dump(rs);
        }
    }

    public static void dump(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int i2 = 0;
        while (i2 < md.getColumnCount()) {
            int index = i2 + 1;
            String info = md.getColumnLabel(index);
            String name = md.getColumnName(index);
            if (info == null) {
                info = name;
            } else if (name != null && !name.equals(info)) {
                info = String.valueOf(info) + " (" + name + ")";
            }
            info = String.valueOf(info) + " = " + rs.getString(index);
            info = String.valueOf(info) + " [" + md.getColumnTypeName(index) + "(" + md.getPrecision(index);
            if (md.getScale(index) != 0) {
                info = String.valueOf(info) + "," + md.getScale(index);
            }
            info = String.valueOf(info) + ")]";
            log.fine(info);
            ++i2;
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        CLogMgt.setLevel(Level.ALL);
        try {
            JDBCInfo info = new JDBCInfo(DB.createConnection(true, 2));
            info.listCatalogs();
            info.listSchemas();
            info.listTypes();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }
}

