/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.base.Service;
import org.adempiere.base.ServiceQuery;
import org.compiere.db.AdempiereDatabase;
import org.compiere.util.CLogger;

public class Database {
    private static CLogger log = CLogger.getCLogger(Database.class);
    public static String DB_ORACLE = "Oracle";
    public static String DB_POSTGRESQL = "PostgreSQL";
    public static int CONNECTION_TIMEOUT = 10;
    public static final int DB_ORACLE_DEFAULT_PORT = 1521;
    public static final int DB_ORACLE_DEFAULT_CM_PORT = 1630;
    public static final int DB_POSTGRESQL_DEFAULT_PORT = 5432;

    public static AdempiereDatabase getDatabase(String type) {
        ServiceQuery query = new ServiceQuery();
        query.put("id", type);
        AdempiereDatabase db = Service.locator().locate(AdempiereDatabase.class, query).getService();
        return db;
    }

    public static String[] getDatabaseNames() {
        ArrayList<String> names = new ArrayList<String>();
        List<AdempiereDatabase> services = Service.locator().list(AdempiereDatabase.class).getServices();
        for (AdempiereDatabase db : services) {
            names.add(db.getName());
        }
        return names.toArray(new String[0]);
    }

    public static AdempiereDatabase getDatabaseFromURL(String url) {
        if (url == null) {
            log.severe("No Database URL");
            return null;
        }
        if (url.indexOf("oracle") != -1) {
            return Database.getDatabase(DB_ORACLE);
        }
        if (url.indexOf("postgresql") != -1) {
            return Database.getDatabase(DB_POSTGRESQL);
        }
        log.severe("No Database for " + url);
        return null;
    }
}

