/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.db.JDBCInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;

public class CreateAdempiere {
    private AdempiereDatabase m_dbTarget = null;
    private AdempiereDatabase m_dbSource = null;
    private String m_databaseHost = null;
    private int m_databasePort = 0;
    private String m_systemPassword = null;
    private String m_adempiereUser = null;
    private String m_adempierePassword = null;
    private String m_databaseName = null;
    private String m_databaseDevice = null;
    private Properties m_ctx = new Properties();
    private Connection m_conn = null;
    private static CLogger log = CLogger.getCLogger(CreateAdempiere.class);
    private PrintWriter m_writer = null;

    public CreateAdempiere(String databaseType, String databaseHost, int databasePort, String systemPassword) {
        this.initDatabase(databaseType);
        this.m_databaseHost = databaseHost;
        this.m_databasePort = databasePort == 0 ? this.m_dbTarget.getStandardPort() : databasePort;
        this.m_systemPassword = systemPassword;
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(this.m_dbTarget.getName()) + " on " + databaseHost);
        }
    }

    private void initDatabase(String databaseType) {
        try {
            this.m_dbTarget = Database.getDatabase(databaseType);
        }
        catch (Exception e) {
            log.severe(e.toString());
            e.printStackTrace();
        }
        if (this.m_dbTarget == null) {
            throw new IllegalStateException("No database: " + databaseType);
        }
        this.m_dbSource = DB.getDatabase();
    }

    public void cleanStart() {
        Connection conn = this.getConnection(true, true);
        if (conn == null) {
            throw new IllegalStateException("No Database");
        }
        this.dropDatabase(conn);
        this.createUser(conn);
        this.createDatabase(conn);
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            log.log(Level.SEVERE, "close connection", e2);
        }
        conn = null;
    }

    public void setAdempiereUser(String adempiereUser, String adempierePassword) {
        this.m_adempiereUser = adempiereUser;
        this.m_adempierePassword = adempierePassword;
    }

    public void setDatabaseName(String databaseName, String databaseDevice) {
        this.m_databaseName = databaseName;
        this.m_databaseDevice = databaseDevice;
    }

    public boolean testConnection() {
        String dbUrl = this.m_dbTarget.getConnectionURL(this.m_databaseHost, this.m_databasePort, this.m_databaseName, this.m_dbTarget.getSystemUser());
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(dbUrl) + " - " + this.m_dbTarget.getSystemUser() + "/" + this.m_systemPassword);
        }
        try {
            Connection conn = this.m_dbTarget.getDriverConnection(dbUrl, this.m_dbTarget.getSystemUser(), this.m_systemPassword);
            JDBCInfo info = new JDBCInfo(conn);
            if (CLogMgt.isLevelFinest()) {
                info.listCatalogs();
                info.listSchemas();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "test", e);
            return false;
        }
        return true;
    }

    public boolean createUser(Connection sysConn) {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(this.m_adempiereUser) + "/" + this.m_adempierePassword);
        }
        return this.executeCommands(this.m_dbTarget.getCommands(0), sysConn, true, false);
    }

    public boolean createDatabase(Connection sysConn) {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(this.m_databaseName) + "(" + this.m_databaseDevice + ")");
        }
        return this.executeCommands(this.m_dbTarget.getCommands(1), sysConn, true, false);
    }

    public boolean dropDatabase(Connection sysConn) {
        log.info(this.m_databaseName);
        return this.executeCommands(this.m_dbTarget.getCommands(2), sysConn, true, false);
    }

    public boolean copy(String whereClause, boolean dropFirst) {
        ArrayList<String> list;
        int count;
        boolean success;
        block16: {
            log.info(whereClause);
            if (this.getConnection(false, true) == null) {
                return false;
            }
            success = true;
            count = 0;
            list = new ArrayList<String>();
            String sql = "SELECT * FROM AD_Table";
            if (whereClause != null && whereClause.length() > 0) {
                sql = String.valueOf(sql) + " WHERE " + whereClause;
            }
            sql = String.valueOf(sql) + " ORDER BY TableName";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    Connection conn = pstmt.getConnection();
                    DatabaseMetaData md = null;
                    if (conn == null) {
                        throw new DBException("No Connection");
                    }
                    md = conn.getMetaData();
                    rs = pstmt.executeQuery();
                    while (rs.next() && success) {
                        MTable table2 = new MTable(this.m_ctx, rs, null);
                        if (table2.isView()) continue;
                        if (dropFirst) {
                            this.executeCommands(new String[]{"DROP TABLE " + table2.getTableName()}, this.m_conn, false, false);
                        }
                        if (this.createTable(table2, md)) {
                            list.add(table2.getTableName());
                            ++count;
                            continue;
                        }
                        success = false;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    success = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!success) {
            return false;
        }
        this.enableConstraints(list);
        this.databaseBuild();
        if (log.isLoggable(Level.INFO)) {
            log.info("#" + count);
        }
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (SQLException e2) {
            log.log(Level.SEVERE, "close connection", e2);
        }
        this.m_conn = null;
        return success;
    }

    public boolean execute(File script2) {
        return false;
    }

    private boolean createTable(MTable mTable, DatabaseMetaData md) {
        String tableName = mTable.getTableName();
        log.info(tableName);
        String catalog = this.m_dbSource.getCatalog();
        String schema = this.m_dbSource.getSchema();
        String table2 = tableName.toUpperCase();
        MColumn[] columns = mTable.getColumns(false);
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(tableName).append(" (");
        ResultSet sourceColumns = null;
        ResultSet sourcePK = null;
        try {
            try {
                String columnName;
                boolean first = true;
                sourceColumns = md.getColumns(catalog, schema, table2, null);
                while (sourceColumns.next()) {
                    sb.append(first ? "" : ", ");
                    first = false;
                    MColumn column = null;
                    columnName = sourceColumns.getString("COLUMN_NAME");
                    int i2 = 0;
                    while (i2 < columns.length) {
                        String cn = columns[i2].getColumnName();
                        if (cn.equalsIgnoreCase(columnName)) {
                            columnName = cn;
                            column = columns[i2];
                            break;
                        }
                        ++i2;
                    }
                    sb.append(columnName).append(" ");
                    String typeName = sourceColumns.getString("TYPE_NAME");
                    int size = sourceColumns.getInt("COLUMN_SIZE");
                    int decDigits = sourceColumns.getInt("DECIMAL_DIGITS");
                    if (sourceColumns.wasNull()) {
                        decDigits = -1;
                    }
                    if (typeName.equals("NUMBER")) {
                        int dt = column.getAD_Reference_ID();
                        if (DisplayType.isID(dt)) {
                            sb.append("INTEGER");
                        } else {
                            int scale = DisplayType.getDefaultPrecision(dt);
                            sb.append("DECIMAL(").append(18 + scale).append(",").append(scale).append(")");
                        }
                    } else if (typeName.equals("DATE") || typeName.equals("BLOB") || typeName.equals("CLOB")) {
                        sb.append(typeName);
                    } else if (typeName.equals("CHAR") || typeName.startsWith("VARCHAR")) {
                        sb.append(typeName).append("(").append(size).append(")");
                    } else if (typeName.startsWith("NCHAR") || typeName.startsWith("NVAR")) {
                        sb.append(typeName).append("(").append(size / 2).append(")");
                    } else if (typeName.startsWith("TIMESTAMP")) {
                        sb.append("DATE");
                    } else {
                        log.severe("Do not support data type " + typeName);
                    }
                    String def = sourceColumns.getString("COLUMN_DEF");
                    if (def != null) {
                        def = def.replaceAll("''", "\\'");
                        sb.append(" DEFAULT ").append(def);
                    }
                    if (sourceColumns.getInt("NULLABLE") == 0) {
                        sb.append(" NOT NULL");
                        continue;
                    }
                    sb.append(" NULL");
                }
                sourcePK = md.getPrimaryKeys(catalog, schema, table2);
                first = true;
                boolean hasPK = false;
                while (sourcePK.next()) {
                    hasPK = true;
                    if (first) {
                        sb.append(", CONSTRAINT ").append(sourcePK.getString("PK_NAME")).append(" PRIMARY KEY (");
                    } else {
                        sb.append(",");
                    }
                    first = false;
                    columnName = sourcePK.getString("COLUMN_NAME");
                    sb.append(this.checkColumnName(columnName));
                }
                if (hasPK) {
                    sb.append(")");
                }
                sb.append(")");
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "createTable", ex);
                DB.close(sourceColumns);
                DB.close(sourcePK);
                sourceColumns = null;
                sourcePK = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(sourceColumns);
            DB.close(sourcePK);
            sourceColumns = null;
            sourcePK = null;
            throw throwable;
        }
        DB.close(sourceColumns);
        DB.close(sourcePK);
        sourceColumns = null;
        sourcePK = null;
        if (!this.executeCommands(new String[]{sb.toString()}, this.m_conn, false, true)) {
            return true;
        }
        this.createTableIndexes(mTable, md);
        return this.createTableData(mTable);
    }

    private String checkColumnName(String columnName) {
        return M_Element.getColumnName(columnName);
    }

    private void createTableIndexes(MTable mTable, DatabaseMetaData md) {
        String tableName = mTable.getTableName();
        log.info(tableName);
        String catalog = this.m_dbSource.getCatalog();
        String schema = this.m_dbSource.getSchema();
        String table2 = tableName.toUpperCase();
        try {
            ResultSet resultSet = md.getIndexInfo(catalog, schema, table2, false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean createTableData(MTable mTable) {
        long start;
        int errors;
        int count;
        boolean success;
        block8: {
            success = true;
            count = 0;
            errors = 0;
            start = System.currentTimeMillis();
            String sql = "SELECT * FROM " + mTable.getTableName();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, mTable.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (this.createTableDataRow(rs, mTable)) {
                            ++count;
                            continue;
                        }
                        ++errors;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    success = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        long elapsed = System.currentTimeMillis() - start;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Inserted=" + count + " - Errors=" + errors + " - " + elapsed + " ms");
        }
        return success;
    }

    private boolean createTableDataRow(ResultSet rs, MTable mTable) {
        StringBuffer insert = new StringBuffer("INSERT INTO ").append(mTable.getTableName()).append(" (");
        StringBuffer values = new StringBuffer();
        MColumn[] columns = mTable.getColumns(false);
        int i2 = 0;
        while (i2 < columns.length) {
            if (i2 != 0) {
                insert.append(",");
                values.append(",");
            }
            MColumn column = columns[i2];
            String columnName = column.getColumnName();
            insert.append(columnName);
            int dt = column.getAD_Reference_ID();
            try {
                Object value = rs.getObject(columnName);
                if (rs.wasNull()) {
                    values.append("NULL");
                } else if (columnName.endsWith("_ID") || DisplayType.isNumeric(dt) || DisplayType.isID(dt) && !columnName.equals("AD_Language")) {
                    BigDecimal bd = rs.getBigDecimal(columnName);
                    String s = this.m_dbTarget.TO_NUMBER(bd, dt);
                    values.append(s);
                } else if (DisplayType.isDate(dt)) {
                    Timestamp ts = rs.getTimestamp(columnName);
                    String tsString = this.m_dbTarget.TO_DATE(ts, dt == 15);
                    values.append(tsString);
                } else if (DisplayType.isLOB(dt)) {
                    values.append("NULL");
                } else if (DisplayType.isText(dt) || dt == 20 || dt == 17 || dt == 28 || columnName.equals("AD_Language")) {
                    String s = rs.getString(columnName);
                    values.append(DB.TO_STRING(s));
                } else {
                    log.warning("Unknown DisplayType=" + dt + " - " + value + " [" + value.getClass().getName() + "]");
                    values.append("NuLl");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, columnName, e);
            }
            ++i2;
        }
        insert.append(") VALUES (").append(values).append(")");
        return this.executeCommands(new String[]{insert.toString()}, this.m_conn, false, false);
    }

    private boolean enableConstraints(ArrayList<String> list) {
        log.info("");
        return false;
    }

    private void databaseBuild() {
        String fileName = "C:\\Adempiere\\adempiere-all2\\db\\database\\DatabaseBuild.sql";
        File file = new File(fileName);
        if (!file.exists()) {
            log.severe("No file: " + fileName);
        }
    }

    private Connection getConnection(boolean asSystem, boolean createNew) {
        if (!createNew && this.m_conn != null) {
            return this.m_conn;
        }
        String dbUrl = this.m_dbTarget.getConnectionURL(this.m_databaseHost, this.m_databasePort, asSystem ? this.m_dbTarget.getSystemDatabase(this.m_databaseName) : this.m_databaseName, asSystem ? this.m_dbTarget.getSystemUser() : this.m_adempiereUser);
        try {
            this.m_conn = asSystem ? this.m_dbTarget.getDriverConnection(dbUrl, this.m_dbTarget.getSystemUser(), this.m_systemPassword) : this.m_dbTarget.getDriverConnection(dbUrl, this.m_adempiereUser, this.m_adempierePassword);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, dbUrl, e);
        }
        return this.m_conn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean executeCommands(String[] cmds, Connection conn, boolean batch, boolean doConvert) {
        Statement stmt;
        block17: {
            String cmdOriginal;
            String cmd;
            block16: {
                if (cmds == null || cmds.length == 0) {
                    log.warning("No Commands");
                    return false;
                }
                stmt = null;
                cmd = null;
                cmdOriginal = null;
                if (conn != null || (conn = this.getConnection(false, false)) != null) break block16;
                DB.close(stmt);
                return false;
            }
            try {
                if (conn.getAutoCommit() == batch) {
                    conn.setAutoCommit(!batch);
                }
                stmt = conn.createStatement();
                int i2 = 0;
                while (i2 < cmds.length) {
                    cmd = cmds[i2];
                    cmdOriginal = cmds[i2];
                    if (cmd != null && cmd.length() != 0) {
                        if (cmd.indexOf(64) != -1) {
                            cmd = Util.replace(cmd, "@SystemPassword@", this.m_systemPassword);
                            cmd = Util.replace(cmd, "@AdempiereUser@", this.m_adempiereUser);
                            cmd = Util.replace(cmd, "@AdempierePassword@", this.m_adempierePassword);
                            cmd = Util.replace(cmd, "@SystemPassword@", this.m_systemPassword);
                            cmd = Util.replace(cmd, "@DatabaseName@", this.m_databaseName);
                            if (this.m_databaseDevice != null) {
                                cmd = Util.replace(cmd, "@DatabaseDevice@", this.m_databaseDevice);
                            }
                        }
                        if (doConvert) {
                            cmd = this.m_dbTarget.convertStatement(cmd);
                        }
                        this.writeLog(cmd);
                        log.finer(cmd);
                        int no = stmt.executeUpdate(cmd);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("# " + no);
                        }
                    }
                    ++i2;
                }
                if (!batch) break block17;
                conn.commit();
            }
            catch (Exception e) {
                try {
                    String msg = e.getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = e.toString();
                    }
                    msg = String.valueOf(msg) + " (";
                    if (e instanceof SQLException) {
                        msg = String.valueOf(msg) + "State=" + ((SQLException)e).getSQLState() + ",ErrorCode=" + ((SQLException)e).getErrorCode();
                    }
                    msg = String.valueOf(msg) + ")";
                    if (cmdOriginal != null && !cmdOriginal.equals(cmd)) {
                        msg = String.valueOf(msg) + " - " + cmdOriginal;
                    }
                    msg = String.valueOf(msg) + "\n=>" + cmd;
                    log.log(Level.SEVERE, msg);
                }
                catch (Throwable throwable) {
                    DB.close(stmt);
                    stmt = null;
                    throw throwable;
                }
                DB.close(stmt);
                return false;
            }
        }
        DB.close(stmt);
        return true;
    }

    private void writeLog(String cmd) {
        try {
            if (this.m_writer == null) {
                File file = File.createTempFile("create", ".log");
                this.m_writer = new PrintWriter(new FileWriter(file));
                if (log.isLoggable(Level.INFO)) {
                    log.info(file.toString());
                }
            }
            this.m_writer.println(cmd);
            this.m_writer.flush();
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        CLogMgt.setLevel(Level.FINE);
        CLogMgt.setLoggerLevel(Level.FINE, null);
        CreateAdempiere cc = new CreateAdempiere(Database.DB_POSTGRESQL, "127.0.0.2", 5432, "adempiere");
        cc.setAdempiereUser("adempiere", "adempiere");
        cc.setDatabaseName("adempiere", "adempiere");
        if (!cc.testConnection()) {
            return;
        }
        cc.cleanStart();
        cc.copy("TableName > 'C_RfQResponseLineQty'", false);
    }
}

