/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.swing.JOptionPane;
import org.adempiere.base.Service;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.db.SecurityPrincipal;
import org.compiere.interfaces.Server;
import org.compiere.interfaces.Status;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;

public class CConnection
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -858558852550858165L;
    private static volatile CConnection s_cc = null;
    private static CLogger log = CLogger.getCLogger(CConnection.class);
    private String m_name = "Standard";
    private String m_apps_host = "MyAppsServer";
    private String m_type = "";
    private String m_db_host = "MyDBServer";
    private int m_db_port = 0;
    private String m_db_name = "MyDBName";
    private boolean m_bequeath = false;
    private boolean m_firewall = false;
    private String m_fw_host = "";
    private int m_fw_port = 0;
    private String m_db_uid = "adempiere";
    private String m_db_pwd = "adempiere";
    private AdempiereDatabase m_db = null;
    private Exception m_dbException = null;
    private Exception m_appsException = null;
    private boolean m_okDB = false;
    private boolean m_okApps = false;
    private String[] m_info = new String[2];
    private String m_version = null;
    private DataSource m_ds = null;
    private Server m_server = null;
    private String m_dbInfo = null;
    private int m_webPort;
    private int m_sslPort;
    private boolean m_queryAppsServer;
    private SecurityPrincipal securityPrincipal;

    public static CConnection get() {
        return CConnection.get(null);
    }

    public static synchronized CConnection get(String apps_host) {
        if (s_cc == null) {
            String attributes = Ini.getProperty("Connection");
            if (attributes == null || attributes.length() == 0) {
                CConnection cc = null;
                if (apps_host != null && Adempiere.isWebStartClient() && (cc = new CConnection(apps_host)).testAppsServer() == null) {
                    s_cc = cc;
                    Ini.setProperty("Connection", cc.toStringLong());
                    Ini.saveProperties(Ini.isClient());
                }
                if (s_cc == null) {
                    if (cc == null) {
                        cc = new CConnection(apps_host);
                    }
                    s_cc = cc;
                    Ini.setProperty("Connection", cc.toStringLong());
                    Ini.saveProperties(Ini.isClient());
                }
            } else {
                s_cc = new CConnection(null);
                s_cc.setAttributes(attributes);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(s_cc.toString());
            }
        }
        return s_cc;
    }

    public static CConnection get(String type, String db_host, int db_port, String db_name) {
        return CConnection.get(type, db_host, db_port, db_name, null, null);
    }

    public static CConnection get(String type, String db_host, int db_port, String db_name, String db_uid, String db_pwd) {
        CConnection cc = new CConnection(db_host);
        cc.setAppsHost(db_host);
        cc.setType(type);
        cc.setDbHost(db_host);
        cc.setDbPort(db_port);
        cc.setDbName(db_name);
        if (db_uid != null) {
            cc.setDbUid(db_uid);
        }
        if (db_pwd != null) {
            cc.setDbPwd(db_pwd);
        }
        return cc;
    }

    public CConnection(String host) {
        if (host != null) {
            this.m_apps_host = host;
            this.m_db_host = host;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setName() {
        this.m_name = this.toString();
    }

    public String getAppsHost() {
        return this.m_apps_host;
    }

    public void setAppsHost(String apps_host) {
        this.m_apps_host = apps_host;
        this.m_name = this.toString();
        this.m_okApps = false;
    }

    public int getWebPort() {
        return this.m_webPort;
    }

    public void setWebPort(int webPort) {
        this.m_webPort = webPort;
    }

    public void setWebPort(String webPortString) {
        try {
            if (webPortString != null && webPortString.length() != 0) {
                this.setWebPort(Integer.parseInt(webPortString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public int getSSLPort() {
        return this.m_sslPort;
    }

    public void setSSLPort(int sslPort) {
        this.m_sslPort = sslPort;
    }

    public void setSSLPort(String sslPortString) {
        try {
            if (sslPortString != null && sslPortString.length() != 0) {
                this.setSSLPort(Integer.parseInt(sslPortString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public boolean isAppsServerOK(boolean tryContactAgain) {
        if (!tryContactAgain && this.m_queryAppsServer) {
            return this.m_okApps;
        }
        if (this.getAppServerCredential() == null) {
            this.m_okApps = false;
            return this.m_okApps;
        }
        this.m_queryAppsServer = true;
        try {
            Status status = Service.locator().locate(Status.class).getService();
            this.m_version = status.getDateVersion();
        }
        catch (Throwable t) {
            this.m_okApps = false;
        }
        return this.m_okApps;
    }

    public synchronized Exception testAppsServer() {
        this.m_appsException = null;
        this.queryAppsServerInfo();
        return this.getAppsServerException();
    }

    public Server getServer() {
        if (this.m_server == null) {
            this.m_server = Service.locator().locate(Server.class).getService();
        }
        return this.m_server;
    }

    public String getServerVersion() {
        return this.m_version;
    }

    public String getDbHost() {
        return this.m_db_host;
    }

    public void setDbHost(String db_host) {
        this.m_db_host = db_host;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public String getDbName() {
        return this.m_db_name;
    }

    public void setDbName(String db_name) {
        this.m_db_name = db_name;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public int getDbPort() {
        return this.m_db_port;
    }

    public void setDbPort(int db_port) {
        this.m_db_port = db_port;
        this.m_okDB = false;
    }

    public void setDbPort(String db_portString) {
        try {
            if (db_portString != null && db_portString.length() != 0) {
                this.setDbPort(Integer.parseInt(db_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getDbPwd() {
        return this.m_db_pwd;
    }

    public void setDbPwd(String db_pwd) {
        this.m_db_pwd = db_pwd;
        this.m_okDB = false;
    }

    public String getDbUid() {
        return this.m_db_uid;
    }

    public void setDbUid(String db_uid) {
        this.m_db_uid = db_uid;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public boolean isRMIoverHTTP() {
        return false;
    }

    public boolean isServerObjects() {
        return false;
    }

    public boolean isServerProcess() {
        return false;
    }

    public boolean isTerminalServer() {
        return false;
    }

    public boolean isViaFirewall() {
        return this.m_firewall;
    }

    public void setViaFirewall(boolean viaFirewall) {
        this.m_firewall = viaFirewall;
        this.m_okDB = false;
    }

    public void setViaFirewall(String viaFirewallString) {
        try {
            this.setViaFirewall(Boolean.valueOf(viaFirewallString));
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getFwHost() {
        return this.m_fw_host;
    }

    public void setFwHost(String fw_host) {
        this.m_fw_host = fw_host;
        this.m_okDB = false;
    }

    public int getFwPort() {
        return this.m_fw_port;
    }

    public void setFwPort(int fw_port) {
        this.m_fw_port = fw_port;
        this.m_okDB = false;
    }

    public void setFwPort(String fw_portString) {
        try {
            if (fw_portString != null && fw_portString.length() != 0) {
                this.setFwPort(Integer.parseInt(fw_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public boolean isBequeath() {
        return this.m_bequeath;
    }

    public void setBequeath(boolean bequeath) {
        this.m_bequeath = bequeath;
        this.m_okDB = false;
    }

    public void setBequeath(String bequeathString) {
        try {
            this.setBequeath(Boolean.valueOf(bequeathString));
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        if (Database.getDatabase(type) != null) {
            this.m_type = type;
            this.m_okDB = false;
        }
        if (this.isOracle()) {
            if (this.getDbPort() != 1521) {
                this.setDbPort(1521);
            }
            this.setFwPort(1630);
        } else {
            this.setBequeath(false);
            this.setViaFirewall(false);
        }
        if (this.isPostgreSQL() && this.getDbPort() != 5432) {
            this.setDbPort(5432);
        }
    }

    public boolean supportsBLOB() {
        return this.m_db.supportsBLOB();
    }

    public boolean isOracle() {
        return Database.DB_ORACLE.equals(this.m_type);
    }

    public boolean isPostgreSQL() {
        return Database.DB_POSTGRESQL.equals(this.m_type);
    }

    public boolean isDatabaseOK() {
        return this.m_okDB;
    }

    public boolean setDataSource() {
        AdempiereDatabase getDB;
        if (this.m_ds == null && Ini.isClient() && (getDB = this.getDatabase()) != null) {
            this.m_ds = getDB.getDataSource(this);
        }
        return this.m_ds != null;
    }

    public boolean setDataSource(DataSource ds) {
        if (ds == null && this.m_ds != null) {
            this.getDatabase().close();
        }
        this.m_ds = ds;
        return this.m_ds != null;
    }

    public DataSource getDataSource() {
        return this.m_ds;
    }

    public boolean isDataSource() {
        return this.m_ds != null;
    }

    public Exception testDatabase(boolean retest) {
        if (!retest && this.m_ds != null && this.m_okDB) {
            return null;
        }
        if (this.getDatabase() != null) {
            this.getDatabase().close();
        }
        this.m_ds = null;
        this.setDataSource();
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                this.readInfo(conn);
                conn.close();
            }
            catch (Exception e) {
                log.severe(e.toString());
                return e;
            }
        }
        return this.m_dbException;
    }

    public void readInfo(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        this.m_info[0] = "Database=" + dbmd.getDatabaseProductName() + " - " + dbmd.getDatabaseProductVersion();
        this.m_info[0] = this.m_info[0].replace('\n', ' ');
        this.m_info[1] = "Driver  =" + dbmd.getDriverName() + " - " + dbmd.getDriverVersion();
        if (this.isDataSource()) {
            this.m_info[1] = String.valueOf(this.m_info[1]) + " - via DataSource";
        }
        this.m_info[1] = this.m_info[1].replace('\n', ' ');
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_info[0]) + " - " + this.m_info[1]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        return sb.toString();
    }

    public String toStringDetail() {
        StringBuilder sb = new StringBuilder(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                sb.append("\nDatabase=" + dbmd.getDatabaseProductName() + " - " + dbmd.getDatabaseProductVersion());
                sb.append("\nDriver  =" + dbmd.getDriverName() + " - " + dbmd.getDriverVersion());
                if (this.isDataSource()) {
                    sb.append(" - via DS");
                }
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conn = null;
        return sb.toString();
    }

    public String getDBInfo() {
        if (this.m_dbInfo != null) {
            return this.m_dbInfo;
        }
        StringBuilder sb = new StringBuilder();
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                sb.append(dbmd.getDatabaseProductVersion()).append(";").append(dbmd.getDriverVersion());
                if (this.isDataSource()) {
                    sb.append(";DS");
                }
                conn.close();
                this.m_dbInfo = sb.toString();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
                sb.append(e.getLocalizedMessage());
            }
        }
        conn = null;
        return sb.toString();
    }

    public String toStringLong() {
        StringBuilder sb = new StringBuilder("CConnection[");
        sb.append("name=").append(this.escape(this.m_name)).append(",AppsHost=").append(this.escape(this.m_apps_host)).append(",WebPort=").append(this.m_webPort).append(",SSLPort=").append(this.m_sslPort).append(",type=").append(this.escape(this.m_type)).append(",DBhost=").append(this.escape(this.m_db_host)).append(",DBport=").append(this.m_db_port).append(",DBname=").append(this.escape(this.m_db_name)).append(",BQ=").append(this.m_bequeath).append(",FW=").append(this.m_firewall).append(",FWhost=").append(this.escape(this.m_fw_host)).append(",FWport=").append(this.m_fw_port).append(",UID=").append(this.escape(this.m_db_uid)).append(",PWD=").append(this.escape(this.m_db_pwd)).append("]");
        return sb.toString();
    }

    private String escape(String value) {
        if (value == null) {
            return null;
        }
        value = value.replace("=", "&eq;");
        value = value.replace(",", "&comma;");
        return value;
    }

    private void setAttributes(String attributes) {
        try {
            String[] pairs;
            attributes = attributes.substring(attributes.indexOf("[") + 1, attributes.length() - 1);
            String[] stringArray = pairs = attributes.split("[,]");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String pair = stringArray[n2];
                String[] pairComponents = pair.split("[=]");
                String key = pairComponents[0];
                String string = value = pairComponents.length == 2 ? this.unescape(pairComponents[1]) : "";
                if ("name".equalsIgnoreCase(key)) {
                    this.setName(value);
                } else if ("AppsHost".equalsIgnoreCase(key)) {
                    this.setAppsHost(value);
                } else if ("type".equalsIgnoreCase(key)) {
                    this.setType(value);
                } else if ("DBhost".equalsIgnoreCase(key)) {
                    this.setDbHost(value);
                } else if ("DBport".equalsIgnoreCase(key)) {
                    this.setDbPort(value);
                } else if ("DbName".equalsIgnoreCase(key)) {
                    this.setDbName(value);
                } else if ("BQ".equalsIgnoreCase(key)) {
                    this.setBequeath(value);
                } else if ("FW".equalsIgnoreCase(key)) {
                    this.setViaFirewall(value);
                } else if ("FWhost".equalsIgnoreCase(key)) {
                    this.setFwHost(value);
                } else if ("FWport".equalsIgnoreCase(key)) {
                    this.setFwPort(value);
                } else if ("UID".equalsIgnoreCase(key)) {
                    this.setDbUid(value);
                } else if ("PWD".equalsIgnoreCase(key)) {
                    this.setDbPwd(value);
                } else if ("WebPort".equalsIgnoreCase(key)) {
                    this.setWebPort(value);
                } else if ("SSLPort".equalsIgnoreCase(key)) {
                    this.setSSLPort(value);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.valueOf(attributes) + " - " + e.toString(), e);
        }
    }

    private String unescape(String value) {
        value = value.replace("&eq;", "=");
        value = value.replace("&comma;", ",");
        return value;
    }

    public boolean equals(Object o) {
        CConnection cc;
        return o instanceof CConnection && (cc = (CConnection)o).getAppsHost().equals(this.m_apps_host) && cc.getDbHost().equals(this.m_db_host) && cc.getDbPort() == this.m_db_port && cc.getDbName().equals(this.m_db_name) && cc.getType().equals(this.m_type) && cc.getDbUid().equals(this.m_db_uid) && cc.getDbPwd().equals(this.m_db_pwd);
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder(this.m_info[0] != null ? this.m_info[0] : "");
        sb.append(" - ").append(this.m_info[1] != null ? this.m_info[1] : "").append("\n").append(this.getDatabase().toString());
        if (Ini.isClient()) {
            sb.append("\nAppsServerOK=").append(this.isAppsServerOK(false)).append(", DatabaseOK=").append(this.isDatabaseOK());
        } else {
            sb.append("\nDatabaseOK=").append(this.isDatabaseOK());
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public AdempiereDatabase getDatabase() {
        if (this.m_db != null && !this.m_db.getName().equals(this.m_type)) {
            this.m_db = null;
        }
        if (this.m_db == null) {
            try {
                this.m_db = Database.getDatabase(this.m_type);
                if (this.m_db != null) {
                    this.m_db.getDataSource(this);
                }
            }
            catch (NoClassDefFoundError ee) {
                System.err.println("Environment Error - Check idempiere.properties - " + ee);
                if (Ini.isClient() && JOptionPane.showConfirmDialog(null, "There is a configuration error:\n" + ee + "\nDo you want to reset the saved configuration?", "Adempiere Configuration Error", 0, 0) == 0) {
                    Ini.deletePropertyFile();
                }
                System.exit(1);
            }
            catch (Exception e) {
                log.severe(e.toString());
            }
        }
        return this.m_db;
    }

    public String getConnectionURL() {
        this.getDatabase();
        if (this.m_db != null) {
            return this.m_db.getConnectionURL(this);
        }
        return "";
    }

    public Connection getConnection(boolean autoCommit, int transactionIsolation) {
        Connection conn = null;
        this.m_dbException = null;
        this.m_okDB = false;
        this.getDatabase();
        if (this.m_db == null) {
            this.m_dbException = new IllegalStateException("No Database Connector");
            return null;
        }
        try {
            try {
                conn = this.m_db.getCachedConnection(this, autoCommit, transactionIsolation);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (conn != null) {
                if (conn.getTransactionIsolation() != transactionIsolation) {
                    conn.setTransactionIsolation(transactionIsolation);
                }
                if (conn.getAutoCommit() != autoCommit) {
                    conn.setAutoCommit(autoCommit);
                }
                this.m_okDB = true;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            String msg = String.valueOf(ule.getLocalizedMessage()) + " -> Did you set the LD_LIBRARY_PATH ? - " + this.getConnectionURL();
            this.m_dbException = new Exception(msg);
            log.severe(msg);
        }
        catch (SQLException ex) {
            this.m_dbException = ex;
            if (conn == null) {
                System.err.println(String.valueOf(this.getConnectionURL()) + ", (1) AutoCommit=" + autoCommit + ",TrxIso=" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
            } else {
                try {
                    log.severe(String.valueOf(this.getConnectionURL()) + ", (2) AutoCommit=" + conn.getAutoCommit() + "->" + autoCommit + ", TrxIso=" + CConnection.getTransactionIsolationInfo(conn.getTransactionIsolation()) + "->" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
                }
                catch (Exception ee) {
                    log.severe(String.valueOf(this.getConnectionURL()) + ", (3) AutoCommit=" + autoCommit + ", TrxIso=" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            this.m_dbException = ex;
            System.err.println(String.valueOf(this.getConnectionURL()) + " - " + ex.getLocalizedMessage());
        }
        return conn;
    }

    public Exception getDatabaseException() {
        return this.m_dbException;
    }

    public InitialContext getInitialContext(boolean useCache) {
        return null;
    }

    private boolean queryAppsServerInfo() {
        this.m_okApps = false;
        this.m_queryAppsServer = true;
        if (this.getAppsHost().equalsIgnoreCase("MyAppsServer")) {
            log.warning(String.valueOf(this.getAppsHost()) + " ignored");
            return this.m_okApps;
        }
        Status status = Service.locator().locate(Status.class).getService();
        try {
            this.updateInfoFromServer(status);
            this.m_okApps = true;
        }
        catch (Exception e) {
            this.m_appsException = e;
        }
        return this.m_okApps;
    }

    public synchronized Exception getAppsServerException() {
        return this.m_appsException;
    }

    private void updateInfoFromServer(Status svr) throws Exception {
        if (svr == null) {
            throw new IllegalArgumentException("AppsServer was NULL");
        }
        this.setType(svr.getDbType());
        this.setDbHost(svr.getDbHost());
        this.setDbPort(svr.getDbPort());
        this.setDbName(svr.getDbName());
        this.setDbUid(svr.getDbUid());
        this.setDbPwd(svr.getDbPwd());
        this.setBequeath(false);
        this.setFwHost(svr.getFwHost());
        this.setFwPort(svr.getFwPort());
        if (this.getFwHost() == null || this.getFwHost().length() == 0) {
            this.setViaFirewall(false);
        }
        this.m_version = svr.getDateVersion();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Server=" + this.getDbHost() + ", DB=" + this.getDbName());
        }
    }

    public String convertStatement(String origStatement) throws Exception {
        if (this.m_db != null && !this.m_db.getName().equals(this.m_type)) {
            this.getDatabase();
        }
        if (this.m_db != null) {
            return this.m_db.convertStatement(origStatement);
        }
        throw new Exception("CConnection.convertStatement - No Converstion Database");
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        if (this.m_db != null) {
            sb.append(this.m_db.getStatus());
        }
        return sb.toString();
    }

    public static String getTransactionIsolationInfo(int transactionIsolation) {
        if (transactionIsolation == 0) {
            return "NONE";
        }
        if (transactionIsolation == 2) {
            return "READ_COMMITTED";
        }
        if (transactionIsolation == 1) {
            return "READ_UNCOMMITTED";
        }
        if (transactionIsolation == 4) {
            return "REPEATABLE_READ";
        }
        if (transactionIsolation == 2) {
            return "SERIALIZABLE";
        }
        return "<?" + transactionIsolation + "?>";
    }

    public void setAppServerCredential(String identity, char[] secret) {
        this.securityPrincipal = new SecurityPrincipal();
        this.securityPrincipal.identity = identity;
        this.securityPrincipal.secret = secret;
        this.m_server = null;
    }

    public SecurityPrincipal getAppServerCredential() {
        return this.securityPrincipal;
    }

    public Object clone() throws CloneNotSupportedException {
        CConnection c = (CConnection)super.clone();
        String[] info = new String[]{this.m_info[0], this.m_info[1]};
        c.m_info = info;
        return c;
    }
}

