/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.cm;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.compiere.model.X_CM_BroadcastServer;
import org.compiere.util.CLogger;

public class CacheHandler {
    protected String[] cacheURLs;
    protected CLogger log;

    public CacheHandler(String thisURL, CLogger tLog, Properties ctx, String trxName) {
        int[] theseServers = X_CM_BroadcastServer.getAllIDs("CM_BroadcastServer", "CM_WebProject_ID=0", trxName);
        if (theseServers != null && theseServers.length > 0) {
            String[] thisURLs = new String[theseServers.length];
            int i2 = 0;
            while (i2 < theseServers.length) {
                X_CM_BroadcastServer thisServer = new X_CM_BroadcastServer(ctx, theseServers[i2], trxName);
                thisURLs[i2] = thisServer.getIP_Address();
                ++i2;
            }
            this.cacheURLs = thisURLs;
        } else {
            String[] thisURLs = new String[]{thisURL};
            this.cacheURLs = thisURLs;
        }
        this.log = tLog;
    }

    public CacheHandler(String[] thisURLs, CLogger tLog) {
        this.log = tLog;
        this.cacheURLs = thisURLs;
    }

    public void cleanTemplate(Integer ID) {
        this.cleanTemplate("" + ID);
    }

    public void cleanTemplate(String ID) {
        this.runURLRequest("Template", ID);
    }

    public void emptyTemplate() {
        this.runURLRequest("Template", "0");
    }

    public void cleanContainer(Integer ID) {
        this.cleanContainer("" + ID);
    }

    public void cleanContainer(String ID) {
        this.runURLRequest("Container", ID);
    }

    public void cleanContainerTree(Integer ID) {
        this.cleanContainerTree("" + ID);
    }

    public void cleanContainerTree(String ID) {
        this.runURLRequest("ContainerTree", ID);
    }

    public void cleanContainerElement(Integer ID) {
        this.cleanContainerElement("" + ID);
    }

    public void cleanContainerElement(String ID) {
        this.runURLRequest("ContainerElement", ID);
    }

    private void runURLRequest(String cache, String ID) {
        String thisURL = null;
        int i2 = 0;
        while (i2 < this.cacheURLs.length) {
            block16: {
                try {
                    thisURL = "http://" + this.cacheURLs[i2] + "/cache/Service?Cache=" + cache + "&ID=" + ID;
                    URL url = new URL(thisURL);
                    Proxy thisProxy = Proxy.NO_PROXY;
                    URLConnection urlConn = url.openConnection(thisProxy);
                    urlConn.setUseCaches(false);
                    urlConn.connect();
                    InputStreamReader stream = null;
                    StringBuilder srvOutput = new StringBuilder();
                    try {
                        try {
                            int c;
                            stream = new InputStreamReader(urlConn.getInputStream());
                            while ((c = ((Reader)stream).read()) != -1) {
                                srvOutput.append((char)c);
                            }
                        }
                        catch (Exception E2) {
                            E2.printStackTrace();
                            if (stream == null) break block16;
                            try {
                                ((Reader)stream).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            stream = null;
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                ((Reader)stream).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            stream = null;
                        }
                        throw throwable;
                    }
                    if (stream == null) break block16;
                    try {
                        ((Reader)stream).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stream = null;
                }
                catch (IOException E) {
                    if (this.log == null) break block16;
                    this.log.warning("Can't clean cache at:" + thisURL + " be carefull, your deployment server may use invalid or old cache data!");
                }
            }
            ++i2;
        }
    }

    public static String convertJNPURLToCacheURL(String JNPURL) {
        if (JNPURL.indexOf("jnp://") >= 0) {
            JNPURL = JNPURL.substring(JNPURL.indexOf("jnp://") + 6);
        }
        if (JNPURL.indexOf(58) >= 0) {
            JNPURL = JNPURL.substring(0, JNPURL.indexOf(58));
        }
        if (JNPURL.length() > 0) {
            return JNPURL;
        }
        return null;
    }
}

