/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.util.Env;

public class Doc_Requisition
extends Doc {
    public Doc_Requisition(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MRequisition.class, rs, "POR", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MRequisition req = (MRequisition)this.getPO();
        this.setDateDoc(req.getDateDoc());
        this.setDateAcct(req.getDateDoc());
        this.setAmount(0, req.getTotalLines());
        this.setAmount(1, req.getTotalLines());
        this.p_lines = this.loadLines(req);
        return null;
    }

    private DocLine[] loadLines(MRequisition req) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MRequisitionLine[] lines = req.getLines();
        int i2 = 0;
        while (i2 < lines.length) {
            MRequisitionLine line = lines[i2];
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQty();
            docLine.setQty(Qty, false);
            BigDecimal LineNetAmt = line.getLineNetAmt();
            docLine.setAmount(LineNetAmt);
            list.add(docLine);
            ++i2;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "R");
        this.setC_Currency_ID(as.getC_Currency_ID());
        BigDecimal grossAmt = this.getAmount(0);
        if (as.isCreateReservation()) {
            BigDecimal total = Env.ZERO;
            int i2 = 0;
            while (i2 < this.p_lines.length) {
                DocLine line = this.p_lines[i2];
                BigDecimal cost = line.getAmtSource();
                total = total.add(cost);
                MAccount expense = line.getAccount(2, as);
                fact.createLine(line, expense, as.getC_Currency_ID(), cost, null);
                ++i2;
            }
            MAccount offset = this.getAccount(111, as);
            if (offset == null) {
                this.p_Error = "@NotFound@ @CommitmentOffset_Acct@";
                this.log.log(Level.SEVERE, this.p_Error);
                return null;
            }
            fact.createLine(null, offset, this.getC_Currency_ID(), null, total);
            facts.add(fact);
        }
        return facts;
    }
}

