/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_ProjectIssue
extends Doc {
    private DocLine m_line = null;
    private MProjectIssue m_issue = null;

    public Doc_ProjectIssue(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MProjectIssue.class, rs, "PJI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        this.m_issue = (MProjectIssue)this.getPO();
        this.setDateDoc(this.m_issue.getMovementDate());
        this.setDateAcct(this.m_issue.getMovementDate());
        this.m_line = new DocLine(this.m_issue, this);
        this.m_line.setQty(this.m_issue.getMovementQty(), true);
        if (this.m_line.getM_Product_ID() == 0) {
            this.log.warning(String.valueOf(this.m_line.toString()) + " - No Product");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.m_line.toString());
        }
        return null;
    }

    @Override
    public String getDocumentNo() {
        MProject p2 = this.m_issue.getParent();
        if (p2 != null) {
            StringBuilder msgreturn = new StringBuilder().append(p2.getValue()).append(" #").append(this.m_issue.getLine());
            return msgreturn.toString();
        }
        StringBuilder msgreturn = new StringBuilder("(").append(this.m_issue.get_ID()).append(")");
        return msgreturn.toString();
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        MProject project = new MProject(this.getCtx(), this.m_issue.getC_Project_ID(), this.getTrxName());
        String ProjectCategory = project.getProjectCategory();
        MProduct product = MProduct.get(this.getCtx(), this.m_issue.getM_Product_ID());
        FactLine dr = null;
        FactLine cr = null;
        BigDecimal cost = null;
        if (this.m_issue.getM_InOutLine_ID() != 0) {
            cost = this.getPOCost(as);
        } else if (this.m_issue.getS_TimeExpenseLine_ID() != 0) {
            cost = this.getLaborCost(as);
        }
        if (cost == null) {
            cost = this.m_line.getProductCosts(as, this.getAD_Org_ID(), false);
        }
        int acctType = 62;
        if ("A".equals(ProjectCategory)) {
            acctType = 61;
        }
        dr = fact.createLine(this.m_line, this.getAccount(acctType, as), as.getC_Currency_ID(), cost, null);
        dr.setQty(this.m_line.getQty().negate());
        acctType = 3;
        if (product.isService()) {
            acctType = 2;
        }
        cr = fact.createLine(this.m_line, this.m_line.getAccount(acctType, as), as.getC_Currency_ID(), null, cost);
        cr.setM_Locator_ID(this.m_line.getM_Locator_ID());
        cr.setLocationFromLocator(this.m_line.getM_Locator_ID(), true);
        if (product != null && product.get_ID() > 0 && !product.isService() && product.isStocked()) {
            BigDecimal costDetailQty = this.m_line.getQty();
            BigDecimal costDetailAmt = cost;
            if (!MCostDetail.createProjectIssue(as, this.m_line.getAD_Org_ID(), this.m_line.getM_Product_ID(), this.m_line.getM_AttributeSetInstance_ID(), this.m_line.get_ID(), 0, costDetailAmt, costDetailQty, this.m_line.getDescription(), this.getTrxName())) {
                this.p_Error = "Failed to create cost detail record";
                return null;
            }
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private BigDecimal getPOCost(MAcctSchema as) {
        BigDecimal retValue;
        block9: {
            retValue = null;
            String sql = "SELECT currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateOrdered, o.C_ConversionType_ID, ?, ?) FROM C_OrderLine ol INNER JOIN M_InOutLine iol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID) INNER JOIN C_Order o ON (o.C_Order_ID=ol.C_Order_ID) WHERE iol.M_InOutLine_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.getTrxName());
                    pstmt.setInt(1, as.getC_Currency_ID());
                    pstmt.setInt(2, this.getAD_Client_ID());
                    pstmt.setInt(3, this.getAD_Org_ID());
                    pstmt.setInt(4, this.m_issue.getM_InOutLine_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("POCost = " + retValue);
                        }
                    } else {
                        this.log.warning("Not found for M_InOutLine_ID=" + this.m_issue.getM_InOutLine_ID());
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    pstmt = null;
                    rs = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
        }
        if (retValue != null) {
            retValue = retValue.multiply(this.m_line.getQty());
        }
        return retValue;
    }

    private BigDecimal getLaborCost(MAcctSchema as) {
        BigDecimal retValue;
        block8: {
            retValue = Env.ZERO;
            BigDecimal qty = Env.ZERO;
            String sql = "SELECT ConvertedAmt, Qty FROM S_TimeExpenseLine  WHERE S_TimeExpenseLine.S_TimeExpenseLine_ID = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.getTrxName());
                    pstmt.setInt(1, this.m_issue.getS_TimeExpenseLine_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                        qty = rs.getBigDecimal(2);
                        retValue = retValue.multiply(qty);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("ExpLineCost = " + retValue);
                        }
                    } else {
                        this.log.warning("Not found for S_TimeExpenseLine_ID=" + this.m_issue.getS_TimeExpenseLine_ID());
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    pstmt = null;
                    rs = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
        }
        return retValue;
    }
}

