/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineMA;
import org.compiere.model.MProduct;
import org.compiere.model.ProductCost;
import org.compiere.util.Env;

public class Doc_Movement
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_Movement(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MMovement.class, rs, "MMM", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMovement move = (MMovement)this.getPO();
        this.setDateDoc(move.getMovementDate());
        this.setDateAcct(move.getMovementDate());
        this.m_Reversal_ID = move.getReversal_ID();
        this.m_DocStatus = move.getDocStatus();
        this.p_lines = this.loadLines(move);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    private DocLine[] loadLines(MMovement move) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MMovementLine[] lines = move.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MMovementLine line = lines[i];
            DocLine docLine = new DocLine(line, this);
            docLine.setQty(line.getMovementQty(), false);
            docLine.setReversalLine_ID(line.getReversalLine_ID());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(docLine.toString());
            }
            list.add(docLine);
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        int i = 0;
        while (i < this.p_lines.length) {
            DocLine line = this.p_lines[i];
            BigDecimal costs = null;
            if (!this.isReversal(line)) {
                MProduct product = line.getProduct();
                String costingLevel = product.getCostingLevel(as);
                if ("B".equals(costingLevel)) {
                    if (line.getM_AttributeSetInstance_ID() == 0) {
                        MMovementLine mLine = (MMovementLine)line.getPO();
                        MMovementLineMA[] mas = MMovementLineMA.get(this.getCtx(), mLine.get_ID(), this.getTrxName());
                        if (mas != null && mas.length > 0) {
                            costs = BigDecimal.ZERO;
                            int j = 0;
                            while (j < mas.length) {
                                MMovementLineMA ma = mas[j];
                                BigDecimal QtyMA = ma.getMovementQty();
                                ProductCost pc = line.getProductCost();
                                pc.setQty(QtyMA);
                                pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                BigDecimal maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_MovementLine_ID=? AND IsSOTrx='N'");
                                costs = costs.add(maCosts);
                                ++j;
                            }
                        }
                    } else {
                        costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_MovementLine_ID=? AND IsSOTrx='N'");
                    }
                } else {
                    costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_MovementLine_ID=? AND IsSOTrx='N'");
                }
            } else {
                costs = BigDecimal.ZERO;
            }
            if ((dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs.negate())) != null) {
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setQty(line.getQty().negate());
                if (this.isReversal(line) && !dr.updateReverseLine(323, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                    this.p_Error = "Original Inventory Move not posted yet";
                    return null;
                }
                cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs);
                if (cr != null) {
                    String costingLevel;
                    cr.setM_Locator_ID(line.getM_LocatorTo_ID());
                    cr.setQty(line.getQty());
                    if (this.isReversal(line)) {
                        if (!cr.updateReverseLine(323, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                            this.p_Error = "Original Inventory Move not posted yet";
                            return null;
                        }
                        costs = cr.getAcctBalance();
                    }
                    if (dr.getAD_Org_ID() != cr.getAD_Org_ID() && "O".equals(costingLevel = line.getProduct().getCostingLevel(as))) {
                        String description = line.getDescription();
                        if (description == null) {
                            description = "";
                        }
                        if (!MCostDetail.createMovement(as, dr.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs.negate(), line.getQty().negate(), true, String.valueOf(description) + "(|->)", this.getTrxName())) {
                            this.p_Error = "Failed to create cost detail record";
                            return null;
                        }
                        if (!MCostDetail.createMovement(as, cr.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), false, String.valueOf(description) + "(|<-)", this.getTrxName())) {
                            this.p_Error = "Failed to create cost detail record";
                            return null;
                        }
                    }
                }
            }
            ++i;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private boolean isReversal(DocLine line) {
        return this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0;
    }
}

