/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MOrderLandedCostAllocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class Doc_InOut
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_InOut(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MInOut.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MInOut inout = (MInOut)this.getPO();
        this.setDateDoc(inout.getMovementDate());
        this.m_Reversal_ID = inout.getReversal_ID();
        this.m_DocStatus = inout.getDocStatus();
        this.p_lines = this.loadLines(inout);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    private DocLine[] loadLines(MInOut inout) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInOutLine[] lines = inout.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInOutLine line = lines[i];
            if (line.isDescription() || line.getM_Product_ID() == 0 || line.getMovementQty().signum() == 0) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Ignored: " + line);
                }
            } else {
                DocLine docLine = new DocLine(line, this);
                BigDecimal Qty = line.getMovementQty();
                docLine.setReversalLine_ID(line.getReversalLine_ID());
                docLine.setQty(Qty, this.getDocumentType().equals("MMS"));
                String sql = "SELECT PP_Cost_Collector_ID  FROM C_OrderLine WHERE C_OrderLine_ID=? AND PP_Cost_Collector_ID IS NOT NULL";
                int PP_Cost_Collector_ID = DB.getSQLValueEx(this.getTrxName(), sql, line.getC_OrderLine_ID());
                docLine.setPP_Cost_Collector_ID(PP_Cost_Collector_ID);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(docLine.toString());
                }
                list.add(docLine);
            }
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        block99: {
            block106: {
                block104: {
                    block100: {
                        block96: {
                            facts = new ArrayList<Fact>();
                            fact = new Fact(this, as, "A");
                            this.setC_Currency_ID(as.getC_Currency_ID());
                            dr = null;
                            cr = null;
                            if (!this.getDocumentType().equals("MMS") || !this.isSOTrx()) break block96;
                            i = 0;
                            while (i < this.p_lines.length) {
                                block98: {
                                    block97: {
                                        line = this.p_lines[i];
                                        product = line.getProduct();
                                        costs = null;
                                        if (this.isReversal(line)) ** GOTO lbl-1000
                                        if ("B".equals(product.getCostingLevel(as))) {
                                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                                ioLine = (MInOutLine)line.getPO();
                                                mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                                if (mas != null && mas.length > 0) {
                                                    costs = BigDecimal.ZERO;
                                                    j = 0;
                                                    while (j < mas.length) {
                                                        ma = mas[j];
                                                        QtyMA = ma.getMovementQty();
                                                        pc = line.getProductCost();
                                                        pc.setQty(QtyMA);
                                                        pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                                        maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                                        costs = costs.add(maCosts);
                                                        ++j;
                                                    }
                                                }
                                            } else {
                                                costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                            }
                                        } else {
                                            costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                        }
                                        if (costs != null && costs.signum() != 0) break block97;
                                        if (product.isStocked()) {
                                            count = DB.getSQLValue(null, "SELECT Count(*) FROM M_CostDetail WHERE M_Product_ID=? AND Processed='Y' AND Amt=0.00 AND Qty > 0 AND (C_OrderLine_ID > 0 OR C_InvoiceLine_ID > 0)", product.getM_Product_ID());
                                            if (count > 0) {
                                                costs = BigDecimal.ZERO;
                                            } else {
                                                this.p_Error = "No Costs for " + line.getProduct().getName();
                                                this.log.log(Level.WARNING, this.p_Error);
                                                return null;
                                            }
                                        }
                                        break block98;
lbl-1000:
                                        // 1 sources

                                        {
                                            costs = BigDecimal.ZERO;
                                        }
                                    }
                                    if ((dr = fact.createLine(line, line.getAccount(4, as), as.getC_Currency_ID(), costs, null)) == null) {
                                        this.p_Error = "FactLine DR not created: " + line;
                                        this.log.log(Level.WARNING, this.p_Error);
                                        return null;
                                    }
                                    dr.setM_Locator_ID(line.getM_Locator_ID());
                                    dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                    dr.setAD_Org_ID(line.getOrder_Org_ID());
                                    dr.setQty(line.getQty().negate());
                                    if (!this.isReversal(line) || dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl61
                                    if (!product.isStocked()) {
                                        fact.remove(dr);
                                    } else {
                                        this.p_Error = "Original Shipment/Receipt not posted yet";
                                        return null;
lbl61:
                                        // 1 sources

                                        cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), null, costs);
                                        if (cr == null) {
                                            this.p_Error = "FactLine CR not created: " + line;
                                            this.log.log(Level.WARNING, this.p_Error);
                                            return null;
                                        }
                                        cr.setM_Locator_ID(line.getM_Locator_ID());
                                        cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                        cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                        if (this.isReversal(line)) {
                                            if (!cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                                                this.p_Error = "Original Shipment/Receipt not posted yet";
                                                return null;
                                            }
                                            costs = cr.getAcctBalance();
                                        }
                                        if ("B".equals(product.getCostingLevel(as))) {
                                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                                ioLine = (MInOutLine)line.getPO();
                                                mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                                if (mas != null && mas.length > 0) {
                                                    j = 0;
                                                    while (j < mas.length) {
                                                        ma = mas[j];
                                                        if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, ma.getMovementQty().negate(), line.getDescription(), true, this.getTrxName())) {
                                                            this.p_Error = "Failed to create cost detail record";
                                                            return null;
                                                        }
                                                        ++j;
                                                    }
                                                }
                                            } else if (line.getM_Product_ID() != 0 && !MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                                this.p_Error = "Failed to create cost detail record";
                                                return null;
                                            }
                                        } else if (line.getM_Product_ID() != 0 && !MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                            this.p_Error = "Failed to create cost detail record";
                                            return null;
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (as.isAccrual() && as.isCreateSOCommitment()) {
                                i = 0;
                                while (i < this.p_lines.length) {
                                    line = this.p_lines[i];
                                    factcomm = Doc_Order.getCommitmentSalesRelease(as, this, line.getQty(), line.get_ID(), Env.ONE);
                                    if (factcomm != null) {
                                        facts.add(factcomm);
                                    }
                                    ++i;
                                }
                            }
                            break block99;
                        }
                        if (!this.getDocumentType().equals("MMR") || !this.isSOTrx()) break block100;
                        i = 0;
                        while (i < this.p_lines.length) {
                            block103: {
                                block102: {
                                    block101: {
                                        line = this.p_lines[i];
                                        product = line.getProduct();
                                        costs = null;
                                        if (this.isReversal(line)) break block101;
                                        if ("B".equals(product.getCostingLevel(as))) {
                                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                                ioLine = (MInOutLine)line.getPO();
                                                mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                                costs = BigDecimal.ZERO;
                                                if (mas != null && mas.length > 0) {
                                                    j = 0;
                                                    while (j < mas.length) {
                                                        ma = mas[j];
                                                        QtyMA = ma.getMovementQty();
                                                        pc = line.getProductCost();
                                                        pc.setQty(QtyMA);
                                                        pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                                        maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                                        costs = costs.add(maCosts);
                                                        ++j;
                                                    }
                                                }
                                            } else {
                                                costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                            }
                                        } else {
                                            costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                        }
                                        if (costs != null && costs.signum() != 0) break block102;
                                        if (product.isStocked()) {
                                            this.p_Error = "No Costs for " + line.getProduct().getName();
                                            this.log.log(Level.WARNING, this.p_Error);
                                            return null;
                                        }
                                        break block103;
                                    }
                                    costs = BigDecimal.ZERO;
                                }
                                if ((dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs, null)) == null) {
                                    this.p_Error = "FactLine DR not created: " + line;
                                    this.log.log(Level.WARNING, this.p_Error);
                                    return null;
                                }
                                dr.setM_Locator_ID(line.getM_Locator_ID());
                                dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                if (!this.isReversal(line)) ** GOTO lbl162
                                if (dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl161
                                if (!product.isStocked()) {
                                    fact.remove(dr);
                                } else {
                                    this.p_Error = "Original Shipment/Receipt not posted yet";
                                    return null;
lbl161:
                                    // 1 sources

                                    costs = dr.getAcctBalance();
lbl162:
                                    // 2 sources

                                    if ("B".equals(product.getCostingLevel(as))) {
                                        if (line.getM_AttributeSetInstance_ID() == 0) {
                                            ioLine = (MInOutLine)line.getPO();
                                            mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                            if (mas != null && mas.length > 0) {
                                                j = 0;
                                                while (j < mas.length) {
                                                    ma = mas[j];
                                                    if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, ma.getMovementQty(), line.getDescription(), true, this.getTrxName())) {
                                                        this.p_Error = "Failed to create cost detail record";
                                                        return null;
                                                    }
                                                    ++j;
                                                }
                                            }
                                        } else if (line.getM_Product_ID() != 0 && !MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                            this.p_Error = "Failed to create cost detail record";
                                            return null;
                                        }
                                    } else if (line.getM_Product_ID() != 0 && !MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                        this.p_Error = "Failed to create cost detail record";
                                        return null;
                                    }
                                    if ((cr = fact.createLine(line, line.getAccount(4, as), as.getC_Currency_ID(), null, costs)) == null) {
                                        this.p_Error = "FactLine CR not created: " + line;
                                        this.log.log(Level.WARNING, this.p_Error);
                                        return null;
                                    }
                                    cr.setM_Locator_ID(line.getM_Locator_ID());
                                    cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                    cr.setAD_Org_ID(line.getOrder_Org_ID());
                                    cr.setQty(line.getQty().negate());
                                    if (this.isReversal(line) && !cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                                        this.p_Error = "Original Shipment/Receipt not posted yet";
                                        return null;
                                    }
                                }
                            }
                            ++i;
                        }
                        break block99;
                    }
                    if (!this.getDocumentType().equals("MMR") || this.isSOTrx()) break block104;
                    i = 0;
                    while (i < this.p_lines.length) {
                        block105: {
                            C_Currency_ID = as.getC_Currency_ID();
                            line = this.p_lines[i];
                            costs = null;
                            product = line.getProduct();
                            orderLine = null;
                            landedCost = BigDecimal.ZERO;
                            costingMethod = product.getCostingMethod(as);
                            if (this.isReversal(line)) ** GOTO lbl-1000
                            C_OrderLine_ID = line.getC_OrderLine_ID();
                            if (C_OrderLine_ID > 0) {
                                orderLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.getTrxName());
                                var19_60 = allocations = MOrderLandedCostAllocation.getOfOrderLine(C_OrderLine_ID, this.getTrxName());
                                var18_57 = allocations.length;
                                var17_53 = 0;
                                while (var17_53 < var18_57) {
                                    allocation = var19_60[var17_53];
                                    totalAmt = allocation.getAmt();
                                    totalQty = allocation.getQty();
                                    amt = totalAmt.multiply(line.getQty()).divide(totalQty, RoundingMode.HALF_UP);
                                    landedCost = landedCost.add(amt);
                                    ++var17_53;
                                }
                            }
                            if (!"A".equals(costingMethod) && !"I".equals(costingMethod) && !"p".equals(costingMethod) && (!"S".equals(costingMethod) || !"B".equals(product.getCostingLevel(as)))) ** GOTO lbl243
                            if (orderLine != null) {
                                C_Currency_ID = orderLine.getC_Currency_ID();
                                costs = orderLine.getPriceCost();
                                if (costs == null || costs.signum() == 0) {
                                    costs = orderLine.getPriceActual();
                                    C_Tax_ID = orderLine.getC_Tax_ID();
                                    if (orderLine.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                                        stdPrecision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
                                        costTax = tax.calculateTax(costs, true, stdPrecision);
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine("Costs=" + costs + " - Tax=" + costTax);
                                        }
                                        costs = costs.subtract(costTax);
                                    }
                                }
                                costs = costs.multiply(line.getQty());
                            } else {
                                this.p_Error = "Resubmit - No Costs for " + product.getName() + " (required order line)";
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
lbl243:
                                // 1 sources

                                costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                            }
                            if (costs == null || costs.signum() == 0) {
                                if (orderLine != null && orderLine.getPriceActual().signum() == 0) {
                                    costs = BigDecimal.ZERO;
                                } else {
                                    this.p_Error = "Resubmit - No Costs for " + product.getName();
                                    this.log.log(Level.WARNING, this.p_Error);
                                    return null;
                                }
                            }
                            break block105;
lbl-1000:
                            // 1 sources

                            {
                                costs = BigDecimal.ZERO;
                            }
                        }
                        assets = line.getAccount(3, as);
                        if (product.isService()) {
                            assets = line.getPP_Cost_Collector_ID() > 0 ? line.getAccount(11, as) : line.getAccount(2, as);
                        }
                        drAsset = costs;
                        if (landedCost.signum() != 0 && ("I".equals(costingMethod) || "A".equals(costingMethod))) {
                            drAsset = drAsset.add(landedCost);
                        }
                        if ((dr = fact.createLine(line, assets, C_Currency_ID, drAsset, null)) == null) {
                            this.p_Error = "DR not created: " + line;
                            this.log.log(Level.WARNING, this.p_Error);
                            return null;
                        }
                        dr.setM_Locator_ID(line.getM_Locator_ID());
                        dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                        dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                        if (!this.isReversal(line) || dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl273
                        if (!product.isStocked()) {
                            fact.remove(dr);
                        } else {
                            this.p_Error = "Original Receipt not posted yet";
                            return null;
lbl273:
                            // 1 sources

                            cr = fact.createLine(line, this.getAccount(51, as), C_Currency_ID, null, costs);
                            if (cr == null) {
                                this.p_Error = "CR not created: " + line;
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
                            }
                            cr.setM_Locator_ID(line.getM_Locator_ID());
                            cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                            cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                            cr.setQty(line.getQty().negate());
                            if (this.isReversal(line) && !cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                                this.p_Error = "Original Receipt not posted yet";
                                return null;
                            }
                            if (!fact.isAcctBalanced()) {
                                if (this.isReversal(line)) {
                                    dr = fact.createLine(line, line.getAccount(24, as), C_Currency_ID, Env.ONE, null);
                                    if (!dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                                        this.p_Error = "Original Receipt not posted yet";
                                        return null;
                                    }
                                } else if (landedCost.signum() != 0) {
                                    cr = fact.createLine(line, line.getAccount(24, as), C_Currency_ID, null, landedCost);
                                    if (cr == null) {
                                        this.p_Error = "CR not created: " + line;
                                        this.log.log(Level.WARNING, this.p_Error);
                                        return null;
                                    }
                                    cr.setM_Locator_ID(line.getM_Locator_ID());
                                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                                    cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                                    cr.setQty(line.getQty().negate());
                                }
                            }
                        }
                        ++i;
                    }
                    break block99;
                }
                if (!this.getDocumentType().equals("MMS") || this.isSOTrx()) break block106;
                i = 0;
                while (i < this.p_lines.length) {
                    C_Currency_ID = as.getC_Currency_ID();
                    line = this.p_lines[i];
                    costs = null;
                    product = line.getProduct();
                    if (!this.isReversal(line)) {
                        ioLine = (MInOutLine)line.getPO();
                        rmaLine = ioLine.getM_RMALine();
                        costs = rmaLine != null ? rmaLine.getAmt() : BigDecimal.ZERO;
                        v0 = originalInOutLine = rmaLine != null ? rmaLine.getM_InOutLine() : null;
                        if (originalInOutLine != null && originalInOutLine.getC_OrderLine_ID() > 0) {
                            originalOrderLine = (MOrderLine)originalInOutLine.getC_OrderLine();
                            C_Tax_ID = originalOrderLine.getC_Tax_ID();
                            if (originalOrderLine.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                                stdPrecision = MCurrency.getStdPrecision(this.getCtx(), originalOrderLine.getC_Currency_ID());
                                costTax = tax.calculateTax(costs, true, stdPrecision);
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("Costs=" + costs + " - Tax=" + costTax);
                                }
                                costs = costs.subtract(costTax);
                            }
                            if (C_Currency_ID != originalOrderLine.getC_Currency_ID()) {
                                costs = MConversionRate.convert(this.getCtx(), costs, originalOrderLine.getC_Currency_ID(), C_Currency_ID, this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID(), true);
                            }
                            costs = costs.multiply(line.getQty());
                            costs = costs.negate();
                        } else {
                            if ("B".equals(product.getCostingLevel(as))) {
                                if (line.getM_AttributeSetInstance_ID() == 0) {
                                    mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                    costs = BigDecimal.ZERO;
                                    if (mas != null && mas.length > 0) {
                                        j = 0;
                                        while (j < mas.length) {
                                            ma = mas[j];
                                            QtyMA = ma.getMovementQty();
                                            pc = line.getProductCost();
                                            pc.setQty(QtyMA);
                                            pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                            maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                            costs = costs.add(maCosts);
                                            ++j;
                                        }
                                    }
                                } else {
                                    costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                                }
                            } else {
                                costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                            }
                            if (costs == null || costs.signum() == 0) {
                                this.p_Error = "Resubmit - No Costs for " + product.getName();
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
                            }
                        }
                    } else {
                        costs = Env.ONE;
                    }
                    dr = fact.createLine(line, this.getAccount(51, as), C_Currency_ID, costs, null);
                    if (dr == null) {
                        this.p_Error = "CR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                    dr.setQty(line.getQty().negate());
                    if (!this.isReversal(line) || dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl373
                    if (!product.isStocked()) {
                        fact.remove(dr);
                    } else {
                        this.p_Error = "Original Receipt not posted yet";
                        return null;
lbl373:
                        // 1 sources

                        assets = line.getAccount(3, as);
                        if (product.isService()) {
                            assets = line.getAccount(2, as);
                        }
                        if ((cr = fact.createLine(line, assets, C_Currency_ID, null, costs)) == null) {
                            this.p_Error = "DR not created: " + line;
                            this.log.log(Level.WARNING, this.p_Error);
                            return null;
                        }
                        cr.setM_Locator_ID(line.getM_Locator_ID());
                        cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                        cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                        if (this.isReversal(line) && !cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                            this.p_Error = "Original Receipt not posted yet";
                            return null;
                        }
                        costingError = this.createVendorRMACostDetail(as, line, costs);
                        if (!Util.isEmpty(costingError)) {
                            this.p_Error = costingError;
                            return null;
                        }
                    }
                    ++i;
                }
                break block99;
            }
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        facts.add(fact);
        return facts;
    }

    private boolean isReversal(DocLine line) {
        return this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0;
    }

    private String createVendorRMACostDetail(MAcctSchema as, DocLine line, BigDecimal costs) {
        MProduct product;
        BigDecimal tQty = line.getQty();
        BigDecimal tAmt = costs;
        if (tAmt.signum() != tQty.signum()) {
            tAmt = tAmt.negate();
        }
        if ("B".equals((product = line.getProduct()).getCostingLevel(as))) {
            if (line.getM_AttributeSetInstance_ID() == 0) {
                MInOutLineMA[] mas = MInOutLineMA.get(this.getCtx(), line.get_ID(), this.getTrxName());
                if (mas != null && mas.length > 0) {
                    int j = 0;
                    while (j < mas.length) {
                        MInOutLineMA ma = mas[j];
                        if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, tAmt, ma.getMovementQty().negate(), line.getDescription(), false, this.getTrxName())) {
                            return "SaveError";
                        }
                        ++j;
                    }
                }
            } else if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, tAmt, tQty, line.getDescription(), false, this.getTrxName())) {
                return "SaveError";
            }
        } else if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, tAmt, tQty, line.getDescription(), false, this.getTrxName())) {
            return "SaveError";
        }
        return "";
    }
}

