/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.acct.FactUtil;
import org.compiere.model.I_C_Project;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MCharge;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AssetAddition
extends Doc {
    public Doc_AssetAddition(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MAssetAddition.class, rs, "GLD", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        MAssetAddition assetAdd = this.getAssetAddition();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, assetAdd.getPostingType());
        facts.add(fact);
        if ("IMP".equals(assetAdd.getA_SourceType()) || "Exp".equals(assetAdd.getA_CapvsExp())) {
            return facts;
        }
        BigDecimal assetValueAmt = assetAdd.getAssetValueAmt();
        FactLine[] fls = FactUtil.createSimpleOperation(fact, null, this.getA_Asset_Acct(), this.getP_Asset_Acct(as), as.getC_Currency_ID(), assetValueAmt, false);
        int invoiceBP_ID = this.getInvoicePartner_ID();
        int invoiceProject_ID = this.getInvoiceProject_ID();
        if (invoiceBP_ID > 0) {
            fls[1].setC_BPartner_ID(invoiceBP_ID);
        }
        if (invoiceProject_ID > 0) {
            fls[1].setC_Project_ID(invoiceProject_ID);
        }
        return facts;
    }

    private MAssetAddition getAssetAddition() {
        return (MAssetAddition)this.getPO();
    }

    private MAccount getP_Asset_Acct(MAcctSchema as) {
        MAssetAddition assetAdd = this.getAssetAddition();
        MAccount pAssetAcct = null;
        if ("PRJ".equals(assetAdd.getA_SourceType())) {
            I_C_Project prj = assetAdd.getC_Project();
            return this.getProjectAcct(prj, as);
        }
        if ("MAN".equals(assetAdd.getA_SourceType()) && this.getC_Charge_ID() > 0) {
            pAssetAcct = MCharge.getAccount(this.getC_Charge_ID(), as);
            return pAssetAcct;
        }
        if ("INV".equals(assetAdd.getA_SourceType()) && assetAdd.getC_InvoiceLine().getC_Project_ID() > 0) {
            I_C_Project prj = assetAdd.getC_InvoiceLine().getC_Project();
            return this.getProjectAcct(prj, as);
        }
        pAssetAcct = this.getP_Expense_Acct(assetAdd.getM_Product_ID(), as);
        return pAssetAcct;
    }

    public MAccount getP_Expense_Acct(int M_Product_ID, MAcctSchema as) {
        ProductCost pc = new ProductCost(this.getCtx(), M_Product_ID, 0, null);
        return pc.getAccount(2, as);
    }

    private MAccount getProjectAcct(I_C_Project prj, MAcctSchema as) {
        String projectCategory = prj.getProjectCategory();
        String acctName = "PJ_WIP_Acct";
        if ("A".equals(projectCategory)) {
            acctName = "PJ_Asset_Acct";
        }
        String sql = "SELECT " + acctName + " FROM " + "C_Project_Acct" + " WHERE " + "C_Project_ID" + "=?" + " AND " + "C_AcctSchema_ID" + "=?";
        int acct_id = DB.getSQLValueEx(this.getTrxName(), sql, prj.getC_Project_ID(), as.get_ID());
        return MAccount.get(this.getCtx(), acct_id);
    }

    private MAccount getA_Asset_Acct() {
        MAssetAddition assetAdd = this.getAssetAddition();
        int acct_id = MAssetAcct.forA_Asset_ID(this.getCtx(), assetAdd.getA_Asset_ID(), assetAdd.getPostingType(), assetAdd.getDateAcct(), null).getA_Asset_Acct();
        return MAccount.get(this.getCtx(), acct_id);
    }

    public int getInvoicePartner_ID() {
        MAssetAddition assetAdd = this.getAssetAddition();
        if ("INV".equals(assetAdd.getA_SourceType()) && assetAdd.getC_Invoice_ID() > 0) {
            return assetAdd.getC_Invoice().getC_BPartner_ID();
        }
        return 0;
    }

    public int getInvoiceProject_ID() {
        MAssetAddition assetAdd = this.getAssetAddition();
        if ("INV".equals(assetAdd.getA_SourceType()) && assetAdd.getC_Invoice_ID() > 0) {
            return assetAdd.getC_InvoiceLine().getC_Project_ID();
        }
        return 0;
    }
}

