/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Allocation;
import org.compiere.acct.Doc_AllocationTax;
import org.compiere.acct.Doc_Invoice;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MCashLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AllocationHdr
extends Doc {
    private static final BigDecimal TOLERANCE = BigDecimal.valueOf(0.02);
    private ArrayList<Fact> m_facts = null;

    public Doc_AllocationHdr(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MAllocationHdr.class, rs, "CMA", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MAllocationHdr alloc = (MAllocationHdr)this.getPO();
        this.setDateDoc(alloc.getDateTrx());
        this.p_lines = this.loadLines(alloc);
        return null;
    }

    private DocLine[] loadLines(MAllocationHdr alloc) {
        ArrayList<DocLine_Allocation> list = new ArrayList<DocLine_Allocation>();
        MAllocationLine[] lines = alloc.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MAllocationLine line = lines[i2];
            DocLine_Allocation docLine = new DocLine_Allocation(line, (Doc)this);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(docLine.toString());
            }
            list.add(docLine);
            ++i2;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        this.m_facts = new ArrayList();
        Fact fact = new Fact(this, as, "A");
        Fact factForRGL = new Fact(this, as, "A");
        boolean isInterOrg = this.isInterOrg(as);
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            block50: {
                X_C_Invoice invoice;
                MPayment payment;
                MAccount payAcct;
                MAccount bpAcct;
                BigDecimal allocationAccounted;
                BigDecimal allocationSource;
                DocLine_Allocation line;
                block53: {
                    FactLine flForRGL;
                    FactLine fl;
                    BigDecimal allocationAccountedForRGL;
                    BigDecimal allocationSourceForRGL;
                    block54: {
                        block51: {
                            block52: {
                                line = (DocLine_Allocation)this.p_lines[i2];
                                this.setC_BPartner_ID(line.getC_BPartner_ID());
                                if (line.getC_Payment_ID() != 0 && line.getC_Invoice_ID() == 0 && line.getC_Order_ID() == 0 && line.getC_CashLine_ID() == 0 && line.getC_BPartner_ID() == 0 && Env.ZERO.compareTo(line.getDiscountAmt()) == 0 && Env.ZERO.compareTo(line.getWriteOffAmt()) == 0) break block50;
                                allocationSourceForRGL = allocationSource = line.getAmtSource().add(line.getDiscountAmt()).add(line.getWriteOffAmt());
                                allocationAccounted = Env.ZERO;
                                allocationAccountedForRGL = Env.ZERO;
                                fl = null;
                                flForRGL = null;
                                bpAcct = null;
                                payAcct = null;
                                payment = null;
                                if (line.getC_Payment_ID() != 0) {
                                    payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                                }
                                invoice = null;
                                if (line.getC_Invoice_ID() != 0) {
                                    invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                                }
                                if (invoice != null) break block51;
                                if (line.getC_Invoice_ID() != 0 || line.getC_Payment_ID() != 0 || line.getC_Charge_ID() == 0) break block52;
                                fl = fact.createLine(line, line.getChargeAccount(as, line.getAmtSource()), this.getC_Currency_ID(), line.getAmtSource());
                                break block53;
                            }
                            if (line.getC_Invoice_ID() == 0 && line.getC_Payment_ID() != 0) {
                                fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                                if (fl != null && payment != null) {
                                    fl.setAD_Org_ID(payment.getAD_Org_ID());
                                }
                                break block53;
                            } else {
                                this.p_Error = "Cannot determine SO/PO";
                                this.log.log(Level.SEVERE, this.p_Error);
                                return null;
                            }
                        }
                        if (!invoice.isSOTrx()) break block54;
                        MAccount acct_unallocated_cash = null;
                        if (line.getC_Payment_ID() != 0) {
                            acct_unallocated_cash = this.getPaymentAcct(as, line.getC_Payment_ID());
                        } else if (line.getC_CashLine_ID() != 0) {
                            acct_unallocated_cash = this.getCashAcct(as, line.getC_CashLine_ID());
                        }
                        MAccount acct_receivable = this.getAccount(1, as);
                        if (!as.isPostIfClearingEqual() && acct_unallocated_cash != null && acct_unallocated_cash.equals(acct_receivable) && !isInterOrg) {
                            allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                        } else if (line.getC_Payment_ID() != 0) {
                            payAcct = this.getPaymentAcct(as, line.getC_Payment_ID());
                            fl = fact.createLine((DocLine)line, payAcct, this.getC_Currency_ID(), line.getAmtSource(), null);
                            if (fl != null && payment != null) {
                                fl.setAD_Org_ID(payment.getAD_Org_ID());
                            }
                        } else if (line.getC_CashLine_ID() != 0) {
                            fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                            MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                            if (fl != null && cashLine.get_ID() != 0) {
                                fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                            }
                        }
                        if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(30, as), this.getC_Currency_ID(), line.getDiscountAmt(), null)) != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                        if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), line.getWriteOffAmt(), null)) != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                        if (as.isAccrual()) {
                            bpAcct = this.getAccount(1, as);
                            fl = fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSource);
                            if (fl != null) {
                                allocationAccounted = fl.getAcctBalance().negate();
                            }
                            if (fl != null && invoice != null) {
                                fl.setAD_Org_ID(invoice.getAD_Org_ID());
                            }
                            if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSourceForRGL)) != null) {
                                allocationAccountedForRGL = flForRGL.getAcctBalance().negate();
                            }
                            break block53;
                        } else {
                            allocationAccountedForRGL = allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                        }
                        break block53;
                    }
                    MAccount acct_payment_select = null;
                    if (line.getC_Payment_ID() != 0) {
                        acct_payment_select = this.getPaymentAcct(as, line.getC_Payment_ID());
                    } else if (line.getC_CashLine_ID() != 0) {
                        acct_payment_select = this.getCashAcct(as, line.getC_CashLine_ID());
                    }
                    MAccount acct_liability = this.getAccount(2, as);
                    boolean isUsingClearing = true;
                    allocationSourceForRGL = allocationSourceForRGL.negate();
                    if (!as.isPostIfClearingEqual() && acct_payment_select != null && acct_payment_select.equals(acct_liability) && !isInterOrg) {
                        allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                        isUsingClearing = false;
                    }
                    allocationSource = allocationSource.negate();
                    if (as.isAccrual()) {
                        bpAcct = this.getAccount(2, as);
                        fl = fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSource, null);
                        if (fl != null) {
                            allocationAccounted = fl.getAcctBalance();
                        }
                        if (fl != null && invoice != null) {
                            fl.setAD_Org_ID(invoice.getAD_Org_ID());
                        }
                        if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSourceForRGL, null)) != null) {
                            allocationAccountedForRGL = flForRGL.getAcctBalance();
                        }
                    } else {
                        allocationAccountedForRGL = allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                    }
                    if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(31, as), this.getC_Currency_ID(), null, line.getDiscountAmt().negate())) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), null, line.getWriteOffAmt().negate())) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (isUsingClearing && line.getC_Payment_ID() != 0) {
                        payAcct = this.getPaymentAcct(as, line.getC_Payment_ID());
                        fl = fact.createLine((DocLine)line, payAcct, this.getC_Currency_ID(), null, line.getAmtSource().negate());
                        if (fl != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                    } else if (isUsingClearing && line.getC_CashLine_ID() != 0) {
                        fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), null, line.getAmtSource().negate());
                        MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                        if (fl != null && cashLine.get_ID() != 0) {
                            fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                        }
                    }
                }
                if (invoice != null && as.isTaxCorrection()) {
                    BigDecimal taxCorrectionAmt = Env.ZERO;
                    if (as.isTaxCorrectionDiscount()) {
                        taxCorrectionAmt = line.getDiscountAmt();
                    }
                    if (as.isTaxCorrectionWriteOff()) {
                        taxCorrectionAmt = taxCorrectionAmt.add(line.getWriteOffAmt());
                    }
                    if (taxCorrectionAmt.signum() != 0 && !this.createTaxCorrection(as, fact, line, this.getAccount(invoice.isSOTrx() ? 30 : 31, as), this.getAccount(32, as), invoice.isSOTrx())) {
                        this.p_Error = "Cannot create Tax correction";
                        return null;
                    }
                }
                if (invoice != null && (this.getC_Currency_ID() != as.getC_Currency_ID() || this.getC_Currency_ID() != line.getInvoiceC_Currency_ID())) {
                    this.p_Error = this.createRealizedGainLoss(line, as, fact, bpAcct, (MInvoice)invoice, payAcct, payment, allocationSource, allocationAccounted);
                    if (this.p_Error != null) {
                        return null;
                    }
                }
            }
            ++i2;
        }
        if (!as.isPostIfClearingEqual() && this.p_lines.length > 0 && !isInterOrg) {
            boolean allEquals = true;
            FactLine[] factlines = fact.getLines();
            BigDecimal netBalance = Env.ZERO;
            FactLine prevFactLine = null;
            FactLine[] factLineArray = factlines;
            int n = factlines.length;
            int n2 = 0;
            while (n2 < n) {
                FactLine factLine = factLineArray[n2];
                netBalance = netBalance.add(factLine.getAmtSourceDr()).subtract(factLine.getAmtSourceCr());
                if (prevFactLine != null && !this.equalFactLineIDs(prevFactLine, factLine)) {
                    allEquals = false;
                    break;
                }
                prevFactLine = factLine;
                ++n2;
            }
            if (netBalance.compareTo(Env.ZERO) == 0 && allEquals) {
                factLineArray = factlines;
                n = factlines.length;
                n2 = 0;
                while (n2 < n) {
                    FactLine factline = factLineArray[n2];
                    fact.remove(factline);
                    ++n2;
                }
            }
        }
        this.setC_BPartner_ID(0);
        this.m_facts.add(fact);
        return this.m_facts;
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        if (this.p_lines.length <= 0) {
            return false;
        }
        int startorg = this.p_lines[0].getAD_Org_ID();
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            DocLine_Allocation line = (DocLine_Allocation)this.p_lines[i2];
            int orgpayment = startorg;
            MPayment payment = null;
            if (line.getC_Payment_ID() != 0) {
                payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                orgpayment = payment.getAD_Org_ID();
            }
            int orginvoice = startorg;
            MInvoice invoice = null;
            if (line.getC_Invoice_ID() != 0) {
                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                orginvoice = invoice.getAD_Org_ID();
            }
            int orgcashline = startorg;
            MCashLine cashline = null;
            if (line.getC_CashLine_ID() != 0) {
                cashline = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                orgcashline = cashline.getAD_Org_ID();
            }
            int orgorder = startorg;
            MOrder order = null;
            if (line.getC_Order_ID() != 0) {
                order = new MOrder(this.getCtx(), line.getC_Order_ID(), this.getTrxName());
                orgorder = order.getAD_Org_ID();
            }
            if (line.getAD_Org_ID() != startorg || orgpayment != startorg || orginvoice != startorg || orgcashline != startorg || orgorder != startorg) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean equalFactLineIDs(FactLine prevFactLine, FactLine factLine) {
        return factLine.getA_Asset_ID() == prevFactLine.getA_Asset_ID() && factLine.getAccount_ID() == prevFactLine.getAccount_ID() && factLine.getAD_Client_ID() == prevFactLine.getAD_Client_ID() && factLine.getAD_Org_ID() == prevFactLine.getAD_Org_ID() && factLine.getAD_OrgTrx_ID() == prevFactLine.getAD_OrgTrx_ID() && factLine.getC_AcctSchema_ID() == prevFactLine.getC_AcctSchema_ID() && factLine.getC_Activity_ID() == prevFactLine.getC_Activity_ID() && factLine.getC_BPartner_ID() == prevFactLine.getC_BPartner_ID() && factLine.getC_Campaign_ID() == prevFactLine.getC_Campaign_ID() && factLine.getC_Currency_ID() == prevFactLine.getC_Currency_ID() && factLine.getC_LocFrom_ID() == prevFactLine.getC_LocFrom_ID() && factLine.getC_LocTo_ID() == prevFactLine.getC_LocTo_ID() && factLine.getC_Period_ID() == prevFactLine.getC_Period_ID() && factLine.getC_Project_ID() == prevFactLine.getC_Project_ID() && factLine.getC_ProjectPhase_ID() == prevFactLine.getC_ProjectPhase_ID() && factLine.getC_ProjectTask_ID() == prevFactLine.getC_ProjectTask_ID() && factLine.getC_SalesRegion_ID() == prevFactLine.getC_SalesRegion_ID() && factLine.getC_SubAcct_ID() == prevFactLine.getC_SubAcct_ID() && factLine.getC_Tax_ID() == prevFactLine.getC_Tax_ID() && factLine.getC_UOM_ID() == prevFactLine.getC_UOM_ID() && factLine.getGL_Budget_ID() == prevFactLine.getGL_Budget_ID() && factLine.getGL_Category_ID() == prevFactLine.getGL_Category_ID() && factLine.getM_Locator_ID() == prevFactLine.getM_Locator_ID() && factLine.getM_Product_ID() == prevFactLine.getM_Product_ID() && factLine.getUserElement1_ID() == prevFactLine.getUserElement1_ID() && factLine.getUserElement2_ID() == prevFactLine.getUserElement2_ID() && factLine.getUser1_ID() == prevFactLine.getUser1_ID() && factLine.getUser2_ID() == prevFactLine.getUser2_ID();
    }

    private BigDecimal createCashBasedAcct(MAcctSchema as, Fact fact, MInvoice invoice, BigDecimal allocationSource) {
        BigDecimal allocationAccounted = Env.ZERO;
        double percent = invoice.getGrandTotal().doubleValue() / allocationSource.doubleValue();
        if (percent > 0.99 && percent < 1.01) {
            percent = 1.0;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Multiplier=" + percent + " - GrandTotal=" + invoice.getGrandTotal() + " - Allocation Source=" + allocationSource);
        }
        Doc_Invoice docInvoice = (Doc_Invoice)Doc.get(as, 318, invoice.getC_Invoice_ID(), this.getTrxName());
        docInvoice.loadDocumentDetails();
        allocationAccounted = docInvoice.createFactCash(as, fact, BigDecimal.valueOf(percent));
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Allocation Accounted=" + allocationAccounted);
        }
        if (as.isCreatePOCommitment() && !invoice.isSOTrx()) {
            MInvoiceLine[] lines = invoice.getLines();
            int i2 = 0;
            while (i2 < lines.length) {
                Fact factC = Doc_Order.getCommitmentRelease(as, this, lines[i2].getQtyInvoiced(), lines[i2].getC_InvoiceLine_ID(), BigDecimal.valueOf(percent));
                if (factC == null) {
                    return null;
                }
                this.m_facts.add(factC);
                ++i2;
            }
        }
        return allocationAccounted;
    }

    private MAccount getPaymentAcct(MAcctSchema as, int C_Payment_ID) {
        int accountType;
        block9: {
            this.setC_BankAccount_ID(0);
            accountType = 10;
            String sql = "SELECT p.C_BankAccount_ID, d.DocBaseType, p.IsReceipt, p.IsPrepayment FROM C_Payment p INNER JOIN C_DocType d ON (p.C_DocType_ID=d.C_DocType_ID) WHERE C_Payment_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.getTrxName());
                    pstmt.setInt(1, C_Payment_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.setC_BankAccount_ID(rs.getInt(1));
                        if ("APP".equals(rs.getString(2))) {
                            accountType = 12;
                        }
                        if ("Y".equals(rs.getString(4))) {
                            accountType = "Y".equals(rs.getString(3)) ? 13 : 14;
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.getC_BankAccount_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_Payment_ID=" + C_Payment_ID);
            return null;
        }
        return this.getAccount(accountType, as);
    }

    private MAccount getCashAcct(MAcctSchema as, int C_CashLine_ID) {
        String sql = "SELECT c.C_CashBook_ID FROM C_Cash c, C_CashLine cl WHERE c.C_Cash_ID=cl.C_Cash_ID AND cl.C_CashLine_ID=?";
        this.setC_CashBook_ID(DB.getSQLValue(null, sql, C_CashLine_ID));
        if (this.getC_CashBook_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_CashLine_ID=" + C_CashLine_ID);
            return null;
        }
        return this.getAccount(21, as);
    }

    private String createRealizedGainLoss(DocLine line, MAcctSchema as, Fact fact, MAccount invAcct, MInvoice invoice, MAccount payAcct, MPayment payment, BigDecimal allocationSource, BigDecimal allocationAccounted) {
        BigDecimal invoiceSource = null;
        BigDecimal invoiceAccounted = null;
        BigDecimal paymentSource = null;
        BigDecimal paymentAccounted = null;
        StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'");
        List<Object> valuesInv = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 318, invoice.getC_Invoice_ID(), as.getC_AcctSchema_ID());
        if (valuesInv != null) {
            if (invoice.isSOTrx()) {
                invoiceSource = (BigDecimal)valuesInv.get(0);
                invoiceAccounted = (BigDecimal)valuesInv.get(1);
            } else {
                invoiceSource = (BigDecimal)valuesInv.get(2);
                invoiceAccounted = (BigDecimal)valuesInv.get(3);
            }
        }
        if (invoiceSource == null || invoiceAccounted == null) {
            return "Gain/Loss - Invoice not posted yet";
        }
        String invoiceCur = MCurrency.get(this.getCtx(), invoice.getC_Currency_ID()).getISO_Code();
        String allocCur = MCurrency.get(this.getCtx(), this.getC_Currency_ID()).getISO_Code();
        StringBuilder descriptionInv = new StringBuilder("Invoice=(").append(invoiceCur).append(")").append(invoiceSource).append("/").append(invoiceAccounted).append(" - Allocation=(").append(allocCur).append(")").append(allocationSource).append("/").append(allocationAccounted);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(descriptionInv.toString());
        }
        BigDecimal allocationInvoiceSource = allocationSource;
        if (this.getC_Currency_ID() != invoice.getC_Currency_ID()) {
            allocationInvoiceSource = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), invoice.getC_Currency_ID(), this.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
            if (allocationInvoiceSource == null) {
                return "Gain/Loss - No Conversion from Allocation->Invoice";
            }
            StringBuilder d2 = new StringBuilder("Allocation=(").append(allocCur).append(")").append(allocationSource).append("->(").append(invoiceCur).append(")").append(allocationInvoiceSource);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            descriptionInv.append(" - ").append((CharSequence)d2);
        }
        BigDecimal invoiceDifference = null;
        if (allocationInvoiceSource.compareTo(invoiceSource) == 0) {
            invoiceDifference = invoiceAccounted.subtract(allocationAccounted);
            StringBuilder d2 = new StringBuilder("(full) = ").append(invoiceDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            descriptionInv.append(" - ").append((CharSequence)d2);
        } else {
            double multiplier = allocationInvoiceSource.doubleValue() / invoiceSource.doubleValue();
            invoiceDifference = (invoiceAccounted = invoiceAccounted.multiply(BigDecimal.valueOf(multiplier))).subtract(allocationAccounted);
            if (invoiceDifference.abs().compareTo(TOLERANCE) < 0) {
                invoiceDifference = Env.ZERO;
            }
            int precision = as.getStdPrecision();
            if (invoiceDifference.scale() > precision) {
                invoiceDifference = invoiceDifference.setScale(precision, RoundingMode.HALF_UP);
            }
            StringBuilder d2 = new StringBuilder("(partial) = ").append(invoiceDifference).append(" - Multiplier=").append(multiplier);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            descriptionInv.append(" - ").append((CharSequence)d2);
        }
        BigDecimal paymentDifference = Env.ZERO;
        StringBuilder descriptionPay = null;
        if (payment != null && payment.getC_Payment_ID() > 0) {
            StringBuilder d2;
            List<Object> valuesPay = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 335, payment.getC_Payment_ID(), as.getC_AcctSchema_ID());
            if (valuesPay != null) {
                if (invoice.isSOTrx()) {
                    paymentSource = (BigDecimal)valuesPay.get(2);
                    paymentAccounted = (BigDecimal)valuesPay.get(3);
                } else {
                    paymentSource = (BigDecimal)valuesPay.get(0);
                    paymentAccounted = (BigDecimal)valuesPay.get(1);
                }
            }
            if (paymentSource == null || paymentAccounted == null) {
                return "Gain/Loss - Payment not posted yet";
            }
            String paymentCur = MCurrency.get(this.getCtx(), payment.getC_Currency_ID()).getISO_Code();
            descriptionPay = new StringBuilder("Payment=(").append(paymentCur).append(")").append(paymentSource).append("/").append(paymentAccounted).append(" - Allocation=(").append(allocCur).append(")").append(allocationSource).append("/").append(allocationAccounted);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(descriptionPay.toString());
            }
            BigDecimal allocationPaymentSource = allocationSource;
            if (this.getC_Currency_ID() != payment.getC_Currency_ID()) {
                allocationPaymentSource = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), payment.getC_Currency_ID(), this.getDateAcct(), payment.getC_ConversionType_ID(), payment.getAD_Client_ID(), payment.getAD_Org_ID());
                if (allocationPaymentSource == null) {
                    return "Gain/Loss - No Conversion from Allocation->Payment";
                }
                d2 = new StringBuilder("Allocation=(").append(allocCur).append(")").append(allocationSource).append("->(").append(paymentCur).append(")").append(allocationPaymentSource);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d2.toString());
                }
                descriptionPay.append(" - ").append((CharSequence)d2);
            }
            if (allocationPaymentSource.compareTo(paymentSource) == 0) {
                paymentDifference = paymentAccounted.subtract(allocationAccounted);
                d2 = new StringBuilder("(full) = ").append(paymentDifference);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d2.toString());
                }
                descriptionPay.append(" - ").append((CharSequence)d2);
            } else {
                double multiplier = allocationPaymentSource.doubleValue() / paymentSource.doubleValue();
                paymentDifference = (paymentAccounted = paymentAccounted.multiply(BigDecimal.valueOf(multiplier))).subtract(allocationAccounted);
                if (paymentDifference.abs().compareTo(TOLERANCE) < 0) {
                    paymentDifference = Env.ZERO;
                }
                int precision = as.getStdPrecision();
                if (paymentDifference.scale() > precision) {
                    paymentDifference = paymentDifference.setScale(precision, RoundingMode.HALF_UP);
                }
                StringBuilder d22 = new StringBuilder("(partial) = ").append(paymentDifference).append(" - Multiplier=").append(multiplier);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d22.toString());
                }
                descriptionPay.append(" - ").append((CharSequence)d22);
            }
        }
        if (invoiceDifference.signum() == 0 && paymentDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        BigDecimal acctDifference = invoiceDifference.subtract(paymentDifference);
        if (invoice.isSOTrx()) {
            if (acctDifference.signum() != 0) {
                FactLine fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference);
                StringBuilder description = new StringBuilder(descriptionInv);
                if (paymentDifference.signum() != 0 && descriptionPay != null) {
                    description.append(" / ").append((CharSequence)descriptionPay);
                }
                fl.setDescription(description.toString());
            }
            if (invoiceDifference.signum() != 0) {
                FactLine fl = fact.createLine(line, invAcct, as.getC_Currency_ID(), invoiceDifference.negate());
                fl.setDescription(descriptionInv.toString());
            }
            if (paymentDifference.signum() != 0) {
                FactLine fl = fact.createLine(line, payAcct, as.getC_Currency_ID(), paymentDifference);
                fl.setDescription(descriptionPay.toString());
            }
        } else {
            if (invoiceDifference.signum() != 0) {
                FactLine fl = fact.createLine(line, invAcct, as.getC_Currency_ID(), invoiceDifference);
                fl.setDescription(descriptionInv.toString());
            }
            if (paymentDifference.signum() != 0) {
                FactLine fl = fact.createLine(line, payAcct, as.getC_Currency_ID(), paymentDifference.negate());
                fl.setDescription(descriptionPay.toString());
            }
            if (acctDifference.signum() != 0) {
                FactLine fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
                StringBuilder description = new StringBuilder(descriptionInv);
                if (paymentDifference.signum() != 0 && descriptionPay != null) {
                    description.append(" / ").append((CharSequence)descriptionPay);
                }
                fl.setDescription(description.toString());
            }
        }
        return null;
    }

    private boolean createTaxCorrection(MAcctSchema as, Fact fact, DocLine_Allocation line, MAccount DiscountAccount, MAccount WriteOffAccoint, boolean isSOTrx) {
        Doc_AllocationTax tax;
        block11: {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(line.toString());
            }
            BigDecimal discount = Env.ZERO;
            if (as.isTaxCorrectionDiscount()) {
                discount = line.getDiscountAmt();
            }
            BigDecimal writeOff = Env.ZERO;
            if (as.isTaxCorrectionWriteOff()) {
                writeOff = line.getWriteOffAmt();
            }
            tax = new Doc_AllocationTax(DiscountAccount, discount, WriteOffAccoint, writeOff, isSOTrx);
            String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=318 AND Record_ID=? AND C_AcctSchema_ID=? AND Line_ID IS NULL";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.getTrxName());
                    pstmt.setInt(1, line.getC_Invoice_ID());
                    pstmt.setInt(2, as.getC_AcctSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        tax.addInvoiceFact(new MFactAcct(this.getCtx(), rs, fact.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (tax.getLineCount() == 0) {
            this.log.warning("Invoice not posted yet - " + line);
            return false;
        }
        if (tax.getLineCount() < 2) {
            return true;
        }
        return tax.createEntries(as, fact, line);
    }
}

