/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.model.MEntityType;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class ModelInterfaceGenerator {
    private String packageName = "";
    public static final String NL = "\n";
    public static final String COPY = "/******************************************************************************\n * Product: iDempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *\n * or via info@compiere.org or http://www.compiere.org/license.html           *\n *****************************************************************************/\n";
    private static CLogger log = CLogger.getCLogger(ModelInterfaceGenerator.class);
    private Collection<String> s_importClasses = new TreeSet<String>();

    public ModelInterfaceGenerator(int AD_Table_ID, String directory, String packageName) {
        this.packageName = packageName;
        StringBuilder mandatory = new StringBuilder();
        StringBuilder sb = this.createColumns(AD_Table_ID, mandatory);
        String tableName = this.createHeader(AD_Table_ID, sb, mandatory);
        if (!directory.endsWith("/") && !directory.endsWith("\\")) {
            directory = String.valueOf(directory) + File.separator;
        }
        this.writeToFile(sb, String.valueOf(directory) + tableName + ".java");
    }

    private String createHeader(int AD_Table_ID, StringBuilder sb, StringBuilder mandatory) {
        String tableName = "";
        int accessLevel = 0;
        String sql = "SELECT TableName, AccessLevel FROM AD_Table WHERE AD_Table_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Table_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    tableName = rs.getString(1);
                    accessLevel = rs.getInt(2);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (tableName == null) {
            throw new RuntimeException("TableName not found for ID=" + AD_Table_ID);
        }
        StringBuilder accessLevelInfo = new StringBuilder().append(accessLevel).append(" ");
        if (accessLevel >= 4) {
            accessLevelInfo.append("- System ");
        }
        if (accessLevel == 2 || accessLevel == 3 || accessLevel == 6 || accessLevel == 7) {
            accessLevelInfo.append("- Client ");
        }
        if (accessLevel == 1 || accessLevel == 3 || accessLevel == 5 || accessLevel == 7) {
            accessLevelInfo.append("- Org ");
        }
        StringBuilder className = new StringBuilder("I_").append(tableName);
        StringBuilder start = new StringBuilder().append(COPY).append("package ").append(this.packageName).append(";").append(NL);
        if (!this.packageName.equals("org.compiere.model")) {
            this.addImportClass("org.compiere.model.*");
        }
        this.addImportClass(BigDecimal.class);
        this.addImportClass(KeyNamePair.class);
        this.createImports(start);
        start.append("/** Generated Interface for ").append(tableName).append(NL).append(" *  @author iDempiere (generated) \n").append(" *  @version ").append(Adempiere.MAIN_VERSION).append(NL).append(" */\n");
        if (!this.packageName.equals("org.compiere.model")) {
            start.append("@SuppressWarnings(\"all\")\n");
        }
        start.append("public interface ").append((CharSequence)className).append(" {").append(NL).append("    /** TableName=").append(tableName).append(" */\n").append("    public static final String Table_Name = \"").append(tableName).append("\";\n").append("    /** AD_Table_ID=").append(AD_Table_ID).append(" */\n");
        if (AD_Table_ID <= 999999) {
            start.append("    public static final int Table_ID = ").append(AD_Table_ID).append(";\n");
        } else {
            start.append("    public static final int Table_ID = MTable.getTable_ID(Table_Name);\n");
        }
        start.append("    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);\n").append("    /** AccessLevel = ").append((CharSequence)accessLevelInfo).append(NL).append("     */\n").append("    BigDecimal accessLevel = BigDecimal.valueOf(").append(accessLevel).append(");\n").append("    /** Load Meta Data */\n");
        String end = "}";
        sb.insert(0, start);
        sb.append(end);
        return className.toString();
    }

    private StringBuilder createColumns(int AD_Table_ID, StringBuilder mandatory) {
        StringBuilder sb = new StringBuilder();
        String sql = "SELECT c.ColumnName, c.IsUpdateable, c.IsMandatory, c.AD_Reference_ID, c.AD_Reference_Value_ID, DefaultValue, SeqNo,  c.FieldLength, c.ValueMin, c.ValueMax, c.VFormat, c.Callout,  c.Name, c.Description, c.ColumnSQL, c.IsEncrypted, c.IsKey FROM AD_Column c WHERE c.AD_Table_ID=? AND c.IsActive='Y' ORDER BY c.ColumnName";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Table_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String columnName = rs.getString(1);
                    boolean isUpdateable = "Y".equals(rs.getString(2));
                    boolean isMandatory = "Y".equals(rs.getString(3));
                    int displayType = rs.getInt(4);
                    int AD_Reference_Value_ID = rs.getInt(5);
                    String defaultValue = rs.getString(6);
                    int fieldLength = rs.getInt(8);
                    String ValueMin = rs.getString(9);
                    String ValueMax = rs.getString(10);
                    String VFormat = rs.getString(11);
                    String Callout2 = rs.getString(12);
                    String Name2 = rs.getString(13);
                    String Description = rs.getString(14);
                    String ColumnSQL = rs.getString(15);
                    boolean virtualColumn = ColumnSQL != null && ColumnSQL.length() > 0;
                    boolean IsEncrypted = "Y".equals(rs.getString(16));
                    boolean IsKey = "Y".equals(rs.getString(17));
                    sb.append(NL).append("    /** Column name ").append(columnName).append(" */\n").append("    public static final String COLUMNNAME_").append(columnName).append(" = \"").append(columnName).append("\";");
                    sb.append(this.createColumnMethods(mandatory, columnName, isUpdateable, isMandatory, displayType, AD_Reference_Value_ID, fieldLength, defaultValue, ValueMin, ValueMax, VFormat, Callout2, Name2, Description, virtualColumn, IsEncrypted, IsKey, AD_Table_ID));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return sb;
    }

    private String createColumnMethods(StringBuilder mandatory, String columnName, boolean isUpdateable, boolean isMandatory, int displayType, int AD_Reference_ID, int fieldLength, String defaultValue, String ValueMin, String ValueMax, String VFormat, String Callout2, String Name2, String Description, boolean virtualColumn, boolean IsEncrypted, boolean IsKey, int AD_Table_ID) {
        Class<?> clazz = ModelInterfaceGenerator.getClass(columnName, displayType, AD_Reference_ID);
        String dataType = ModelInterfaceGenerator.getDataTypeName(clazz, displayType);
        if (defaultValue == null) {
            defaultValue = "";
        }
        StringBuilder sb = new StringBuilder();
        if (ModelInterfaceGenerator.isGenerateSetter(columnName)) {
            this.generateJavaComment("Set", Name2, Description, sb);
            sb.append("\tpublic void set").append(columnName).append(" (").append(dataType).append(" ").append(columnName).append(");");
        }
        this.generateJavaComment("Get", Name2, Description, sb);
        sb.append("\tpublic ").append(dataType);
        if (clazz.equals(Boolean.class)) {
            sb.append(" is");
            if (columnName.toLowerCase().startsWith("is")) {
                sb.append(columnName.substring(2));
            } else {
                sb.append(columnName);
            }
        } else {
            sb.append(" get").append(columnName);
        }
        sb.append("();");
        if (ModelInterfaceGenerator.isGenerateModelGetter(columnName) && DisplayType.isID(displayType) && !IsKey) {
            String fieldName = ModelInterfaceGenerator.getFieldName(columnName);
            String referenceClassName = ModelInterfaceGenerator.getReferenceClassName(AD_Table_ID, columnName, displayType, AD_Reference_ID);
            if (fieldName != null && referenceClassName != null) {
                sb.append(NL).append("\tpublic " + referenceClassName + " get").append(fieldName).append("() throws RuntimeException;");
            }
        }
        this.addImportClass(clazz);
        return sb.toString();
    }

    public void generateJavaComment(String startOfComment, String propertyName, String description, StringBuilder result) {
        result.append(NL).append("\t/** ").append(startOfComment).append(" ").append(propertyName);
        if (description != null && description.length() > 0) {
            result.append(".\n\t  * ").append(description).append(NL);
        }
        result.append("\t  */\n");
    }

    private void writeToFile(StringBuilder sb, String fileName) {
        try {
            File out = new File(fileName);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
            int i2 = 0;
            while (i2 < sb.length()) {
                char c = sb.charAt(i2);
                if (c == ';' || c == '}') {
                    ((Writer)fw).write(c);
                    if (sb.substring(i2 + 1).startsWith("//")) {
                        ((Writer)fw).write(9);
                    } else {
                        fw.write(NL);
                    }
                } else if (c == '{') {
                    fw.write(NL);
                    ((Writer)fw).write(c);
                    fw.write(NL);
                } else {
                    ((Writer)fw).write(c);
                }
                ++i2;
            }
            ((Writer)fw).flush();
            ((Writer)fw).close();
            float size = out.length();
            StringBuilder msgout = new StringBuilder().append(out.getAbsolutePath()).append(" - ").append(size /= 1024.0f).append(" kB");
            System.out.println(msgout.toString());
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, ex);
            throw new RuntimeException(ex);
        }
    }

    private void addImportClass(String className) {
        if (className == null || className.startsWith("java.lang.") && !className.startsWith("java.lang.reflect.") || className.startsWith(String.valueOf(this.packageName) + ".")) {
            return;
        }
        for (String name : this.s_importClasses) {
            if (!className.equals(name)) continue;
            return;
        }
        if (className.equals("byte[]")) {
            log.warning("Invalid type - " + className);
            return;
        }
        this.s_importClasses.add(className);
    }

    private void addImportClass(Class<?> cl) {
        if (cl.isArray()) {
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            return;
        }
        this.addImportClass(cl.getCanonicalName());
    }

    private void createImports(StringBuilder sb) {
        for (String name : this.s_importClasses) {
            sb.append("import ").append(name).append(";");
        }
        sb.append(NL);
    }

    public static Class<?> getClass(String columnName, int displayType, int AD_Reference_ID) {
        if (columnName.equalsIgnoreCase("Posted") || columnName.equalsIgnoreCase("Processed") || columnName.equalsIgnoreCase("Processing")) {
            return Boolean.class;
        }
        if (columnName.equalsIgnoreCase("Record_ID")) {
            return Integer.class;
        }
        if ((18 == displayType || 30 == displayType) && AD_Reference_ID > 0) {
            String sql = "SELECT c.AD_Reference_ID, c.AD_Reference_Value_ID FROM AD_Ref_Table rt INNER JOIN AD_Column c ON (c.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Reference_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new IllegalStateException("Not found AD_Ref_Table/AD_Column - DisplayType=" + displayType + ", AD_Reference_ID=" + AD_Reference_ID);
                    }
                    displayType = rs.getInt(1);
                    AD_Reference_ID = rs.getInt(2);
                }
                catch (SQLException e) {
                    throw new DBException(e, sql);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return ModelInterfaceGenerator.getClass(columnName, displayType, AD_Reference_ID);
        }
        return DisplayType.getClass(displayType, true);
    }

    public static String getDataTypeName(Class<?> cl, int displayType) {
        String dataType = cl.getName();
        if ((dataType = dataType.substring(dataType.lastIndexOf(46) + 1)).equals("Boolean")) {
            dataType = "boolean";
        } else if (dataType.equals("Integer")) {
            dataType = "int";
        } else if (displayType == 23 || displayType == 32) {
            dataType = "byte[]";
        }
        return dataType;
    }

    public static boolean isGenerateSetter(String columnName) {
        return !"AD_Client_ID".equals(columnName) && !"Created".equals(columnName) && !"CreatedBy".equals(columnName) && !"Updated".equals(columnName) && !"UpdatedBy".equals(columnName);
    }

    public static boolean isGenerateModelGetter(String columnName) {
        return !"AD_Client_ID".equals(columnName) && !"AD_Org_ID".equals(columnName) && !"CreatedBy".equals(columnName) && !"UpdatedBy".equals(columnName);
    }

    public static boolean isGenerateModelGetterForEntity(int AD_Table_ID, String toEntityType) {
        String fromEntityType = DB.getSQLValueString(null, "SELECT EntityType FROM AD_Table where AD_Table_ID=?", AD_Table_ID);
        MEntityType fromEntity = MEntityType.get(Env.getCtx(), fromEntityType);
        MEntityType toEntity = MEntityType.get(Env.getCtx(), toEntityType);
        return fromEntityType.equals(toEntityType) || fromEntity.isSystemMaintained() && toEntity.isSystemMaintained() || !fromEntity.isSystemMaintained() && toEntity.isSystemMaintained();
    }

    public static String getModelPackage(String entityType) {
        if ("D".equals(entityType)) {
            return "org.compiere.model";
        }
        MEntityType entity = MEntityType.get(Env.getCtx(), entityType);
        if (entity != null) {
            return entity.getModelPackage();
        }
        return null;
    }

    public static String getFieldName(String columnName) {
        String fieldName = columnName.endsWith("_ID_To") ? String.valueOf(columnName.substring(0, columnName.length() - 6)) + "_To" : columnName.substring(0, columnName.length() - 3);
        return fieldName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getReferenceClassName(int AD_Table_ID, String columnName, int displayType, int AD_Reference_ID) {
        String referenceClassName = null;
        if (displayType == 19 || displayType == 30 && AD_Reference_ID == 0) {
            String refTableName = MQuery.getZoomTableName(columnName);
            referenceClassName = "I_" + refTableName;
            MTable table2 = MTable.get(Env.getCtx(), refTableName);
            if (table2 == null) throw new RuntimeException("No table found for " + refTableName);
            String entityType = table2.getEntityType();
            String modelpackage = ModelInterfaceGenerator.getModelPackage(entityType);
            if (modelpackage != null) {
                referenceClassName = String.valueOf(modelpackage) + "." + referenceClassName;
            }
            if (ModelInterfaceGenerator.isGenerateModelGetterForEntity(AD_Table_ID, entityType)) return referenceClassName;
            return null;
        }
        if (displayType == 18 || displayType == 30 && AD_Reference_ID > 0) {
            if (AD_Table_ID == 270 && columnName.equals("Account_ID")) {
                return null;
            }
            if (AD_Table_ID == 707 && columnName.equals("Account_ID")) {
                return null;
            }
            String sql = "SELECT t.TableName, t.EntityType, ck.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (t.AD_Table_ID=rt.AD_Table_ID) INNER JOIN AD_Column ck ON (ck.AD_Table_ID=rt.AD_Table_ID AND ck.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement("SELECT t.TableName, t.EntityType, ck.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (t.AD_Table_ID=rt.AD_Table_ID) INNER JOIN AD_Column ck ON (ck.AD_Table_ID=rt.AD_Table_ID AND ck.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?", null);
                    pstmt.setInt(1, AD_Reference_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String refTableName = rs.getString(1);
                        String entityType = rs.getString(2);
                        int refDisplayType = rs.getInt(3);
                        if (refDisplayType == 13) {
                            referenceClassName = "I_" + refTableName;
                            String modelpackage = ModelInterfaceGenerator.getModelPackage(entityType);
                            if (modelpackage != null) {
                                referenceClassName = String.valueOf(modelpackage) + "." + referenceClassName;
                            }
                            if (!ModelInterfaceGenerator.isGenerateModelGetterForEntity(AD_Table_ID, entityType)) {
                                referenceClassName = null;
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, "SELECT t.TableName, t.EntityType, ck.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (t.AD_Table_ID=rt.AD_Table_ID) INNER JOIN AD_Column ck ON (ck.AD_Table_ID=rt.AD_Table_ID AND ck.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?");
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            return referenceClassName;
        }
        if (displayType == 21) {
            return "I_C_Location";
        }
        if (displayType == 31) {
            return "I_M_Locator";
        }
        if (displayType == 25) {
            return "I_C_ValidCombination";
        }
        if (displayType != 35) return referenceClassName;
        return "I_M_AttributeSetInstance";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GenerateModel[").append("]");
        return sb.toString();
    }

    public static void generateSource(String sourceFolder, String packageName, String entityType, String tableName) {
        if (sourceFolder == null || sourceFolder.trim().length() == 0) {
            throw new IllegalArgumentException("Must specify source folder");
        }
        File file = new File(sourceFolder);
        if (!file.exists()) {
            throw new IllegalArgumentException("Source folder doesn't exists. sourceFolder=" + sourceFolder);
        }
        if (packageName == null || packageName.trim().length() == 0) {
            throw new IllegalArgumentException("Must specify package name");
        }
        if (tableName == null || tableName.trim().length() == 0) {
            throw new IllegalArgumentException("Must specify table name");
        }
        String tableLike = tableName.trim();
        if (!tableLike.startsWith("'") || !tableLike.endsWith("'")) {
            tableLike = "'" + tableLike + "'";
        }
        StringBuilder entityTypeFilter = new StringBuilder();
        if (entityType != null && entityType.trim().length() > 0) {
            entityTypeFilter.append("EntityType IN (");
            StringTokenizer tokenizer = new StringTokenizer(entityType, ",");
            int i2 = 0;
            while (tokenizer.hasMoreTokens()) {
                StringBuilder token = new StringBuilder(tokenizer.nextToken().trim());
                if (!token.toString().startsWith("'") || !token.toString().endsWith("'")) {
                    token = new StringBuilder("'").append((CharSequence)token).append("'");
                }
                if (i2 > 0) {
                    entityTypeFilter.append(",");
                }
                entityTypeFilter.append((CharSequence)token);
                ++i2;
            }
            entityTypeFilter.append(")");
        } else {
            entityTypeFilter.append("EntityType IN ('U','A')");
        }
        StringBuilder directory = new StringBuilder().append(sourceFolder.trim());
        String packagePath = packageName.replace(".", File.separator);
        if (!directory.toString().endsWith("/") && !directory.toString().endsWith("\\")) {
            directory.append(File.separator);
        }
        directory = File.separator.equals("/") ? new StringBuilder(directory.toString().replaceAll("[\\\\]", File.separator)) : new StringBuilder(directory.toString().replaceAll("[/]", File.separator));
        file = new File((directory = new StringBuilder(directory).append(packagePath)).toString());
        if (!file.exists()) {
            file.mkdirs();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT AD_Table_ID ").append("FROM AD_Table ").append("WHERE (TableName IN ('RV_WarehousePrice','RV_BPartner')").append(" OR IsView='N')").append(" AND IsActive = 'Y' AND TableName NOT LIKE '%_Trl' ");
        if (tableLike.indexOf(",") == -1) {
            sql.append(" AND TableName LIKE ").append(tableLike);
        } else {
            sql.append(" AND TableName IN (").append(tableLike).append(")");
        }
        sql.append(" AND ").append(entityTypeFilter.toString());
        sql.append(" ORDER BY TableName");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    new ModelInterfaceGenerator(rs.getInt(1), directory.toString(), packageName);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }
}

