/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.adempiere.util.ModelClassGenerator;
import org.adempiere.util.ModelInterfaceGenerator;
import org.compiere.Adempiere;

public class ModelGeneratorDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3546051609729699491L;
    private JButton bGenerate;
    private JButton bCancel;
    private JButton bFolder;
    private JTextField fFolderName;
    private JTextField fPackageName;
    private JTextField fTableName;
    private JCheckBox fGenerateInterface;
    private JCheckBox fGenerateClass;
    private JTextField fEntityType;

    public ModelGeneratorDialog() {
        this.setTitle("Model Class Generator");
        BorderLayout layout = new BorderLayout();
        this.getContentPane().setLayout(layout);
        Panel confirmPanel = new Panel();
        this.getContentPane().add((Component)confirmPanel, "South");
        Panel mainPanel = new Panel();
        this.getContentPane().add((Component)mainPanel, "Center");
        mainPanel.setLayout(new GridLayout(5, 2));
        Panel filePanel = new Panel();
        filePanel.setLayout(new BorderLayout());
        String defaultPath = String.valueOf(Adempiere.getAdempiereHome()) + File.separator + "org.adempiere.base" + File.separator + "src";
        this.fFolderName = new JTextField(defaultPath);
        filePanel.add((Component)this.fFolderName, "Center");
        this.bFolder = new JButton("...");
        this.bFolder.setMargin(new Insets(0, 0, 0, 0));
        filePanel.add((Component)this.bFolder, "East");
        mainPanel.add(new JLabel("Source Folder"));
        mainPanel.add(filePanel);
        this.bFolder.addActionListener(this);
        mainPanel.add(new JLabel("Package Name"));
        this.fPackageName = new JTextField("org.compiere.model");
        mainPanel.add(this.fPackageName);
        mainPanel.add(new JLabel("Table Name"));
        this.fTableName = new JTextField("AD_ReplaceThis%");
        mainPanel.add(this.fTableName);
        mainPanel.add(new JLabel("Entity Type"));
        this.fEntityType = new JTextField("D");
        mainPanel.add(this.fEntityType);
        this.fGenerateInterface = new JCheckBox("Generate Interface");
        this.fGenerateInterface.setSelected(true);
        mainPanel.add(this.fGenerateInterface);
        this.fGenerateClass = new JCheckBox("Generate Class");
        this.fGenerateClass.setSelected(true);
        mainPanel.add(this.fGenerateClass);
        this.bGenerate = new JButton("Generate Source");
        confirmPanel.add(this.bGenerate);
        this.bCancel = new JButton("Cancel");
        confirmPanel.add(this.bCancel);
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bGenerate) {
            String folder = this.fFolderName.getText();
            if (folder == null || folder.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter source folder name", "Error", 0);
                return;
            }
            String packageName = this.fPackageName.getText();
            if (packageName == null || packageName.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter package name", "Error", 0);
                return;
            }
            String tableName = this.fTableName.getText();
            if (tableName == null || tableName.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter table name", "Error", 0);
                return;
            }
            String entityType = this.fEntityType.getText();
            if (entityType == null || entityType.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter entity type", "Error", 0);
                return;
            }
            if (!this.fGenerateClass.isSelected() && !this.fGenerateInterface.isSelected()) {
                JOptionPane.showMessageDialog(this, "Must select at least one of generate interface or generate class", "Error", 0);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.fGenerateInterface.isSelected()) {
                ModelInterfaceGenerator.generateSource(folder, packageName, entityType, tableName);
            }
            if (this.fGenerateClass.isSelected()) {
                ModelClassGenerator.generateSource(folder, packageName, entityType, tableName);
            }
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.bFolder) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            int state = fileChooser.showOpenDialog(this);
            if (state == 0) {
                this.fFolderName.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

