/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.ModelInterfaceGenerator;
import org.compiere.Adempiere;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class ModelClassGenerator {
    public static final String NL = "\n";
    private static CLogger log = CLogger.getCLogger(ModelClassGenerator.class);
    private String packageName = "";
    private Collection<String> s_importClasses = new TreeSet<String>();

    public ModelClassGenerator(int AD_Table_ID, String directory, String packageName) {
        this.packageName = packageName;
        StringBuilder mandatory = new StringBuilder();
        StringBuilder sb = this.createColumns(AD_Table_ID, mandatory);
        String className = this.createHeader(AD_Table_ID, sb, mandatory, packageName);
        if (!directory.endsWith(File.separator)) {
            directory = String.valueOf(directory) + File.separator;
        }
        this.writeToFile(sb, String.valueOf(directory) + className + ".java");
    }

    private String createHeader(int AD_Table_ID, StringBuilder sb, StringBuilder mandatory, String packageName) {
        String tableName = "";
        int accessLevel = 0;
        String sql = "SELECT TableName, AccessLevel FROM AD_Table WHERE AD_Table_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Table_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    tableName = rs.getString(1);
                    accessLevel = rs.getInt(2);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (tableName == null) {
            throw new RuntimeException("TableName not found for ID=" + AD_Table_ID);
        }
        StringBuilder accessLevelInfo = new StringBuilder().append(accessLevel).append(" ");
        if (accessLevel >= 4) {
            accessLevelInfo.append("- System ");
        }
        if (accessLevel == 2 || accessLevel == 3 || accessLevel == 6 || accessLevel == 7) {
            accessLevelInfo.append("- Client ");
        }
        if (accessLevel == 1 || accessLevel == 3 || accessLevel == 5 || accessLevel == 7) {
            accessLevelInfo.append("- Org ");
        }
        StringBuilder keyColumn = new StringBuilder().append(tableName).append("_ID");
        StringBuilder className = new StringBuilder("X_").append(tableName);
        StringBuilder start = new StringBuilder().append("/******************************************************************************\n * Product: iDempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *\n * or via info@compiere.org or http://www.compiere.org/license.html           *\n *****************************************************************************/\n").append("/** Generated Model - DO NOT CHANGE */").append(NL).append("package ").append(packageName).append(";").append(NL).append(NL);
        this.addImportClass(Properties.class);
        this.addImportClass(ResultSet.class);
        if (!packageName.equals("org.compiere.model")) {
            this.addImportClass("org.compiere.model.*");
        }
        this.createImports(start);
        start.append("/** Generated Model for ").append(tableName).append(NL).append(" *  @author iDempiere (generated) ").append(NL).append(" *  @version ").append(Adempiere.MAIN_VERSION).append(" - $Id$ */").append(NL).append("public class ").append((CharSequence)className).append(" extends PO").append(" implements I_").append(tableName).append(", I_Persistent ").append(NL).append("{").append(NL).append(NL).append("\t/**").append(NL).append("\t *").append(NL).append("\t */").append(NL).append("\tprivate static final long serialVersionUID = ").append(String.format("%1$tY%1$tm%1$td", new Timestamp(System.currentTimeMillis()))).append("L;").append(NL).append(NL).append("    /** Standard Constructor */").append(NL).append("    public ").append((CharSequence)className).append(" (Properties ctx, int ").append((CharSequence)keyColumn).append(", String trxName)").append(NL).append("    {").append(NL).append("      super (ctx, ").append((CharSequence)keyColumn).append(", trxName);").append(NL).append("      /** if (").append((CharSequence)keyColumn).append(" == 0)").append(NL).append("        {").append(NL).append((CharSequence)mandatory).append("        } */").append(NL).append("    }").append(NL).append(NL).append("    /** Load Constructor */").append(NL).append("    public ").append((CharSequence)className).append(" (Properties ctx, ResultSet rs, String trxName)").append(NL).append("    {").append(NL).append("      super (ctx, rs, trxName);").append(NL).append("    }").append(NL).append(NL).append("    /** AccessLevel").append(NL).append("      * @return ").append((CharSequence)accessLevelInfo).append(NL).append("      */").append(NL).append("    protected int get_AccessLevel()").append(NL).append("    {").append(NL).append("      return accessLevel.intValue();").append(NL).append("    }").append(NL).append(NL).append("    /** Load Meta Data */").append(NL).append("    protected POInfo initPO (Properties ctx)").append(NL).append("    {").append(NL).append("      POInfo poi = POInfo.getPOInfo (ctx, Table_ID, get_TrxName());").append(NL).append("      return poi;").append(NL).append("    }").append(NL).append(NL).append("    public String toString()").append(NL).append("    {").append(NL).append("      StringBuffer sb = new StringBuffer (\"").append((CharSequence)className).append("[\")").append(NL).append("        .append(get_ID()).append(\"]\");").append(NL).append("      return sb.toString();").append(NL).append("    }").append(NL);
        String end = "}";
        sb.insert(0, start);
        sb.append(end);
        return className.toString();
    }

    private StringBuilder createColumns(int AD_Table_ID, StringBuilder mandatory) {
        StringBuilder sb = new StringBuilder();
        String sql = "SELECT c.ColumnName, c.IsUpdateable, c.IsMandatory, c.AD_Reference_ID, c.AD_Reference_Value_ID, DefaultValue, SeqNo,  c.FieldLength, c.ValueMin, c.ValueMax, c.VFormat, c.Callout,  c.Name, c.Description, c.ColumnSQL, c.IsEncrypted, c.IsKey, c.IsIdentifier FROM AD_Column c WHERE c.AD_Table_ID=? AND c.ColumnName NOT IN ('AD_Client_ID', 'AD_Org_ID', 'IsActive', 'Created', 'CreatedBy', 'Updated', 'UpdatedBy') AND c.IsActive='Y' ORDER BY c.ColumnName";
        boolean isKeyNamePairCreated = false;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Table_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String columnName = rs.getString(1);
                    boolean isUpdateable = "Y".equals(rs.getString(2));
                    boolean isMandatory = "Y".equals(rs.getString(3));
                    int displayType = rs.getInt(4);
                    int AD_Reference_Value_ID = rs.getInt(5);
                    String defaultValue = rs.getString(6);
                    int seqNo = rs.getInt(7);
                    int fieldLength = rs.getInt(8);
                    String ValueMin = rs.getString(9);
                    String ValueMax = rs.getString(10);
                    String VFormat = rs.getString(11);
                    String Callout2 = rs.getString(12);
                    String Name2 = rs.getString(13);
                    String Description = rs.getString(14);
                    String ColumnSQL = rs.getString(15);
                    boolean virtualColumn = ColumnSQL != null && ColumnSQL.length() > 0;
                    boolean IsEncrypted = "Y".equals(rs.getString(16));
                    boolean IsKey = "Y".equals(rs.getString(17));
                    boolean IsIdentifier = "Y".equals(rs.getString(18));
                    sb.append(this.createColumnMethods(mandatory, columnName, isUpdateable, isMandatory, displayType, AD_Reference_Value_ID, fieldLength, defaultValue, ValueMin, ValueMax, VFormat, Callout2, Name2, Description, virtualColumn, IsEncrypted, IsKey, AD_Table_ID));
                    if (seqNo != 1 || !IsIdentifier) continue;
                    if (!isKeyNamePairCreated) {
                        sb.append((CharSequence)this.createKeyNamePair(columnName, displayType));
                        isKeyNamePairCreated = true;
                        continue;
                    }
                    StringBuilder msgException = new StringBuilder("More than one primary identifier found ").append(" (AD_Table_ID=").append(AD_Table_ID).append(", ColumnName=").append(columnName).append(")");
                    throw new RuntimeException(msgException.toString());
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return sb;
    }

    private String createColumnMethods(StringBuilder mandatory, String columnName, boolean isUpdateable, boolean isMandatory, int displayType, int AD_Reference_ID, int fieldLength, String defaultValue, String ValueMin, String ValueMax, String VFormat, String Callout2, String Name2, String Description, boolean virtualColumn, boolean IsEncrypted, boolean IsKey, int AD_Table_ID) {
        String staticVar;
        Class<?> clazz = ModelInterfaceGenerator.getClass(columnName, displayType, AD_Reference_ID);
        String dataType = ModelInterfaceGenerator.getDataTypeName(clazz, displayType);
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (DisplayType.isLOB(displayType)) {
            fieldLength = 0;
        }
        String setValue = "\t\tset_Value";
        if (IsEncrypted) {
            setValue = "\t\tset_ValueE";
        }
        if (!isUpdateable) {
            setValue = "\t\tset_ValueNoCheck";
            if (IsEncrypted) {
                setValue = "\t\tset_ValueNoCheckE";
            }
        }
        StringBuilder sb = new StringBuilder();
        if (DisplayType.isID(displayType) && !IsKey) {
            String fieldName = ModelInterfaceGenerator.getFieldName(columnName);
            String referenceClassName = ModelInterfaceGenerator.getReferenceClassName(AD_Table_ID, columnName, displayType, AD_Reference_ID);
            if (fieldName != null && referenceClassName != null) {
                sb.append(NL).append("\tpublic ").append(referenceClassName).append(" get").append(fieldName).append("() throws RuntimeException").append(NL).append("    {").append(NL).append("\t\treturn (").append(referenceClassName).append(")MTable.get(getCtx(), ").append(referenceClassName).append(".Table_Name)").append(NL).append("\t\t\t.getPO(get").append(columnName).append("(), get_TrxName());").append("\t}").append(NL);
                this.addImportClass(clazz);
            }
        }
        this.generateJavaSetComment(columnName, Name2, Description, sb);
        sb.append("\tpublic void set").append(columnName).append(" (").append(dataType).append(" ").append(columnName).append(")").append(NL).append("\t{").append(NL);
        if (AD_Reference_ID != 0 && String.class == clazz) {
            staticVar = this.addListValidation(sb, AD_Reference_ID, columnName);
            sb.insert(0, staticVar);
        }
        if (displayType == 200012) {
            staticVar = this.addListValidation(sb, 195, columnName);
            sb.insert(0, staticVar);
        }
        if (virtualColumn) {
            sb.append("\t\tthrow new IllegalArgumentException (\"").append(columnName).append(" is virtual column\");");
        } else if (clazz.equals(Integer.class)) {
            if (columnName.endsWith("_ID")) {
                int firstOK = 1;
                if (columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("Record_ID") || columnName.equals("C_DocType_ID") || columnName.equals("Node_ID") || columnName.equals("AD_Role_ID") || columnName.equals("M_AttributeSet_ID") || columnName.equals("M_AttributeSetInstance_ID")) {
                    firstOK = 0;
                }
                sb.append("\t\tif (").append(columnName).append(" < ").append(firstOK).append(") ").append(NL).append("\t").append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", null);").append(NL).append("\t\telse ").append(NL).append("\t");
            }
            sb.append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", Integer.valueOf(").append(columnName).append("));").append(NL);
        } else if (clazz.equals(Boolean.class)) {
            sb.append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", Boolean.valueOf(").append(columnName).append("));").append(NL);
        } else {
            sb.append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", ").append(columnName).append(");").append(NL);
        }
        sb.append("\t}").append(NL);
        if (isMandatory) {
            mandatory.append("\t\t\tset").append(columnName).append(" (");
            if (clazz.equals(Integer.class)) {
                mandatory.append("0");
            } else if (clazz.equals(Boolean.class)) {
                if (defaultValue.indexOf(89) != -1) {
                    mandatory.append(true);
                } else {
                    mandatory.append("false");
                }
            } else if (clazz.equals(BigDecimal.class)) {
                mandatory.append("Env.ZERO");
            } else if (clazz.equals(Timestamp.class)) {
                mandatory.append("new Timestamp( System.currentTimeMillis() )");
            } else {
                mandatory.append("null");
            }
            mandatory.append(");").append(NL);
            if (defaultValue.length() > 0) {
                mandatory.append("// ").append(defaultValue).append(NL);
            }
        }
        this.generateJavaGetComment(Name2, Description, sb);
        String getValue = "get_Value";
        if (IsEncrypted) {
            getValue = "get_ValueE";
        }
        sb.append("\tpublic ").append(dataType);
        if (clazz.equals(Boolean.class)) {
            sb.append(" is");
            if (columnName.toLowerCase().startsWith("is")) {
                sb.append(columnName.substring(2));
            } else {
                sb.append(columnName);
            }
        } else {
            sb.append(" get").append(columnName);
        }
        sb.append(" () ").append(NL).append("\t{").append(NL).append("\t\t");
        if (clazz.equals(Integer.class)) {
            sb.append("Integer ii = (Integer)").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL).append("\t\tif (ii == null)").append(NL).append("\t\t\t return 0;").append(NL).append("\t\treturn ii.intValue();").append(NL);
        } else if (clazz.equals(BigDecimal.class)) {
            sb.append("BigDecimal bd = (BigDecimal)").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL).append("\t\tif (bd == null)").append(NL).append("\t\t\t return Env.ZERO;").append(NL).append("\t\treturn bd;").append(NL);
            this.addImportClass(BigDecimal.class);
            this.addImportClass(Env.class);
        } else if (clazz.equals(Boolean.class)) {
            sb.append("Object oo = ").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL).append("\t\tif (oo != null) ").append(NL).append("\t\t{").append(NL).append("\t\t\t if (oo instanceof Boolean) ").append(NL).append("\t\t\t\t return ((Boolean)oo).booleanValue(); ").append(NL).append("\t\t\treturn \"Y\".equals(oo);").append(NL).append("\t\t}").append(NL).append("\t\treturn false;").append(NL);
        } else if (dataType.equals("Object")) {
            sb.append("\t\treturn ").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL);
        } else {
            sb.append("return (").append(dataType).append(")").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL);
            this.addImportClass(clazz);
        }
        sb.append("\t}").append(NL);
        return sb.toString();
    }

    public void generateJavaSetComment(String columnName, String propertyName, String description, StringBuilder result) {
        result.append(NL).append("\t/** Set ").append(propertyName).append(".").append(NL).append("\t\t@param ").append(columnName).append(" ");
        if (description != null && description.length() > 0) {
            result.append(NL).append("\t\t").append(description).append(NL);
        } else {
            result.append(propertyName);
        }
        result.append("\t  */").append(NL);
    }

    public void generateJavaGetComment(String propertyName, String description, StringBuilder result) {
        result.append(NL).append("\t/** Get ").append(propertyName);
        if (description != null && description.length() > 0) {
            result.append(".").append(NL).append("\t\t@return ").append(description).append(NL);
        } else {
            result.append(".\n\t\t@return ").append(propertyName);
        }
        result.append("\t  */").append(NL);
    }

    private String addListValidation(StringBuilder sb, int AD_Reference_ID, String columnName) {
        StringBuilder retValue = new StringBuilder();
        if (AD_Reference_ID <= 999999) {
            retValue.append("\n\t/** ").append(columnName).append(" AD_Reference_ID=").append(AD_Reference_ID).append(" */").append("\n\tpublic static final int ").append(columnName.toUpperCase()).append("_AD_Reference_ID=").append(AD_Reference_ID).append(";");
        }
        boolean found = false;
        StringBuilder values = new StringBuilder("Reference_ID=").append(AD_Reference_ID);
        StringBuilder statement = new StringBuilder();
        String sql = "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY AD_Ref_List_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Reference_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String value = rs.getString(1);
                    values.append(" - ").append(value);
                    if (statement.length() == 0) {
                        statement.append("\n\t\tif (").append(columnName).append(".equals(\"").append(value).append("\")");
                    } else {
                        statement.append(" || ").append(columnName).append(".equals(\"").append(value).append("\")");
                    }
                    if (!found) {
                        found = true;
                    }
                    String name = rs.getString(2);
                    char[] nameArray = name.toCharArray();
                    StringBuilder nameClean = new StringBuilder();
                    boolean initCap = true;
                    int i2 = 0;
                    while (i2 < nameArray.length) {
                        char c = nameArray[i2];
                        if (Character.isJavaIdentifierPart(c)) {
                            if (initCap) {
                                nameClean.append(Character.toUpperCase(c));
                            } else {
                                nameClean.append(c);
                            }
                            initCap = false;
                        } else {
                            if (c == '+') {
                                nameClean.append("Plus");
                            } else if (c == '-') {
                                nameClean.append("_");
                            } else if (c == '>') {
                                if (name.indexOf(60) == -1) {
                                    nameClean.append("Gt");
                                }
                            } else if (c == '<') {
                                if (name.indexOf(62) == -1) {
                                    nameClean.append("Le");
                                }
                            } else if (c == '!') {
                                nameClean.append("Not");
                            } else if (c == '=') {
                                nameClean.append("Eq");
                            } else if (c == '~') {
                                nameClean.append("Like");
                            }
                            initCap = true;
                        }
                        ++i2;
                    }
                    retValue.append("\n\t/** ").append(name).append(" = ").append(value).append(" */");
                    retValue.append("\n\tpublic static final String ").append(columnName.toUpperCase()).append("_").append((CharSequence)nameClean).append(" = \"").append(value).append("\";");
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        statement.append(")").append("; ").append("else ").append("throw new IllegalArgumentException (\"").append(columnName).append(" Invalid value - \" + ").append(columnName).append(" + \" - ").append((CharSequence)values).append("\");");
        sb.append(NL);
        return retValue.toString();
    }

    private StringBuilder createKeyNamePair(String columnName, int displayType) {
        StringBuilder method = new StringBuilder("get").append(columnName).append("()");
        if (displayType != 10) {
            method = new StringBuilder("String.valueOf(").append((CharSequence)method).append(")");
        }
        StringBuilder sb = new StringBuilder(NL).append("    /** Get Record ID/ColumnName").append(NL).append("        @return ID/ColumnName pair").append(NL).append("      */").append(NL).append("    public KeyNamePair getKeyNamePair() ").append(NL).append("    {").append(NL).append("        return new KeyNamePair(get_ID(), ").append((CharSequence)method).append(");").append(NL).append("    }").append(NL);
        this.addImportClass(KeyNamePair.class);
        return sb;
    }

    private void writeToFile(StringBuilder sb, String fileName) {
        try {
            File out = new File(fileName);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
            int i2 = 0;
            while (i2 < sb.length()) {
                char c = sb.charAt(i2);
                if (c == ';' || c == '}') {
                    ((Writer)fw).write(c);
                    sb.substring(i2 + 1).startsWith("//");
                } else if (c == '{') {
                    ((Writer)fw).write(c);
                } else {
                    ((Writer)fw).write(c);
                }
                ++i2;
            }
            ((Writer)fw).flush();
            ((Writer)fw).close();
            float size = out.length();
            StringBuilder msgout = new StringBuilder().append(out.getAbsolutePath()).append(" - ").append(size /= 1024.0f).append(" kB");
            System.out.println(msgout.toString());
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, ex);
            throw new RuntimeException(ex);
        }
    }

    private void addImportClass(String className) {
        if (className == null || className.startsWith("java.lang.") && !className.startsWith("java.lang.reflect.") || className.startsWith(String.valueOf(this.packageName) + ".")) {
            return;
        }
        for (String name : this.s_importClasses) {
            if (!className.equals(name)) continue;
            return;
        }
        this.s_importClasses.add(className);
    }

    private void addImportClass(Class<?> cl) {
        if (cl.isArray()) {
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            return;
        }
        this.addImportClass(cl.getCanonicalName());
    }

    private void createImports(StringBuilder sb) {
        for (String name : this.s_importClasses) {
            sb.append("import ").append(name).append(";").append(NL);
        }
        sb.append(NL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GenerateModel[").append("]");
        return sb.toString();
    }

    public static void generateSource(String sourceFolder, String packageName, String entityType, String tableName) {
        if (sourceFolder == null || sourceFolder.trim().length() == 0) {
            throw new IllegalArgumentException("Must specify source folder");
        }
        File file = new File(sourceFolder);
        if (!file.exists()) {
            throw new IllegalArgumentException("Source folder doesn't exists. sourceFolder=" + sourceFolder);
        }
        if (packageName == null || packageName.trim().length() == 0) {
            throw new IllegalArgumentException("Must specify package name");
        }
        if (tableName == null || tableName.trim().length() == 0) {
            throw new IllegalArgumentException("Must specify table name");
        }
        StringBuilder tableLike = new StringBuilder().append(tableName.trim());
        if (!tableLike.toString().startsWith("'") || !tableLike.toString().endsWith("'")) {
            tableLike = new StringBuilder("'").append((CharSequence)tableLike).append("'");
        }
        StringBuilder entityTypeFilter = new StringBuilder();
        if (entityType != null && entityType.trim().length() > 0) {
            entityTypeFilter.append("EntityType IN (");
            StringTokenizer tokenizer = new StringTokenizer(entityType, ",");
            int i2 = 0;
            while (tokenizer.hasMoreTokens()) {
                StringBuilder token = new StringBuilder().append(tokenizer.nextToken().trim());
                if (!token.toString().startsWith("'") || !token.toString().endsWith("'")) {
                    token = new StringBuilder("'").append((CharSequence)token).append("'");
                }
                if (i2 > 0) {
                    entityTypeFilter.append(",");
                }
                entityTypeFilter.append((CharSequence)token);
                ++i2;
            }
            entityTypeFilter.append(")");
        } else {
            entityTypeFilter.append("EntityType IN ('U','A')");
        }
        StringBuilder directory = new StringBuilder().append(sourceFolder.trim());
        String packagePath = packageName.replace(".", File.separator);
        if (!directory.toString().endsWith("/") && !directory.toString().endsWith("\\")) {
            directory.append(File.separator);
        }
        directory = File.separator.equals("/") ? new StringBuilder(directory.toString().replaceAll("[\\\\]", File.separator)) : new StringBuilder(directory.toString().replaceAll("[/]", File.separator));
        directory.append(packagePath);
        file = new File(directory.toString());
        if (!file.exists()) {
            file.mkdirs();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT AD_Table_ID ").append("FROM AD_Table ").append("WHERE (TableName IN ('RV_WarehousePrice','RV_BPartner')").append(" OR IsView='N')").append(" AND IsActive = 'Y' AND TableName NOT LIKE '%_Trl' ");
        if (tableLike.indexOf(",") == -1) {
            sql.append(" AND TableName LIKE ").append((CharSequence)tableLike);
        } else {
            sql.append(" AND TableName IN (").append((CharSequence)tableLike).append(")");
        }
        sql.append(" AND ").append(entityTypeFilter.toString());
        sql.append(" ORDER BY TableName");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    new ModelClassGenerator(rs.getInt(1), directory.toString(), packageName);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }
}

