/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;

public class LogAuthFailure {
    private static FileOutputStream file = null;
    private static Writer writer;
    public static String authFailureFilename;
    private static CLogger log;

    static {
        authFailureFilename = "AuthFailure.log";
        log = CLogger.getCLogger(LogAuthFailure.class);
    }

    public LogAuthFailure() {
        String path = String.valueOf(Ini.getAdempiereHome()) + File.separator + "log";
        String name = String.valueOf(path) + File.separator + authFailureFilename;
        try {
            File fileName = new File(name);
            file = new FileOutputStream(fileName, true);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)file, "UTF8"));
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(e.getMessage());
            }
            e.printStackTrace();
        }
    }

    public void log(String clientIP, String context, String username, String msg) {
        block2: {
            try {
                SimpleDateFormat format = DisplayType.getTimestampFormat_Default();
                String dateTimeText = format.format(new Timestamp(System.currentTimeMillis()));
                writer.append("[");
                writer.append(dateTimeText);
                writer.append("] [error] [client ");
                writer.append(clientIP);
                writer.append("] [context ");
                writer.append(context);
                writer.append("] [username ");
                writer.append(username);
                writer.append("] ");
                writer.append(msg);
                writer.append("\n");
                writer.flush();
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.fine(e.getMessage());
            }
        }
    }
}

