/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSearchDefinition;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public abstract class AbstractDocumentSearch {
    static CLogger log = CLogger.getCLogger(AbstractDocumentSearch.class);
    protected boolean windowOpened = false;

    public boolean openDocumentsByDocumentNo(String searchString) {
        this.windowOpened = false;
        StringBuilder msglog = new StringBuilder();
        msglog.append("Search started with String: ").append(searchString);
        if (log.isLoggable(Level.FINE)) {
            log.fine(msglog.toString());
        }
        if (!Util.isEmpty(searchString)) {
            String[] codes = searchString.trim().replaceAll("  ", " ").split(" ");
            ArrayList<String> codeList = new ArrayList<String>();
            boolean codeSearch = true;
            StringBuilder search = new StringBuilder();
            int i2 = 0;
            while (i2 < codes.length) {
                try {
                    String s = codes[i2];
                    if (MSearchDefinition.isValidTransactionCode(s) && codeSearch) {
                        codeList.add(s);
                    } else {
                        codeSearch = false;
                        search.append(s);
                        if (i2 != codes.length - 1) {
                            search.append(" ");
                        }
                    }
                }
                catch (SQLException e) {
                    log.severe(e.toString());
                    e.printStackTrace();
                }
                ++i2;
            }
            if (codeList.size() > 0) {
                i2 = 0;
                while (i2 < codeList.size()) {
                    msglog = new StringBuilder("Search with Transaction: '");
                    msglog.append((String)codeList.get(i2)).append("' for: '").append(search.toString()).append("'");
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(msglog.toString());
                    }
                    this.getID((String)codeList.get(i2), search.toString());
                    ++i2;
                }
            } else {
                msglog = new StringBuilder("Search without Transaction: ").append(search.toString());
                if (log.isLoggable(Level.FINE)) {
                    log.fine(msglog.toString());
                }
                this.getID(null, search.toString());
            }
        } else {
            log.fine("Search String is invalid");
        }
        return this.windowOpened;
    }

    private void getID(String transactionCode, String searchString) {
        ResultSet rsSO = null;
        ResultSet rsPO = null;
        PreparedStatement pstmtSO = null;
        PreparedStatement pstmtPO = null;
        StringBuilder sqlSO = null;
        StringBuilder sqlPO = null;
        StringBuilder msglog = null;
        Properties ctx = Env.getCtx();
        MRole role = MRole.get(ctx, Env.getAD_Role_ID(ctx), Env.getAD_User_ID(ctx), true);
        try {
            try {
                for (MSearchDefinition msd : MSearchDefinition.getForCode(transactionCode)) {
                    MTable table2;
                    block40: {
                        block38: {
                            block39: {
                                table2 = new MTable(Env.getCtx(), msd.getAD_Table_ID(), null);
                                if (!msd.getSearchType().equals("T")) break block38;
                                MColumn column = new MColumn(Env.getCtx(), msd.getAD_Column_ID(), null);
                                sqlSO = new StringBuilder("SELECT ").append(table2.getTableName()).append("_ID FROM ").append(table2.getTableName()).append(" ");
                                if (msd.getDataType().equals("I")) {
                                    sqlSO.append("WHERE ").append(column.getColumnName()).append("=?");
                                } else {
                                    sqlSO.append("WHERE UPPER(").append(column.getColumnName()).append(") LIKE UPPER(?)");
                                }
                                sqlSO.append(Env.parseContext(Env.getCtx(), -1, " AND AD_Client_ID=@#AD_Client_ID@", false, true));
                                if (msd.getPO_Window_ID() != 0) {
                                    sqlPO = new StringBuilder(sqlSO.toString());
                                    String columntrx = "IsSOTrx";
                                    if ("C_Payment".equals(table2.getTableName())) {
                                        columntrx = "IsReceipt";
                                    }
                                    sqlPO.append(" AND ").append(columntrx).append("='N'");
                                    sqlSO.append(" AND ").append(columntrx).append("='Y'");
                                    pstmtPO = DB.prepareStatement(sqlPO.toString(), null);
                                }
                                pstmtSO = DB.prepareStatement(sqlSO.toString(), null);
                                if (!msd.getDataType().equals("I")) break block39;
                                pstmtSO.setInt(1, Integer.valueOf(searchString.replaceAll("\\D", "")));
                                if (pstmtPO != null) {
                                    pstmtPO.setInt(1, Integer.valueOf(searchString.replaceAll("\\D", "")));
                                }
                                break block40;
                            }
                            if (!msd.getDataType().equals("S")) break block40;
                            if (searchString.endsWith("%")) {
                                pstmtSO.setString(1, searchString);
                            } else {
                                pstmtSO.setString(1, String.valueOf(searchString) + "%");
                            }
                            if (pstmtPO == null) break block40;
                            if (searchString.endsWith("%")) {
                                pstmtPO.setString(1, searchString);
                            } else {
                                pstmtPO.setString(1, String.valueOf(searchString) + "%");
                            }
                            break block40;
                        }
                        if (msd.getSearchType().equals("Q")) {
                            sqlSO = new StringBuilder().append(Env.parseContext(Env.getCtx(), -1, msd.getQuery(), false, true));
                            pstmtSO = DB.prepareStatement(sqlSO.toString(), null);
                            int count = 1;
                            char[] cArray = sqlSO.toString().toCharArray();
                            int n = cArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char c = cArray[n2];
                                if (c == '?') {
                                    ++count;
                                }
                                ++n2;
                            }
                            int i2 = 1;
                            while (i2 < count) {
                                if (msd.getDataType().equals("I")) {
                                    pstmtSO.setInt(i2, Integer.valueOf(searchString.replaceAll("\\D", "")));
                                } else if (msd.getDataType().equals("S")) {
                                    if (searchString.endsWith("%")) {
                                        pstmtSO.setString(i2, searchString);
                                    } else {
                                        pstmtSO.setString(i2, String.valueOf(searchString) + "%");
                                    }
                                }
                                ++i2;
                            }
                        }
                    }
                    if (pstmtSO != null) {
                        msglog = new StringBuilder("SQL Sales: ").append(sqlSO.toString());
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(msglog.toString());
                        }
                        rsSO = pstmtSO.executeQuery();
                        Vector<Integer> idSO = new Vector<Integer>();
                        while (rsSO.next()) {
                            idSO.add(rsSO.getInt(1));
                        }
                        if (role.getWindowAccess(msd.getAD_Window_ID()) != null) {
                            msglog = new StringBuilder("Open Window: ").append(msd.getAD_Window_ID()).append(" / Table: ").append(table2.getTableName()).append(" / Number of Results: ").append(idSO.size());
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(msglog.toString());
                            }
                            if (idSO.size() == 0 && (searchString == null || searchString.trim().length() == 0)) {
                                idSO.add(0);
                            }
                            this.openWindow(idSO, table2.getTableName(), msd.getAD_Window_ID());
                        } else {
                            log.warning("Role is not allowed to view this window");
                        }
                    }
                    if (pstmtPO != null) {
                        msglog = new StringBuilder("SQL Purchase: ").append((CharSequence)sqlPO);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(msglog.toString());
                        }
                        rsPO = pstmtPO.executeQuery();
                        Vector<Integer> idPO = new Vector<Integer>();
                        while (rsPO.next()) {
                            idPO.add(rsPO.getInt(1));
                        }
                        if (role.getWindowAccess(msd.getPO_Window_ID()) != null) {
                            msglog = new StringBuilder("Open Window: ").append(msd.getPO_Window_ID()).append(" / Table: ").append(table2.getTableName()).append(" / Number of Results: ").append(idPO.size());
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(msglog.toString());
                            }
                            this.openWindow(idPO, table2.getTableName(), msd.getPO_Window_ID());
                        } else {
                            log.warning("Role is not allowed to view this window");
                        }
                    }
                    DB.close(rsSO, pstmtSO);
                    DB.close(rsPO, pstmtPO);
                    pstmtSO = null;
                    pstmtPO = null;
                    rsSO = null;
                    rsPO = null;
                }
            }
            catch (Exception e) {
                log.severe(e.toString());
                e.printStackTrace();
                DB.close(rsSO, pstmtSO);
                DB.close(rsPO, pstmtPO);
                rsSO = null;
                rsPO = null;
                pstmtSO = null;
                pstmtPO = null;
            }
        }
        finally {
            DB.close(rsSO, pstmtSO);
            DB.close(rsPO, pstmtPO);
            rsSO = null;
            rsPO = null;
            pstmtSO = null;
            pstmtPO = null;
        }
    }

    private void openWindow(Vector<Integer> ids, String tableName, int windowId) {
        boolean ok;
        if (ids == null || ids.size() == 0) {
            return;
        }
        StringBuilder whereString = new StringBuilder(" ").append(tableName).append("_ID");
        if (ids.size() == 1) {
            if (ids.get(0) == 0) {
                whereString = null;
            } else {
                whereString.append("=").append(ids.get(0));
            }
        } else {
            whereString.append(" IN (");
            int i2 = 0;
            while (i2 < ids.size()) {
                whereString.append(ids.get(i2));
                if (i2 < ids.size() - 1) {
                    whereString.append(",");
                } else {
                    whereString.append(") ");
                }
                ++i2;
            }
        }
        MQuery query = new MQuery(tableName);
        if (whereString != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(whereString.toString());
            }
            query.addRestriction(whereString.toString());
        }
        if (!(ok = this.openWindow(windowId, query))) {
            StringBuilder msglog = new StringBuilder("Unable to open window: ").append(whereString.toString());
            log.severe(msglog.toString());
        }
        if (!this.windowOpened && ok) {
            this.windowOpened = true;
        }
    }

    protected abstract boolean openWindow(int var1, MQuery var2);
}

