/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import org.compiere.model.MShipper;
import org.compiere.model.MShipperLabels;
import org.compiere.model.MShipperPackaging;
import org.compiere.model.MShipperPickupTypes;
import org.compiere.model.X_M_ShipperLabelsCfg;
import org.compiere.model.X_M_ShipperPackagingCfg;
import org.compiere.model.X_M_ShipperPickupTypesCfg;
import org.compiere.process.SvrProcess;

public class ShipperCreateFrom
extends SvrProcess {
    private MShipper m_shipper;

    @Override
    protected void prepare() {
        this.m_shipper = new MShipper(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        this.createShipperPackaging();
        this.createShipperLabels();
        this.createShipperPickupTypes();
        return "OK";
    }

    private void createShipperPackaging() {
        int[] xspIds;
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_ShipperCfg_ID=" + this.m_shipper.getM_ShipperCfg_ID() + " ");
        whereClause.append("AND IsActive='Y' ");
        whereClause.append("AND M_ShipperPackagingCfg_ID NOT IN ( ");
        whereClause.append("SELECT M_ShipperPackagingCfg_ID ");
        whereClause.append("FROM M_ShipperPackaging ");
        whereClause.append("WHERE M_Shipper_ID=" + this.m_shipper.getM_Shipper_ID() + ")");
        int[] nArray = xspIds = X_M_ShipperPackagingCfg.getAllIDs("M_ShipperPackagingCfg", whereClause.toString(), this.get_TrxName());
        int n = xspIds.length;
        int n2 = 0;
        while (n2 < n) {
            int xspId = nArray[n2];
            X_M_ShipperPackagingCfg xsp = new X_M_ShipperPackagingCfg(this.getCtx(), xspId, this.get_TrxName());
            MShipperPackaging sp = new MShipperPackaging(this.getCtx(), 0, null);
            sp.setM_Shipper_ID(this.m_shipper.getM_Shipper_ID());
            sp.setM_ShipperPackagingCfg_ID(xsp.getM_ShipperPackagingCfg_ID());
            sp.setName(xsp.getName());
            sp.setIsDefault(xsp.isDefault());
            sp.setWeight(xsp.getWeight());
            sp.saveEx();
            ++n2;
        }
    }

    private void createShipperLabels() {
        int[] xslIds;
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_ShipperCfg_ID=" + this.m_shipper.getM_ShipperCfg_ID() + " ");
        whereClause.append("AND IsActive='Y' ");
        whereClause.append("AND M_ShipperLabelsCfg_ID NOT IN ( ");
        whereClause.append("SELECT M_ShipperLabelsCfg_ID ");
        whereClause.append("FROM M_ShipperLabels ");
        whereClause.append("WHERE M_Shipper_ID=" + this.m_shipper.getM_Shipper_ID() + ")");
        int[] nArray = xslIds = X_M_ShipperLabelsCfg.getAllIDs("M_ShipperLabelsCfg", whereClause.toString(), this.get_TrxName());
        int n = xslIds.length;
        int n2 = 0;
        while (n2 < n) {
            int xslId = nArray[n2];
            X_M_ShipperLabelsCfg xsl = new X_M_ShipperLabelsCfg(this.getCtx(), xslId, this.get_TrxName());
            MShipperLabels sl = new MShipperLabels(this.getCtx(), 0, null);
            sl.setM_Shipper_ID(this.m_shipper.getM_Shipper_ID());
            sl.setM_ShipperLabelsCfg_ID(xsl.getM_ShipperLabelsCfg_ID());
            sl.setName(xsl.getName());
            sl.setIsDefault(xsl.isDefault());
            sl.setLabelPrintMethod(xsl.getLabelPrintMethod());
            sl.saveEx();
            ++n2;
        }
    }

    private void createShipperPickupTypes() {
        int[] xsptIds;
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_ShipperCfg_ID=" + this.m_shipper.getM_ShipperCfg_ID() + " ");
        whereClause.append("AND IsActive='Y' ");
        whereClause.append("AND M_ShipperPickupTypesCfg_ID NOT IN ( ");
        whereClause.append("SELECT M_ShipperPickupTypesCfg_ID ");
        whereClause.append("FROM M_ShipperPickupTypes ");
        whereClause.append("WHERE M_Shipper_ID=" + this.m_shipper.getM_Shipper_ID() + ")");
        int[] nArray = xsptIds = X_M_ShipperPickupTypesCfg.getAllIDs("M_ShipperPickupTypesCfg", whereClause.toString(), this.get_TrxName());
        int n = xsptIds.length;
        int n2 = 0;
        while (n2 < n) {
            int xsptId = nArray[n2];
            X_M_ShipperPickupTypesCfg xspt = new X_M_ShipperPickupTypesCfg(this.getCtx(), xsptId, this.get_TrxName());
            MShipperPickupTypes spt = new MShipperPickupTypes(this.getCtx(), 0, null);
            spt.setM_Shipper_ID(this.m_shipper.getM_Shipper_ID());
            spt.setM_ShipperPickupTypesCfg_ID(xspt.getM_ShipperPickupTypesCfg_ID());
            spt.setName(xspt.getName());
            spt.setIsDefault(xspt.isDefault());
            spt.saveEx();
            ++n2;
        }
    }
}

