/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ResetLockedAccount
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_User_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para;
        ProcessInfoParameter[] processInfoParameterArray = para = this.getParameter();
        int n = para.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter element = processInfoParameterArray[n2];
            String name = element.getParameterName();
            if (element.getParameter() != null || element.getParameter_To() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = element.getParameterAsInt();
                } else if (name.equals("AD_User_ID")) {
                    this.p_AD_User_ID = element.getParameterAsInt();
                } else if (this.log.isLoggable(Level.INFO)) {
                    this.log.log(Level.INFO, "Unknown Parameter: " + name);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int no;
        if (this.p_AD_Client_ID == 0) {
            this.p_AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        }
        if (this.p_AD_User_ID > 0) {
            MUser user = new MUser(this.getCtx(), this.p_AD_User_ID, null);
            if (!user.isLocked()) {
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "UserIsNotLocked", new Object[]{user.getName()}));
            }
            StringBuilder sql = new StringBuilder("UPDATE AD_User SET IsLocked = 'N', DateAccountLocked=NULL, FailedLoginCount=0, DateLastLogin=NULL, Updated=SysDate ").append(" WHERE IsLocked='Y' AND AD_Client_ID = ? ").append(" AND AD_User_ID = " + user.getAD_User_ID());
            int no2 = DB.executeUpdate(sql.toString(), new Object[]{this.p_AD_Client_ID}, false, this.get_TrxName());
            if (no2 <= 0) {
                throw new AdempiereException(String.valueOf(Msg.getMsg(this.getCtx(), "CouldNotUnlockAccount")) + user.toString());
            }
            StringBuilder msgreturn = new StringBuilder(Msg.getMsg(this.getCtx(), "ProcessOK")).append(" - ").append(Msg.getMsg(this.getCtx(), "UserUnlocked", new Object[]{user.getName()}));
            return msgreturn.toString();
        }
        int MAX_ACCOUNT_LOCK_MINUTES = MSysConfig.getIntValue("USER_LOCKING_MAX_ACCOUNT_LOCK_MINUTES", 0);
        int MAX_INACTIVE_PERIOD = MSysConfig.getIntValue("USER_LOCKING_MAX_INACTIVE_PERIOD_DAY", 0);
        StringBuilder sql = new StringBuilder("UPDATE AD_User SET IsLocked = 'N', DateAccountLocked=NULL, FailedLoginCount=0, DateLastLogin=NULL, Updated=SysDate ").append(" WHERE IsLocked='Y' AND AD_Client_ID = ? ");
        if (DB.isPostgreSQL()) {
            if (MAX_ACCOUNT_LOCK_MINUTES > 0) {
                sql.append(" AND EXTRACT(EPOCH FROM (now()-DateAccountLocked)) / 60 > ").append(MAX_ACCOUNT_LOCK_MINUTES);
            }
            if (MAX_INACTIVE_PERIOD > 0) {
                sql.append(" AND EXTRACT(EPOCH FROM (now()-DateLastLogin)) / 86400 <= ").append(MAX_INACTIVE_PERIOD);
            }
        } else {
            if (MAX_ACCOUNT_LOCK_MINUTES > 0) {
                sql.append(" AND (SysDate-DateAccountLocked) * 1440 > ").append(MAX_ACCOUNT_LOCK_MINUTES);
            }
            if (MAX_INACTIVE_PERIOD > 0) {
                sql.append(" AND (SysDate-DateLastLogin) <= ").append(MAX_INACTIVE_PERIOD);
            }
        }
        if ((no = DB.executeUpdate(sql.toString(), this.p_AD_Client_ID, this.get_TrxName())) < 0) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "CouldNotUnlockAccount"));
        }
        StringBuilder msgreturn = new StringBuilder().append(no).append(" ").append(Msg.getMsg(this.getCtx(), "LockedAccountResetted"));
        return msgreturn.toString();
    }
}

