/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pdf;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.compiere.model.MSysConfig;

public class Document {
    static {
        FontFactory.registerDirectories();
    }

    private static void writePDF(Pageable pageable, OutputStream output) {
        try {
            File dir;
            PageFormat pf = pageable.getPageFormat(0);
            com.itextpdf.text.Document document = new com.itextpdf.text.Document(new Rectangle((float)((int)pf.getWidth()), (float)((int)pf.getHeight())));
            PdfWriter writer = PdfWriter.getInstance((com.itextpdf.text.Document)document, (OutputStream)output);
            writer.setPdfVersion('2');
            document.open();
            DefaultFontMapper mapper = new DefaultFontMapper();
            String pdfFontDir = MSysConfig.getValue("PDF_FONT_DIR", "");
            if (pdfFontDir != null && pdfFontDir.trim().length() > 0 && (dir = new File(pdfFontDir = pdfFontDir.trim())).exists() && dir.isDirectory()) {
                mapper.insertDirectory(pdfFontDir);
            }
            float w = (float)pf.getWidth();
            float h = (float)pf.getHeight();
            PdfContentByte cb = writer.getDirectContent();
            int page = 0;
            while (page < pageable.getNumberOfPages()) {
                if (page != 0) {
                    document.newPage();
                }
                PdfTemplate tp = cb.createTemplate(w, h);
                Graphics2D g2 = tp.createGraphics(w, h, (FontMapper)mapper);
                tp.setWidth(w);
                tp.setHeight(h);
                pageable.getPrintable(page).print(g2, pf, page);
                g2.dispose();
                cb.addTemplate(tp, 0.0f, 0.0f);
                writer.releaseTemplate(tp);
                ++page;
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getPDFAsFile(String filename, Pageable pageable) {
        File result = new File(filename);
        try {
            Document.writePDF(pageable, new FileOutputStream(result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] getPDFAsArray(Pageable pageable) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream(10240);
            Document.writePDF(pageable, output);
            return output.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isValid(Pageable layout) {
        return true;
    }

    public static boolean isLicensed() {
        return true;
    }
}

