/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.X_AD_BroadcastMessage;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MBroadcastMessage
extends X_AD_BroadcastMessage {
    private static final long serialVersionUID = 1908264699133879072L;
    private static CCache<Integer, MBroadcastMessage> s_cache = new CCache("AD_BroadcastMessage", 30, 60);

    public MBroadcastMessage(Properties ctx, int AD_BroadcastMessage_ID, String trxName) {
        super(ctx, AD_BroadcastMessage_ID, trxName);
    }

    public MBroadcastMessage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MBroadcastMessage get(Properties ctx, int AD_BroadcastMessage_ID) {
        Integer key = AD_BroadcastMessage_ID;
        MBroadcastMessage retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new MBroadcastMessage(ctx, AD_BroadcastMessage_ID, null);
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public boolean isValidUserforMessage() {
        Properties ctx = Env.getCtx();
        if (this.getBroadcastType() != null && this.getBroadcastType().equals("I") && this.getTarget() != null) {
            if (this.getTarget().equals("R")) {
                String sql = "SELECT COUNT(*) FROM AD_User_Roles WHERE AD_Role_ID = ? AND AD_User_ID=? AND IsActive='Y'";
                int roleSubs = DB.getSQLValue(null, sql, this.getAD_Role_ID(), Env.getAD_User_ID(ctx));
                if (roleSubs > 0) {
                    return true;
                }
            } else {
                if (this.getTarget().equals("U") && this.getAD_User_ID() == Env.getAD_User_ID(ctx)) {
                    return true;
                }
                if (this.getTarget().equals("C") && this.getAD_Client_ID() == Env.getAD_Client_ID(ctx)) {
                    return true;
                }
                if (this.getTarget().equals("E")) {
                    return true;
                }
            }
        } else {
            int AD_User_ID = Env.getAD_User_ID(ctx);
            String sql = "SELECT AD_User_ID from AD_Note WHERE AD_BroadcastMessage_ID = ?  AND AD_User_ID = ? ";
            int result = DB.getSQLValue(null, sql, this.getAD_BroadcastMessage_ID(), AD_User_ID);
            return result > 0;
        }
        return false;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ("I".equals(this.getBroadcastType())) {
            this.setBroadcastFrequency("J");
        }
        boolean logack = "A".equals(this.getBroadcastFrequency()) || "O".equals(this.getBroadcastFrequency());
        this.setLogAcknowledge(logack);
        return true;
    }
}

