/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class GridTabWrapper
implements InvocationHandler {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private final GridTab m_gridTab;

    public static <T> T create(GridTab gridTab, Class<T> cl) {
        return (T)Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (InvocationHandler)new GridTabWrapper(gridTab));
    }

    private GridTabWrapper(GridTab gridTab) {
        this.m_gridTab = gridTab;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("set") && args.length == 1) {
            String propertyName = methodName.substring(3);
            this.m_gridTab.setValue(propertyName, args[0]);
            return null;
        }
        if (methodName.startsWith("get") && (args == null || args.length == 0)) {
            String propertyName = methodName.substring(3);
            Object value = this.m_gridTab.getValue(propertyName);
            if (value != null) {
                return value;
            }
            if (method.getReturnType() == Integer.TYPE) {
                value = 0;
            } else if (method.getReturnType() == BigDecimal.class) {
                value = BigDecimal.ZERO;
            } else if (this.isModelInterface(method.getReturnType())) {
                value = this.getReferencedObject(propertyName, method);
            } else if (PO.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method not supported - " + methodName);
            }
            return value;
        }
        if (methodName.startsWith("is") && (args == null || args.length == 0)) {
            String propertyName = methodName.substring(2);
            GridField field = this.m_gridTab.getField(propertyName);
            if (field != null) {
                Object value = field.getValue();
                return value instanceof Boolean ? value : Boolean.valueOf("Y".equals(value));
            }
            field = this.m_gridTab.getField("Is" + propertyName);
            if (field != null) {
                Object value = field.getValue();
                return value instanceof Boolean ? value : Boolean.valueOf("Y".equals(value));
            }
            throw new IllegalArgumentException("Method not supported - " + methodName);
        }
        return method.invoke((Object)this.m_gridTab, args);
    }

    public GridTab getGridTab() {
        return this.m_gridTab;
    }

    private final Properties getCtx() {
        return Env.getCtx();
    }

    private final String getTrxName() {
        return null;
    }

    private final Object getReferencedObject(String propertyName, Method method) {
        String tableName;
        GridField idField = this.m_gridTab.getField(String.valueOf(propertyName) + "_ID");
        if (idField == null) {
            return null;
        }
        Integer record_id = (Integer)this.m_gridTab.getValue(idField);
        if (record_id == null || record_id <= 0) {
            return null;
        }
        Class<?> cl = method.getReturnType();
        try {
            tableName = (String)cl.getField("Table_Name").get(null);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        PO po = MTable.get(this.getCtx(), tableName).getPO(record_id, this.getTrxName());
        return po;
    }

    private boolean isModelInterface(Class<?> cl) {
        try {
            String tableName = (String)cl.getField("Table_Name").get(null);
            return tableName != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

