/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.adempiere.base.Service;
import org.adempiere.base.osgi.OSGiScriptEngine;
import org.adempiere.base.osgi.OSGiScriptEngineFactory;
import org.osgi.framework.BundleContext;

public class OSGiScriptEngineManager
extends ScriptEngineManager {
    private Bindings bindings;
    private Map<ScriptEngineManager, ClassLoader> classLoaders;
    private BundleContext context;

    public OSGiScriptEngineManager(BundleContext context) {
        this.context = context;
        this.bindings = new SimpleBindings();
        this.classLoaders = this.findManagers(context);
    }

    public void reloadManagers() {
        this.classLoaders = this.findManagers(this.context);
    }

    @Override
    public Object get(String key) {
        return this.bindings.get(key);
    }

    @Override
    public Bindings getBindings() {
        return this.bindings;
    }

    @Override
    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngine engine = null;
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoaders.get(manager));
            engine = manager.getEngineByExtension(extension);
            Thread.currentThread().setContextClassLoader(old);
            if (engine != null) break;
        }
        return engine;
    }

    @Override
    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngine engine = null;
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoaders.get(manager));
            engine = manager.getEngineByMimeType(mimeType);
            Thread.currentThread().setContextClassLoader(old);
            if (engine != null) break;
        }
        return engine;
    }

    @Override
    public ScriptEngine getEngineByName(String shortName) {
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoaders.get(manager));
            ScriptEngine engine = manager.getEngineByName(shortName);
            Thread.currentThread().setContextClassLoader(old);
            if (engine == null) continue;
            return new OSGiScriptEngine(engine, new OSGiScriptEngineFactory(engine.getFactory(), this.classLoaders.get(manager)));
        }
        return null;
    }

    @Override
    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> osgiFactories = new ArrayList<ScriptEngineFactory>();
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            for (ScriptEngineFactory factory : engineManager.getEngineFactories()) {
                osgiFactories.add(new OSGiScriptEngineFactory(factory, this.classLoaders.get(engineManager)));
            }
        }
        return osgiFactories;
    }

    @Override
    public void put(String key, Object value) {
        this.bindings.put(key, value);
    }

    @Override
    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            engineManager.registerEngineExtension(extension, factory);
        }
    }

    @Override
    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            engineManager.registerEngineMimeType(type, factory);
        }
    }

    @Override
    public void registerEngineName(String name, ScriptEngineFactory factory) {
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            engineManager.registerEngineName(name, factory);
        }
    }

    @Override
    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            manager.setBindings(bindings);
        }
    }

    private Map<ScriptEngineManager, ClassLoader> findManagers(BundleContext context) {
        HashMap<ScriptEngineManager, ClassLoader> managers = new HashMap<ScriptEngineManager, ClassLoader>();
        List<ScriptEngineFactory> seFactoryList = Service.locator().list(ScriptEngineFactory.class).getServices();
        if (seFactoryList != null) {
            for (ScriptEngineFactory seFactory : seFactoryList) {
                ClassLoader factoryLoader = seFactory.getClass().getClassLoader();
                ScriptEngineManager manager = new ScriptEngineManager(factoryLoader);
                manager.setBindings(this.bindings);
                managers.put(manager, factoryLoader);
            }
        }
        return managers;
    }
}

